/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.tigerModules;

import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.resources.TigerResourceFactory;
import java.io.IOException;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.tigerModules.Tiger2ImporterProperties;
import org.corpus_tools.peppermodules.tigerModules.mappers.Tiger22SaltMapper;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.service.component.annotations.Component;

@Component(name="Tiger2ImporterComponent", factory="PepperImporterComponentFactory")
public class Tiger2Importer
extends PepperImporterImpl
implements PepperImporter {
    private ResourceSet resourceSet = null;

    public Tiger2Importer() {
        this.setName("Tiger2Importer");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-TigerModules"));
        this.setDesc("This importer transforms data in TigerXML and tiger2 format to a Salt model. ");
        this.addSupportedFormat("tiger2", "2.0.5", null);
        this.addSupportedFormat("tigerXML", "1.0", null);
        this.getDocumentEndings().add("tiger2");
        this.getDocumentEndings().add("tig2");
        this.getDocumentEndings().add("xml");
        this.getDocumentEndings().add("tiger");
        this.setProperties(new Tiger2ImporterProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            Tiger2Importer tiger2Importer = this;
            synchronized (tiger2Importer) {
                if (this.resourceSet == null) {
                    this.resourceSet = new ResourceSetImpl();
                    this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("tiger2", new TigerResourceFactory());
                    this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("tig2", new TigerResourceFactory());
                    this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new TigerResourceFactory());
                    this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("tiger", new TigerResourceFactory());
                }
            }
        }
        return this.resourceSet;
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        Tiger22SaltMapper mapper = new Tiger22SaltMapper();
        if (sElementId.getIdentifiableElement() instanceof SDocument) {
            URI inputUri = (URI)this.getIdentifier2ResourceTable().get(sElementId);
            if (inputUri == null) {
                throw new PepperModuleException((PepperModule)this, "There was no matching uri found corresponding to document '" + sElementId + "'.");
            }
            Resource resourceLoad = this.getResourceSet().createResource(inputUri);
            if (resourceLoad == null) {
                throw new PepperModuleException((PepperModule)this, "Cannot map the data stored at given uri '" + inputUri + "', because no resource object could have been created to read these data.");
            }
            try {
                resourceLoad.load(null);
            }
            catch (IOException e) {
                throw new PepperModuleException((PepperModule)this, "Cannot load <tiger2/> model from file '" + inputUri + "'.", (Throwable)e);
            }
            Object objCorpus = resourceLoad.getContents().get(0);
            if (!(objCorpus instanceof Corpus)) {
                throw new PepperModuleException((PepperModule)this, "Cannot map the data stored at given uri '" + inputUri + "', because they could not have been mapped to a tiger2 corpus model object.");
            }
            Corpus corpus = (Corpus)resourceLoad.getContents().get(0);
            mapper.setCorpus(corpus);
        }
        return mapper;
    }
}

