/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.tcfModules;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.peppermodules.tcfModules.TCFDictionary;
import org.corpus_tools.peppermodules.tcfModules.TCFImporterProperties;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.semantics.SLemmaAnnotation;
import org.corpus_tools.salt.semantics.SPOSAnnotation;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class TCFMapperImport
extends PepperMapperImpl {
    public static final String LEVEL_SENTENCE = "sentence";
    public static final String LAYER_POS = "pos";
    public static final String LAYER_DEPENDENCIES = "dependencies";
    public static final String LEVEL_DEPENDENCY = "dependency";
    public static final String LAYER_TCF_MORPHOLOGY = "morphology";
    public static final String LAYER_CONSTITUENTS = "syntax";
    public static final String LAYER_LEMMA = "lemma";
    public static final String LAYER_REFERENCES = "references";
    public static final String LAYER_NE = "named entities";
    public static final String LAYER_PHONETICS = "phonetics";
    public static final String LAYER_ORTHOGRAPHY = "orthography";
    public static final String LAYER_GEO = "geography";
    public static final String LAYER_LS = "lexical-semantics";
    public static final String LAYER_WORDSENSE = "wordSense";
    public static final String LAYER_SPLITTINGS = "wordSplittings";
    public static final String LAYER_DISCOURSE = "discourseConnectives";
    public static final String LAYER_TEXTSTRUCTURE = "textstructure";
    public static final String LAYER_SENTENCES = "sentences";
    public static final String STYPE_REFERENCE = "reference";
    public static final String STYPE_DEPENDENCY = "dependency";
    private static final String BAD_TOKENIZATION_ERROR_MESSAGE = "Bad tokenization: Full text not matching token text!";
    private static final String REF_SEPERATOR = "%%%";
    public static final String ANNO_NAME_CONSTITUENT = "const";
    private static Logger logger = LoggerFactory.getLogger(TCFMapperImport.class);

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument() == null) {
            this.setDocument(SaltFactory.createSDocument());
        }
        SDocumentGraph docGraph = SaltFactory.createSDocumentGraph();
        this.getDocument().setDocumentGraph(docGraph);
        TCFReader reader = new TCFReader();
        this.readXMLResource(reader, this.getResourceURI());
        return DOCUMENT_STATUS.COMPLETED;
    }

    private class TCFReader
    extends DefaultHandler2
    implements TCFDictionary {
        private EMap<String, SNode> sNodes = new BasicEMap();
        private EMap<String, Label> labels = new BasicEMap();
        private EMap<String, SLayer> sLayers = new BasicEMap();
        private STextualDS currentSTDS;
        private int p = 0;
        private Stack<String> path = new Stack();
        private Stack<String> idPath = new Stack();
        private StringBuilder chars = new StringBuilder();
        private String currentNodeID = null;
        private String currentAnnoID = null;
        private String currentAnnoKey = null;
        private SNode currentSNode = null;
        private int id;
        private int metaId;
        private static final String REF_PREFIX = "reference-";
        private static final String CLN = ":";
        private static final String SPAN = "span";
        private boolean shrinkTokenAnnotations;
        private boolean useCommonAnnotatedElement;
        private boolean ignoreIds;
        private List<SNode> trashList;

        public TCFReader() {
            this.shrinkTokenAnnotations = ((TCFImporterProperties)TCFMapperImport.this.getProperties()).isShrinkTokenAnnotation();
            this.useCommonAnnotatedElement = ((TCFImporterProperties)TCFMapperImport.this.getProperties()).isUseCommonAnnotatedElement();
            this.ignoreIds = false;
            this.id = 0;
            this.metaId = 0;
            this.trashList = new ArrayList<SNode>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            localName = qName.substring(qName.lastIndexOf(CLN) + 1);
            this.path.push(localName);
            if ("constituent".equals(localName)) {
                String tokenIDs;
                String constID = attributes.getValue("ID");
                if (!this.ignoreIds) {
                    boolean bl = this.ignoreIds = constID == null;
                }
                if (this.ignoreIds) {
                    constID = Integer.toString(this.id++);
                }
                if ((tokenIDs = attributes.getValue("tokenIDs")) == null) {
                    SStructure sStruc = SaltFactory.createSStructure();
                    sStruc.createAnnotation(TCFMapperImport.LAYER_CONSTITUENTS, "cat", (Object)attributes.getValue("cat"));
                    this.store(constID, (SNode)sStruc);
                    sStruc.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_CONSTITUENTS));
                    if (this.idPath.empty()) {
                        this.getSDocGraph().addNode((Node)sStruc);
                    } else {
                        this.getSDocGraph().addNode((SNode)this.sNodes.get((Object)this.idPath.peek()), (SNode)sStruc, SALT_TYPE.SDOMINANCE_RELATION);
                    }
                    this.idPath.push(constID);
                } else {
                    SNode sNode = (SNode)this.sNodes.get((Object)tokenIDs);
                    if (tokenIDs.contains(" ")) {
                        if (sNode == null) {
                            String[] seq = tokenIDs.split(" ");
                            ArrayList<SToken> sTokensForSpan = new ArrayList<SToken>();
                            for (int i = 0; i < seq.length; ++i) {
                                sTokensForSpan.add((SToken)this.sNodes.get((Object)seq[i]));
                            }
                            sNode = this.getSDocGraph().createSpan(sTokensForSpan);
                            if (this.useCommonAnnotatedElement) {
                                this.store(tokenIDs, sNode);
                            }
                        }
                        sNode.createAnnotation(TCFMapperImport.LAYER_CONSTITUENTS, "cat", (Object)attributes.getValue("cat"));
                        this.getSDocGraph().addNode((SNode)this.sNodes.get((Object)this.idPath.peek()), sNode, SALT_TYPE.SDOMINANCE_RELATION);
                        this.idPath.push(tokenIDs);
                    } else {
                        if (this.shrinkTokenAnnotations) {
                            sNode = (SToken)this.sNodes.get((Object)tokenIDs);
                        } else {
                            sNode = (SNode)this.sNodes.get((Object)(tokenIDs + SPAN));
                            if (sNode == null) {
                                sNode = this.getSDocGraph().createSpan(new SToken[]{(SToken)this.sNodes.get((Object)tokenIDs)});
                                if (this.useCommonAnnotatedElement) {
                                    this.store(tokenIDs + SPAN, sNode);
                                }
                            }
                        }
                        this.annotateSNode(sNode, TCFMapperImport.LAYER_CONSTITUENTS, "cat", attributes.getValue("cat"), false, false);
                        this.getSDocGraph().addNode((SNode)this.sNodes.get((Object)this.idPath.peek()), sNode, SALT_TYPE.SDOMINANCE_RELATION);
                        this.idPath.push(tokenIDs);
                    }
                }
            } else if ("depparsing".equals(localName)) {
                this.currentNodeID = null;
                SLayer depLayer = this.buildLayer(TCFMapperImport.LAYER_DEPENDENCIES);
                depLayer.createMetaAnnotation(null, "tagset", (Object)attributes.getValue("tagset"));
            } else if ("parse".equals(localName)) {
                this.idPath.clear();
            } else if ("dependency".equals(localName)) {
                SDocumentGraph graph = this.getSDocGraph();
                if (attributes.getValue("govIDs") != null) {
                    SPointingRelation depRel = (SPointingRelation)graph.addNode((SNode)this.sNodes.get((Object)attributes.getValue("govIDs")), (SNode)this.sNodes.get((Object)attributes.getValue("depIDs")), SALT_TYPE.SPOINTING_RELATION);
                    depRel.createAnnotation(TCFMapperImport.LAYER_DEPENDENCIES, "func", (Object)attributes.getValue("func"));
                    depRel.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_DEPENDENCIES));
                    depRel.setType("dependency");
                }
            } else if (TCFMapperImport.LAYER_SENTENCES.equals(localName)) {
                this.buildLayer(TCFMapperImport.LAYER_SENTENCES);
            } else if (!"MetaData".equals(localName)) {
                if ("TextCorpus".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "lang", attributes.getValue("lang"), false, true);
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "document", TCFMapperImport.this.getDocument().getName(), false, true);
                } else if (TCFMapperImport.LAYER_LEMMA.equals(localName)) {
                    if (this.chars.length() > 0) {
                        this.chars.delete(0, this.chars.length());
                    }
                    this.currentNodeID = attributes.getValue("tokenIDs");
                    this.currentAnnoID = attributes.getValue("ID");
                    SNode sNode = this.getNode(this.currentNodeID);
                    sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_LEMMA));
                    this.currentSNode = sNode;
                } else if ("text".equals(localName)) {
                    STextualDS primaryText = SaltFactory.createSTextualDS();
                    if (this.chars.length() > 0) {
                        this.chars.delete(0, this.chars.length());
                    }
                    this.currentSTDS = primaryText;
                    this.getSDocGraph().addNode((Node)primaryText);
                    this.p = 0;
                } else if ("token".equals(localName)) {
                    this.currentNodeID = attributes.getValue("ID");
                    if (this.chars.length() > 0) {
                        this.chars.delete(0, this.chars.length());
                    }
                } else if ("lemmas".equals(localName)) {
                    this.buildLayer(TCFMapperImport.LAYER_LEMMA);
                } else if (TCFMapperImport.LEVEL_SENTENCE.equals(localName)) {
                    String[] seq = attributes.getValue("tokenIDs").split(" ");
                    ArrayList<SToken> sentenceTokens = new ArrayList<SToken>();
                    for (int i = 0; i < seq.length; ++i) {
                        sentenceTokens.add((SToken)this.sNodes.get((Object)seq[i]));
                    }
                    SSpan sentenceSpan = this.getSDocGraph().createSpan(sentenceTokens);
                    String att = attributes.getValue("ID");
                    this.store(att, (SNode)sentenceSpan);
                    this.annotateSNode((SNode)sentenceSpan, null, TCFMapperImport.LEVEL_SENTENCE, TCFMapperImport.LEVEL_SENTENCE, false, false);
                    sentenceSpan.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_SENTENCES));
                } else if (!"Services".equals(localName)) {
                    if ("Toolchain".equals(localName)) {
                        this.metaId = 0;
                        this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "Toolchain" + CLN + "ComponentId", attributes.getValue("ComponentId"), false, true);
                    } else if ("tag".equals(localName)) {
                        this.path.pop();
                        if (this.chars.length() > 0) {
                            this.chars.delete(0, this.chars.length());
                        }
                        if ("POStags".equals(this.path.peek())) {
                            this.currentNodeID = attributes.getValue("tokenIDs");
                            this.currentAnnoID = attributes.getValue("ID");
                            SNode sNode = this.getNode(this.currentNodeID);
                            sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_POS));
                            this.currentSNode = sNode;
                        } else if ("tags".equals(this.path.peek())) {
                            ++this.metaId;
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "tag" + this.metaId + CLN + "lang", attributes.getValue("lang"), false, true);
                        }
                    } else if ("POStags".equals(localName)) {
                        SLayer posLayer = this.buildLayer(TCFMapperImport.LAYER_POS);
                        if (attributes.getValue("tagset") != null) {
                            posLayer.createMetaAnnotation(null, "tagset", (Object)attributes.getValue("tagset"));
                        }
                    } else if (!"Resources".equals(localName)) {
                        if ("analysis".equals(localName)) {
                            this.currentNodeID = attributes.getValue("tokenIDs");
                            SNode sNode = this.getNode(this.currentNodeID);
                            sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_TCF_MORPHOLOGY));
                            this.currentSNode = sNode;
                        } else if ("f".equals(localName)) {
                            if (this.chars.length() > 0) {
                                this.chars.delete(0, this.chars.length());
                            }
                            this.currentAnnoKey = attributes.getValue("name");
                        } else if ("segment".equals(localName)) {
                            if (this.chars.length() > 0) {
                                this.chars.delete(0, this.chars.length());
                            }
                            this.annotateSNode(this.currentSNode, "segment", "type", attributes.getValue("type"), false, false);
                        } else if (TCFMapperImport.LAYER_TCF_MORPHOLOGY.equals(localName)) {
                            SLayer tcfMorphLayer = SaltFactory.createSLayer();
                            tcfMorphLayer.setName(TCFMapperImport.LAYER_TCF_MORPHOLOGY);
                            this.getSDocGraph().addLayer((Layer)tcfMorphLayer);
                            this.sLayers.put((Object)TCFMapperImport.LAYER_TCF_MORPHOLOGY, (Object)tcfMorphLayer);
                        } else if (TCFMapperImport.LAYER_REFERENCES.equals(localName)) {
                            this.id = 0;
                            this.ignoreIds = false;
                            this.currentNodeID = null;
                            SLayer refLayer = this.buildLayer(TCFMapperImport.LAYER_REFERENCES);
                            if (attributes.getValue("typetagset") != null) {
                                refLayer.createMetaAnnotation(null, "typetagset", (Object)attributes.getValue("typetagset"));
                            }
                            if (attributes.getValue("reltagset") != null) {
                                refLayer.createMetaAnnotation(null, "reltagset", (Object)attributes.getValue("typetagset"));
                            }
                        } else if ("entity".equals(localName)) {
                            this.path.pop();
                            if (this.path.peek().equals("namedEntities")) {
                                this.currentNodeID = attributes.getValue("tokenIDs");
                                SNode sNode = this.getNode(this.currentNodeID);
                                this.annotateSNode(sNode, TCFMapperImport.LAYER_NE, "class", attributes.getValue("class"), false, false);
                                sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_NE));
                            } else if (this.path.peek().equals(TCFMapperImport.LAYER_REFERENCES)) {
                                this.currentSNode = null;
                                this.idPath.clear();
                            }
                        } else if (TCFMapperImport.STYPE_REFERENCE.equals(localName)) {
                            if (!this.ignoreIds) {
                                this.ignoreIds = attributes.getValue("ID").equals(this.currentNodeID);
                            }
                            StringBuilder ref = new StringBuilder();
                            this.currentNodeID = this.ignoreIds ? REF_PREFIX + this.id++ : attributes.getValue("ID");
                            this.currentSNode = this.getNode(attributes.getValue("tokenIDs"));
                            this.annotateSNode(this.currentSNode, TCFMapperImport.LAYER_REFERENCES, "type", attributes.getValue("type"), false, false);
                            this.store(this.currentNodeID, this.currentSNode);
                            this.currentSNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_REFERENCES));
                            if (attributes.getValue("rel") != null) {
                                ref.append(this.currentSNode.getId()).append(TCFMapperImport.REF_SEPERATOR).append(attributes.getValue("target")).append(TCFMapperImport.REF_SEPERATOR).append(attributes.getValue("rel"));
                                this.idPath.push(ref.toString());
                            } else if (this.ignoreIds) {
                                this.idPath.push(this.currentSNode.getId().toString());
                            }
                        } else if ("namedEntities".equals(localName)) {
                            SLayer namedEntities = this.buildLayer(TCFMapperImport.LAYER_NE);
                            String annoVal = attributes.getValue("type");
                            if (annoVal != null) {
                                namedEntities.createMetaAnnotation(null, "type", (Object)annoVal);
                            }
                        } else if (TCFMapperImport.LAYER_PHONETICS.equals(localName)) {
                            SLayer phoLayer = this.buildLayer(TCFMapperImport.LAYER_PHONETICS);
                            String annoVal = attributes.getValue("transcription");
                            if (annoVal != null) {
                                phoLayer.createMetaAnnotation(null, "transcription", (Object)annoVal);
                            }
                        } else if ("pron".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.currentNodeID = attributes.getValue("tokID");
                            Object object = this.shrinkTokenAnnotations ? (SToken)this.sNodes.get((Object)this.currentNodeID) : (this.currentSNode = this.useCommonAnnotatedElement ? (SNode)this.sNodes.get((Object)(this.currentNodeID + SPAN)) : this.getSDocGraph().createSpan(new SToken[]{(SToken)this.sNodes.get((Object)this.currentNodeID)}));
                            if (this.currentSNode == null) {
                                this.currentSNode = this.getSDocGraph().createSpan(new SToken[]{(SToken)this.sNodes.get((Object)this.currentNodeID)});
                                this.store(this.currentNodeID + SPAN, this.currentSNode);
                            }
                            this.currentSNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_PHONETICS));
                        } else if (TCFMapperImport.LAYER_ORTHOGRAPHY.equals(localName)) {
                            this.buildLayer(TCFMapperImport.LAYER_ORTHOGRAPHY);
                        } else if ("correction".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.currentNodeID = attributes.getValue("tokenIDs");
                            SNode sNode = this.getNode(this.currentNodeID);
                            SAnnotation correction = sNode.createAnnotation(TCFMapperImport.LAYER_ORTHOGRAPHY, "correction", null);
                            String opVal = attributes.getValue("operation");
                            if (opVal != null) {
                                SAnnotation operation = SaltFactory.createSAnnotation();
                                operation.setName("operation");
                                operation.setNamespace(TCFMapperImport.LAYER_ORTHOGRAPHY);
                                operation.setValue((Object)attributes.getValue("operation"));
                                correction.addLabel((Label)operation);
                            }
                            sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_ORTHOGRAPHY));
                            this.currentSNode = sNode;
                        } else if ("geo".equals(localName)) {
                            SLayer geoLayer = this.buildLayer(TCFMapperImport.LAYER_GEO);
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                geoLayer.createMetaAnnotation(null, attributes.getLocalName(i), (Object)attributes.getValue(i));
                            }
                        } else if ("src".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                        } else if ("gpoint".equals(localName)) {
                            SNode sNode = this.getNode(attributes.getValue("tokenIDs"));
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_GEO, "alt", attributes.getValue("alt"), false, false);
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_GEO, "lat", attributes.getValue("lat"), false, false);
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_GEO, "lon", attributes.getValue("lon"), false, false);
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_GEO, "continent", attributes.getValue("continent"), false, false);
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_GEO, "country", attributes.getValue("country"), false, false);
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_GEO, "capital", attributes.getValue("capital"), false, false);
                            sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_GEO));
                        } else if ("synonymy".equals(localName) || "antonymy".equals(localName) || "hyponymy".equals(localName) || "hyperonymy".equals(localName)) {
                            if (!this.sLayers.containsKey((Object)TCFMapperImport.LAYER_LS)) {
                                this.buildLayer(TCFMapperImport.LAYER_LS);
                            }
                        } else if ("orthform".equals(localName)) {
                            this.path.pop();
                            this.chars.delete(0, this.chars.length());
                            this.currentAnnoID = attributes.getValue("lemmaRefs");
                            SLemmaAnnotation lemma = (SLemmaAnnotation)this.labels.get((Object)this.currentAnnoID);
                            SAnnotation anno = SaltFactory.createSAnnotation();
                            anno.setNamespace(TCFMapperImport.LAYER_LS);
                            anno.setName(this.path.peek());
                            lemma.addLabel((Label)anno);
                            ((SNode)lemma.getContainer()).addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_LS));
                        } else if ("wsd".equals(localName)) {
                            this.buildLayer(TCFMapperImport.LAYER_WORDSENSE);
                            String annoVal = attributes.getValue("src");
                            if (annoVal != null) {
                                ((SLayer)this.sLayers.get((Object)TCFMapperImport.LAYER_WORDSENSE)).createMetaAnnotation(null, "src", (Object)annoVal);
                            }
                        } else if ("ws".equals(localName)) {
                            SNode sNode = this.getNode(attributes.getValue("tokenIDs"));
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_WORDSENSE, "lexunits", attributes.getValue("lexunits"), false, false);
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_WORDSENSE, "comment", attributes.getValue("comment"), false, false);
                            sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_WORDSENSE));
                        } else if ("WordSplittings".equals(localName)) {
                            SLayer splitLayer = this.buildLayer(TCFMapperImport.LAYER_SPLITTINGS);
                            if (attributes.getValue("type") != null) {
                                splitLayer.createMetaAnnotation(null, "type", (Object)attributes.getValue("type"));
                            }
                        } else if ("split".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.currentSNode = this.getNode(attributes.getValue("tokID"));
                            this.currentSNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_SPLITTINGS));
                        } else if ("discourseconnectives".equals(localName)) {
                            SLayer discourseLayer = this.buildLayer(TCFMapperImport.LAYER_DISCOURSE);
                            String annoVal = attributes.getValue("tagset");
                            if (annoVal != null) {
                                discourseLayer.createMetaAnnotation(null, "tagset", (Object)annoVal);
                            }
                        } else if ("connective".equals(localName)) {
                            SNode sNode = this.getNode(attributes.getValue("tokenIDs"));
                            this.annotateSNode(sNode, TCFMapperImport.LAYER_DISCOURSE, "type", attributes.getValue("type"), false, false);
                            sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_DISCOURSE));
                        } else if (TCFMapperImport.LAYER_TEXTSTRUCTURE.equals(localName)) {
                            this.buildLayer(TCFMapperImport.LAYER_TEXTSTRUCTURE);
                        } else if ("textspan".equals(localName)) {
                            if (attributes.getValue("start") != null && attributes.getValue("end") != null) {
                                SDocumentGraph graph = this.getSDocGraph();
                                SToken startToken = (SToken)this.sNodes.get((Object)attributes.getValue("start"));
                                SToken endToken = (SToken)this.sNodes.get((Object)attributes.getValue("end"));
                                SToken sNode = null;
                                if (startToken.equals(endToken)) {
                                    sNode = this.shrinkTokenAnnotations ? startToken : graph.createSpan(new SToken[]{startToken});
                                } else {
                                    int j;
                                    List allTokens = graph.getSortedTokenByText();
                                    for (j = 0; j < allTokens.size() && !((SToken)allTokens.get(j)).equals(startToken); ++j) {
                                    }
                                    sNode = graph.createSpan(new SToken[]{startToken});
                                    ++j;
                                    while (j < allTokens.size() && !((SToken)allTokens.get(j)).equals(endToken)) {
                                        graph.addNode((SNode)sNode, (SNode)allTokens.get(j), SALT_TYPE.SSPANNING_RELATION);
                                        ++j;
                                    }
                                    graph.addNode((SNode)sNode, (SNode)allTokens.get(j), SALT_TYPE.SSPANNING_RELATION);
                                }
                                this.annotateSNode((SNode)sNode, TCFMapperImport.LAYER_TEXTSTRUCTURE, "type", attributes.getValue("type"), false, false);
                                sNode.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_TEXTSTRUCTURE));
                            }
                        } else if ("MdCreator".equals(localName) || "MdCreationDate".equals(localName) || "MdSelfLink".equals(localName) || "MdProfile".equals(localName) || "MdCollectionDisplayName".equals(localName) || "RelationType".equals(localName) || "Res1".equals(localName) || "Res2".equals(localName) || "JournalFileRef".equals(localName) || "ResourceClass".equals(localName) || "TimeCoverage".equals(localName) || "LegalOwner".equals(localName) || "Genre".equals(localName) || "LifeCycleStatus".equals(localName) || "StartYear".equals(localName) || "CompletionYear".equals(localName) || "PublicationDate".equals(localName) || "LastUpdate".equals(localName) || "CountryCoding".equals(localName) || "ResourceRef".equals(localName) || "PID".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                        } else if ("ResourceType".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "ResourceProxy" + this.metaId + "ResourceType" + CLN + "mimetype", attributes.getValue("mimetype"), false, true);
                        } else if ("ResourceProxyList".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.metaId = 0;
                        } else if ("IsPartOfList".equals(localName) || "ResourceRelationList".equals(localName) || "JournalFileProxyList".equals(localName)) {
                            this.metaId = 0;
                        } else if ("IsPartOf".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            ++this.metaId;
                        } else if ("ResourceRelation".equals(localName) || "JournalFileProxy".equals(localName) || "ResourceProxy".equals(localName)) {
                            ++this.metaId;
                        } else if ("Descriptions".equals(localName)) {
                            this.metaId = 0;
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Descriptions", attributes.getValue("ComponentId"), false, true);
                        } else if ("Description".equals(localName)) {
                            ++this.metaId;
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Description" + this.metaId + CLN + "type", attributes.getValue("type"), false, true);
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Description" + this.metaId + CLN + "lang", attributes.getValue("lang"), false, true);
                        } else if ("parsing".equals(localName)) {
                            this.currentNodeID = null;
                            this.ignoreIds = false;
                            SLayer syntaxLayer = this.buildLayer(TCFMapperImport.LAYER_CONSTITUENTS);
                            syntaxLayer.createMetaAnnotation(null, "tagset", (Object)attributes.getValue("tagset"));
                        } else if ("GeneralInfo".equals(localName)) {
                            this.metaId = 0;
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "ComponentId", attributes.getValue("ComponentId"), false, true);
                        } else if ("ResourceName".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "ResourceName" + ++this.metaId + CLN + "lang", attributes.getValue("lang"), false, true);
                        } else if ("ResourceTitle".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "ResourceTitle" + ++this.metaId + CLN + "lang", attributes.getValue("lang"), false, true);
                        } else if ("CMD".equals(localName)) {
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "CMDVersion", attributes.getValue("CMDVersion"), false, true);
                        } else if ("Version".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Version" + CLN + "lang", attributes.getValue("lang"), false, true);
                        } else if ("Location".equals(localName)) {
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Location" + CLN + "ComponentId", attributes.getValue("ComponentId"), false, true);
                        } else if ("Adress".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Adress" + CLN + "lang", attributes.getValue("lang"), false, true);
                        } else if ("Region".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Region" + CLN + "lang", attributes.getValue("lang"), false, true);
                        } else if ("ContinentName".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "ContinentName" + CLN + "lang", attributes.getValue("lang"), false, true);
                        } else if ("CountryName".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Country" + CLN + "CountryName" + CLN + "lang", attributes.getValue("lang"), false, true);
                        } else if ("Country".equals(localName)) {
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Country" + CLN + "ComponentId", attributes.getValue("ComponentId"), false, true);
                        } else if ("tags".equals(localName)) {
                            this.metaId = 0;
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "tags" + CLN + "ComponentId", attributes.getValue("ComponentId"), false, true);
                        } else if ("ToolInChain".equals(localName)) {
                            ++this.metaId;
                            this.id = 0;
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "Toolchain" + CLN + "ToolInChain" + this.metaId + CLN + "ComponentId", attributes.getValue("ComponentId"), false, true);
                        } else if ("Parameter".equals(localName)) {
                            this.chars.delete(0, this.chars.length());
                            ++this.id;
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "Toolchain" + CLN + "ToolInChain" + this.metaId + CLN + "Parameter" + this.id + CLN + "name", attributes.getValue("name"), false, true);
                            this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "Toolchain" + CLN + "ToolInChain" + this.metaId + CLN + "Parameter" + this.id + CLN + "value", attributes.getValue("value"), false, true);
                        }
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            localName = qName.substring(qName.lastIndexOf(CLN) + 1);
            if ("constituent".equals(localName)) {
                this.idPath.pop();
            } else if ("entity".equals(localName)) {
                if (TCFMapperImport.STYPE_REFERENCE.equals(this.path.peek())) {
                    String[] seq = null;
                    SNode target = null;
                    while (!this.idPath.empty()) {
                        SPointingRelation ref;
                        seq = this.idPath.pop().split(TCFMapperImport.REF_SEPERATOR);
                        if (this.ignoreIds) {
                            if (seq.length == 1) {
                                target = (SNode)this.getSDocGraph().getNode(seq[0]);
                                continue;
                            }
                            if (target == null) {
                                logger.info("!--------------------------- WARNING: target of reference not set!");
                            }
                            if (this.referenceExists((SNode)this.getSDocGraph().getNode(seq[0]), target)) continue;
                            ref = (SPointingRelation)this.getSDocGraph().addNode((SNode)this.getSDocGraph().getNode(seq[0]), target, SALT_TYPE.SPOINTING_RELATION);
                            ref.setType(TCFMapperImport.STYPE_REFERENCE);
                            ref.createAnnotation(TCFMapperImport.LAYER_REFERENCES, "rel", (Object)seq[2]);
                            ref.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_REFERENCES));
                            continue;
                        }
                        if (seq.length == 1 || seq[0].equals(seq[1]) || this.referenceExists((SNode)this.getSDocGraph().getNode(seq[0]), (SNode)this.sNodes.get((Object)seq[1]))) continue;
                        ref = (SPointingRelation)this.getSDocGraph().addNode((SNode)this.getSDocGraph().getNode(seq[0]), (SNode)this.sNodes.get((Object)seq[1]), SALT_TYPE.SPOINTING_RELATION);
                        ref.createAnnotation(TCFMapperImport.LAYER_REFERENCES, "rel", (Object)seq[2]);
                        ref.setType(TCFMapperImport.STYPE_REFERENCE);
                        ref.addLayer((Layer)this.sLayers.get((Object)TCFMapperImport.LAYER_REFERENCES));
                    }
                }
            } else if ("text".equals(localName)) {
                String oldtext = this.currentSTDS.getText();
                this.currentSTDS.setText(oldtext == null ? this.chars.toString() : oldtext + this.chars.toString());
            } else if ("tag".equals(localName)) {
                if ("POStags".equals(this.path.peek())) {
                    SPOSAnnotation sAnno = SaltFactory.createSPOSAnnotation();
                    sAnno.setValue((Object)this.chars.toString());
                    this.currentSNode.addAnnotation((SAnnotation)sAnno);
                    this.labels.put((Object)this.currentAnnoID, (Object)sAnno);
                }
                if ("tags".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "tag" + this.metaId, this.chars.toString(), false, true);
                }
            } else if ("f".equals(localName)) {
                this.annotateSNode(this.currentSNode, TCFMapperImport.LAYER_TCF_MORPHOLOGY, this.currentAnnoKey, this.chars.toString(), false, false);
            } else if (TCFMapperImport.LAYER_LEMMA.equals(localName)) {
                SLemmaAnnotation anno = SaltFactory.createSLemmaAnnotation();
                anno.setValue((Object)this.chars.toString());
                this.currentSNode.addAnnotation((SAnnotation)anno);
                this.labels.put((Object)this.currentAnnoID, (Object)anno);
            } else if ("token".equals(localName)) {
                int old_p = this.p;
                String primaryData = this.currentSTDS.getText();
                String tok = this.chars.toString();
                int lookAhead = primaryData.substring(this.p).length() - primaryData.substring(this.p).trim().length() + 1;
                while (this.p < primaryData.length() && this.p - old_p <= lookAhead && !primaryData.substring(this.p).startsWith(tok)) {
                    ++this.p;
                }
                if (this.p == primaryData.length() || this.p - old_p > lookAhead) {
                    logger.warn("WARNING: Skipped token [".concat(tok).concat("] (ID=").concat(this.currentNodeID).concat("), it could not be found in the base text. This might lead to further errors in processing the document."));
                    this.p = old_p;
                    SToken emptyToken = SaltFactory.createSToken();
                    this.getSDocGraph().addNode((Node)emptyToken);
                    this.store(this.currentNodeID, (SNode)emptyToken);
                    this.trashList.add((SNode)emptyToken);
                } else {
                    this.store(this.currentNodeID, (SNode)this.getSDocGraph().createToken((SSequentialDS)this.currentSTDS, Integer.valueOf(this.p), Integer.valueOf(this.p + tok.length())));
                    this.p += tok.length();
                }
            } else if (!"segment".equals(localName) && !"tokens".equals(localName)) {
                if ("pron".equals(localName)) {
                    this.currentSNode.createAnnotation(TCFMapperImport.LAYER_PHONETICS, "pron", (Object)this.chars.toString());
                } else if ("correction".equals(localName)) {
                    this.currentSNode.getAnnotation("orthography::correction").setValue((Object)this.chars.toString());
                } else if ("src".equals(localName)) {
                    ((SLayer)this.sLayers.get((Object)TCFMapperImport.LAYER_GEO)).createMetaAnnotation(null, "src", (Object)this.chars.toString());
                } else if ("orthform".equals(localName)) {
                    ((Label)this.labels.get((Object)this.currentAnnoID)).getLabel(TCFMapperImport.LAYER_LS, this.path.peek()).setValue((Object)this.chars.toString());
                } else if ("split".equals(localName)) {
                    this.currentSNode.createAnnotation(TCFMapperImport.LAYER_SPLITTINGS, "split", (Object)this.chars.toString());
                } else if ("MdCreator".equals(localName)) {
                    if (this.chars.length() > 0) {
                        SMetaAnnotation meta = TCFMapperImport.this.getDocument().getMetaAnnotation("MdCreator");
                        if (meta != null) {
                            meta.setValue((Object)(meta.getValue().toString() + "; " + this.chars.toString()));
                        } else {
                            TCFMapperImport.this.getDocument().createMetaAnnotation(null, "MdCreator", (Object)this.chars.toString());
                        }
                    }
                } else if ("MdCreationDate".equals(localName)) {
                    if (this.chars.length() > 0) {
                        TCFMapperImport.this.getDocument().createMetaAnnotation(null, "MdCreationDate", (Object)this.chars.toString());
                    }
                } else if ("MdSelfLink".equals(localName)) {
                    if (this.chars.length() > 0) {
                        TCFMapperImport.this.getDocument().createMetaAnnotation(null, "MdSelfLink", (Object)this.chars.toString());
                    }
                } else if ("MdProfile".equals(localName)) {
                    if (this.chars.length() > 0) {
                        TCFMapperImport.this.getDocument().createMetaAnnotation(null, "MdProfile", (Object)this.chars.toString());
                    }
                } else if ("MdCollectionDisplayName".equals(localName)) {
                    if (this.chars.length() > 0) {
                        TCFMapperImport.this.getDocument().createMetaAnnotation(null, "MdCollectionDisplayName", (Object)this.chars.toString());
                    }
                } else if ("TextCorpus".equals(localName)) {
                    for (SNode sNode : this.trashList) {
                        this.getSDocGraph().removeNode((Node)sNode);
                    }
                } else if ("ResourceType".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "ResourceProxy" + this.metaId + "ResourceType", this.chars.toString(), false, true);
                } else if ("ResourceRef".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "ResourceProxy" + this.metaId + "ResourceRef", this.chars.toString(), false, true);
                } else if ("JournalFileRef".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "JournalFileProxy" + this.metaId, this.chars.toString(), false, true);
                } else if ("RelationType".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "ResourceRelation" + this.metaId + CLN + "RelationType", this.chars.toString(), false, true);
                } else if ("Res1".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "ResourceRelation" + this.metaId + CLN + "Res1", this.chars.toString(), false, true);
                } else if ("Res2".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "ResourceRelation" + this.metaId + CLN + "Res2", this.chars.toString(), false, true);
                } else if ("IsPartOf".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "IsPartOfList" + CLN + "IsPartOf" + this.metaId, this.chars.toString(), false, true);
                } else if ("ResourceName".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "ResourceName" + this.metaId, this.chars.toString(), false, true);
                } else if ("ResourceTitle".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "ResourceTitle" + this.metaId, this.chars.toString(), false, true);
                } else if ("ResourceTitle".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "ResourceClass";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("Version".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Version", this.chars.toString(), false, true);
                } else if ("LifeCycleStatus".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "LifeCycleStatus", this.chars.toString(), false, true);
                } else if ("StartYear".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "StartYear", this.chars.toString(), false, true);
                } else if ("CompletionYear".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "CompletionYear", this.chars.toString(), false, true);
                } else if ("PublicationDate".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "PublicationDate", this.chars.toString(), false, true);
                } else if ("LastUpdate".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "LastUpdate", this.chars.toString(), false, true);
                } else if ("TimeCoverage".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "TimeCoverage";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("LegalOwner".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "LegalOwner";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("Genre".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Genre";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("Adress".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Location" + CLN + "Adress";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("Region".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Location" + CLN + "Region";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("ContinentName".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Location" + CLN + "ContinentName";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("CountryName".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Location" + CLN + "Country" + CLN + "CountryName";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("CountryCoding".equals(localName)) {
                    String qN = "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Location" + CLN + "Country" + CLN + "CountryCoding";
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, qN, TCFMapperImport.this.getDocument().getMetaAnnotation(qN) == null ? this.chars.toString() : TCFMapperImport.this.getDocument().getMetaAnnotation(qN).getValue() + "; " + this.chars.toString(), false, true);
                } else if ("Description".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "GeneralInfo" + CLN + "Description" + this.metaId, this.chars.toString(), false, true);
                } else if ("PID".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "Toolchain" + CLN + "ToolInChain" + this.metaId + CLN + "PID", this.chars.toString(), false, true);
                } else if ("Parameter".equals(localName)) {
                    this.annotateSNode((SNode)TCFMapperImport.this.getDocument(), null, "WebServiceToolChain" + CLN + "Toolchain" + CLN + "ToolInChain" + this.metaId + CLN + "Parameter" + this.id, this.chars.toString(), false, true);
                }
            }
        }

        private boolean isPrettyPrint(String s) {
            return s.replace(" ", "").replace("\t", "").replace("\n", "").replace("\r", "").isEmpty();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            boolean add;
            StringBuilder txt = new StringBuilder();
            for (int i = start; i < start + length; ++i) {
                txt.append(ch[i]);
            }
            boolean bl = add = !this.isPrettyPrint(txt.toString());
            if (add) {
                this.chars.append(txt.toString());
            }
        }

        private SNode getNode(String id) {
            if (id == null) {
                return null;
            }
            SNode sNode = (SNode)this.sNodes.get((Object)id);
            SDocumentGraph graph = this.getSDocGraph();
            if (id.contains(" ")) {
                if (sNode == null) {
                    String[] seq = id.split(" ");
                    sNode = graph.createSpan(new SToken[]{(SToken)this.sNodes.get((Object)seq[0])});
                    for (int i = 1; i < seq.length; ++i) {
                        graph.addNode(sNode, (SNode)((SToken)this.sNodes.get((Object)seq[i])), SALT_TYPE.SSPANNING_RELATION);
                    }
                    if (this.useCommonAnnotatedElement) {
                        this.store(id, sNode);
                    }
                }
            } else {
                Object object = this.shrinkTokenAnnotations ? (SToken)sNode : (sNode = this.useCommonAnnotatedElement ? (SNode)this.sNodes.get((Object)(id + SPAN)) : graph.createSpan(new SToken[]{(SToken)sNode}));
                if (sNode == null) {
                    sNode = graph.createSpan(new SToken[]{(SToken)this.sNodes.get((Object)id)});
                    this.store(id.concat(SPAN), sNode);
                }
            }
            return sNode;
        }

        private void store(String key, SNode sNode) {
            if (this.sNodes.contains((Object)key)) {
                throw new PepperModuleDataException((PepperMapper)TCFMapperImport.this, "Multiple use of id ".concat(key).concat(". IDs are supposed to be unique."));
            }
            this.sNodes.put((Object)key, (Object)sNode);
        }

        private SDocumentGraph getSDocGraph() {
            return TCFMapperImport.this.getDocument().getDocumentGraph();
        }

        private SLayer buildLayer(String name) {
            SLayer newLayer = SaltFactory.createSLayer();
            newLayer.setName(name);
            this.sLayers.put((Object)name, (Object)newLayer);
            this.getSDocGraph().addLayer((Layer)newLayer);
            return newLayer;
        }

        private Label annotateSNode(SNode sNode, String namespace, String name, String value, boolean acceptEmptyOrNullValues, boolean isMetaAnnotation) {
            SMetaAnnotation anno;
            if (sNode == null || name == null) {
                return null;
            }
            if ((value == null || value.isEmpty()) && !acceptEmptyOrNullValues) {
                return null;
            }
            String qName = namespace == null ? name : namespace + "::" + name;
            Object object = anno = isMetaAnnotation ? sNode.getMetaAnnotation(qName) : sNode.getAnnotation(qName);
            if (anno != null) {
                anno.setValue((Object)value);
            } else {
                anno = isMetaAnnotation ? sNode.createMetaAnnotation(namespace, name, (Object)value) : sNode.createAnnotation(namespace, name, (Object)value);
            }
            return anno;
        }

        private boolean referenceExists(SNode sSource, SNode sTarget) {
            for (SRelation sRel : sSource.getOutRelations()) {
                if (!(sRel instanceof SPointingRelation) || sRel.getTarget() != sTarget || !sRel.getType().equals(TCFMapperImport.STYPE_REFERENCE)) continue;
                return true;
            }
            return false;
        }
    }
}

