/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.tcfModules;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.tcfModules.TCFDictionary;
import org.corpus_tools.peppermodules.tcfModules.TCFExporterProperties;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCFMapperExport
extends PepperMapperImpl
implements TCFDictionary {
    private static final Logger logger = LoggerFactory.getLogger(TCFMapperExport.class);
    private XMLStreamWriter currentTCF = null;
    private HashMap<String, String> meta = null;
    private HashMap<SNode, String> sNodes = null;
    private HashSet<SToken> emptyTokens = null;
    private String qNameLine = null;
    private String valueLine = null;
    private String qNamePage = null;
    private String valuePage = null;
    private boolean emptyTokensAllowed = false;
    private String qNameSentence = null;
    private String valueSentence = null;
    private String qNamePOS = null;
    private String qNameLemma = null;

    public void init() {
        this.currentTCF = null;
        this.sNodes = new HashMap();
        this.emptyTokens = new HashSet();
        this.qNameLine = ((TCFExporterProperties)this.getProperties()).getTextstructureLineName();
        this.valueLine = ((TCFExporterProperties)this.getProperties()).getTextstructureLineValue();
        this.qNamePage = ((TCFExporterProperties)this.getProperties()).getTextstructurePageName();
        this.valuePage = ((TCFExporterProperties)this.getProperties()).getTextstructurePageValue();
        this.emptyTokensAllowed = ((TCFExporterProperties)this.getProperties()).isEmptyTokensAllowed();
        this.qNameSentence = ((TCFExporterProperties)this.getProperties()).getSentenceQName();
        this.valueSentence = ((TCFExporterProperties)this.getProperties()).getSentenceValue();
        this.qNamePOS = ((TCFExporterProperties)this.getProperties()).getPOSQName();
        this.qNameLemma = ((TCFExporterProperties)this.getProperties()).getLemmaQName();
        this.initMeta();
    }

    private void initMeta() {
        this.meta = new HashMap();
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.init();
        if (this.getDocument() == null) {
            throw new PepperModuleDataException((PepperMapper)this, "No document delivered to be converted.");
        }
        ByteArrayOutputStream outStream = null;
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        File file = null;
        boolean multipleFiles = this.getDocument().getDocumentGraph().getTextualDSs().size() > 1;
        List sTextualDSs = this.getDocument().getDocumentGraph().getTextualDSs();
        STextualDS sTextualDS = null;
        for (int i = 0; i < sTextualDSs.size(); ++i) {
            try {
                sTextualDS = (STextualDS)sTextualDSs.get(i);
                outStream = new ByteArrayOutputStream();
                XMLStreamWriter w = this.currentTCF = factory.createXMLStreamWriter(outStream);
                w.writeStartDocument();
                w.writeProcessingInstruction("xml-model href=\"http://de.clarin.eu/images/weblicht-tutorials/resources/tcf-04/schemas/latest/d-spin_0_4.rnc\" type=\"application/relax-ng-compact-syntax\"");
                w.writeStartElement("wl", "D-Spin", "http://www.dspin.de/data");
                w.writeNamespace("ed", "http://www.dspin.de/data/extdata");
                w.writeNamespace("lx", "http://www.dspin.de/data/lexicon");
                w.writeNamespace("md", "http://www.dspin.de/data/metadata");
                w.writeNamespace("tc", "http://www.dspin.de/data/textcorpus");
                w.writeNamespace("wl", "http://www.dspin.de/data");
                w.writeAttribute("version", "0.4");
                w.writeStartElement("md", "MetaData", "http://www.dspin.de/data/metadata");
                w.writeEndElement();
                w.writeStartElement("tc", "TextCorpus", "http://www.dspin.de/data/textcorpus");
                w.writeAttribute("lang", this.getLanguage());
                this.mapSTextualDS(sTextualDS);
                this.mapTokenization(this.getDocument().getDocumentGraph().getSortedTokenByText());
                this.mapSentences();
                this.mapPOSAnnotations();
                this.mapLemmaAnnotations();
                this.mapLayoutAnnotations();
                w.writeEndElement();
                w.writeEndElement();
                w.writeEndDocument();
                file = new File(this.getResourceURI().toFileString() + (multipleFiles ? i + ".tcf" : ""));
                file.getParentFile().mkdirs();
                try {
                    PrintWriter p = new PrintWriter(file);
                    p.println(outStream.toString());
                    p.close();
                }
                catch (FileNotFoundException e) {
                    logger.error("Could not write TCF " + this.getResourceURI(), (Throwable)e);
                }
                continue;
            }
            catch (XMLStreamException e) {
                throw new PepperModuleException();
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private String getLanguage() {
        return "x-unspecified";
    }

    private void mapSTextualDS(STextualDS ds) {
        XMLStreamWriter w = this.currentTCF;
        try {
            w.writeStartElement("tc", "text", "http://www.dspin.de/data/textcorpus");
            w.writeCharacters(ds.getText());
            w.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        w = null;
    }

    private void mapTokenization(List<SToken> sTokens) {
        if (!sTokens.isEmpty()) {
            XMLStreamWriter w = this.currentTCF;
            try {
                w.writeStartElement("tc", "tokens", "http://www.dspin.de/data/textcorpus");
                SDocumentGraph sDocGraph = this.getDocument().getDocumentGraph();
                int i = 0;
                String id = null;
                String sText = null;
                for (SToken sTok : sTokens) {
                    sText = sDocGraph.getText((SNode)sTok);
                    if (this.emptyTokensAllowed || !sText.replace(" ", "").replace(System.getProperty("line.separator"), "").replace("\t", "").isEmpty()) {
                        id = "t_" + ++i;
                        this.sNodes.put((SNode)sTok, id);
                        w.writeStartElement("tc", "token", "http://www.dspin.de/data/textcorpus");
                        w.writeAttribute("ID", id);
                        w.writeCharacters(sText);
                        w.writeEndElement();
                        continue;
                    }
                    this.emptyTokens.add(sTok);
                }
                w.writeEndElement();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private void mapSentences() {
        XMLStreamWriter w = this.currentTCF;
        SDocumentGraph sDocGraph = this.getDocument().getDocumentGraph();
        ArrayList<SSpan> sSpans = new ArrayList<SSpan>();
        for (SSpan sSpan : this.getDocument().getDocumentGraph().getSpans()) {
            if (sSpan.getAnnotation(this.qNameSentence) == null || !sSpan.getAnnotation(this.qNameSentence).getValue().toString().equals(this.valueSentence)) continue;
            sSpans.add(sSpan);
        }
        List sTokens = null;
        String value = "";
        try {
            if (!sSpans.isEmpty()) {
                w.writeStartElement("tc", "sentences", "http://www.dspin.de/data/textcorpus");
                SSpan sSpan = null;
                for (int j = 0; j < sSpans.size(); ++j) {
                    sSpan = (SSpan)sSpans.get(j);
                    sTokens = sDocGraph.getOverlappedTokens((SNode)sSpan, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION});
                    sTokens = sDocGraph.getSortedTokenByText(sTokens);
                    w.writeStartElement("tc", "sentence", "http://www.dspin.de/data/textcorpus");
                    w.writeAttribute("ID", "s_" + (j + 1));
                    for (SToken sTok : sTokens) {
                        value = value + (this.emptyTokens.contains(sTok) ? "" : " " + this.sNodes.get(sTok));
                    }
                    w.writeAttribute("tokenIDs", value.trim());
                    w.writeEndElement();
                    value = "";
                }
                w.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void mapPOSAnnotations() {
        XMLStreamWriter w = this.currentTCF;
        ArrayList<SAnnotation> sAnnos = new ArrayList<SAnnotation>();
        SAnnotation anno = null;
        for (SToken sTok : this.getDocument().getDocumentGraph().getSortedTokenByText()) {
            anno = sTok.getAnnotation(this.qNamePOS);
            if (anno == null) continue;
            sAnnos.add(anno);
        }
        try {
            if (!sAnnos.isEmpty()) {
                w.writeStartElement("tc", "POStags", "http://www.dspin.de/data/textcorpus");
                w.writeAttribute("tagset", "stts");
                int k = 1;
                for (SAnnotation sAnno : sAnnos) {
                    w.writeStartElement("tc", "tag", "http://www.dspin.de/data/textcorpus");
                    w.writeAttribute("ID", "pt_" + k++);
                    w.writeAttribute("tokenIDs", this.sNodes.get(sAnno.getContainer()));
                    w.writeCharacters(sAnno.getValue().toString());
                    w.writeEndElement();
                }
                w.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new PepperModuleDataException((PepperMapper)this, "Failed to write POS-annotations.");
        }
    }

    private void mapLemmaAnnotations() {
        XMLStreamWriter w = this.currentTCF;
        ArrayList<SAnnotation> sAnnos = new ArrayList<SAnnotation>();
        SAnnotation anno = null;
        for (SToken sTok : this.getDocument().getDocumentGraph().getSortedTokenByText()) {
            anno = sTok.getAnnotation(this.qNameLemma);
            if (anno == null) continue;
            sAnnos.add(anno);
        }
        try {
            if (!sAnnos.isEmpty()) {
                w.writeStartElement("tc", "lemmas", "http://www.dspin.de/data/textcorpus");
                int k = 1;
                for (SAnnotation sAnno : sAnnos) {
                    w.writeStartElement("tc", "lemma", "http://www.dspin.de/data/textcorpus");
                    w.writeAttribute("ID", "le_" + k++);
                    w.writeAttribute("tokenIDs", this.sNodes.get(sAnno.getContainer()));
                    w.writeCharacters(sAnno.getValue().toString());
                    w.writeEndElement();
                }
                w.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            logger.warn("Failed to write lemma annotations.");
        }
    }

    private void mapLayoutAnnotations() {
        ArrayList<SNode> layoutNodes = new ArrayList<SNode>();
        SAnnotation anno = null;
        for (SNode sNode : this.getDocument().getDocumentGraph().getNodes()) {
            anno = sNode.getAnnotation(this.qNameLine);
            if (anno != null && anno.getValue_STEXT().equals(this.valueLine)) {
                layoutNodes.add(sNode);
            }
            if ((anno = sNode.getAnnotation(this.qNamePage)) == null || !anno.getValue_STEXT().equals(this.valuePage)) continue;
            layoutNodes.add(sNode);
        }
        if (!layoutNodes.isEmpty()) {
            XMLStreamWriter w = this.currentTCF;
            try {
                w.writeStartElement("tc", "textstructure", "http://www.dspin.de/data/textcorpus");
                List sTokens = null;
                String type = null;
                for (SNode sNode : layoutNodes) {
                    sTokens = this.getDocument().getDocumentGraph().getSortedTokenByText(this.getDocument().getDocumentGraph().getOverlappedTokens(sNode, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SDOMINANCE_RELATION}));
                    ArrayList<SToken> realTokens = new ArrayList<SToken>();
                    for (SToken sTok : sTokens) {
                        if (this.emptyTokens.contains(sTok)) continue;
                        realTokens.add(sTok);
                    }
                    if (realTokens.isEmpty()) continue;
                    w.writeStartElement("tc", "textspan", "http://www.dspin.de/data/textcorpus");
                    w.writeAttribute("start", this.sNodes.get(realTokens.get(0)));
                    w.writeAttribute("end", this.sNodes.get(realTokens.get(realTokens.size() - 1)));
                    type = sNode.getAnnotation(this.qNamePage) != null && sNode.getAnnotation(this.qNamePage).getValue().equals(this.valuePage) ? "page" : (sNode.getAnnotation(this.qNameLine) != null && sNode.getAnnotation(this.qNameLine).getValue().equals(this.valueLine) ? "line" : "IMPOSSIBLE RIGHT NOW");
                    w.writeAttribute("type", type);
                    w.writeEndElement();
                }
                w.writeEndElement();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

