/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.tcfModules;

import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.peppermodules.tcfModules.TCFImporterProperties;
import org.corpus_tools.peppermodules.tcfModules.TCFMapperImport;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="TCFImporterComponent", factory="PepperImporterComponentFactory")
public class TCFImporter
extends PepperImporterImpl
implements PepperImporter {
    public TCFImporter() {
        this.setName("TCFImporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-TCFModules"));
        this.setDesc("This importer transforms data in TCF format produced for instance by WebLicht (see http://weblicht.sfs.uni-tuebingen.de/) or WebAnno (see https://www.ukp.tu-darmstadt.de/software/webanno/) to a Salt model. ");
        this.addSupportedFormat("TCF", "0.4", null);
        this.setProperties(new TCFImporterProperties());
        this.getDocumentEndings().add("xml");
        this.getDocumentEndings().add("tcf");
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        TCFMapperImport mapper = new TCFMapperImport();
        mapper.setResourceURI((URI)this.getIdentifier2ResourceTable().get(sElementId));
        return mapper;
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        return super.isReadyToStart();
    }
}

