/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.tcfModules;

import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class TCFExporterProperties
extends PepperModuleProperties {
    public static final String PROP_TEXTSTRUCTURE_LINE_QNAME = "textstructure.line.qname";
    public static final String PROP_TEXTSTRUCTURE_LINE_VALUE = "textstructure.line.value";
    public static final String PROP_TEXTSTRUCTURE_PAGE_QNAME = "textstructure.page.qname";
    public static final String PROP_TEXTSTRUCTURE_PAGE_VALUE = "textstructure.page.value";
    public static final String PROP_EMPTY_TOKENS_ALLOWED = "allow.emptyTokens";
    public static final String PROP_SENTENCE_QNAME = "sentence.qname";
    public static final String PROP_SENTENCE_VALUE = "sentence.value";
    public static final String PROP_POS_QNAME = "pos.qname";
    public static final String PROP_LEMMA_QNAME = "lemma.qname";
    public static final String PROP_NE_QNAME = "";

    public TCFExporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_TEXTSTRUCTURE_LINE_QNAME, String.class, "This property says which annotation key is used for spans over tokens that mark a line of text.", (Object)"textstructure", false));
        this.addProperty(new PepperModuleProperty(PROP_TEXTSTRUCTURE_LINE_VALUE, String.class, "This property says which annotation value is used for spans over tokens that mark a line of text.", (Object)"line", false));
        this.addProperty(new PepperModuleProperty(PROP_TEXTSTRUCTURE_PAGE_QNAME, String.class, "This property says which annotation key is used for spans over tokens that mark a page of text.", (Object)"textstructure", false));
        this.addProperty(new PepperModuleProperty(PROP_TEXTSTRUCTURE_PAGE_VALUE, String.class, "This property says which annotation value is used for spans over tokens that mark a page of text.", (Object)"page", false));
        this.addProperty(new PepperModuleProperty(PROP_EMPTY_TOKENS_ALLOWED, Boolean.class, "this property says whether empty tokens are allowed or not", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_SENTENCE_QNAME, String.class, "This property says which annotation key is used for spans over tokens that mark a sentence.", (Object)"sentence", false));
        this.addProperty(new PepperModuleProperty(PROP_SENTENCE_VALUE, String.class, "This property says which annotation key is used for POS annotations.", (Object)"sentence", false));
        this.addProperty(new PepperModuleProperty(PROP_POS_QNAME, String.class, "This property says which annotation key is used for POS annotations.", (Object)"POS", false));
        this.addProperty(new PepperModuleProperty(PROP_LEMMA_QNAME, String.class, "This property says which annotation annotation key is used for lemma annotations.", (Object)"LEMMA", false));
    }

    public String getTextstructureLineName() {
        return this.getProperty(PROP_TEXTSTRUCTURE_LINE_QNAME).getValue().toString();
    }

    public String getTextstructureLineValue() {
        return this.getProperty(PROP_TEXTSTRUCTURE_LINE_VALUE).getValue().toString();
    }

    public String getTextstructurePageName() {
        return this.getProperty(PROP_TEXTSTRUCTURE_PAGE_QNAME).getValue().toString();
    }

    public String getTextstructurePageValue() {
        return this.getProperty(PROP_TEXTSTRUCTURE_PAGE_VALUE).getValue().toString();
    }

    public Boolean isEmptyTokensAllowed() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_EMPTY_TOKENS_ALLOWED).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public String getSentenceQName() {
        return this.getProperty(PROP_SENTENCE_QNAME).getValue().toString();
    }

    public String getSentenceValue() {
        return this.getProperty(PROP_SENTENCE_VALUE).getValue().toString();
    }

    public String getPOSQName() {
        return this.getProperty(PROP_POS_QNAME).getValue().toString();
    }

    public String getLemmaQName() {
        return this.getProperty(PROP_LEMMA_QNAME).getValue().toString();
    }
}

