/*
 * Decompiled with CFR 0.152.
 */
package edu.tufts.perseus.pepper.modules.PerseusModules;

import edu.tufts.perseus.pepper.modules.PerseusModules.Perseus2SaltMapper;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.xml.sax.helpers.DefaultHandler;

@Component(name="AldtImporterComponent", factory="PepperImporterComponentFactory")
public class PerseusImporter
extends PepperImporterImpl
implements PepperImporter {
    private Perseus2SaltMapper mapper = null;
    private Properties props;

    public PerseusImporter() {
        this.setName("AldtImporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-PerseusModules"));
        this.setDesc("This importer transforms data in aldt format used in the Perseus project to a Salt model. ");
        this.addSupportedFormat("aldt", "1.0", null);
        this.addSupportedFormat("aldt", "1.5", null);
        this.getDocumentEndings().add("xml");
        this.mapper = new Perseus2SaltMapper();
    }

    public void start(Identifier sElementId) throws PepperModuleException {
        if (sElementId != null && sElementId.getIdentifiableElement() != null && (sElementId.getIdentifiableElement() instanceof SDocument || sElementId.getIdentifiableElement() instanceof SCorpus)) {
            URI documentPath;
            if (sElementId.getIdentifiableElement() instanceof SCorpus) {
                SCorpus sCorpus = (SCorpus)sElementId.getIdentifiableElement();
                this.mapper.setCorpus(sCorpus);
            } else if (sElementId.getIdentifiableElement() instanceof SDocument && (documentPath = (URI)this.getIdentifier2ResourceTable().get(sElementId)) != null) {
                SDocument sDoc = (SDocument)sElementId.getIdentifiableElement();
                this.mapper.setDocument(sDoc);
                this.mapper.setResourcesURI(this.getResources());
                this.mapper.setProps(this.props);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                try {
                    SAXParser parser = factory.newSAXParser();
                    parser.parse(documentPath.toFileString(), (DefaultHandler)this.mapper);
                }
                catch (Exception a_e) {
                    throw new PepperModuleException((PepperModule)this, "Unable to parse " + documentPath.toFileString() + ":", (Throwable)a_e);
                }
            }
        }
    }
}

