/*
 * Decompiled with CFR 0.152.
 */
package edu.tufts.perseus.pepper.modules.PerseusModules;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.semantics.SCatAnnotation;
import org.corpus_tools.salt.semantics.SLemmaAnnotation;
import org.corpus_tools.salt.semantics.SPOSAnnotation;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Perseus2SaltMapper
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(Perseus2SaltMapper.class);
    private URI resourcesURI = null;
    private ArrayList<SDocument> docList = null;
    private SDocument sDocument = null;
    private STextualDS sTextDS = null;
    private SStructure currentSentence = null;
    private HashMap<String, String> currentAnnotatorInfo = null;
    private String currentText = null;
    private HashMap<String, SToken> tokenMap = null;
    private HashMap<String, ArrayList<HashMap<String, String>>> tokenRelMap = null;
    private HashMap<String, String> allAnnotators = null;
    public static final String DEFAULT_SEPARATOR = " ";
    private StreamSource xsltSource;
    private String citation_base_uri = null;
    public static final String FILE_ALPHEIOS_XSL = "alpheios-beta2unicode.xsl";
    public static final String FILE_DUMMY_XSL = "dummy.xml";
    private static final HashMap<String, Integer> postagMap = new HashMap<String, Integer>(){
        private static final long serialVersionUID = -5308305950463962194L;
        {
            this.put("part-of-speech", new Integer(0));
            this.put("person", new Integer(1));
            this.put("number", new Integer(2));
            this.put("tense", new Integer(3));
            this.put("mood", new Integer(4));
            this.put("voice", new Integer(5));
            this.put("gender", new Integer(6));
            this.put("case", new Integer(7));
            this.put("degree", new Integer(8));
            this.put("possessive", new Integer(9));
            this.put("definite", new Integer(10));
            this.put("object", new Integer(11));
            this.put("prefix", new Integer(12));
            this.put("sort", new Integer(13));
        }
    };
    private static final HashMap<String, HashMap> abbrevMap = new HashMap<String, HashMap>(){
        {
            this.put("part-of-speech", new HashMap<String, String>(){
                {
                    this.put("n", "noun");
                    this.put("v", "verb");
                    this.put("t", "participle");
                    this.put("a", "adjective");
                    this.put("d", "adverb");
                    this.put("c", "conjunction");
                    this.put("l", "article");
                    this.put("g", "particle");
                    this.put("r", "preposition");
                    this.put("p", "pronoun");
                    this.put("m", "numeral");
                    this.put("i", "interjection");
                    this.put("e", "exclamation");
                    this.put("x", "irregular");
                    this.put("u", "punctuation");
                    this.put("f", "functional");
                    this.put("z", "determiner");
                }
            });
            this.put("person", new HashMap<String, String>(){
                {
                    this.put("1", "first");
                    this.put("2", "second");
                    this.put("3", "third");
                }
            });
            this.put("number", new HashMap<String, String>(){
                {
                    this.put("s", "singular");
                    this.put("p", "plural");
                    this.put("d", "dual");
                }
            });
            this.put("tense", new HashMap<String, String>(){
                {
                    this.put("p", "present");
                    this.put("i", "imperfect");
                    this.put("r", "perfect");
                    this.put("l", "pluperfect");
                    this.put("t", "future perfect");
                    this.put("f", "future");
                    this.put("a", "aorist");
                    this.put("e", "preterite");
                    this.put("c", "conditional");
                }
            });
            this.put("mood", new HashMap<String, String>(){
                {
                    this.put("i", "indicative");
                    this.put("s", "subjunctive");
                    this.put("o", "optative");
                    this.put("n", "infinitive");
                    this.put("m", "imperative");
                    this.put("g", "gerundive");
                    this.put("p", "participial");
                }
            });
            this.put("voice", new HashMap<String, String>(){
                {
                    this.put("m", "middle");
                    this.put("a", "active");
                    this.put("p", "passive");
                    this.put("d", "deponent");
                    this.put("e", "mediopassive");
                }
            });
            this.put("gender", new HashMap<String, String>(){
                {
                    this.put("m", "masculine");
                    this.put("f", "feminine");
                    this.put("n", "neuter");
                    this.put("c", "common");
                }
            });
            this.put("case", new HashMap<String, String>(){
                {
                    this.put("n", "nominative");
                    this.put("g", "genitive");
                    this.put("d", "dative");
                    this.put("a", "accusative");
                    this.put("b", "ablative");
                    this.put("v", "vocative");
                    this.put("i", "instrumental");
                    this.put("l", "locative");
                }
            });
            this.put("degree", new HashMap<String, String>(){
                {
                    this.put("p", "positive");
                    this.put("c", "comparative");
                    this.put("s", "superlative");
                }
            });
            this.put("possessive", new HashMap<String, String>(){
                {
                    this.put("a", "possessive first plural");
                    this.put("b", "possessive first singular");
                    this.put("c", "possessive second dual");
                    this.put("d", "possessive second feminine plural");
                    this.put("e", "possessive second feminine singular");
                    this.put("f", "possessive second masculine plural");
                    this.put("g", "possessive second masculine singular");
                    this.put("h", "possessive third dual");
                    this.put("i", "possessive third feminine plural");
                    this.put("j", "possessive third feminine singular");
                    this.put("k", "possessive third masculine plural");
                    this.put("l", "possessive third masculine singular");
                }
            });
            this.put("definite", new HashMap<String, String>(){
                {
                    this.put("d", "definite");
                    this.put("i", "indefinite");
                }
            });
            this.put("object", new HashMap<String, String>(){
                {
                    this.put("a", "first plural");
                    this.put("b", "first singular");
                    this.put("c", "second dual");
                    this.put("d", "second feminine plural");
                    this.put("e", "second feminine singular");
                    this.put("f", "second masculine plural");
                    this.put("g", "second masculine singular");
                    this.put("h", "third dual");
                    this.put("i", "third feminine plural");
                    this.put("j", "third feminine singular");
                    this.put("k", "third masculine plural");
                    this.put("l", "third masculine singular");
                }
            });
            this.put("prefix", new HashMap<String, String>(){
                {
                    this.put("c", "conj+");
                    this.put("e", "emphatic+");
                    this.put("i", "interrogative+");
                    this.put("n", "neg+");
                    this.put("p", "prep+");
                    this.put("r", "resultative+");
                }
            });
            this.put("sort", new HashMap<String, String>(){
                {
                    this.put("c", "cardinal");
                    this.put("o", "ordinal");
                }
            });
        }
    };

    public void setResourcesURI(URI resourcesURI) {
        this.resourcesURI = resourcesURI;
    }

    public URI getResourcesURI() {
        return this.resourcesURI;
    }

    public Perseus2SaltMapper() {
        this.initCorpus();
    }

    private void initCorpus() {
        this.allAnnotators = new HashMap();
        this.docList = new ArrayList();
    }

    public void setCorpus(SCorpus a_sCorpus) {
        this.addSMetaAnnotationString((SAnnotationContainer)a_sCorpus, "CORPUS", a_sCorpus.getName());
        Iterator<SDocument> dIter = this.docList.iterator();
        int num = 0;
        while (dIter.hasNext()) {
            SDocument doc = dIter.next();
            this.addSMetaAnnotationString((SAnnotationContainer)a_sCorpus, "CORPUS_DOC" + ++num, this.getDocName(doc));
        }
        for (String key : this.allAnnotators.keySet()) {
            String value = this.allAnnotators.get(key);
            this.addSMetaAnnotationString((SAnnotationContainer)a_sCorpus, "CORPUS_annotator_" + key, value);
        }
        this.initCorpus();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String a_uri, String a_localName, String a_qName, Attributes a_atts) throws SAXException {
        this.currentText = "";
        if (!a_qName.equals("treebank")) {
            if (a_qName.equals("annotator") && this.currentSentence == null) {
                this.currentAnnotatorInfo = new HashMap();
            } else if (a_qName.equals("sentence")) {
                this.startSentence(a_atts);
            } else if (a_qName.equals("word")) {
                this.startWord(a_atts);
            }
        }
    }

    @Override
    public void endElement(String a_uri, String a_localName, String a_qName) throws SAXException {
        if ("date".equals(a_qName)) {
            SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
            try {
                this.addDate((SAnnotationContainer)this.getDocument(), df.parse(this.currentText));
            }
            catch (ParseException a_e) {
                logger.warn("Date " + this.currentText + " is not in expected format " + "EEE MMM dd HH:mm:ss z yyyy");
                this.addDateString((SAnnotationContainer)this.getDocument(), this.currentText);
            }
            catch (Exception e) {
                logger.warn("Unable to add date " + this.currentText + ":", (Throwable)e);
            }
        } else if (a_qName.equals("annotator") && this.currentSentence == null) {
            this.addAnnotator(this.currentAnnotatorInfo);
        } else if (this.currentSentence == null && (a_qName.equals("short") || a_qName.equals("name") || a_qName.equals("address"))) {
            this.currentAnnotatorInfo.put(a_qName, this.currentText);
        } else if (a_qName.equals("primary") || a_qName.equals("secondary") || a_qName.equals("annotator") && this.currentSentence != null) {
            String shortname = "annotator";
            if (!a_qName.equals("annotator")) {
                shortname = shortname + "_" + a_qName;
            }
            String fullname = "perseus::" + shortname;
            SAnnotation ann = this.currentSentence.getAnnotation(fullname);
            if (this.currentSentence != null) {
                if (ann != null) {
                    ann.setValue((Object)(ann.getValue() + "," + this.currentText));
                } else {
                    ann = this.addAnnotationString((SAnnotationContainer)this.currentSentence, shortname, this.currentText);
                }
            }
        } else if (a_qName.equals("sentence")) {
            this.endSentence();
        }
    }

    @Override
    public void characters(char[] a_ch, int a_start, int a_length) throws SAXException {
        this.currentText = this.currentText + new String(a_ch, a_start, a_length);
    }

    private void initDocument() {
        this.currentSentence = null;
        this.currentText = null;
        this.currentAnnotatorInfo = null;
        this.sDocument = null;
    }

    public void setProps(Properties a_props) {
        if (a_props != null) {
            this.citation_base_uri = a_props.getProperty("citation_base_uri");
        }
    }

    public void setDocument(SDocument a_sDocument) {
        this.initDocument();
        this.sDocument = a_sDocument;
        this.docList.add(a_sDocument);
        logger.debug("Creating DocumentGraph for " + this.getDocument().getId());
        this.sDocument.setDocumentGraph(SaltFactory.createSDocumentGraph());
        String name = this.getDocName(a_sDocument);
        this.sDocument.getDocumentGraph().setName(name);
        this.sDocument.getDocumentGraph().setId(this.getDocument().getId());
        logger.debug("Adding TextDS");
        STextualDS sTextDS = SaltFactory.createSTextualDS();
        this.setText(sTextDS);
        this.sDocument.getDocumentGraph().addNode((Node)sTextDS);
        this.addSMetaAnnotationString((SAnnotationContainer)this.getDocument(), "DOCUMENT_ID", name);
    }

    public SDocument getDocument() {
        return this.sDocument;
    }

    public void setText(STextualDS a_sTextDS) {
        this.sTextDS = a_sTextDS;
    }

    public STextualDS getTextDS() {
        return this.sTextDS;
    }

    private void addDate(SAnnotationContainer a_elem, Date a_date) {
        SMetaAnnotation ann = SaltFactory.createSMetaAnnotation();
        ann.setNamespace("perseus");
        ann.setName("date");
        ann.setValue((Object)a_date);
        a_elem.addMetaAnnotation(ann);
    }

    private void addDateString(SAnnotationContainer a_elem, String a_date) {
        SMetaAnnotation ann = SaltFactory.createSMetaAnnotation();
        ann.setNamespace("perseus");
        ann.setName("date");
        ann.setValue((Object)a_date);
        a_elem.addMetaAnnotation(ann);
    }

    private void addAnnotator(Map a_info) {
        String key = (String)a_info.get("short");
        String nameStr = (String)a_info.get("name");
        String addyStr = (String)a_info.get("address");
        HashMap ann = new HashMap();
        this.allAnnotators.put(key, nameStr + "," + addyStr);
    }

    private String getLongString(String a_att, String a_value) {
        return (String)abbrevMap.get(a_att).get(a_value);
    }

    private void startWord(Attributes a_atts) {
        SLemmaAnnotation sAnno;
        logger.debug("Starting Word");
        SToken sToken = SaltFactory.createSToken();
        this.getDocument().getDocumentGraph().addNode((Node)sToken);
        String postag = a_atts.getValue("postag");
        String lemmaFull = a_atts.getValue("lemma");
        String lemma = null;
        String sense = null;
        if (lemmaFull != null) {
            lemma = lemmaFull.replaceAll("[0-9]*$", "");
            sense = lemmaFull.replaceAll("^[^0-9]+", "");
        }
        String form = a_atts.getValue("form");
        String relation = a_atts.getValue("relation");
        String id = a_atts.getValue("id");
        String cid = a_atts.getValue("cid");
        String head = a_atts.getValue("head");
        String urn = a_atts.getValue("cite");
        if (urn != null && !urn.equalsIgnoreCase("")) {
            this.addAnnotationString((SAnnotationContainer)sToken, "urn", urn);
            if (this.citation_base_uri != null) {
                this.addAnnotationString((SAnnotationContainer)sToken, "cite", "<a href='" + this.citation_base_uri + urn + "' target='_blank'>" + "Text" + "</a>");
            }
        }
        this.addAnnotationString((SAnnotationContainer)sToken, "word_id", cid);
        if (postag != null && !postag.equalsIgnoreCase("")) {
            logger.debug("Adding POSTAG annotation");
            sAnno = SaltFactory.createSAnnotation();
            sAnno.setNamespace("perseus");
            sAnno.setName("postag");
            sAnno.setValue((Object)postag);
            sToken.addAnnotation((SAnnotation)sAnno);
            SPOSAnnotation pAnno = SaltFactory.createSPOSAnnotation();
            String pos = postag.substring(0, 1);
            if (!pos.equals("-")) {
                logger.debug("Adding POFS annotation");
                pAnno.setValue((Object)this.getLongString("part-of-speech", pos));
                sToken.addAnnotation((SAnnotation)pAnno);
            }
            for (String key : postagMap.keySet()) {
                int index = postagMap.get(key);
                String value = null;
                try {
                    value = postag.substring(index, index + 1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (value == null || value.equals("-")) continue;
                logger.debug("Adding annotation: " + key + "=" + value);
                sAnno = SaltFactory.createSAnnotation();
                sAnno.setNamespace("perseus");
                sAnno.setName(key);
                sAnno.setValue((Object)this.getLongString(key, value));
                sToken.addAnnotation((SAnnotation)sAnno);
            }
        }
        if (lemma != null && !lemma.isEmpty()) {
            sAnno = SaltFactory.createSLemmaAnnotation();
            sAnno.setValue((Object)lemma);
            sAnno.setNamespace("perseus");
            sToken.addAnnotation((SAnnotation)sAnno);
            logger.debug("Added Lemma Annotation " + sAnno.getValue_STEXT());
        }
        if (sense != null && !sense.isEmpty()) {
            this.addAnnotationString((SAnnotationContainer)sToken, "sense", sense);
        }
        if (form != null && !form.isEmpty()) {
            logger.debug("Adding Form Annotation");
            sAnno = SaltFactory.createSAnnotation();
            sAnno.setValue((Object)form);
            sAnno.setNamespace("perseus");
            sAnno.setName("form");
            sToken.addAnnotation((SAnnotation)sAnno);
        }
        this.tokenMap.put(id, sToken);
        if (!head.equals("0")) {
            this.saveDependency(head, id, relation);
        } else {
            logger.debug("Linking root word to sentence " + this.currentSentence.getId());
            SDominanceRelation tDomRel = SaltFactory.createSDominanceRelation();
            tDomRel.setSource((Node)this.currentSentence);
            tDomRel.setTarget((Node)sToken);
            SAnnotation sAnno2 = SaltFactory.createSAnnotation();
            sAnno2.setNamespace("perseus");
            sAnno2.setName("relation");
            sAnno2.setValue((Object)relation);
            tDomRel.addAnnotation(sAnno2);
            this.getDocument().getDocumentGraph().addRelation((Relation)tDomRel);
            logger.debug("Linked root word to sentence " + this.currentSentence.getId());
        }
        if (this.getTextDS().getText() == null) {
            this.getTextDS().setText("");
        }
        this.getTextDS().setText(this.getTextDS().getText() + DEFAULT_SEPARATOR);
        Integer startPos = 0;
        Integer endPos = 0;
        startPos = this.getTextDS().getText().length();
        this.getTextDS().setText(this.getTextDS().getText() + form);
        endPos = this.getTextDS().getText().length();
        STextualRelation sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)this.getTextDS());
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)startPos);
        sTextRel.setEnd((Number)endPos);
        this.getDocument().getDocumentGraph().addRelation((Relation)sTextRel);
    }

    private void startSentence(Attributes a_atts) {
        logger.debug("Adding Sentence " + a_atts.getValue("id"));
        SStructure sStructure = SaltFactory.createSStructure();
        this.getDocument().getDocumentGraph().addNode((Node)sStructure);
        this.currentSentence = sStructure;
        SCatAnnotation sAnno = SaltFactory.createSCatAnnotation();
        sAnno.setNamespace("perseus");
        sAnno.setValue((Object)"S");
        sStructure.addAnnotation((SAnnotation)sAnno);
        String docId = a_atts.getValue("document_id");
        String subDoc = a_atts.getValue("subdoc");
        String span = a_atts.getValue("span");
        String id = a_atts.getValue("id");
        ArrayList<String> chunkIds = new ArrayList<String>();
        String[] subdocs = subDoc.split(DEFAULT_SEPARATOR);
        for (int i = 0; i < subdocs.length; ++i) {
            String citeDoc = subdocs[i];
            if (citeDoc.startsWith("urn:cts:")) {
                chunkIds.add(citeDoc);
                continue;
            }
            chunkIds.add(docId + ":" + citeDoc);
        }
        this.addAnnotationString((SAnnotationContainer)sStructure, "sentence_id", id);
        this.addAnnotationString((SAnnotationContainer)sStructure, "subdoc", StringUtils.join((Object[])chunkIds.toArray(), (String)","));
        if (span != null) {
            this.addAnnotationString((SAnnotationContainer)sStructure, "span", span.replaceAll("\\\\", Matcher.quoteReplacement("\\\\")));
        }
        this.tokenMap = new HashMap();
        this.tokenRelMap = new HashMap();
    }

    private void endSentence() {
        for (String key : this.tokenMap.keySet()) {
            this.setDependency(key);
        }
    }

    private void saveDependency(String a_source, String a_target, String a_rel) {
        HashMap<String, String> relMap = new HashMap<String, String>();
        relMap.put(a_target, a_rel);
        if (!this.tokenRelMap.containsKey(a_source)) {
            this.tokenRelMap.put(a_source, new ArrayList());
        }
        this.tokenRelMap.get(a_source).add(relMap);
    }

    private void setDependency(String a_source) {
        SToken parent = this.tokenMap.get(a_source);
        logger.debug("Adding Token Dependency:" + a_source);
        ArrayList<HashMap<String, String>> rels = this.tokenRelMap.get(a_source);
        if (rels != null) {
            for (HashMap<String, String> relMap : rels) {
                for (String key : relMap.keySet()) {
                    SPointingRelation sRel = SaltFactory.createSPointingRelation();
                    sRel.setType("parent");
                    sRel.setSource((Node)parent);
                    this.getDocument().getDocumentGraph().addRelation((Relation)sRel);
                    logger.debug("Adding Dependency Relation: " + relMap.get(key) + DEFAULT_SEPARATOR + a_source + " to " + key + " node " + this.tokenMap.get(key));
                    sRel.setTarget((Node)this.tokenMap.get(key));
                    SAnnotation sAnno = SaltFactory.createSAnnotation();
                    sAnno.setNamespace("perseus");
                    sAnno.setName("relation");
                    sAnno.setValue((Object)relMap.get(key));
                    sRel.addAnnotation(sAnno);
                }
            }
        }
    }

    public static void main(String[] a_args) {
        String documentPath = a_args[0];
        Perseus2SaltMapper mapper = new Perseus2SaltMapper();
        SDocument sdoc = SaltFactory.createSDocument();
        mapper.setDocument(sdoc);
        File resourceFolder = new File("./src/main/resources");
        mapper.setResourcesURI(URI.createFileURI((String)resourceFolder.getAbsolutePath()));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(documentPath, (DefaultHandler)mapper);
        }
        catch (Exception a_e) {
            throw new PepperModuleException("Unable to parse " + documentPath + ":", (Throwable)a_e);
        }
    }

    private SMetaAnnotation addSMetaAnnotationString(SAnnotationContainer a_elem, String a_name, String a_value) {
        SMetaAnnotation ann = SaltFactory.createSMetaAnnotation();
        ann.setNamespace("perseus");
        ann.setName(a_name);
        ann.setValue((Object)a_value);
        a_elem.addMetaAnnotation(ann);
        return ann;
    }

    private SAnnotation addAnnotationString(SAnnotationContainer a_elem, String a_name, String a_value) {
        SAnnotation ann = SaltFactory.createSAnnotation();
        ann.setNamespace("perseus");
        ann.setName(a_name);
        ann.setValue((Object)a_value);
        a_elem.addAnnotation(ann);
        return ann;
    }

    private SProcessingAnnotation addSProcessingAnnotationString(SAnnotationContainer a_elem, String a_name, String a_value) {
        SProcessingAnnotation ann = SaltFactory.createSProcessingAnnotation();
        ann.setNamespace("perseus");
        ann.setName(a_name);
        ann.setValue((Object)a_value);
        a_elem.addProcessingAnnotation(ann);
        return ann;
    }

    private String getDocName(SDocument a_doc) {
        String name = "";
        URI uri = a_doc.getPath();
        int segs = uri.segmentCount();
        if (segs > 1) {
            for (int i = 1; i < segs; ++i) {
                if (!name.isEmpty()) {
                    name = name + ".";
                }
                name = name + uri.segment(i);
            }
        } else {
            name = uri.segment(0);
        }
        return name;
    }
}

