/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.coraXMLModules;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.xml.sax.Attributes;

class Text {
    private SDocumentGraph graph;
    private Map<String, TextLayer> sub_layers = new Hashtable<String, TextLayer>();
    private ModLayer mod_layer;
    private STimeline timeline;

    private TextLayer make_layer(String layer_name) {
        return new TextLayer(layer_name, this.graph);
    }

    private ModLayer make_annotatable_layer(String layer_name, Set<String> boundary_types) {
        return new ModLayer(layer_name, this.graph, boundary_types);
    }

    private Text() {
    }

    public Text(SDocumentGraph the_graph, String tok_dipl_name, String tok_mod_name, String dipl_seg_name, String mod_seg_name, String tok_dipl_textlayer, String tok_mod_textlayer, boolean export_token_layer, String comments_layer_name, boolean export_subtoken_annotation, Set<String> boundary_types) {
        this.graph = the_graph;
        if (export_token_layer) {
            TextLayer tok_layer = this.make_layer("trans");
            tok_layer.set_seg("token");
            this.sub_layers.put("token", tok_layer);
        }
        TextLayer dipl_layer = this.make_layer(tok_dipl_textlayer);
        dipl_layer.set_seg(dipl_seg_name);
        this.mod_layer = this.make_annotatable_layer(tok_mod_textlayer, boundary_types);
        this.mod_layer.set_seg(mod_seg_name);
        this.sub_layers.put(tok_dipl_name, dipl_layer);
        this.sub_layers.put(tok_mod_name, this.mod_layer);
        if (export_subtoken_annotation) {
            TextLayer subtok_layer = this.make_layer("trans");
            subtok_layer.set_seg("tok_sub");
            this.sub_layers.put("sub", subtok_layer);
        }
        if (!comments_layer_name.isEmpty() && !this.sub_layers.containsKey(comments_layer_name)) {
            TextLayer comments_layer = this.make_layer(comments_layer_name);
            comments_layer.set_seg(comments_layer_name);
            this.sub_layers.put(comments_layer_name, comments_layer);
        }
        this.timeline = SaltFactory.createSTimeline();
        this.graph.setTimeline(this.timeline);
        this.timeline.increasePointOfTime();
    }

    public TextLayer layer(String coraxml_name) {
        return this.sub_layers.get(coraxml_name);
    }

    public void annotate(String name, Attributes attr) {
        this.annotate(name, attr.getValue("tag"));
    }

    public void annotate(String name, String value) {
        this.mod_layer.annotate(name, value);
    }

    public void annotate_boundary(String name, Attributes attr) {
        this.annotate_boundary(name, attr.getValue("tag"));
    }

    public void add_tok_to_span(String name, Attributes attr) {
        this.mod_layer.add_to_span(attr.getValue("span-id"));
        if (attr.getValue("tag") != null) {
            this.mod_layer.annotate_span(attr.getValue("span-id"), name, attr.getValue("tag"));
        }
    }

    public void annotate_boundary(String name, String value) {
        this.mod_layer.annotate_boundary(name, value);
    }

    public void map_tokens_to_timeline_simple() {
        Integer start = (Integer)this.timeline.getEnd() - 1;
        int number_of_tokens = 0;
        for (TextLayer l : this.sub_layers.values()) {
            if (number_of_tokens < l.open_tokens.size()) {
                number_of_tokens = l.open_tokens.size();
            }
            l.set_start(start);
        }
        this.timeline.increasePointOfTime(Integer.valueOf(number_of_tokens));
        for (TextLayer l : this.sub_layers.values()) {
            while (l.open_tokens.size() > 1) {
                l.tok_to_timeline(this.timeline, l.current_position + 1);
            }
        }
        Integer end = (Integer)this.timeline.getEnd() - 1;
        for (TextLayer l : this.sub_layers.values()) {
            l.tok_to_timeline(this.timeline, end);
        }
    }

    public void map_tokens_to_timeline_aligned() {
        int start = (Integer)this.timeline.getEnd() - 1;
        TreeSet<Integer> tok_offsets = new TreeSet<Integer>();
        for (String layer : this.sub_layers.keySet()) {
            this.layer(layer).set_start(start);
            if (layer.equals("token")) continue;
            tok_offsets.addAll(this.layer((String)layer).offsets);
        }
        for (Integer tok_offset : tok_offsets) {
            this.timeline.increasePointOfTime();
            int end = (Integer)this.timeline.getEnd() - 1;
            for (String layer : this.sub_layers.keySet()) {
                if (layer.equals("token") || this.layer((String)layer).offsets.size() <= 0 || tok_offset != this.layer((String)layer).offsets.get(0)) continue;
                this.layer(layer).tok_to_timeline(this.timeline, end);
                this.layer((String)layer).offsets.remove(0);
            }
        }
        if (this.layer("token") != null) {
            if (start == (Integer)this.timeline.getEnd() - 1) {
                this.timeline.increasePointOfTime();
            }
            this.layer("token").tok_to_timeline(this.timeline, (Integer)this.timeline.getEnd() - 1);
        }
    }

    protected class ModLayer
    extends TextLayer {
        private Map<String, List<SToken>> open_boundary_tokens;
        private Map<String, SSpan> span_annotations;

        protected ModLayer(String l, SDocumentGraph my_graph, Set<String> boundary_types) {
            super(l, my_graph);
            this.open_boundary_tokens = new HashMap<String, List<SToken>>();
            this.span_annotations = new HashMap<String, SSpan>();
            for (String b_type : boundary_types) {
                this.open_boundary_tokens.put(b_type, new LinkedList());
            }
        }

        @Override
        public ModLayer add_token(Attributes attr) {
            super.add_token(attr);
            for (String b_type : this.open_boundary_tokens.keySet()) {
                this.open_boundary_tokens.get(b_type).add(this.last_token());
            }
            return this;
        }

        public void add_to_span(String id) {
            SSpan span;
            if (this.last_token() == null) {
                return;
            }
            if (this.span_annotations.containsKey(id)) {
                span = this.span_annotations.get(id);
            } else {
                span = SaltFactory.createSSpan();
                Text.this.graph.addNode((Node)span);
                this.span_annotations.put(id, span);
            }
            SSpanningRelation rel = SaltFactory.createSSpanningRelation();
            rel.setSource((Node)span);
            rel.setTarget((Node)this.last_token());
            Text.this.graph.addRelation((Relation)rel);
        }

        public void annotate_span(String id, String name, String value) {
            if (this.span_annotations.containsKey(id)) {
                this.span_annotations.get(id).createAnnotation("annotation", name, (Object)value);
            }
        }

        public void annotate_boundary(String name, String value) {
            List<SToken> boundary_tokens = this.open_boundary_tokens.get(name);
            if (boundary_tokens != null) {
                if (!value.equals("None")) {
                    SSpan span = SaltFactory.createSSpan();
                    span.createAnnotation("annotation", name, (Object)value);
                    Text.this.graph.addNode((Node)span);
                    for (SToken tok : boundary_tokens) {
                        SSpanningRelation rel = SaltFactory.createSSpanningRelation();
                        rel.setSource((Node)span);
                        rel.setTarget((Node)tok);
                        Text.this.graph.addRelation((Relation)rel);
                    }
                }
                boundary_tokens.clear();
            }
        }

        public SAnnotation annotate(String name, String value) {
            if (this.last_token() == null) {
                return null;
            }
            return this.last_token().createAnnotation("annotation", name, (Object)value);
        }
    }

    protected class TextLayer {
        private STextualDS textual;
        private SDocumentGraph graph;
        private String layer_name;
        protected String seg_name;
        private SToken last_added = null;
        private Integer current_position = 0;
        protected Queue<SToken> open_tokens = new LinkedList<SToken>();
        protected List<Integer> offsets = new LinkedList<Integer>();

        protected TextLayer(String l, SDocumentGraph my_graph) {
            this.layer_name = l;
            this.graph = my_graph;
            this.textual = SaltFactory.createSTextualDS();
            this.textual.setText("");
            this.graph.addNode((Node)this.textual);
        }

        public void set_seg(String name) {
            this.seg_name = name;
            this.textual.setName(this.seg_name);
        }

        void set_start(Integer pos) {
            this.current_position = pos;
        }

        protected int last_offset() {
            if (this.offsets.isEmpty()) {
                return 0;
            }
            return this.offsets.get(this.offsets.size() - 1);
        }

        public SToken last_token() {
            return this.last_added;
        }

        private SToken add_text(String value) {
            int left_pos = this.textual.getText().length();
            value = StringEscapeUtils.unescapeHtml4((String)value);
            this.textual.setText(this.textual.getText() + value);
            int right_pos = left_pos + value.length();
            return this.graph.createToken((SSequentialDS)this.textual, Integer.valueOf(left_pos), Integer.valueOf(right_pos));
        }

        public TextLayer add_token(String value, Integer len) {
            SToken tok = this.add_text(value);
            this.order(this.last_added, tok);
            if (this.open_tokens != null && this.offsets != null) {
                this.open_tokens.add(tok);
                this.offsets.add(this.last_offset() + len);
            }
            this.last_added = tok;
            this.textual.setText(this.textual.getText() + " ");
            return this;
        }

        public TextLayer add_token(Attributes attr) {
            return this.add_token(attr.getValue(this.layer_name), attr.getValue("trans").length());
        }

        public TextLayer add_comment(String text, String type) {
            this.add_token(text, 1);
            this.last_token().createAnnotation("annotation", "editorial_comment", (Object)type);
            return this;
        }

        private Subtokenizer subtokenizerFactory(String style) {
            if (style.equals("REN")) {
                return new RENSubtokenizer();
            }
            return null;
        }

        public TextLayer add_token(Attributes attr, String subtok_ann_style) {
            Subtokenizer subtok = this.subtokenizerFactory(subtok_ann_style);
            if (subtok == null) {
                throw new RuntimeException("Transcription-style " + subtok_ann_style + " is not implemented.");
            }
            String transcription = attr.getValue("trans");
            TreeSet<Integer> splitpoints = new TreeSet<Integer>();
            LinkedList<Subtokenspan> spans = new LinkedList<Subtokenspan>();
            subtok.add_subtoken_spans(transcription, splitpoints, spans);
            splitpoints.add(transcription.length());
            splitpoints.remove(0);
            LinkedList<String> parts = new LinkedList<String>();
            Integer last_split = 0;
            for (Integer split : splitpoints) {
                if (subtok.remove_special(transcription.substring(last_split, split)).isEmpty()) continue;
                parts.add(transcription.substring(last_split, split));
                last_split = split;
            }
            if (last_split < transcription.length()) {
                parts.set(parts.size() - 1, (String)parts.get(parts.size() - 1) + transcription.substring(last_split, transcription.length()));
            }
            int position = 0;
            for (int i = 0; i < parts.size(); ++i) {
                int len = ((String)parts.get(i)).length();
                String text = subtok.remove_special((String)parts.get(i));
                this.add_token(text, len);
                int pos0 = position;
                position += ((String)parts.get(i)).indexOf(text);
                for (Subtokenspan span : spans) {
                    if (position < span.getStart() || position >= span.getEnd()) continue;
                    SSpanningRelation rel = SaltFactory.createSSpanningRelation();
                    rel.setSource((Node)span.getSpan());
                    rel.setTarget((Node)this.last_token());
                    this.graph.addRelation((Relation)rel);
                }
                position = pos0 + len;
            }
            return this;
        }

        private void order(SToken source, SToken target) {
            if (source == null) {
                return;
            }
            SOrderRelation rel = SaltFactory.createSOrderRelation();
            rel.setSource((Node)source);
            rel.setTarget((Node)target);
            rel.setType(this.seg_name);
            this.graph.addRelation((Relation)rel);
        }

        public void tok_to_timeline(STimeline timeline, Integer end) {
            SToken tok = this.open_tokens.poll();
            if (tok == null) {
                return;
            }
            STimelineRelation rel = SaltFactory.createSTimelineRelation();
            rel.setTarget((Node)timeline);
            rel.setSource((Node)tok);
            rel.setStart((Number)this.current_position);
            rel.setEnd((Number)end);
            this.graph.addRelation((Relation)rel);
            this.current_position = end;
        }

        class RENSubtokenizer
        extends Subtokenizer {
            public RENSubtokenizer() {
                this.markup_types.put("unreadable", "\\[[^\\]]+\\]");
                this.markup_types.put("deleted", "\u01c2[^\u01c2]+\u01c2");
                this.markup_types.put("expanded", "\\{._[^}]+\\}");
                this.markup_types.put("para", "\\*[ILROUT][NKE]_[^*]+\\*");
            }

            @Override
            public String remove_special(String text) {
                return text.replaceAll("[\\[\\]}\u01c2#\u00a7]", "").replaceAll("\\{._", "").replaceAll("\\*[ILROUT][NKE]_", "").replaceAll("\\*", "");
            }
        }

        abstract class Subtokenizer {
            Map<String, String> markup_types = new HashMap<String, String>();

            Subtokenizer() {
            }

            public abstract String remove_special(String var1);

            public void add_subtoken_spans(String transcription, Set<Integer> splitpoints, List<Subtokenspan> spans) {
                for (Map.Entry<String, String> type : this.markup_types.entrySet()) {
                    this.add_subtoken_span(transcription, type.getValue(), type.getKey(), splitpoints, spans);
                }
            }

            private void add_subtoken_span(String transcription, String regex, String type, Set<Integer> splitpoints, List<Subtokenspan> spans) {
                Matcher m = Pattern.compile(regex).matcher(transcription);
                while (m.find()) {
                    splitpoints.add(m.start(0));
                    splitpoints.add(m.end(0));
                    spans.add(new Subtokenspan(m.start(0), m.end(0), type, this.remove_special(m.group(0))));
                }
            }
        }

        class Subtokenspan {
            private int start;
            private int end;
            private SSpan span;

            Subtokenspan(int start, int end, String type, String text) {
                this.setStart(start);
                this.setEnd(end);
                this.span = SaltFactory.createSSpan();
                TextLayer.this.graph.addNode((Node)this.getSpan());
                this.getSpan().createAnnotation("annotation", type, (Object)text);
            }

            public int getStart() {
                return this.start;
            }

            public void setStart(int start) {
                this.start = start;
            }

            public int getEnd() {
                return this.end;
            }

            public void setEnd(int end) {
                this.end = end;
            }

            public SSpan getSpan() {
                return this.span;
            }
        }
    }
}

