/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.coraXMLModules;

import java.util.Hashtable;
import java.util.Map;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.xml.sax.Attributes;

class Layout {
    private SDocumentGraph graph;
    private Map<String, LayoutElement> element_starts = new Hashtable<String, LayoutElement>();
    private LayoutElement last_page;
    private char current_column = (char)97;
    private LayoutElement current_element;

    private Layout() {
    }

    public Layout(SDocumentGraph the_graph) {
        this.graph = the_graph;
    }

    private void update(String id, LayoutElement elem) {
        if (this.element_starts.get(id) != null) {
            this.current_element = this.element_starts.get(id);
            this.element_starts.remove(this.current_element);
        }
        elem.set_connection(this.current_element);
    }

    private void add(LayoutElement element) {
        this.element_starts.put(element.from(), element);
    }

    private LayoutElement make_element(int level, String annis_name) {
        return new LayoutElement(level, annis_name, this.graph);
    }

    public Layout make_page(Attributes attr) {
        LayoutElement page = this.make_element(0, "page").set_range(attr).set_value(attr.getValue("no"));
        if (this.last_page == null || !this.last_page.value.equals(page.value)) {
            this.add(page);
            this.last_page = page;
        } else {
            this.last_page.to = page.to();
        }
        return this;
    }

    public Layout make_side(Attributes attr) {
        if (attr.getValue("side") == null || attr.getValue("side").isEmpty()) {
            return this;
        }
        LayoutElement side = this.make_element(1, "side").set_range(attr).set_value(attr.getValue("side"));
        this.update(side.from, side);
        this.add(side);
        return this;
    }

    public String make_column(Attributes attr) {
        if (this.element_starts.get(attr.getValue("id")) != null) {
            this.current_column = (char)97;
        }
        String col_name = attr.getValue("name") != null ? attr.getValue("name") : Character.toString(this.current_column);
        this.current_column = (char)(this.current_column + '\u0001');
        LayoutElement column = this.make_element(2, "column").set_range(attr).set_value(col_name);
        this.update(attr.getValue("id"), column);
        this.add(column);
        return col_name;
    }

    public Layout make_line(Attributes attr) {
        LayoutElement line = this.make_element(3, "line").set_range(attr).set_value(attr.getValue("name"));
        this.update(attr.getValue("id"), line);
        this.add(line);
        if (attr.getValue("loc") != null) {
            LayoutElement loc = this.make_element(4, "reference").set_range(attr).set_value(attr.getValue("loc"));
            this.update(loc.from(), loc);
            this.add(loc);
        }
        return this;
    }

    public Layout render(String id, SToken tok) {
        if (this.element_starts.get(id) != null) {
            this.current_element = this.element_starts.get(id);
        }
        this.current_element.render(tok);
        return this;
    }

    class LayoutElement {
        private int level;
        private String name;
        private SDocumentGraph graph;
        private SSpan span;
        protected String from;
        protected String to;
        protected LayoutElement parent_from;
        private String namespace = "layout";
        public String value;

        public String toString() {
            return "{" + this.name + "(" + this.from + ".." + this.to + ") (parent:" + this.parent_from + ")}";
        }

        protected LayoutElement() {
        }

        protected LayoutElement(int my_level, String annis_name, SDocumentGraph the_graph) {
            this.level = my_level;
            this.name = annis_name;
            this.graph = the_graph;
        }

        public LayoutElement set_range(Attributes attr) {
            String[] rangeparts = attr.getValue("range").split("[.][.]");
            this.from = rangeparts[0];
            this.to = rangeparts.length == 1 ? rangeparts[0] : rangeparts[1];
            return this;
        }

        public String from() {
            return this.from;
        }

        public String to() {
            return this.to;
        }

        public LayoutElement set_connection(LayoutElement elem) {
            if (this.name == elem.name) {
                this.parent_from = elem.parent_from;
                return this;
            }
            if (this.level > elem.level) {
                this.parent_from = elem;
            }
            if (this.level < elem.level) {
                this.parent_from = elem.parent_from.parent_from;
            }
            return this;
        }

        public LayoutElement set_value(String val) {
            this.value = val;
            return this;
        }

        private void span_on_tok(SToken tok) {
            SSpanningRelation rel = SaltFactory.createSSpanningRelation();
            rel.setSource((Node)this.get_span());
            rel.setTarget((Node)tok);
            this.graph.addRelation((Relation)rel);
        }

        public void render(SToken tok) {
            this.span_on_tok(tok);
            if (this.parent_from != null) {
                this.parent_from.render(tok);
            }
        }

        private SSpan get_span() {
            if (this.span == null) {
                this.span = SaltFactory.createSSpan();
                this.span.createAnnotation(this.namespace, this.name, (Object)this.value);
                this.graph.addNode((Node)this.span);
            }
            return this.span;
        }
    }
}

