/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.coraXMLModules;

import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.peppermodules.coraXMLModules.CoraXMLDictionary;

public class CoraXMLImporterProperties
extends PepperModuleProperties
implements CoraXMLDictionary {
    public static final String PREFIX_TOKTEXT = "toktext.";
    public static final String PREFIX_EXPORT = "export.";
    public static final String PROP_TOKTEXT_MOD = "toktext.mod";
    public static final String PROP_TOKTEXT_DIPL = "toktext.dipl";
    public static final String PROP_TOK_MOD = "mod";
    public static final String PROP_TOK_DIPL = "dipl";
    public static final String PROP_TOK_PREFIX = "tok.prefix";
    public static final String PROP_EXPORT_TOKEN = "export.token";
    public static final String PROP_CREATE_REFERENCE_SPAN = "export.create_reference";
    public static final String PROP_COMMENT_LAYER_NAME = "export.layer_for_comments";
    public static final String PROP_EXPORT_SUBTOKEN = "export.subtoken_markup";
    public static final String PROP_BOUNDARY_ANNOTATIONS = "export.boundary_tags";
    public static final String PROP_TOK_IS_SEG = "mod/dipl_eq_token";
    public static final String PROP_EXCLUDE_ANNOTATIONS = "exclude_from_import";

    public CoraXMLImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_TOKTEXT_MOD, String.class, "This property defines which attribute of the mod-Tag is used for the token texts (trans, utf or ascii). By default, the simplified ascii version is used (value:ascii)", (Object)"ascii", false));
        this.addProperty(new PepperModuleProperty(PROP_TOKTEXT_DIPL, String.class, "This property defines which attribute of the dipl-Tag is used for the token texts (trans or utf). By default, the unicode version is used (value:utf)", (Object)"utf", false));
        this.addProperty(new PepperModuleProperty(PROP_EXPORT_TOKEN, Boolean.class, "This property defines whether the token layer is exported. By default, it is exported (value:true)", (Object)Boolean.TRUE, false));
        this.addProperty(new PepperModuleProperty(PROP_CREATE_REFERENCE_SPAN, Boolean.class, "This property defines whether a reference span is created for lines. By default, it is not created (unless lines have a \"loc\"-attribute) (value:false)", (Object)Boolean.FALSE, false));
        this.addProperty(new PepperModuleProperty(PROP_COMMENT_LAYER_NAME, String.class, "This property defines the layer to which top-level comments are exported. By default, they are not exported (value:\"\")", (Object)"", false));
        this.addProperty(new PepperModuleProperty(PROP_EXPORT_SUBTOKEN, String.class, "This property defines whether markup in the transcription is turned into subtoken-annotations. The content of the string gives the name of the markup rules used. By default, no subtoken-annotations are created (value:\"\")", (Object)"", false));
        this.addProperty(new PepperModuleProperty(PROP_TOK_IS_SEG, Boolean.class, "This property defines whether mod and dipl each are strict segmentations of token, i.e. the combined values of trans for each are equal with the trans-value of token. By default, this is not assumed (value:false)", (Object)Boolean.FALSE, false));
        this.addProperty(new PepperModuleProperty(PROP_EXCLUDE_ANNOTATIONS, String.class, "This property defines a semicolon separated list of annotations that are ignored. By default all annotations are imported (value:\"\").", (Object)"", false));
        this.addProperty(new PepperModuleProperty(PROP_BOUNDARY_ANNOTATIONS, String.class, "This property defines a semicolon separated list of annotations that are treated as boundary annotatotions. By default this is the tag boundary (value:boundary)", (Object)"boundary", false));
        this.addProperty(new PepperModuleProperty(PROP_TOK_MOD, String.class, "Name of the element in CoraXML containing the 'mod-token'", (Object)PROP_TOK_MOD, false));
        this.addProperty(new PepperModuleProperty(PROP_TOK_DIPL, String.class, "Name of the element in CoraXML containing the 'dipl-token'", (Object)PROP_TOK_DIPL, false));
        this.addProperty(new PepperModuleProperty(PROP_TOK_PREFIX, String.class, "This property defines a prefix that is attached to 'dipl-token' and 'mod-token' output layers.", (Object)"", false));
    }

    public String getExcludeAnnotations() {
        return (String)this.getProperty(PROP_EXCLUDE_ANNOTATIONS).getValue();
    }

    public String getTokName(String type) {
        if (PROP_TOK_MOD.equals(type)) {
            return (String)this.getProperty(PROP_TOK_MOD).getValue();
        }
        if (PROP_TOK_DIPL.equals(type)) {
            return (String)this.getProperty(PROP_TOK_DIPL).getValue();
        }
        throw new Error("argument must be either dipl or mod");
    }

    public String getDiplTokTextlayer() {
        return (String)this.getProperty(PROP_TOKTEXT_DIPL).getValue();
    }

    public String getModTokTextlayer() {
        return (String)this.getProperty(PROP_TOKTEXT_MOD).getValue();
    }

    public String getTokLayerPrefix() {
        return (String)this.getProperty(PROP_TOK_PREFIX).getValue();
    }

    public boolean getExportTokenLayer() {
        return (Boolean)this.getProperty(PROP_EXPORT_TOKEN).getValue();
    }

    public boolean getCreateReferenceSpan() {
        return (Boolean)this.getProperty(PROP_CREATE_REFERENCE_SPAN).getValue();
    }

    public String getExportCommentsToLayer() {
        return (String)this.getProperty(PROP_COMMENT_LAYER_NAME).getValue();
    }

    public String getExportSubtokenannotation() {
        return (String)this.getProperty(PROP_EXPORT_SUBTOKEN).getValue();
    }

    public boolean getTokenizationIsSegmentation() {
        return (Boolean)this.getProperty(PROP_TOK_IS_SEG).getValue();
    }

    public String getBoundaryAnnotations() {
        return (String)this.getProperty(PROP_BOUNDARY_ANNOTATIONS).getValue();
    }
}

