/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.coraXMLModules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.peppermodules.coraXMLModules.CoraXML2SaltMapper;
import org.corpus_tools.peppermodules.coraXMLModules.CoraXMLDictionary;
import org.corpus_tools.peppermodules.coraXMLModules.CoraXMLImporterProperties;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="CoraXMLImporterComponent", factory="PepperImporterComponentFactory")
public class CoraXMLImporter
extends PepperImporterImpl
implements PepperImporter,
CoraXMLDictionary {
    public static final String MODULE_NAME = "CoraXMLImporter";
    private static final Pattern CORAXML_PATTERN1 = Pattern.compile("<?xml version=(\"|')1[.]0(\"|')");
    private static final Pattern CORAXML_PATTERN2 = Pattern.compile("<cora-header");
    public static final String FORMAT_NAME = "coraXML";
    public static final String FORMAT_VERSION = "1.0";
    private String mod_tok_textlayer = "ascii";
    private String dipl_tok_textlayer = "utf";
    private String tok_anno = "mod";
    private String tok_dipl = "dipl";
    private String tok_layer_prefix = "";
    private boolean export_token_layer = true;
    private boolean create_reference_span = false;
    private String comment_layer_name = "";
    private String export_subtoken_annotation = "";
    private boolean tokenization_is_segmentation = false;
    private String annotations_to_exclude = "";
    private String boundary_tags = "boundary";

    public CoraXMLImporter() {
        this.setProperties(new CoraXMLImporterProperties());
        this.setName(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-CoraXMLModules"));
        this.setDesc("This importer transforms data in cora xml format to a Salt model. ");
        this.setVersion(FORMAT_VERSION);
        this.addSupportedFormat(FORMAT_NAME, FORMAT_VERSION, null);
        this.getDocumentEndings().add("xml");
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        CoraXML2SaltMapper mapper = new CoraXML2SaltMapper();
        mapper.setModTokTextlayer(this.mod_tok_textlayer);
        mapper.setDiplTokTextlayer(this.dipl_tok_textlayer);
        mapper.setExportTokenLayer(this.export_token_layer);
        mapper.setCreateReferenceSpan(this.create_reference_span);
        mapper.setExportCommentsToLayer(this.comment_layer_name);
        mapper.setExportSubtokenannotation(this.export_subtoken_annotation);
        mapper.setTokenizationIsSegmentation(this.tokenization_is_segmentation);
        mapper.setExcludeAnnotations(this.annotations_to_exclude);
        mapper.setBoundaryAnnotations(this.boundary_tags);
        mapper.setTokNames(this.tok_anno, this.tok_dipl);
        mapper.setTokLayerNames(this.tok_layer_prefix + this.tok_anno, this.tok_layer_prefix + this.tok_dipl);
        return mapper;
    }

    public Double isImportable(URI corpusPath) {
        Double retValue = 0.0;
        for (String content : this.sampleFileContent(corpusPath, new String[]{"xml"})) {
            Matcher matcher = CORAXML_PATTERN1.matcher(content);
            Matcher matcher2 = CORAXML_PATTERN2.matcher(content);
            if (!matcher.find() || !matcher2.find()) continue;
            retValue = 1.0;
            break;
        }
        return retValue;
    }

    public SelfTestDesc getSelfTestDesc() {
        PepperModuleProperties props = this.getProperties();
        props.setPropertyValue("export.subtoken_markup", (Object)"REN");
        props.setPropertyValue("tok.prefix", (Object)"tok_");
        props.setPropertyValue("toktext.mod", (Object)"utf");
        props.setPropertyValue("mod/dipl_eq_token", (Object)true);
        props.setPropertyValue("export.layer_for_comments", (Object)"token");
        URI inputPath = this.getResources().appendSegment("selfTests").appendSegment("coraXmlImporter").appendSegment("in").appendSegment("ren");
        URI expectedPath = this.getResources().appendSegment("selfTests").appendSegment("coraXmlImporter").appendSegment("expected");
        return new SelfTestDesc.Builder().withInputCorpusPath(inputPath).withExpectedCorpusPath(expectedPath).build();
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        if (this.getProperties() != null) {
            this.mod_tok_textlayer = ((CoraXMLImporterProperties)this.getProperties()).getModTokTextlayer();
            this.dipl_tok_textlayer = ((CoraXMLImporterProperties)this.getProperties()).getDiplTokTextlayer();
            this.export_token_layer = ((CoraXMLImporterProperties)this.getProperties()).getExportTokenLayer();
            this.create_reference_span = ((CoraXMLImporterProperties)this.getProperties()).getCreateReferenceSpan();
            this.comment_layer_name = ((CoraXMLImporterProperties)this.getProperties()).getExportCommentsToLayer();
            this.export_subtoken_annotation = ((CoraXMLImporterProperties)this.getProperties()).getExportSubtokenannotation();
            this.tokenization_is_segmentation = ((CoraXMLImporterProperties)this.getProperties()).getTokenizationIsSegmentation();
            this.annotations_to_exclude = ((CoraXMLImporterProperties)this.getProperties()).getExcludeAnnotations();
            this.boundary_tags = ((CoraXMLImporterProperties)this.getProperties()).getBoundaryAnnotations();
            this.tok_anno = ((CoraXMLImporterProperties)this.getProperties()).getTokName("mod");
            this.tok_dipl = ((CoraXMLImporterProperties)this.getProperties()).getTokName("dipl");
            this.tok_layer_prefix = ((CoraXMLImporterProperties)this.getProperties()).getTokLayerPrefix();
        }
        return super.isReadyToStart();
    }
}

