/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.coraXMLModules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.coraXMLModules.CoraXMLDictionary;
import org.corpus_tools.peppermodules.coraXMLModules.Layout;
import org.corpus_tools.peppermodules.coraXMLModules.Text;
import org.corpus_tools.salt.SaltFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.AttributesImpl;

public class CoraXML2SaltMapper
extends PepperMapperImpl
implements PepperMapper,
CoraXMLDictionary {
    private static final Logger logger = LoggerFactory.getLogger((String)"CoraXMLImporter");
    private String mod_tok_textlayer = "ascii";
    private String dipl_tok_textlayer = "utf";
    private String tok_anno = "mod";
    private String tok_dipl = "dipl";
    private String tok_anno_name = "mod";
    private String tok_dipl_name = "dipl";
    private boolean exportTokenLayer = true;
    private boolean createReferenceSpan = false;
    private String exportCommentsToLayer = "";
    private String exportSubtokenannotation = "";
    private boolean tokenization_is_segmentation = true;
    private Set<String> annotations_to_ignore = new TreeSet<String>();
    private Set<String> boundary_annotations = new HashSet<String>();

    public void setTokNames(String anno, String dipl) {
        this.tok_anno = anno;
        this.tok_dipl = dipl;
    }

    public void setTokLayerNames(String anno, String dipl) {
        this.tok_anno_name = anno;
        this.tok_dipl_name = dipl;
    }

    public void setModTokTextlayer(String textlayer) {
        if ("ascii".equals(textlayer) || "utf".equals(textlayer) || "trans".equals(textlayer)) {
            this.mod_tok_textlayer = textlayer;
        }
    }

    public void setDiplTokTextlayer(String textlayer) {
        if ("utf".equals(textlayer) || "trans".equals(textlayer)) {
            this.dipl_tok_textlayer = textlayer;
        }
    }

    public void setExportTokenLayer(boolean exportTokenLayer) {
        this.exportTokenLayer = exportTokenLayer;
    }

    public void setCreateReferenceSpan(boolean createReferenceSpan) {
        this.createReferenceSpan = createReferenceSpan;
    }

    public void setExportCommentsToLayer(String layerName) {
        this.exportCommentsToLayer = layerName;
    }

    public void setExportSubtokenannotation(String subtokannot) {
        this.exportSubtokenannotation = subtokannot;
    }

    public void setTokenizationIsSegmentation(boolean tokenization_is_segmentation) {
        this.tokenization_is_segmentation = tokenization_is_segmentation;
    }

    public void setExcludeAnnotations(String annotations_to_exclude) {
        this.annotations_to_ignore.addAll(Arrays.asList(annotations_to_exclude.split(";")));
    }

    public void setBoundaryAnnotations(String boundary_annotations) {
        this.boundary_annotations.addAll(Arrays.asList(boundary_annotations.split(";")));
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        CoraXMLReader reader = new CoraXMLReader();
        this.readXMLResource(reader, this.getResourceURI());
        return DOCUMENT_STATUS.COMPLETED;
    }

    class CoraXMLReader
    extends DefaultHandler2 {
        boolean in_mod = false;
        boolean in_header = false;
        boolean meta_is_xml = false;
        String meta_name = "";
        StringBuffer meta_value = new StringBuffer();
        StringBuffer comment_text = new StringBuffer();
        String comment_type;
        Map<String, String> pageNameForBeginning = new HashMap<String, String>();
        String currentPage = null;
        Map<String, String> columnNameForBeginning = new HashMap<String, String>();
        Map<String, String> columnIdForBeginning = new HashMap<String, String>();
        String currentColumn = null;
        private Stack<String> xmlElementStack = null;
        Layout layout = null;
        Text text = null;

        CoraXMLReader() {
        }

        private Stack<String> getXMLELementStack() {
            if (this.xmlElementStack == null) {
                this.xmlElementStack = new Stack();
            }
            return this.xmlElementStack;
        }

        Layout layout() {
            if (this.layout == null) {
                this.layout = new Layout(CoraXML2SaltMapper.this.getDocument().getDocumentGraph());
            }
            return this.layout;
        }

        Text text() {
            if (this.text == null) {
                this.text = new Text(CoraXML2SaltMapper.this.getDocument().getDocumentGraph(), CoraXML2SaltMapper.this.tok_dipl, CoraXML2SaltMapper.this.tok_anno, CoraXML2SaltMapper.this.tok_dipl_name, CoraXML2SaltMapper.this.tok_anno_name, CoraXML2SaltMapper.this.dipl_tok_textlayer, CoraXML2SaltMapper.this.mod_tok_textlayer, CoraXML2SaltMapper.this.exportTokenLayer, CoraXML2SaltMapper.this.exportCommentsToLayer, !CoraXML2SaltMapper.this.exportSubtokenannotation.isEmpty(), CoraXML2SaltMapper.this.boundary_annotations);
            }
            return this.text;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("page".equals(qName)) {
                String pageName = attributes.getValue("no");
                if (attributes.getValue("side") != null) {
                    pageName = pageName + attributes.getValue("side");
                }
                this.pageNameForBeginning.put(attributes.getValue("range").split("[.][.]")[0], pageName);
                this.layout().make_page(attributes).make_side(attributes);
            } else if ("column".equals(qName)) {
                String columnName = this.layout().make_column(attributes);
                String columnBeginning = attributes.getValue("range").split("[.][.]")[0];
                this.columnNameForBeginning.put(columnBeginning, columnName);
                this.columnIdForBeginning.put(columnBeginning, attributes.getValue("id"));
            } else if ("line".equals(qName)) {
                if (this.columnNameForBeginning.containsKey(attributes.getValue("id"))) {
                    String currentColumnId;
                    this.currentColumn = this.columnNameForBeginning.get(attributes.getValue("id"));
                    if (this.currentColumn.equals("<none>") || this.currentColumn.equals("--")) {
                        this.currentColumn = "";
                    }
                    if (this.pageNameForBeginning.containsKey(currentColumnId = this.columnIdForBeginning.get(attributes.getValue("id")))) {
                        this.currentPage = this.pageNameForBeginning.get(currentColumnId);
                    }
                }
                Attributes line_attributes = attributes;
                if (CoraXML2SaltMapper.this.createReferenceSpan && attributes.getValue("loc") == null) {
                    line_attributes = new AttributesImpl(attributes);
                    ((AttributesImpl)line_attributes).addAttribute("", "", "loc", "", this.currentPage + this.currentColumn + "," + attributes.getValue("name"));
                }
                this.layout().make_line(line_attributes);
            } else if ("token".equals(qName)) {
                if (CoraXML2SaltMapper.this.exportTokenLayer) {
                    this.text().layer(qName).add_token(attributes);
                }
            } else if (CoraXML2SaltMapper.this.tok_anno.equals(qName)) {
                this.text().layer(qName).add_token(attributes);
                this.in_mod = true;
            } else if ("header".equals(qName)) {
                this.in_header = true;
            } else if (CoraXML2SaltMapper.this.tok_dipl.equals(qName)) {
                this.text().layer(qName).add_token(attributes);
                this.layout().render(attributes.getValue("id"), this.text().layer(qName).last_token());
                if (!CoraXML2SaltMapper.this.exportSubtokenannotation.isEmpty()) {
                    this.text().layer("sub").add_token(attributes, CoraXML2SaltMapper.this.exportSubtokenannotation);
                }
            } else if (this.in_mod) {
                if (!CoraXML2SaltMapper.this.annotations_to_ignore.contains(qName)) {
                    if (CoraXML2SaltMapper.this.boundary_annotations.contains(qName)) {
                        this.text().annotate_boundary(qName, attributes);
                    } else if ("punc".equals(qName)) {
                        if (attributes.getValue("tag") != "" && attributes.getValue("tag") != "--") {
                            this.text().annotate("punc", attributes);
                        }
                    } else if ("token_type".equals(qName)) {
                        String value = attributes.getValue("tag") != "" ? attributes.getValue("tag") : "--";
                        this.text().annotate("tokenization", value);
                    } else if ("pos_gen".equals(qName)) {
                        this.text().annotate("posLemma", attributes);
                    } else if ("norm".equals(qName) || "norm_broad".equals(qName)) {
                        String ann_name = "norm".equals(qName) ? "norm" : "modern";
                        this.text().annotate(ann_name, attributes);
                    } else if ("inflClass".equals(qName)) {
                        this.text().annotate("inflectionClass", attributes);
                    } else if ("inflClass_gen".equals(qName)) {
                        this.text().annotate("inflectionClassLemma", attributes);
                    } else if ("infl".equals(qName)) {
                        this.text().annotate("inflection", attributes);
                    } else if ("norm_align".equals(qName) || "grapho".equals(qName)) {
                        this.text().annotate("char_align", attributes);
                    } else if ("lemma_idmwb".equals(qName)) {
                        if (!attributes.getValue("tag").equals("--")) {
                            String lemma_link = "<a href='http://www.mhdwb-online.de/lemmaliste/" + attributes.getValue("tag") + "'>" + attributes.getValue("tag") + "</a>";
                            this.text.annotate("lemmaId", lemma_link);
                        }
                    } else if ("lemma_gen".equals(qName)) {
                        this.text().annotate("lemmaLemma", attributes);
                    } else if (attributes.getValue("span-id") != null) {
                        this.text().add_tok_to_span(qName, attributes);
                    } else if (attributes.getValue("tag") != null) {
                        this.text().annotate(qName, attributes);
                    }
                }
            } else if (this.in_header) {
                this.meta_name = qName;
            } else if ("comment".equals(qName)) {
                this.comment_type = attributes.getValue("type");
            }
            this.getXMLELementStack().push(qName);
        }

        @Override
        public void characters(char[] c_str, int start, int length) throws SAXException {
            if ("comment".equals(this.getXMLELementStack().peek())) {
                this.comment_text.append(c_str, start, length);
            } else if (this.in_header) {
                this.meta_value.append(c_str, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("token".equals(qName)) {
                if (CoraXML2SaltMapper.this.tokenization_is_segmentation) {
                    this.text().map_tokens_to_timeline_aligned();
                } else {
                    this.text().map_tokens_to_timeline_simple();
                }
            } else if (CoraXML2SaltMapper.this.tok_anno.equals(qName)) {
                this.in_mod = false;
            } else if ("header".equals(qName)) {
                this.in_header = false;
                if (!this.meta_is_xml) {
                    String[] lines;
                    for (String line : lines = this.meta_value.toString().split(System.getProperty("line.separator"))) {
                        String[] parts;
                        if ((line = line.trim()).isEmpty() || (parts = line.split(":", 2)).length < 1) continue;
                        String name = parts[0].trim();
                        String value = null;
                        if (parts.length == 2) {
                            value = parts[1].trim();
                        }
                        if (!CoraXML2SaltMapper.this.getDocument().containsLabel(name)) {
                            CoraXML2SaltMapper.this.getDocument().createMetaAnnotation(null, name, (Object)value);
                            continue;
                        }
                        logger.warn("Attempting to create a meta that is already present!\nName: '" + name + "', value: '" + value + "'");
                    }
                }
            } else if (this.in_header) {
                this.meta_is_xml = true;
                CoraXML2SaltMapper.this.getDocument().createMetaAnnotation(null, this.meta_name, (Object)this.meta_value.toString().trim());
                this.meta_value = new StringBuffer();
            } else if ("comment".equals(qName) && this.comment_text.length() > 0) {
                if (!CoraXML2SaltMapper.this.exportCommentsToLayer.isEmpty()) {
                    this.text().layer(CoraXML2SaltMapper.this.exportCommentsToLayer).add_comment(this.comment_text.toString(), this.comment_type);
                    if (CoraXML2SaltMapper.this.tokenization_is_segmentation) {
                        this.text().map_tokens_to_timeline_aligned();
                    } else {
                        this.text().map_tokens_to_timeline_simple();
                    }
                }
                this.comment_text = new StringBuffer();
            }
            this.getXMLELementStack().pop();
        }
    }
}

