/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula.util.xPointer;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.peppermodules.paula.util.xPointer.XPtrRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPtrInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(XPtrInterpreter.class);
    private static final String KW_XML_ENDING = ".xml";
    private String base = null;
    private String xPtr = null;
    private static final String REGEX_NUM_VAL = "[0-9]+";
    private static final String REGEX_STRING_RANGE_CONT = "[/][/]body\\s*,\\s*[']\\s*[']\\s*,\\s*[0-9]+\\s*,\\s*[0-9]+";
    private static final String REGEX_STRING_RANGE = "string-range[(][/][/]body\\s*,\\s*[']\\s*[']\\s*,\\s*[0-9]+\\s*,\\s*[0-9]+[)]";
    private static final String REGEX_STRING_RANGE_PTR = "#xpointer[(]string-range[(][/][/]body\\s*,\\s*[']\\s*[']\\s*,\\s*[0-9]+\\s*,\\s*[0-9]+[)][)]";
    private static final String REGEX_XML_FILE_PTR = "^[^#]+\\.xml$";
    private static final String REGEX_ID_VAL = "\\s*[a-zA-Z0-9_-[.]]+\\s*";
    private static final String REGEX_SHORTHAND_PTR = "\\s*#\\s*[a-zA-Z0-9_-[.]]+\\s*";
    private static final String REGEX_FULL_SHORTHAND_PTR = "[^#]+\\.xml#\\s*[a-zA-Z0-9_-[.]]+\\s*";
    private static final String REGEX_ID_PRTR = "id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)]";
    private static final String REGEX_RANGE = "id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][/]range-to[()]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][()]";
    private static final String REGEX_RANGE_PTR = "#xpointer[(]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][/]range-to[()]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][()][)]";
    private static final String REGEX_SEQ_PTR = "[(](#xpointer[(]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][/]range-to[()]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][()][)]|\\s*#\\s*[a-zA-Z0-9_-[.]]+\\s*|[^#]+\\.xml#\\s*[a-zA-Z0-9_-[.]]+\\s*)([,](#xpointer[(]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][/]range-to[()]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][()][)]|\\s*#\\s*[a-zA-Z0-9_-[.]]+\\s*|[^#]+\\.xml#\\s*[a-zA-Z0-9_-[.]]+\\s*))*[)]";
    private static final String KW_BASE_DEL = "#";
    private static final String ERR_EMPTY_XPTR = "The given XPointer is empty.";
    private static final String ERR_EMPTY_BASE = "The given base name is empty.";
    private static final String ERR_NO_EX = "No xpointer expression was given.";
    private static final String ERR_WRONG_EX = "The given xpointer expression does not follows the supported syntax '[(](#xpointer[(]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][/]range-to[()]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][()][)]|\\s*#\\s*[a-zA-Z0-9_-[.]]+\\s*|[^#]+\\.xml#\\s*[a-zA-Z0-9_-[.]]+\\s*)([,](#xpointer[(]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][/]range-to[()]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][()][)]|\\s*#\\s*[a-zA-Z0-9_-[.]]+\\s*|[^#]+\\.xml#\\s*[a-zA-Z0-9_-[.]]+\\s*))*[)]': ";
    private static final String ERR_BASE_NOT_XML = "The base included in the xpointer is no xml file.";
    private static final String ERR_EMPTY_EX = "The given expression is empty.";
    private static final String ERR_NO_BASE = "The given expression does not conatain any base document. ";

    public XPtrInterpreter() {
    }

    public XPtrInterpreter(String base, String xPtr) throws Exception {
        if (base == null) {
            String[] parts = this.extractBaseXPtr(xPtr);
            this.setInterpreter(parts[0], parts[1]);
            return;
        }
        try {
            String[] parts = this.extractBaseXPtr(xPtr);
            this.setInterpreter(parts[0], parts[1]);
        }
        catch (Exception e) {
            this.setInterpreter(base, xPtr);
        }
    }

    private String[] extractBaseXPtr(String ex) throws Exception {
        if (ex == null || "".equals(ex)) {
            throw new Exception(ERR_EMPTY_EX);
        }
        String[] retArr = new String[2];
        String basePattern = ".xml#";
        if (!ex.contains(basePattern)) {
            retArr[0] = null;
            retArr[1] = ex;
        } else {
            String[] parts = ex.split(KW_BASE_DEL);
            if (parts.length > 2) {
                retArr[0] = parts[0].replace("(", "");
                retArr[1] = ex;
            } else {
                String lastLetter = parts[0].substring(parts[0].length() - KW_XML_ENDING.length());
                if (!KW_XML_ENDING.equalsIgnoreCase(lastLetter)) {
                    throw new Exception(ERR_BASE_NOT_XML);
                }
                retArr[0] = parts[0];
                retArr[1] = KW_BASE_DEL + parts[1];
            }
        }
        return retArr;
    }

    private Vector<XPtrRef> getXPtrRefs(String ex) throws Exception {
        if (ex == null || "".equals(ex)) {
            throw new Exception(ERR_NO_EX);
        }
        TOKENTYPE tokType = this.getXPtrType(ex);
        logger.debug("[PAULAImporter] type of xpointer expression '{}' is {}.", (Object)ex, (Object)tokType);
        if (tokType == TOKENTYPE.ERROR) {
            throw new Exception("The given xpointer expression '" + ex + "' does not follows the supported syntax '" + REGEX_SEQ_PTR);
        }
        Vector<XPtrRef> trList = new Vector<XPtrRef>();
        if (tokType == TOKENTYPE.TOKEN) {
            trList.add(this.getFromSimpleToken(ex));
        } else if (tokType == TOKENTYPE.TOKENRANGE) {
            trList.add(this.getFromTokenRange(ex));
        } else if (tokType == TOKENTYPE.TOKENSEQ) {
            String strPat = "(#xpointer[(]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][/]range-to[()]id[(][']\\s*[a-zA-Z0-9_-[.]]+\\s*['][)][()][)]|\\s*#\\s*[a-zA-Z0-9_-[.]]+\\s*|[^#]+\\.xml#\\s*[a-zA-Z0-9_-[.]]+\\s*)";
            Pattern pattern = Pattern.compile(strPat, 2);
            Matcher matcher = pattern.matcher(ex);
            while (matcher.find()) {
                Pattern pat2 = Pattern.compile(REGEX_RANGE_PTR, 2);
                Matcher match2 = pat2.matcher(matcher.group());
                if (match2.find()) {
                    trList.add(this.getFromTokenRange(match2.group()));
                    continue;
                }
                String ptr = matcher.group();
                ptr = ptr.replace("(", "");
                ptr = ptr.replace(")", "");
                ptr = ptr.replace(",", "");
                trList.add(this.getFromSimpleToken(ptr));
            }
        } else if (tokType == TOKENTYPE.STRTOKENRANGE) {
            trList.add(this.getFromStringRange(ex));
        } else if (tokType == TOKENTYPE.SIMPLE_XML_FILE) {
            trList.add(this.getFromSimpleXMLFile(ex));
        }
        return trList;
    }

    private TOKENTYPE getXPtrType(String chckStr) {
        chckStr = chckStr.replaceAll(" ", "");
        Pattern pattern = null;
        Matcher matcher = null;
        String strPattern = "";
        strPattern = REGEX_RANGE_PTR;
        pattern = Pattern.compile(strPattern, 2);
        matcher = pattern.matcher(chckStr);
        if (matcher.matches()) {
            return TOKENTYPE.TOKENRANGE;
        }
        strPattern = REGEX_SEQ_PTR;
        pattern = Pattern.compile(strPattern, 2);
        matcher = pattern.matcher(chckStr);
        if (matcher.matches()) {
            return TOKENTYPE.TOKENSEQ;
        }
        strPattern = REGEX_SHORTHAND_PTR;
        pattern = Pattern.compile(strPattern, 2);
        matcher = pattern.matcher(chckStr);
        if (matcher.matches()) {
            return TOKENTYPE.TOKEN;
        }
        strPattern = REGEX_STRING_RANGE_PTR;
        pattern = Pattern.compile(strPattern, 2);
        matcher = pattern.matcher(chckStr);
        if (matcher.matches()) {
            return TOKENTYPE.STRTOKENRANGE;
        }
        strPattern = REGEX_XML_FILE_PTR;
        pattern = Pattern.compile(strPattern, 2);
        matcher = pattern.matcher(chckStr);
        if (matcher.matches()) {
            return TOKENTYPE.SIMPLE_XML_FILE;
        }
        return TOKENTYPE.ERROR;
    }

    private XPtrRef getFromSimpleToken(String ex) throws Exception {
        XPtrRef tar = null;
        Pattern pattern1 = Pattern.compile(REGEX_FULL_SHORTHAND_PTR, 2);
        Matcher matcher1 = pattern1.matcher(ex);
        if (matcher1.find()) {
            String[] parts = ex.split(KW_BASE_DEL);
            Pattern pattern = Pattern.compile(REGEX_ID_VAL, 2);
            Matcher matcher = pattern.matcher(parts[1]);
            if (matcher.find()) {
                String id = matcher.group().trim();
                tar = new XPtrRef(parts[0].trim(), id);
                tar.setType(XPtrRef.POINTERTYPE.ELEMENT);
            }
        } else {
            Pattern pattern = Pattern.compile(REGEX_ID_VAL, 2);
            Matcher matcher = pattern.matcher(ex);
            if (matcher.find()) {
                String id = matcher.group().trim();
                tar = new XPtrRef(this.base, id);
                tar.setType(XPtrRef.POINTERTYPE.ELEMENT);
            }
        }
        return tar;
    }

    private XPtrRef getFromTokenRange(String ex) throws Exception {
        XPtrRef tar = null;
        Pattern pattern = Pattern.compile("[']\\s*[a-zA-Z0-9_-[.]]+\\s*[']", 2);
        Matcher matcher = pattern.matcher(ex);
        String from = null;
        String to = null;
        int i = 0;
        while (matcher.find()) {
            if (i > 1) {
                throw new Exception(ERR_WRONG_EX + ex);
            }
            if (i == 0) {
                from = matcher.group().replaceAll("'", "");
            } else if (i == 1) {
                to = matcher.group().replaceAll("'", "");
            }
            ++i;
        }
        tar = new XPtrRef(this.base, from.trim(), to.trim());
        tar.setType(XPtrRef.POINTERTYPE.ELEMENT);
        return tar;
    }

    private XPtrRef getFromStringRange(String ex) throws Exception {
        XPtrRef tar = null;
        Pattern pattern = Pattern.compile(REGEX_NUM_VAL);
        Matcher matcher = pattern.matcher(ex);
        String start = "";
        String length = "";
        int i = 0;
        while (matcher.find()) {
            if (i > 1) {
                throw new Exception(ERR_WRONG_EX + ex);
            }
            if (i == 0) {
                start = matcher.group();
            } else if (i == 1) {
                length = matcher.group();
            }
            ++i;
        }
        tar = new XPtrRef(this.base, start.trim(), length.trim());
        tar.setType(XPtrRef.POINTERTYPE.TEXT);
        return tar;
    }

    private XPtrRef getFromSimpleXMLFile(String ex) throws Exception {
        XPtrRef xPtrRef = new XPtrRef(ex, ex);
        xPtrRef.setType(XPtrRef.POINTERTYPE.XMLFILE);
        return xPtrRef;
    }

    public void setInterpreter(String base, String xPtr) {
        String[] parts;
        if (xPtr == null) {
            throw new NullPointerException("The given XPointer expression is empty.");
        }
        try {
            parts = this.extractBaseXPtr(xPtr);
        }
        catch (Exception e) {
            throw new NullPointerException(ERR_NO_BASE + xPtr);
        }
        if (parts[0] != null) {
            this.base = parts[0];
            this.xPtr = parts[1];
        } else {
            this.base = base;
            this.xPtr = xPtr;
        }
    }

    public void setXPtr(String xPtr) throws Exception {
        if (xPtr == null || "".equals(xPtr)) {
            throw new Exception(ERR_EMPTY_XPTR);
        }
        this.xPtr = xPtr;
    }

    public void setBase(String base) throws Exception {
        if (base == null || "".equals(base)) {
            throw new Exception(ERR_EMPTY_BASE);
        }
        this.base = base;
    }

    public TOKENTYPE getXPtrType() throws Exception {
        return this.getXPtrType(this.xPtr);
    }

    public Vector<XPtrRef> getResult() throws Exception {
        return this.getXPtrRefs(this.xPtr);
    }

    public String getXPtr() {
        return this.xPtr;
    }

    public String getDoc() {
        return this.base;
    }

    public String toString() {
        String retStr = "";
        retStr = "document name: " + this.base + ", xpointer: " + this.xPtr;
        return retStr;
    }

    static enum TOKENTYPE {
        TOKEN,
        TOKENRANGE,
        TOKENSEQ,
        STRTOKENRANGE,
        SIMPLE_XML_FILE,
        ERROR;

    }
}

