/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula.readers;

import java.io.File;
import org.corpus_tools.peppermodules.paula.PAULA2SaltMapper;
import org.corpus_tools.peppermodules.paula.PAULAFileDelegator;
import org.corpus_tools.peppermodules.paula.PAULAXMLDictionary;
import org.corpus_tools.peppermodules.paula.util.xPointer.XPtrInterpreter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public abstract class PAULASpecificReader
extends DefaultHandler2
implements PAULAXMLDictionary {
    private File paulaFile = null;
    private String paulaID = null;
    private String xmlBase = null;
    private String paulaType = null;
    private PAULA2SaltMapper mapper = null;
    private PAULAFileDelegator paulaFileDelegator = null;

    public boolean isTAGorAttribute(String val, String[] list) {
        boolean retVal = false;
        for (String element : list) {
            if (!element.equalsIgnoreCase(val)) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isTAGorAttribute(String val, String tagOrAtt) {
        boolean retVal = false;
        if (tagOrAtt.equalsIgnoreCase(val)) {
            retVal = true;
        }
        return retVal;
    }

    public void setPaulaFile(File paulaFile) {
        this.paulaFile = paulaFile;
    }

    public File getPaulaFile() {
        return this.paulaFile;
    }

    public void setPaulaID(String paulaID) {
        this.paulaID = paulaID;
    }

    public String getPaulaID() {
        return this.paulaID;
    }

    public void setXmlBase(String xmlBase) {
        this.xmlBase = xmlBase;
    }

    public String getXmlBase() {
        return this.xmlBase;
    }

    public String getPaulaType() {
        return this.paulaType;
    }

    public void setPaulaType(String paulaType) {
        this.paulaType = paulaType;
    }

    public PAULA2SaltMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(PAULA2SaltMapper mapper) {
        this.mapper = mapper;
    }

    public void setPaulaFileDelegator(PAULAFileDelegator paulaFileDelegator) {
        this.paulaFileDelegator = paulaFileDelegator;
    }

    public PAULAFileDelegator getPaulaFileDelegator() {
        return this.paulaFileDelegator;
    }

    protected void checkForFileReference(String xPtr) {
        if (xPtr != null && !xPtr.isEmpty()) {
            XPtrInterpreter xPtrInterpreter = new XPtrInterpreter();
            xPtrInterpreter.setInterpreter(null, xPtr);
            if (xPtrInterpreter.getDoc() != null && !xPtrInterpreter.getDoc().isEmpty()) {
                File referedFile = new File(xPtrInterpreter.getDoc());
                this.getPaulaFileDelegator().startPaulaFile(referedFile);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (this.isTAGorAttribute(qName, "header")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!this.isTAGorAttribute(attributes.getQName(i), ATT_HEADER_PAULA_ID)) continue;
                    this.setPaulaID(attributes.getValue(i));
                }
            } else if (this.isTAGorAttribute(qName, "markList") || this.isTAGorAttribute(qName, "structList") || this.isTAGorAttribute(qName, "relList") || this.isTAGorAttribute(qName, "featList") || this.isTAGorAttribute(qName, "multiFeatList")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attName = attributes.getQName(i);
                    String attVal = attributes.getValue(i);
                    if (this.isTAGorAttribute(attName, "xml:base")) {
                        this.setXmlBase(attVal);
                        continue;
                    }
                    if (!this.isTAGorAttribute(attName, "type")) continue;
                    this.setPaulaType(attVal);
                }
                if (this.getXmlBase() != null && !"".equals(this.getXmlBase())) {
                    File referedFile = new File(this.getXmlBase());
                    this.getPaulaFileDelegator().startPaulaFile(referedFile);
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }
}

