/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula.readers;

import java.io.File;
import org.corpus_tools.peppermodules.paula.PAULA2SaltMapper;
import org.corpus_tools.peppermodules.paula.PAULAFileDelegator;
import org.corpus_tools.peppermodules.paula.readers.PAULAFeatReader;
import org.corpus_tools.peppermodules.paula.readers.PAULAMarkReader;
import org.corpus_tools.peppermodules.paula.readers.PAULAMultiFeatReader;
import org.corpus_tools.peppermodules.paula.readers.PAULARelReader;
import org.corpus_tools.peppermodules.paula.readers.PAULASpecificReader;
import org.corpus_tools.peppermodules.paula.readers.PAULAStructReader;
import org.corpus_tools.peppermodules.paula.readers.PAULATextReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class PAULAReader
extends DefaultHandler2 {
    private static final Logger logger = LoggerFactory.getLogger(PAULAReader.class);
    private PAULA2SaltMapper mapper = null;
    private File paulaFile = null;
    private PAULAFileDelegator paulaFileDelegator = null;
    public static final String PAULA_DTD_HEADER = "paula_header.dtd";
    public static final String PAULA_DTD_TEXT = "paula_text.dtd";
    public static final String PAULA_DTD_MARK = "paula_mark.dtd";
    public static final String PAULA_DTD_STRUCT = "paula_struct.dtd";
    public static final String PAULA_DTD_REL = "paula_rel.dtd";
    public static final String PAULA_DTD_FEAT = "paula_feat.dtd";
    public static final String PAULA_DTD_MULTIFEAT = "paula_multiFeat.dtd";
    private String currentDTD = null;
    private PAULASpecificReader specificPAULAReader = null;

    public void setMapper(PAULA2SaltMapper mapper) {
        this.mapper = mapper;
    }

    public PAULA2SaltMapper getMapper() {
        return this.mapper;
    }

    public void setPaulaFile(File paulaFile) {
        this.paulaFile = paulaFile;
    }

    public File getPaulaFile() {
        return this.paulaFile;
    }

    public void setPaulaFileDelegator(PAULAFileDelegator paulaFileDelegator) {
        this.paulaFileDelegator = paulaFileDelegator;
    }

    public PAULAFileDelegator getPaulaFileDelegator() {
        return this.paulaFileDelegator;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (publicId != null && !"".equals(publicId)) {
            this.currentDTD = publicId;
        } else if (systemId != null && !"".equals(systemId)) {
            this.currentDTD = systemId;
        }
        if (this.currentDTD == null || "".equals(this.currentDTD)) {
            throw new SAXException("Error in file '" + this.getPaulaFile().getAbsolutePath() + "', no dtd is given.");
        }
        String[] parts = this.currentDTD.split("/");
        this.currentDTD = parts[parts.length - 1];
        if (this.currentDTD.equalsIgnoreCase(PAULA_DTD_TEXT)) {
            this.specificPAULAReader = new PAULATextReader();
        } else if (this.currentDTD.equalsIgnoreCase(PAULA_DTD_MARK)) {
            this.specificPAULAReader = new PAULAMarkReader();
        } else if (this.currentDTD.equalsIgnoreCase(PAULA_DTD_STRUCT)) {
            this.specificPAULAReader = new PAULAStructReader();
        } else if (this.currentDTD.equalsIgnoreCase(PAULA_DTD_REL)) {
            this.specificPAULAReader = new PAULARelReader();
        } else if (this.currentDTD.equalsIgnoreCase(PAULA_DTD_FEAT)) {
            this.specificPAULAReader = new PAULAFeatReader();
        } else if (this.currentDTD.equalsIgnoreCase(PAULA_DTD_MULTIFEAT)) {
            this.specificPAULAReader = new PAULAMultiFeatReader();
        }
        if (this.specificPAULAReader == null) {
            throw new SAXException("Cannot parse paula-file '" + this.getPaulaFile().getAbsolutePath() + "', because no reader object for the dtd '" + this.currentDTD + "' has been found.");
        }
        this.specificPAULAReader.setMapper(this.getMapper());
        this.specificPAULAReader.setPaulaFile(this.getPaulaFile());
        this.specificPAULAReader.setPaulaFileDelegator(this.getPaulaFileDelegator());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.specificPAULAReader == null) {
            logger.warn("[PAULAImporter] Cannot read document '" + this.getPaulaFile().getAbsolutePath() + "', this file belongs to no or an unknown dtd.");
        } else {
            this.specificPAULAReader.characters(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.specificPAULAReader == null) {
            logger.warn("[PAULAImporter] Cannot read document '" + this.getPaulaFile().getAbsolutePath() + "', this file belongs to no or an unknown dtd.");
        } else {
            this.specificPAULAReader.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.specificPAULAReader == null) {
            logger.warn("[PAULAImporter] Cannot read document '" + this.getPaulaFile().getAbsolutePath() + "', this file belongs to no or an unknown dtd.");
        } else {
            this.specificPAULAReader.endElement(uri, localName, qName);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.specificPAULAReader != null) {
            this.specificPAULAReader.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.specificPAULAReader == null) {
            logger.warn("[PAULAImporter] Cannot read document '" + this.getPaulaFile().getAbsolutePath() + "', this file belongs to no or an unknown dtd.");
        } else {
            this.specificPAULAReader.endDocument();
        }
    }
}

