/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.paula.PAULAFileDelegator;
import org.corpus_tools.peppermodules.paula.PAULAImporterProperties;
import org.corpus_tools.peppermodules.paula.readers.PAULASpecificReader;
import org.corpus_tools.peppermodules.paula.readers.PAULAStructReader;
import org.corpus_tools.peppermodules.paula.util.xPointer.XPtrInterpreter;
import org.corpus_tools.peppermodules.paula.util.xPointer.XPtrRef;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAULA2SaltMapper
extends PepperMapperImpl {
    private static final Logger logger = LoggerFactory.getLogger(PAULA2SaltMapper.class);
    private Boolean isArtificialSCorpus = false;
    private String[] PAULA_FILE_ENDINGS = null;
    private Hashtable<String, Identifier> stagingArea = null;
    private Map<String, String> elementNamingTable = null;
    private static final String KW_NAME_SEP = "#";
    private Map<String, Collection<String>> elementOrderTable = null;
    private static final String KW_FILE_VAL = "file:/";
    private Hashtable<File, List<DominanceRelationContainer>> dominanceRelationContainers = null;

    public PAULA2SaltMapper() {
        this.initialize();
    }

    protected void initialize() {
        this.elementNamingTable = new Hashtable<String, String>();
        this.elementOrderTable = new Hashtable<String, Collection<String>>();
        this.stagingArea = new Hashtable();
    }

    public Boolean getIsArtificialSCorpus() {
        return this.isArtificialSCorpus;
    }

    public void setIsArtificialSCorpus(Boolean isArtificialSCorpus) {
        this.isArtificialSCorpus = isArtificialSCorpus;
    }

    public DOCUMENT_STATUS mapSCorpus() {
        if (!this.isArtificialSCorpus.booleanValue()) {
            PAULAFileDelegator paulaFileDelegator = new PAULAFileDelegator();
            paulaFileDelegator.setMapper(this);
            if (this.getResourceURI() == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map an SCorpus, because no resource path is given for '" + this.getCorpus().getId() + "'.");
            }
            File paulaPath = new File(this.getResourceURI().toFileString());
            paulaFileDelegator.setPaulaPath(paulaPath);
            for (File paulaFile : paulaPath.listFiles()) {
                String[] parts = paulaFile.getName().split("[.]");
                if (parts.length <= 1) continue;
                for (String ending : this.getPAULA_FILE_ENDINGS()) {
                    if (!parts[parts.length - 1].equalsIgnoreCase(ending)) continue;
                    paulaFileDelegator.getPaulaFiles().add(paulaFile);
                }
            }
            if (paulaFileDelegator.getPaulaFiles() != null && paulaFileDelegator.getPaulaFiles().size() != 0) {
                paulaFileDelegator.startPaulaFiles();
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getResourceURI() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map a paula-document to SDocument, because the path for paula-document is empty.");
        }
        if (!this.getResourceURI().toFileString().endsWith("/")) {
            this.setResourceURI(URI.createFileURI((String)(this.getResourceURI().toFileString() + "/")));
        }
        if (this.getDocument() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map a paula-document to SDocument, because the SDocument is empty.");
        }
        if (this.getPAULA_FILE_ENDINGS() == null || this.getPAULA_FILE_ENDINGS().length == 0) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map a paula-document to SDocument, no paula-xml-document endings are given.");
        }
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        sDocGraph.setName(this.getDocument().getName() + "_graph");
        this.getDocument().setDocumentGraph(sDocGraph);
        PAULAFileDelegator paulaFileDelegator = new PAULAFileDelegator();
        paulaFileDelegator.setMapper(this);
        File paulaPath = new File(this.getResourceURI().toFileString());
        paulaFileDelegator.setPaulaPath(paulaPath);
        for (File paulaFile : paulaPath.listFiles()) {
            String[] parts = paulaFile.getName().split("[.]");
            if (parts.length <= 1) continue;
            for (String ending : this.getPAULA_FILE_ENDINGS()) {
                if (!parts[parts.length - 1].equalsIgnoreCase(ending)) continue;
                paulaFileDelegator.getPaulaFiles().add(paulaFile);
            }
        }
        paulaFileDelegator.startPaulaFiles();
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void setPAULA_FILE_ENDINGS(String[] pAULA_FILE_ENDINGS) {
        this.PAULA_FILE_ENDINGS = pAULA_FILE_ENDINGS;
    }

    public String[] getPAULA_FILE_ENDINGS() {
        return this.PAULA_FILE_ENDINGS;
    }

    private String extractNSFromPAULAFile(File paulaFile) {
        String[] parts;
        String retVal = null;
        if (paulaFile != null && (parts = paulaFile.getName().split("[.]"))[0] != null && !parts[0].equals(this.getProps().getEmptyNamespace())) {
            retVal = parts[0];
        }
        return retVal;
    }

    private SLayer attachSNode2SLayer(SNode sNode, String sLayerName) {
        SLayer retVal = null;
        if (sLayerName != null && sNode != null) {
            for (SLayer sLayer : this.getDocument().getDocumentGraph().getLayers()) {
                if (!sLayer.getName().equalsIgnoreCase(sLayerName)) continue;
                retVal = sLayer;
                break;
            }
            if (retVal == null) {
                retVal = SaltFactory.createSLayer();
                retVal.setName(sLayerName);
                this.getDocument().getDocumentGraph().addLayer((Layer)retVal);
            }
            sNode.addLayer((Layer)retVal);
        }
        return retVal;
    }

    private SLayer attachSRelation2SLayer(SRelation sRel, String sLayerName) {
        SLayer retVal = null;
        if (sLayerName != null && sRel != null) {
            for (SLayer sLayer : this.getDocument().getDocumentGraph().getLayers()) {
                if (!sLayer.getName().equalsIgnoreCase(sLayerName)) continue;
                retVal = sLayer;
                break;
            }
            if (retVal == null) {
                retVal = SaltFactory.createSLayer();
                retVal.setName(sLayerName);
                this.getDocument().getDocumentGraph().addLayer((Layer)retVal);
            }
            sRel.addLayer((Layer)retVal);
        }
        return retVal;
    }

    public void paulaTEXTConnector(File paulaFile, String paulaId, String text) {
        if (this.getDocument() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map primary data to salt document, because no salt document is given.");
        }
        if (this.getDocument().getDocumentGraph() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map primary data to salt document, because no salt document-graph is given.");
        }
        String uniqueName = paulaFile.getName();
        String saltName = "text";
        String[] splittedName = paulaFile.getName().split("[.]");
        if (splittedName.length >= 4) {
            saltName = splittedName[splittedName.length - 3];
        }
        STextualDS sTextualDS = null;
        if (this.stagingArea.containsKey(uniqueName)) {
            sTextualDS = (STextualDS)this.getDocument().getDocumentGraph().getNode(this.stagingArea.get(uniqueName).getId());
        } else {
            sTextualDS = SaltFactory.createSTextualDS();
            sTextualDS.setName(saltName);
            this.getDocument().getDocumentGraph().addNode((Node)sTextualDS);
        }
        sTextualDS.setText(text);
        this.elementNamingTable.put(uniqueName, sTextualDS.getId());
    }

    public void paulaMARK_TOKConnector(File paulaFile, String paulaId, String paulaType, String xmlBase, String markID, String href, String markType) {
        Collection<Object> orderedElementSlot;
        String uniqueName = paulaFile.getName() + KW_NAME_SEP + markID;
        if (this.elementNamingTable == null) {
            throw new PepperModuleException((PepperMapper)this, "The map elementNamingTable was not initialized, this might be a bug.");
        }
        if (this.elementOrderTable.get(paulaFile.getName()) == null) {
            orderedElementSlot = new ArrayList();
            this.elementOrderTable.put(paulaFile.getName(), orderedElementSlot);
        }
        orderedElementSlot = this.elementOrderTable.get(paulaFile.getName());
        orderedElementSlot.add(uniqueName);
        Vector<XPtrRef> xPtrRefs = null;
        XPtrInterpreter xPtrInter = new XPtrInterpreter();
        xPtrInter.setInterpreter(xmlBase, href);
        try {
            xPtrRefs = xPtrInter.getResult();
        }
        catch (Exception e) {
            throw new PepperModuleException((PepperMapper)this, "Cannot read href (" + href + ") in file " + paulaFile + ".", (Throwable)e);
        }
        int runs = 0;
        STextualDS sTextDS = null;
        Integer left = null;
        Integer right = null;
        for (XPtrRef xPtrRef : xPtrRefs) {
            if (xPtrRef.getDoc() == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot find a file reference in xpointer '" + xPtrRef + "'.");
            }
            if (++runs > 1) {
                throw new PepperModuleException((PepperMapper)this, "There are too many references for a token node element: " + href);
            }
            if (xPtrRef.getType() == XPtrRef.POINTERTYPE.TEXT) {
                String textNodeName = this.elementNamingTable.get(xPtrRef.getDoc());
                sTextDS = (STextualDS)this.getDocument().getDocumentGraph().getNode(textNodeName);
                if (sTextDS == null) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot create token '" + markID + "' of file '" + paulaId + "', because the referred TextualDS object for text '" + textNodeName + "' is empty. Known STextualDS objects are: " + this.elementNamingTable + ". ");
                }
                try {
                    left = Integer.valueOf(xPtrRef.getLeft());
                    right = Integer.valueOf(xPtrRef.getRight());
                    left = left - 1;
                    right = left + right;
                    if (left > right) {
                        throw new PepperModuleException((PepperMapper)this, "Cannot create token, because its left value is higher than its right value. Error in document " + paulaFile.getName() + ". The left value is '" + left + "', hwereas the right value is '" + right + "'.");
                    }
                    if (left < 0) {
                        throw new PepperModuleException((PepperMapper)this, "Cannot create token, because its left value is smaller than 0. Error in document " + paulaFile.getName() + ". The left value is '" + left + "'.");
                    }
                    if (right <= sTextDS.getText().length()) continue;
                    throw new PepperModuleException((PepperMapper)this, "Cannot create token, because its right value is higher than the size of the text. Error in document " + paulaFile.getName() + ". The right value is '" + right + "', but the length of the text only has the length of '" + sTextDS.getText().length() + "'.");
                }
                catch (Exception e) {
                    throw new PepperModuleException((PepperMapper)this, "The left or right border of XPointer is not set in a correct way: " + href, (Throwable)e);
                }
            }
            throw new PepperModuleException((PepperMapper)this, "An XPointer of the parsed document does not refer to a xml-textelement. Incorrect pointer: base: " + xPtrRef.getDoc() + ", element: " + href + ", type: " + (Object)((Object)xPtrRef.getType()));
        }
        if (sTextDS == null) {
            throw new PepperModuleException((PepperMapper)this, "No primary data node found for token element: " + paulaFile.getName() + KW_NAME_SEP + markID);
        }
        SToken sToken = SaltFactory.createSToken();
        sToken.setName(markID);
        this.getDocument().getDocumentGraph().addNode((Node)sToken);
        this.elementNamingTable.put(uniqueName, sToken.getId());
        STextualRelation textRel = SaltFactory.createSTextualRelation();
        textRel.setSource((Node)sToken);
        textRel.setTarget(sTextDS);
        textRel.setStart(left);
        textRel.setEnd(right);
        this.getDocument().getDocumentGraph().addRelation((Relation)textRel);
    }

    private Collection<String> getPAULAElementIds(String xmlBase, String href) {
        ArrayList<String> refPaulaIds = null;
        try {
            refPaulaIds = new ArrayList<String>();
            XPtrInterpreter xPtrInter = new XPtrInterpreter();
            xPtrInter.setInterpreter(xmlBase, href);
            AbstractList xPtrRefs = null;
            try {
                xPtrRefs = xPtrInter.getResult();
            }
            catch (Exception e) {
                if (href != null && href.contains(" ")) {
                    String[] hrefs = href.split(" ");
                    if (hrefs.length > 0) {
                        xPtrRefs = new ArrayList();
                        for (String idPtr : hrefs) {
                            xPtrInter = new XPtrInterpreter();
                            xPtrInter.setInterpreter(xmlBase, idPtr);
                            try {
                                xPtrRefs.addAll(xPtrInter.getResult());
                            }
                            catch (Exception e1) {
                                throw new PepperModuleException((PepperMapper)this, "Cannot parse xpointer in document '" + this.getResourceURI() + "' because of a nested exception.  ", (Throwable)e);
                            }
                        }
                    }
                }
                throw e;
            }
            block7: for (XPtrRef xPtrRef : xPtrRefs) {
                if (xPtrRef.getType() != XPtrRef.POINTERTYPE.ELEMENT) {
                    throw new PepperModuleException((PepperMapper)this, "The XPointer references in current file are incorrect. There only have to be element pointers and the following is not one of them: " + href + ". Error in file: " + xmlBase);
                }
                if (xPtrRef.isRange()) {
                    String leftName = xPtrInter.getDoc() + KW_NAME_SEP + xPtrRef.getLeft();
                    String rightName = xPtrInter.getDoc() + KW_NAME_SEP + xPtrRef.getRight();
                    boolean start = false;
                    for (String paulaElementId : this.elementOrderTable.get(xPtrInter.getDoc())) {
                        if (paulaElementId.equalsIgnoreCase(leftName)) {
                            start = true;
                        }
                        if (start) {
                            refPaulaIds.add(paulaElementId);
                        }
                        if (!paulaElementId.equalsIgnoreCase(rightName)) continue;
                        continue block7;
                    }
                    continue;
                }
                String paulaElementId = xPtrRef.getDoc() + KW_NAME_SEP + xPtrRef.getID();
                refPaulaIds.add(paulaElementId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PepperModuleException((PepperMapper)this, "Cannot compute paula-ids corresponding to xmlBase '" + xmlBase + "' and href '" + href + "'.", (Throwable)e);
        }
        return refPaulaIds;
    }

    public void paulaMARKConnector(File paulaFile, String paulaId, String paulaType, String xmlBase, String markID, String href, String markType) {
        Collection<Object> orderedElementSlot;
        String uniqueName = paulaFile.getName() + KW_NAME_SEP + markID;
        if (this.elementNamingTable == null) {
            throw new PepperModuleException((PepperMapper)this, "The map elementNamingTable was not initialized, this might be a bug.");
        }
        if (this.elementOrderTable.get(paulaFile.getName()) == null) {
            orderedElementSlot = new ArrayList();
            this.elementOrderTable.put(paulaFile.getName(), orderedElementSlot);
        }
        orderedElementSlot = this.elementOrderTable.get(paulaFile.getName());
        orderedElementSlot.add(uniqueName);
        Collection<String> refPAULAElementIds = this.getPAULAElementIds(xmlBase, href);
        ArrayList<SNode> referedElements = new ArrayList<SNode>();
        for (String refPAULAId : refPAULAElementIds) {
            String paulaIdEntry = this.elementNamingTable.get(refPAULAId);
            if (paulaIdEntry == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the markable '" + markID + "' of file '" + paulaId + "', because the reference '" + refPAULAId + "'does not exist.");
            }
            SNode dstElement = (SNode)this.getDocument().getDocumentGraph().getNode(paulaIdEntry);
            if (dstElement == null) {
                logger.warn("[PAULAImporter] Cannot create span, because destination does not exist in graph: " + refPAULAId + ". Error in file: " + this.getResourceURI().toFileString());
                continue;
            }
            referedElements.add(dstElement);
        }
        if (referedElements.size() == 0) {
            logger.warn("[PAULAImporter] Cannot create span, because it has no destination elements: " + uniqueName + ". Error in file: " + this.getResourceURI().toFileString());
        } else {
            SSpan sSpan = SaltFactory.createSSpan();
            sSpan.setName(markID);
            this.getDocument().getDocumentGraph().addNode((Node)sSpan);
            String sLayerName = this.extractNSFromPAULAFile(paulaFile);
            this.attachSNode2SLayer((SNode)sSpan, sLayerName);
            this.elementNamingTable.put(uniqueName, sSpan.getId());
            SSpanningRelation sSpanRel = null;
            for (String refPAULAId : refPAULAElementIds) {
                SNode dstNode = (SNode)this.getDocument().getDocumentGraph().getNode(this.elementNamingTable.get(refPAULAId));
                if (dstNode == null) {
                    logger.warn("[PAULAImporter] Cannot create span, because destination does not exist in graph: " + refPAULAId + ". Error in file: " + this.getResourceURI().toFileString());
                    continue;
                }
                if (!(dstNode instanceof SToken)) {
                    throw new PepperModuleException((PepperMapper)this, "The referred Target Node '" + refPAULAId + "' in document '" + xmlBase + "'is not of type SToken.");
                }
                sSpanRel = SaltFactory.createSSpanningRelation();
                sSpanRel.setSource((Node)sSpan);
                sSpanRel.setTarget((Node)((SToken)dstNode));
                this.getDocument().getDocumentGraph().addRelation((Relation)sSpanRel);
                sLayerName = this.extractNSFromPAULAFile(paulaFile);
                this.attachSRelation2SLayer((SRelation)sSpanRel, sLayerName);
            }
        }
    }

    public void paulaFEATConnector(File paulaFile, String paulaId, String paulaType, String xmlBase, String featID, String featHref, String featTar, String featVal, String featDesc, String featExp) {
        if (paulaType == null || paulaType.isEmpty()) {
            logger.warn("[PAULAImporter] Cannot work with the given annotation of element: " + paulaId + ", because the type-value is empty. Error in file: " + paulaFile + ".");
        } else {
            if (featVal == null || featVal.isEmpty()) {
                logger.warn("[PAULAImporter] The feature value of an element in the following file is empty: " + paulaFile + ". Therefore this feature is ignored. ");
            }
            Collection<String> paulaElementIds = this.getPAULAElementIds(xmlBase, featHref);
            SAnnotation sAnno = SaltFactory.createSAnnotation();
            if (paulaType != null && !paulaType.isEmpty()) {
                String annoNamespace;
                String[] parts = paulaType.split("[.]");
                if (parts != null && parts.length > 0) {
                    sAnno.setName(parts[parts.length - 1]);
                }
                if (parts != null && parts.length > 1) {
                    String namespace = "";
                    for (int i = 0; i < parts.length - 1; ++i) {
                        namespace = i == 0 ? parts[0] : namespace + "." + parts[i];
                        ++i;
                    }
                    sAnno.setNamespace(namespace);
                } else if (this.getProps().getAnnoNamespaceFromFile() && (annoNamespace = this.extractNSFromPAULAFile(paulaFile)) != null && !annoNamespace.isEmpty()) {
                    sAnno.setNamespace(annoNamespace);
                }
                File file = null;
                if (featVal != null) {
                    URI location;
                    char[] featChar = featVal.toCharArray();
                    boolean hasPeriod = false;
                    boolean lastChrIsNotPeriod = false;
                    for (char chr : featChar) {
                        if (chr == '.') {
                            hasPeriod = true;
                        }
                        if (!hasPeriod || chr == '.') continue;
                        lastChrIsNotPeriod = true;
                    }
                    if (hasPeriod && lastChrIsNotPeriod && !(file = new File((location = URI.createFileURI((String)featVal).resolve(this.getResourceURI())).toFileString())).exists()) {
                        file = null;
                    }
                }
                if (file != null) {
                    if ("audio".equalsIgnoreCase(sAnno.getName())) {
                        SMedialDS audio = SaltFactory.createSMedialDS();
                        audio.setMediaReference(URI.createFileURI((String)file.getAbsolutePath()));
                        this.getDocument().getDocumentGraph().addNode((Node)audio);
                        for (String paulaElementId : paulaElementIds) {
                            List tokens;
                            if (paulaElementId == null || paulaElementId.isEmpty()) {
                                throw new PepperModuleException((PepperMapper)this, "No element with xml-id:" + paulaElementId + " was found.");
                            }
                            String sElementName = this.elementNamingTable.get(paulaElementId);
                            SNode refNode = (SNode)this.getDocument().getDocumentGraph().getNode(sElementName);
                            if (refNode == null || (tokens = this.getDocument().getDocumentGraph().getOverlappedTokens(refNode)) == null) continue;
                            for (SToken tok : tokens) {
                                SMedialRelation rel = SaltFactory.createSMedialRelation();
                                rel.setTarget((Node)audio);
                                rel.setSource((Node)tok);
                                this.getDocument().getDocumentGraph().addRelation((Relation)rel);
                            }
                        }
                        sAnno = null;
                    } else {
                        sAnno.setValue((Object)URI.createFileURI((String)file.getAbsolutePath()));
                    }
                } else {
                    sAnno.setValue((Object)featVal);
                }
            }
            if (sAnno != null) {
                for (String paulaElementId : paulaElementIds) {
                    if (paulaElementId == null || paulaElementId.isEmpty()) {
                        throw new PepperModuleException((PepperMapper)this, "No element with xml-id:" + paulaElementId + " was found.");
                    }
                    String sElementName = this.elementNamingTable.get(paulaElementId);
                    if (sElementName == null) {
                        logger.warn("[PAULAImporter] An element was reffered by an annotation, which does not exist in paula file. The missing element is '" + paulaElementId + "' and it was refferd in file'" + paulaFile.getAbsolutePath() + "'.");
                        continue;
                    }
                    SNode refElement = (SNode)this.getDocument().getDocumentGraph().getNode(sElementName);
                    SRelation refRelation = (SRelation)this.getDocument().getDocumentGraph().getRelation(sElementName);
                    if (refElement != null) {
                        try {
                            refElement.addAnnotation(sAnno);
                        }
                        catch (Exception e) {
                            logger.warn("[PAULAImporter] Exception in paula file: " + this.getResourceURI().toFileString() + " at element: " + featHref + ". Original message is: " + e.getMessage());
                        }
                        continue;
                    }
                    if (refRelation != null) {
                        refRelation.addAnnotation(sAnno);
                        continue;
                    }
                    throw new PepperModuleException((PepperMapper)this, "No element with xml-id:" + paulaElementId + " was found.");
                }
            }
        }
    }

    public void paulaRELConnector(File paulaFile, String paulaId, String paulaType, String xmlBase, String relId, String srcHref, String dstHref) {
        if (srcHref == null || srcHref.isEmpty() || dstHref == null || dstHref.isEmpty() || srcHref.equalsIgnoreCase("empty") || dstHref.equalsIgnoreCase("empty")) {
            logger.warn("[PAULAImporter] Cannot create pointing relation of file (" + paulaFile.getName() + "), because source or destination is empty (see element '" + relId + "').");
        } else if (srcHref.equalsIgnoreCase(dstHref)) {
            logger.warn("[PAULAImporter] Cannot create the pointing relation '" + srcHref + "' to '" + dstHref + "' in document '" + this.getDocument().getId() + "', because it is a cycle. The cycle was found in file (" + paulaFile.getName() + ").");
        } else {
            Collection<String> paulaSrcElementIds = this.getPAULAElementIds(xmlBase, srcHref);
            Collection<String> paulaDstElementIds = this.getPAULAElementIds(xmlBase, dstHref);
            if (paulaSrcElementIds == null || paulaSrcElementIds.size() == 0) {
                throw new PepperModuleException((PepperMapper)this, "The source of pointing relation in file: " + paulaFile.getName() + " is not set.");
            }
            if (paulaDstElementIds == null || paulaDstElementIds.size() == 0) {
                throw new PepperModuleException((PepperMapper)this, "The destination of pointing relation in file: " + paulaFile.getName() + " is not set.");
            }
            if (this.elementNamingTable == null) {
                throw new PepperModuleException((PepperMapper)this, "The map elementNamingTable was not initialized, this might be a bug.");
            }
            for (String paulaSrcElementId : paulaSrcElementIds) {
                for (String paulaDstElementId : paulaDstElementIds) {
                    String saltSrcName = this.elementNamingTable.get(paulaSrcElementId);
                    String saltDstName = this.elementNamingTable.get(paulaDstElementId);
                    if (saltSrcName == null || saltSrcName.isEmpty()) {
                        logger.warn("[PAULAImporter] The requested source of relation (xml-id: " + paulaSrcElementId + ") of file '" + paulaFile.getName() + "' does not exist.");
                        return;
                    }
                    SPointingRelation pRel = SaltFactory.createSPointingRelation();
                    if (saltDstName == null || saltDstName.isEmpty()) {
                        logger.warn("[PAULAImporter] The requested destination of relation (xml-id: " + paulaDstElementId + ") of file '" + paulaFile.getName() + "' does not exist.");
                        return;
                    }
                    pRel.setName(relId);
                    pRel.setType(paulaType);
                    pRel.setSource((Node)((SStructuredNode)this.getDocument().getDocumentGraph().getNode(saltSrcName)));
                    pRel.setTarget((Node)((SStructuredNode)this.getDocument().getDocumentGraph().getNode(saltDstName)));
                    this.getDocument().getDocumentGraph().addRelation((Relation)pRel);
                    String sLayerName = this.extractNSFromPAULAFile(paulaFile);
                    this.attachSRelation2SLayer((SRelation)pRel, sLayerName);
                    String uniqueName = paulaFile.getName() + KW_NAME_SEP + relId;
                    this.elementNamingTable.put(uniqueName, pRel.getIdentifier().getId());
                }
            }
        }
    }

    public void paulaFEAT_METAConnector(File paulaFile, String paulaId, String paulaType, String xmlBase, String featID, String featHref, String featTar, String featVal, String featDesc, String featExp) {
        if (paulaType == null || paulaType.isEmpty()) {
            logger.warn("[PAULAImporter] Cannot add the given meta-annotation, because no annotation name is given in file '" + paulaFile + "'.");
            return;
        }
        String fullName = paulaType;
        SDocument sMetaAnnotatableElement = null;
        if (this.getDocument() != null) {
            sMetaAnnotatableElement = this.getDocument();
        } else if (this.getCorpus() != null) {
            sMetaAnnotatableElement = this.getCorpus();
        } else {
            throw new PepperModuleException((PepperMapper)this, "Cannot map sMetaAnnotation '" + fullName + "=" + featVal + "', because neither a SDocument object nor a SCorpus object is given. This might be a bug in PAULAModules.");
        }
        if (sMetaAnnotatableElement.getMetaAnnotation(fullName) == null) {
            sMetaAnnotatableElement.createMetaAnnotation(null, paulaType, (Object)featVal);
        }
    }

    public void paulaSTRUCTConnector(File paulaFile, String paulaId, String paulaType, String xmlBase, String structID, String relID, String relHref, String relType) {
        Collection<Object> orderedElementSlot;
        String uniqueNameStruct = paulaFile.getName() + KW_NAME_SEP + structID;
        String uniqueNameRel = paulaFile.getName() + KW_NAME_SEP + relID;
        if (xmlBase == null || xmlBase.isEmpty()) {
            xmlBase = paulaFile.getName();
        }
        if (this.elementOrderTable.get(paulaFile.getName()) == null) {
            orderedElementSlot = new ArrayList();
            this.elementOrderTable.put(paulaFile.getName(), orderedElementSlot);
        }
        if (!(orderedElementSlot = this.elementOrderTable.get(paulaFile.getName())).contains(uniqueNameStruct)) {
            orderedElementSlot.add(uniqueNameStruct);
        }
        if (!orderedElementSlot.contains(uniqueNameRel)) {
            orderedElementSlot.add(uniqueNameRel);
        }
        if (this.elementNamingTable.get(uniqueNameStruct) == null) {
            SStructure sStruct = SaltFactory.createSStructure();
            sStruct.setName(structID);
            this.getDocument().getDocumentGraph().addNode((Node)sStruct);
            String sLayerName = this.extractNSFromPAULAFile(paulaFile);
            this.attachSNode2SLayer((SNode)sStruct, sLayerName);
            this.elementNamingTable.put(uniqueNameStruct, sStruct.getId());
        }
        SDominanceRelation domRel = SaltFactory.createSDominanceRelation();
        domRel.setName(relID);
        String saltDstName = this.elementNamingTable.get(uniqueNameStruct);
        domRel.setSource((Node)((SStructure)this.getDocument().getDocumentGraph().getNode(saltDstName)));
        if (relType != null && !relType.isEmpty()) {
            domRel.setType(relType);
        }
        if (this.dominanceRelationContainers == null) {
            this.dominanceRelationContainers = new Hashtable();
        }
        List<DominanceRelationContainer> domRelSlot = null;
        domRelSlot = this.dominanceRelationContainers.get(paulaFile);
        if (domRelSlot == null) {
            domRelSlot = new ArrayList<DominanceRelationContainer>();
            this.dominanceRelationContainers.put(paulaFile, domRelSlot);
        }
        DominanceRelationContainer domCon = new DominanceRelationContainer();
        domCon.paulaId = uniqueNameRel;
        domCon.relation = domRel;
        domCon.xmlBase = xmlBase;
        domCon.href = relHref;
        domRelSlot.add(domCon);
    }

    public void endDocument(PAULASpecificReader paulaReader, File paulaFile) {
        if (paulaReader instanceof PAULAStructReader && this.dominanceRelationContainers != null) {
            for (DominanceRelationContainer domCon : this.dominanceRelationContainers.get(paulaFile)) {
                Collection<String> refPAULAElementIds = this.getPAULAElementIds(domCon.xmlBase, domCon.href);
                for (String refPAULAId : refPAULAElementIds) {
                    String sNodeName = this.elementNamingTable.get(refPAULAId);
                    if (sNodeName == null) {
                        throw new PepperModuleException((PepperMapper)this, "An element is referred, which was not already read. The reffered element is '" + refPAULAId + "' and it was reffered in file '" + paulaFile + "'.");
                    }
                    SNode dstNode = (SNode)this.getDocument().getDocumentGraph().getNode(sNodeName);
                    if (dstNode == null) {
                        throw new PepperModuleException((PepperMapper)this, "No paula element with name: " + refPAULAId + " was found.");
                    }
                    domCon.relation.setTarget((Node)((SStructuredNode)dstNode));
                    this.getDocument().getDocumentGraph().addRelation((Relation)domCon.relation);
                    String sLayerName = this.extractNSFromPAULAFile(paulaFile);
                    this.attachSRelation2SLayer((SRelation)domCon.relation, sLayerName);
                    if (this.elementNamingTable.get(domCon.paulaId) != null) continue;
                    this.elementNamingTable.put(domCon.paulaId, domCon.relation.getId());
                }
            }
            this.dominanceRelationContainers = null;
        }
    }

    public PAULAImporterProperties getProps() {
        return (PAULAImporterProperties)this.getProperties();
    }

    private static class DominanceRelationContainer {
        public String paulaId = null;
        public SDominanceRelation relation = null;
        public String xmlBase = null;
        public String href = null;

        private DominanceRelationContainer() {
        }
    }
}

