/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="SaltXMLImporterComponent", factory="PepperImporterComponentFactory")
public class SaltXMLImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String MODULE_NAME = "SaltXMLImporter";
    public static final String FORMAT_NAME = "SaltXML";
    public static final String FORMAT_VERSION = "1.0";

    public SaltXMLImporter() {
        super(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This importer imports a Salt model from a SaltXML representation. SaltXML is the native format to persist Salt. ");
        this.addSupportedFormat(FORMAT_NAME, FORMAT_VERSION, null);
        this.setProperties(new PepperModuleProperties());
    }

    @Override
    public Double isImportable(URI corpusPath) {
        Double retValue = 0.0;
        for (String content : this.sampleFileContent(corpusPath, "salt", "xml")) {
            if (!content.contains("<?xml") || !content.contains("xmi:version=\"2.0\"") || !content.contains("salt")) continue;
            retValue = 1.0;
            break;
        }
        return retValue;
    }

    @Override
    public SelfTestDesc getSelfTestDesc() {
        return new SelfTestDesc(this.getResources().appendSegment("modules").appendSegment("selfTests").appendSegment("saltXmlImporter").appendSegment("in"), this.getResources().appendSegment("modules").appendSegment("selfTests").appendSegment("saltXmlImporter").appendSegment("expected"));
    }

    @Override
    public void importCorpusStructure(SCorpusGraph corpusGraph) throws PepperModuleException {
        this.setCorpusGraph(corpusGraph);
        corpusGraph.load(this.getCorpusDesc().getCorpusPath());
    }

    @Override
    public PepperMapper createPepperMapper(Identifier id) {
        SaltXMLMapper mapper = new SaltXMLMapper();
        if (id.getIdentifiableElement() instanceof SDocument) {
            SDocument sDocument = (SDocument)id.getIdentifiableElement();
            URI location = this.getCorpusDesc().getCorpusPath();
            location = location.appendSegments(sDocument.getPath().segments());
            location = location.appendFileExtension("salt");
            mapper.setResourceURI(location);
        }
        return mapper;
    }

    private static class SaltXMLMapper
    extends PepperMapperImpl {
        private SaltXMLMapper() {
        }

        @Override
        public DOCUMENT_STATUS mapSDocument() {
            this.getDocument().loadDocumentGraph(this.getResourceURI());
            return DOCUMENT_STATUS.COMPLETED;
        }
    }
}

