/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import java.io.File;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="DoNothingImporterComponent", factory="PepperImporterComponentFactory")
public class DoNothingImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String MODULE_NAME = "DoNothingImporter";
    public static final String FORMAT_NAME = "doNothing";
    public static final String FORMAT_VERSION = "0.0";

    @Override
    public void importCorpusStructure(SCorpusGraph corpusGraph) throws PepperModuleException {
    }

    public DoNothingImporter() {
        super(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This is a dummy importer which imports nothing. ");
        this.addSupportedFormat(FORMAT_NAME, FORMAT_VERSION, null);
    }

    @Override
    public Double isImportable(URI corpusPath) {
        return 0.1;
    }

    @Override
    public SelfTestDesc getSelfTestDesc() {
        URI inURI = this.getResources().appendSegment("modules").appendSegment("selfTests").appendSegment("doNothingImporter").appendSegment("in");
        if (!new File(inURI.toFileString()).mkdirs()) {
            this.logger.warn("Can't create input directory '" + inURI + "' for DoNothingImporter");
        }
        return new SelfTestDesc(inURI, this.getResources().appendSegment("modules").appendSegment("selfTests").appendSegment("doNothingImporter").appendSegment("expected"));
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        PepperMapperImpl mapper = new PepperMapperImpl(){

            @Override
            public DOCUMENT_STATUS mapSDocument() {
                return DOCUMENT_STATUS.COMPLETED;
            }
        };
        return mapper;
    }
}

