/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PepperModuleProperty<T>
implements Comparable<PepperModuleProperty<?>>,
Serializable {
    private static final long serialVersionUID = -1577480488804525468L;
    private final String name;
    private T value = null;
    private final T defaultValue;
    private final boolean required;
    private final String description;
    private final Class<T> type;

    @Deprecated
    public PepperModuleProperty(String name, Class<T> clazz, String description) {
        this(name, clazz, description, null, false);
    }

    @Deprecated
    public PepperModuleProperty(String name, Class<T> clazz, String description, T defaultValue) {
        this(name, clazz, description, defaultValue, false);
    }

    @Deprecated
    public PepperModuleProperty(String name, Class<T> clazz, String description, boolean required) {
        this(name, clazz, description, null, required);
    }

    @Deprecated
    public PepperModuleProperty(String name, Class<T> clazz, String description, T defaultValue, boolean required) {
        this.name = name;
        this.type = clazz;
        this.description = description;
        this.required = required;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public void setValueString(String value) {
        if (value == null) {
            this.value = null;
            return;
        }
        value = value.trim();
        if (!this.type.isArray()) {
            this.value = this.stringToX(this.type, value);
        } else if (String[].class.isAssignableFrom(this.type)) {
            List<String> values = this.extractListFromString(String.class, value);
            this.value = values.toArray(new String[values.size()]);
        } else if (Character[].class.isAssignableFrom(this.type)) {
            List<Character> values = this.extractListFromString(Character.class, value);
            this.value = values.toArray(new Character[values.size()]);
        } else if (Boolean[].class.isAssignableFrom(this.type)) {
            List<Boolean> values = this.extractListFromString(Boolean.class, value);
            this.value = values.toArray(new Boolean[values.size()]);
        } else if (Integer[].class.isAssignableFrom(this.type)) {
            List<Integer> values = this.extractListFromString(Integer.class, value);
            this.value = values.toArray(new Integer[values.size()]);
        } else if (Long[].class.isAssignableFrom(this.type)) {
            List<Long> values = this.extractListFromString(Long.class, value);
            this.value = values.toArray(new Long[values.size()]);
        } else if (Float[].class.isAssignableFrom(this.type)) {
            List<Float> values = this.extractListFromString(Float.class, value);
            this.value = values.toArray(new Float[values.size()]);
        } else if (Double[].class.isAssignableFrom(this.type)) {
            List<Double> values = this.extractListFromString(Double.class, value);
            this.value = values.toArray(new Double[values.size()]);
        } else if (Byte[].class.isAssignableFrom(this.type)) {
            List<Byte> values = this.extractListFromString(Byte.class, value);
            this.value = values.toArray(new Byte[values.size()]);
        } else if (Short[].class.isAssignableFrom(this.type)) {
            List<Short> values = this.extractListFromString(Short.class, value);
            this.value = values.toArray(new Short[values.size()]);
        } else if (File[].class.isAssignableFrom(this.type)) {
            List<File> values = this.extractListFromString(File.class, value);
            this.value = values.toArray(new File[values.size()]);
        }
    }

    private <B> List<B> extractListFromString(Class<B> type, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return Collections.emptyList();
        }
        List values = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)value);
        ArrayList<B> typedValues = new ArrayList<B>();
        for (String stringValue : values) {
            typedValues.add(this.stringToX(type, stringValue));
        }
        return typedValues;
    }

    private <B> B stringToX(Class<B> type, String value) {
        if (String.class.isAssignableFrom(type)) {
            return (B)value;
        }
        if (Character.class.isAssignableFrom(type)) {
            return (B)Character.valueOf(value.charAt(0));
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (B)Boolean.valueOf(value);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (B)Integer.valueOf(value);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (B)Long.valueOf(value);
        }
        if (Float.class.isAssignableFrom(type)) {
            return (B)Float.valueOf(value);
        }
        if (Double.class.isAssignableFrom(type)) {
            return (B)Double.valueOf(value);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (B)Byte.valueOf(value);
        }
        if (Short.class.isAssignableFrom(type)) {
            return (B)Short.valueOf(value);
        }
        if (File.class.isAssignableFrom(type)) {
            return (B)new File(value);
        }
        return null;
    }

    public String toString() {
        return this.getName() + "=" + this.getType() + "::" + this.getValue();
    }

    @Override
    public int compareTo(PepperModuleProperty<?> o) {
        return this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.required ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PepperModuleProperty other = (PepperModuleProperty)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static NameBuilder create() {
        return new NameBuilder();
    }

    public static class NameBuilder {
        public TypeBuilder withName(String name) {
            return new TypeBuilder(name);
        }

        public static class TypeBuilder {
            private final String name;

            public TypeBuilder(String name) {
                this.name = name;
            }

            public <T> DescriptionBuilder<T> withType(Class<T> type) {
                return new DescriptionBuilder<T>(this.name, type);
            }

            public static class DescriptionBuilder<T> {
                private final String name;
                private final Class<T> type;

                public DescriptionBuilder(String name, Class<T> type) {
                    this.name = name;
                    this.type = type;
                }

                public Builder<T> withDescription(String description) {
                    return new Builder<T>(this.name, this.type, description);
                }

                public static class Builder<T> {
                    private final String name;
                    private final Class<T> type;
                    private String description;
                    private T defaultValue;
                    private boolean isRequired;

                    public Builder(String name, Class<T> type, String description) {
                        this.name = name;
                        this.type = type;
                        this.description = description;
                    }

                    public Builder<T> withDefaultValue(T defaultValue) {
                        this.defaultValue = defaultValue;
                        return this;
                    }

                    public Builder<T> isRequired(boolean isRequired) {
                        this.isRequired = isRequired;
                        return this;
                    }

                    public PepperModuleProperty<T> build() {
                        return new PepperModuleProperty<T>(this.name, this.type, this.description, this.defaultValue, this.isRequired);
                    }
                }
            }
        }
    }
}

