/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.impl;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.exceptions.PepperConvertException;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.impl.PepperModuleImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;

public abstract class PepperExporterImpl
extends PepperModuleImpl
implements PepperExporter {
    protected CorpusDesc corpusDefinition;
    private String sDocumentEnding = null;
    private PepperExporter.EXPORT_MODE exportMode = PepperExporter.EXPORT_MODE.NO_EXPORT;
    private Map<Identifier, URI> sElementId2ResourceTable = null;

    protected PepperExporterImpl() {
        super("MyExporter");
    }

    protected PepperExporterImpl(String name) {
        super(name);
    }

    @Override
    public List<FormatDesc> getSupportedFormats() {
        return this.getFingerprint().getSupportedFormats();
    }

    @Override
    public FormatDesc addSupportedFormat(String formatName, String formatVersion, URI formatReference) {
        return this.getFingerprint().addSupportedFormat(formatName, formatVersion, formatReference);
    }

    @Override
    public CorpusDesc getCorpusDesc() {
        return this.corpusDefinition;
    }

    @Override
    public void setCorpusDesc(CorpusDesc newCorpusDefinition) {
        this.corpusDefinition = newCorpusDefinition;
    }

    @Override
    public void start() throws PepperModuleException {
        this.exportCorpusStructure();
        super.start();
    }

    @Override
    public String getDocumentEnding() {
        return this.sDocumentEnding;
    }

    @Override
    public void setDocumentEnding(String sDocumentEnding) {
        this.sDocumentEnding = sDocumentEnding;
    }

    @Override
    public PepperExporter.EXPORT_MODE getExportMode() {
        return this.exportMode;
    }

    @Override
    public void setExportMode(PepperExporter.EXPORT_MODE exportMode) {
        this.exportMode = exportMode;
    }

    @Override
    public synchronized Map<Identifier, URI> getIdentifier2ResourceTable() {
        if (this.sElementId2ResourceTable == null) {
            this.sElementId2ResourceTable = new Hashtable<Identifier, URI>();
        }
        return this.sElementId2ResourceTable;
    }

    @Override
    public void exportCorpusStructure() {
        if (this.getExportMode() != null && !this.getExportMode().equals((Object)PepperExporter.EXPORT_MODE.NO_EXPORT) && this.getSaltProject() != null) {
            LinkedList corpGraphs = new LinkedList(this.getSaltProject().getCorpusGraphs());
            for (SCorpusGraph sCorpusGraph : corpGraphs) {
                if (sCorpusGraph == null) {
                    this.logger.warn("An empty SDocumentGraph is in list of SaltProject. This might be a bug of pepper framework.");
                    continue;
                }
                if (this.getCorpusDesc() == null) {
                    throw new PepperFWException("Cannot export the corpus-structure to file structure, because no corpus description was given. ");
                }
                if (this.getCorpusDesc().getCorpusPath() == null) {
                    throw new PepperFWException("Cannot export the corpus-structure to file structure, because the corpus path for module '" + this.getName() + "' is empty. ");
                }
                for (SCorpus sCorpus : sCorpusGraph.getCorpora()) {
                    URI resourceURI = this.getCorpusDesc().getCorpusPath();
                    for (String segment : sCorpus.getPath().segments()) {
                        resourceURI = resourceURI.appendSegment(segment);
                    }
                    this.getIdentifier2ResourceTable().put(sCorpus.getIdentifier(), resourceURI);
                }
                if (!this.getExportMode().equals((Object)PepperExporter.EXPORT_MODE.DOCUMENTS_IN_FILES)) continue;
                String ending = this.getDocumentEnding();
                if (ending == null) {
                    ending = "";
                }
                for (SDocument sDocument : sCorpusGraph.getDocuments()) {
                    File outFile;
                    URI resourceURI = this.getCorpusDesc().getCorpusPath();
                    for (String segment : sDocument.getPath().segments()) {
                        resourceURI = resourceURI.appendSegment(segment);
                    }
                    resourceURI = resourceURI.appendFileExtension(ending);
                    this.getIdentifier2ResourceTable().put(sDocument.getIdentifier(), resourceURI);
                    String fileName = resourceURI.toFileString();
                    if (fileName == null) {
                        fileName = resourceURI.toString();
                    }
                    if ((outFile = new File(fileName)).getParentFile().exists() || outFile.getParentFile().mkdirs()) continue;
                    this.logger.warn("Cannot create folder {}. ", (Object)outFile.getParentFile());
                }
            }
        }
    }

    @Override
    @Deprecated
    public URI createFolderStructure(Identifier id) {
        if (id == null) {
            throw new PepperConvertException("Cannot export the given sElementID, because given Identifier-object is null.");
        }
        if (id.getIdentifiableElement() == null) {
            throw new PepperConvertException("Cannot export the given sElementID, because the SIdentifiableElement-object of given Identifier-object is null.");
        }
        if (!(id.getIdentifiableElement() instanceof SDocument) && !(id.getIdentifiableElement() instanceof SCorpus)) {
            throw new PepperConvertException("Cannot export the given sElementID, because the element corresponding to it, isn't of type SDocument or SCorpus.");
        }
        if (this.getCorpusDesc() == null) {
            throw new PepperFWException("Cannot export the corpus-structure to file structure, because no corpus description was given. ");
        }
        if (this.getCorpusDesc().getCorpusPath() == null) {
            throw new PepperFWException("Cannot export the corpus-structure to file structure, because the corpus path for module '" + this.getName() + "' is empty. ");
        }
        try {
            File folder = new File(this.getCorpusDesc().getCorpusPath().toFileString());
            File newFolder = new File(folder.getCanonicalPath() + "/" + ((SNode)id.getIdentifiableElement()).getPath().toString());
            if (!newFolder.mkdirs()) {
                this.logger.warn("Cannot create folder {}. ", (Object)newFolder);
            }
            return URI.createFileURI((String)newFolder.getAbsolutePath());
        }
        catch (IOException e) {
            throw new PepperConvertException("Cannot create corpus path as folders for '" + id + "'.", e);
        }
    }
}

