/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.io.File;
import java.util.Collection;
import org.corpus_tools.pepper.common.Pepper;
import org.corpus_tools.pepper.common.PepperConfiguration;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.core.ModuleResolverImpl;
import org.corpus_tools.pepper.core.PepperImpl;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.corpus_tools.pepper.exceptions.PepperOSGiRunnerException;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="PepperTestComponent", immediate=true, enabled=true)
public class PepperOSGiRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PepperOSGiRunner.class);
    public static final String PROP_TEST_DISABLED = "org.corpus_tools.pepper.disableTest";
    public static final String ENV_PEPPER_WORKFLOW_FILE = "PEPPER_TEST_WORKFLOW_FILE";
    public static final String DIR_PLUGINS = "/plugins";
    public static final String DIR_CONF = "/conf";
    private PepperImpl pepper = null;
    public static final String ARG_COMMAND_LINE_PARAMS = "sun.java.command";
    public static final String ARG_SELFTEST = "-selfTest";
    private Boolean isDisabled = false;
    private ComponentContext componentContext = null;

    public void unsetPepper(Pepper pepperConverter) {
        if (!this.isDisabled.booleanValue()) {
            this.pepper = null;
        }
    }

    @Reference(unbind="unsetPepper", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setPepper(Pepper pepperConverter) {
        if (!this.isDisabled.booleanValue()) {
            this.pepper = (PepperImpl)pepperConverter;
        }
    }

    public Pepper getPepper() {
        return this.pepper;
    }

    private static File getWorkflowDescriptionFile() {
        if (System.getenv(ENV_PEPPER_WORKFLOW_FILE) == null) {
            throw new PepperOSGiRunnerException("Cannot start pepper-osgi-runner, please set environment variable 'PEPPER_TEST_WORKFLOW_FILE' to workflow description file which is supposed to be used for conversion.");
        }
        if (System.getenv(ENV_PEPPER_WORKFLOW_FILE).isEmpty()) {
            throw new PepperOSGiRunnerException("Cannot start pepper-osgi-runner, please set environment variable 'PEPPER_TEST_WORKFLOW_FILE' to workflow description file which is supposed to be used for conversion. Currently it is empty.");
        }
        File workflowDescFile = new File(System.getenv(ENV_PEPPER_WORKFLOW_FILE));
        if (!workflowDescFile.exists()) {
            throw new PepperOSGiRunnerException("Cannot start pepper-osgi-runner, because environment variable 'PEPPER_TEST_WORKFLOW_FILE' points to a non  existing file '" + workflowDescFile.getAbsolutePath() + "'.");
        }
        return workflowDescFile;
    }

    private boolean isSelfTest() {
        String args = System.getProperties().getProperty(ARG_COMMAND_LINE_PARAMS);
        return args.contains(ARG_SELFTEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws PepperException {
        Long millis = System.currentTimeMillis();
        try {
            logger.info(PepperUtil.getHello());
            if (this.pepper == null) {
                throw new PepperException("No PepperConverter-object is given for pepper-osgi-runner.");
            }
            if (this.pepper.getModuleResolver() == null) {
                throw new PepperException("No '" + ModuleResolverImpl.class + "' is given for passed '" + Pepper.class + "' object.");
            }
            PepperConfiguration conf = new PepperConfiguration();
            conf.load(this.componentContext);
            this.pepper.setConfiguration(conf);
            if (this.pepper.getConfiguration() != null && this.pepper.getConfiguration().size() != 0) {
                logger.info(PepperUtil.reportConfiguration(this.pepper.getConfiguration()));
            }
            logger.info(PepperUtil.reportModuleList(120, this.getPepper().getRegisteredModules()));
            if (this.isSelfTest()) {
                logger.info("Pepper is running in self test mode...");
                Collection<String> problems = this.pepper.selfTest();
                if (problems.size() == 0) {
                    logger.info("- no problems detected -");
                } else {
                    logger.info("following problems have been found:");
                    for (String problem : problems) {
                        logger.info("\t" + problem);
                    }
                }
            } else {
                URI workflowDescURI = null;
                try {
                    workflowDescURI = URI.createFileURI((String)PepperOSGiRunner.getWorkflowDescriptionFile().getAbsolutePath());
                }
                catch (PepperOSGiRunnerException e) {
                    logger.error(e.getMessage());
                }
                if (workflowDescURI != null) {
                    PepperJob job = this.pepper.getJob(this.pepper.createJob());
                    job.load(workflowDescURI);
                    PepperUtil.PepperJobReporter observer = new PepperUtil.PepperJobReporter(job, conf.getReportInterval());
                    observer.start();
                    try {
                        job.convert();
                    }
                    finally {
                        observer.setStop(true);
                        logger.info(job.getStatusReport());
                    }
                }
            }
            millis = System.currentTimeMillis() - millis;
            logger.info("Conversion ended, and needed: " + millis + " ms");
        }
        catch (RuntimeException e) {
            logger.info(PepperUtil.breakString("Launching of pepper-osgi-runner ended with errors (the stack trace is printed out to 'System.err'):"));
            logger.info(PepperUtil.breakString("   ", e.getMessage() + " (" + e.getClass().getSimpleName() + ")"));
            if (e instanceof PepperException) {
                throw (PepperException)e;
            }
            throw new PepperOSGiRunnerException("An error occured while running pepper-osgi-runner, because of nested exception.", e);
        }
        finally {
            logger.info("************************************************************************************************************************");
        }
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.isDisabled = System.getProperty(PROP_TEST_DISABLED) == null || Boolean.valueOf(System.getProperty(PROP_TEST_DISABLED)) == false ? Boolean.valueOf(false) : Boolean.valueOf(true);
        if (!this.isDisabled.booleanValue()) {
            Thread pepperTestThread = new Thread((Runnable)this, "PepperTest-Thread");
            pepperTestThread.start();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
    }
}

