/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.mergingModules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.util.SaltUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenMergeContainer {
    private static final Logger logger = LoggerFactory.getLogger((String)"Merger");
    private SDocument baseDocument = null;
    private Map<SToken, Map<STextualDS, SToken>> equivalentToken = new HashMap<SToken, Map<STextualDS, SToken>>();
    private Map<STextualDS, AlignedTokensMap> alignedTextsMap = new HashMap<STextualDS, AlignedTokensMap>();
    private Map<STextualDS, String> normalizedTexts = new HashMap<STextualDS, String>();
    private Map<STextualDS, List<Integer>> normalizedBaseTextToOriginalBaseText = new HashMap<STextualDS, List<Integer>>();
    private int maximumNormalizedTextLength = -1;

    public void setBaseDocument(SDocument sDocument) {
        this.baseDocument = sDocument;
    }

    public SDocument getBaseDocument() {
        return this.baseDocument;
    }

    public void setBaseTextPositionByNormalizedTextPosition(STextualDS sTextualDS, List<Integer> posMapping) {
        if (!this.normalizedBaseTextToOriginalBaseText.containsKey(sTextualDS)) {
            this.normalizedBaseTextToOriginalBaseText.put(sTextualDS, posMapping);
        }
    }

    public int getBaseTextPositionByNormalizedTextPosition(STextualDS sTextualDS, int position) {
        int baseTextPosition = -1;
        if (this.normalizedBaseTextToOriginalBaseText.containsKey(sTextualDS)) {
            if (this.normalizedBaseTextToOriginalBaseText.get(sTextualDS).size() > position) {
                baseTextPosition = this.normalizedBaseTextToOriginalBaseText.get(sTextualDS).get(position);
            } else {
                throw new PepperModuleException("Given position of character in the normalized text '" + position + "' was bigger than the size of the normalized text '" + this.normalizedBaseTextToOriginalBaseText.get(sTextualDS).size() + "'.");
            }
        }
        return baseTextPosition;
    }

    public void addNormalizedText(SDocument doc, STextualDS sTextualDS, String normalizedText) {
        if (this.maximumNormalizedTextLength == -1) {
            this.maximumNormalizedTextLength = normalizedText.length();
            this.setBaseDocument(doc);
        } else if (normalizedText.length() > this.maximumNormalizedTextLength) {
            this.maximumNormalizedTextLength = normalizedText.length();
            this.setBaseDocument(doc);
        }
        this.normalizedTexts.put(sTextualDS, normalizedText);
    }

    public String getNormalizedText(STextualDS sTextualDS) {
        return this.normalizedTexts.get(sTextualDS);
    }

    public SToken getAlignedTokenByStart(STextualDS sTextualDS, int start) {
        SToken tok = null;
        if (sTextualDS != null && this.alignedTextsMap.containsKey(sTextualDS)) {
            tok = this.alignedTextsMap.get(sTextualDS).getTokenByStart(start);
        }
        return tok;
    }

    public int getAlignedTokenStart(STextualDS sTextualDS, SToken sToken) {
        int returnVal = -1;
        if (sTextualDS != null && this.alignedTextsMap.containsKey(sTextualDS)) {
            AlignedTokensMap map = this.alignedTextsMap.get(sTextualDS);
            returnVal = map.getStart(sToken);
        }
        return returnVal;
    }

    public int getAlignedTokenLength(STextualDS sTextualDS, SToken sToken) {
        int returnVal = -1;
        if (sTextualDS != null && this.alignedTextsMap.containsKey(sTextualDS)) {
            AlignedTokensMap map = this.alignedTextsMap.get(sTextualDS);
            returnVal = map.getLength(sToken);
        }
        return returnVal;
    }

    public AlignedTokensMap getAlignedTokens(STextualDS text) {
        return this.alignedTextsMap.get(text);
    }

    public void addAlignedToken(STextualDS text, SToken tok, int left, int right) {
        if (this.alignedTextsMap.containsKey(text)) {
            this.alignedTextsMap.get(text).addToken(tok, left, right);
        } else {
            AlignedTokensMap map = new AlignedTokensMap();
            map.addToken(tok, left, right);
            this.alignedTextsMap.put(text, map);
        }
    }

    public void addTokenMapping(SToken baseTextToken, SToken otherTextToken, STextualDS otherSText) {
        if (otherTextToken.equals(baseTextToken)) {
            if (SaltUtil.getGlobalId((Identifier)otherTextToken.getIdentifier()).equals(SaltUtil.getGlobalId((Identifier)baseTextToken.getIdentifier()))) {
                logger.warn("[Merger] Sorry, you tried to add a token '" + SaltUtil.getGlobalId((Identifier)baseTextToken.getIdentifier()) + "' as it's own mapping");
            }
            return;
        }
        if (this.equivalentToken.get(baseTextToken) != null) {
            if (!this.equivalentToken.get(baseTextToken).containsKey(otherSText)) {
                this.equivalentToken.get(baseTextToken).put(otherSText, otherTextToken);
            }
        } else {
            HashMap<STextualDS, SToken> newMapping = new HashMap<STextualDS, SToken>();
            newMapping.put(otherSText, otherTextToken);
            this.equivalentToken.put(baseTextToken, newMapping);
        }
    }

    public SToken getTokenMapping(SToken baseTextToken, STextualDS otherSText) {
        SToken equivalentToken = null;
        if (this.equivalentToken.containsKey(baseTextToken)) {
            equivalentToken = this.equivalentToken.get(baseTextToken).get(otherSText);
        }
        return equivalentToken;
    }

    public Map<SToken, Map<STextualDS, SToken>> getEquivalenceMap() {
        return this.equivalentToken;
    }

    public void finishDocument(SDocument document) {
        logger.debug("[Merger] Finishing document: {}.", (Object)SaltUtil.getGlobalId((Identifier)document.getIdentifier()));
        if (document != null && document.getDocumentGraph() != null) {
            if (document.getDocumentGraph().getTextualDSs() != null) {
                for (STextualDS text : document.getDocumentGraph().getTextualDSs()) {
                    this.alignedTextsMap.remove(text);
                    this.normalizedTexts.remove(text);
                    this.normalizedBaseTextToOriginalBaseText.remove(text);
                }
            }
            this.equivalentToken = new HashMap<SToken, Map<STextualDS, SToken>>();
        }
    }

    public class AlignedTokensMap {
        private Map<SToken, Integer> tokenLeftMap = new HashMap<SToken, Integer>();
        private Map<SToken, Integer> tokenRightMap = new HashMap<SToken, Integer>();
        private Map<Integer, SToken> tokensByStart = new HashMap<Integer, SToken>();

        public List<SToken> getTokens() {
            return new ArrayList<SToken>(this.tokenLeftMap.keySet());
        }

        public void addToken(SToken tok, int left, int right) {
            this.tokenLeftMap.put(tok, left);
            this.tokenRightMap.put(tok, right);
            this.tokensByStart.put(left, tok);
        }

        public SToken getTokenByStart(int start) {
            return this.tokensByStart.get(start);
        }

        public int getLength(SToken tok) {
            if (this.tokenLeftMap.containsKey(tok) && this.tokenRightMap.containsKey(tok)) {
                return this.tokenRightMap.get(tok) - this.tokenLeftMap.get(tok);
            }
            return -1;
        }

        public int getStart(SToken tok) {
            if (this.tokenLeftMap.containsKey(tok)) {
                return this.tokenLeftMap.get(tok);
            }
            return -1;
        }

        public int getEnd(SToken tok) {
            if (this.tokenRightMap.containsKey(tok)) {
                return this.tokenRightMap.get(tok);
            }
            throw new PepperModuleException("Cannot find token '" + tok.getId() + "' in token right map");
        }
    }
}

