/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.mergingModules;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class MergerProperties
extends PepperModuleProperties {
    public static final String PROP_PUNCTUATIONS = "punctuations";
    public static final String PROP_ESCAPE_MAPPING = "escapeMapping";
    public static final String PROP_COPY_NODES = "copyNodes";
    public static final String PROP_ONLY_MERGE_TEXTS_WITH_SAME_NAME = "onlyMergeTextsWithSameName";
    public static final String PROP_FIRST_AS_BASE = "firstAsBase";
    public static final String PUNCTUATION_DEFAULT = "'.',',',':',';','!','?','(',')','{','}','<','>'";
    public static final String ESCAPE_MAPPING_DEFAULT = "\" \": \"\", \"\t\": \"\", \"\t\": \"\", \"\n\": \"\", \"\r\": \"\", \"\u00e4\": \"ae\", \"\u00f6\": \"oe\", \"\u00fc\": \"ue\", \"\u00df\": \"ss\", \"\u00c4\": \"Ae\", \"\u00d6\": \"Oe\", \"\u00dc\": \"Ue\", ";
    private Set<Character> punctuations = null;
    private Map<String, String> escapeMapping = null;

    public MergerProperties() {
        this.addProperty(new PepperModuleProperty(PROP_PUNCTUATIONS, String.class, "Determines the punctuation characters used to be ignored for detecting equal textual data. The value is a comma separated list, each entry must be surrounded by a quot: 'PUNCTUATION' (, 'PUNCTUATION')* .", (Object)PUNCTUATION_DEFAULT));
        this.addProperty(new PepperModuleProperty(PROP_ESCAPE_MAPPING, String.class, "Determines the mapping used in normalization step, to map special characters like umlauts. This value is a comma separated list of mappings: \"REPLACED_CHARACTER\" : \"REPLACEMENT\" (, \"REPLACED_CHARACTER\" : \"REPLACEMENT\")*", (Object)ESCAPE_MAPPING_DEFAULT));
        this.addProperty(new PepperModuleProperty(PROP_FIRST_AS_BASE, Boolean.class, "If this property is set to 'true', the base document is always the one, which belongs to the first SCorpusGraph (the first importer in Pepper workflow description). The value either could be 'true' or 'false'. If this value is set to false, the base document is computed automically (normally the one with the largest primary text).", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_COPY_NODES, Boolean.class, "Determines if SSpan and SStructure nodes should be copied or merged. Merged means to move all annotations to the equivalent in base document. If value is true they will be copied.", (Object)false, false));
        this.addProperty(PepperModuleProperty.create().withName(PROP_ONLY_MERGE_TEXTS_WITH_SAME_NAME).withType(Boolean.class).withDescription("If \"true\", only merge texts that have the same name").withDefaultValue((Object)false).isRequired(false).build());
    }

    public synchronized Set<Character> getPunctuations() {
        PepperModuleProperty prop;
        String puncString;
        if (this.punctuations == null && (puncString = (String)(prop = this.getProperty(PROP_PUNCTUATIONS)).getValue()) != null && !puncString.isEmpty()) {
            this.punctuations = new HashSet<Character>();
            boolean quoteStarted = false;
            for (char ch : puncString.toCharArray()) {
                if ('\'' == ch) {
                    quoteStarted = !quoteStarted;
                    continue;
                }
                if (',' != ch || !quoteStarted) {
                    // empty if block
                }
                this.punctuations.add(Character.valueOf(ch));
            }
        }
        return this.punctuations;
    }

    public Map<String, String> getEscapeMapping() {
        PepperModuleProperty prop;
        String escaping;
        if (this.escapeMapping == null && (escaping = (String)(prop = this.getProperty(PROP_ESCAPE_MAPPING)).getValue()) != null && !escaping.isEmpty()) {
            this.escapeMapping = new Hashtable<String, String>();
            String[] singleMappings = escaping.split(",");
            if (singleMappings.length > 0) {
                for (String singleMapping : singleMappings) {
                    String[] parts = singleMapping.split(":");
                    if (parts.length != 2) continue;
                    this.escapeMapping.put(parts[0].trim().replace("\"", ""), parts[1].trim().replace("\"", ""));
                }
            }
        }
        return this.escapeMapping;
    }

    public Boolean isFirstAsBase() {
        PepperModuleProperty prop = this.getProperty(PROP_FIRST_AS_BASE);
        return (boolean)((Boolean)prop.getValue());
    }

    public Boolean isCopyNodes() {
        PepperModuleProperty prop = this.getProperty(PROP_COPY_NODES);
        return (boolean)((Boolean)prop.getValue());
    }

    public Boolean isOnlyMergeTextWithSameName() {
        PepperModuleProperty prop = this.getProperty(PROP_ONLY_MERGE_TEXTS_WITH_SAME_NAME);
        return (boolean)((Boolean)prop.getValue());
    }
}

