/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.mergingModules;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.MappingSubject;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleInternalException;
import org.corpus_tools.peppermodules.mergingModules.MergeHandler;
import org.corpus_tools.peppermodules.mergingModules.Merger;
import org.corpus_tools.peppermodules.mergingModules.MergerProperties;
import org.corpus_tools.peppermodules.mergingModules.TokenMergeContainer;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.SaltUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergerMapper
extends PepperMapperImpl
implements PepperMapper {
    private static final Logger logger = LoggerFactory.getLogger((String)"Merger");
    protected boolean isTestMode = false;
    private Merger merger = null;
    private SCorpusGraph baseCorpusStructure = null;
    private SDocument baseDocument = null;
    private Map<SNode, SNode> node2NodeMap = null;
    protected TokenMergeContainer container = null;
    private List<Pair<Pair<String, String>, Pair<String, String>>> matchingTexts = new ArrayList<Pair<Pair<String, String>, Pair<String, String>>>();
    private Set<Pair<String, String>> noMatchingTexts = new HashSet<Pair<String, String>>();
    private Set<String> matchingTextsIdx = new HashSet<String>();

    public Merger getMerger() {
        return this.merger;
    }

    public void setMerger(Merger merger) {
        this.merger = merger;
    }

    public SCorpusGraph getBaseCorpusStructure() {
        return this.baseCorpusStructure;
    }

    public void setBaseCorpusStructure(SCorpusGraph baseCorpusStructure) {
        this.baseCorpusStructure = baseCorpusStructure;
    }

    protected void initialize() {
        if (this.getContainer() == null) {
            this.container = new TokenMergeContainer();
        }
    }

    public DOCUMENT_STATUS mapSCorpus() {
        if (this.getMappingSubjects().size() != 0) {
            SCorpus sCorp;
            if (logger.isDebugEnabled()) {
                StringBuilder str = new StringBuilder();
                str.append("Start merging corpora: ");
                for (MappingSubject subj : this.getMappingSubjects()) {
                    str.append("'");
                    str.append(SaltUtil.getGlobalId((Identifier)subj.getIdentifier()));
                    str.append("' ");
                }
                logger.debug("[Merger] " + str.toString());
            }
            SCorpus baseCorpus = null;
            for (MappingSubject subj : this.getMappingSubjects()) {
                if (!(subj.getIdentifier().getIdentifiableElement() instanceof SCorpus) || !(sCorp = (SCorpus)subj.getIdentifier().getIdentifiableElement()).getGraph().equals(this.getBaseCorpusStructure())) continue;
                baseCorpus = sCorp;
                break;
            }
            for (MappingSubject subj : this.getMappingSubjects()) {
                if (!(subj.getIdentifier().getIdentifiableElement() instanceof SCorpus)) continue;
                sCorp = (SCorpus)subj.getIdentifier().getIdentifiableElement();
                if (sCorp == baseCorpus) {
                    subj.setMappingResult(DOCUMENT_STATUS.COMPLETED);
                    continue;
                }
                SaltUtil.moveAnnotations((SAnnotationContainer)sCorp, (SAnnotationContainer)baseCorpus);
                SaltUtil.moveMetaAnnotations((SAnnotationContainer)sCorp, (SAnnotationContainer)baseCorpus);
                subj.setMappingResult(DOCUMENT_STATUS.DELETED);
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public SDocument getBaseDocument() {
        return this.baseDocument;
    }

    public void setBaseDocument(SDocument baseDocument) {
        this.baseDocument = baseDocument;
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.initialize();
        if (this.getMappingSubjects().size() > 1) {
            MappingSubject baseSubject;
            if (logger.isDebugEnabled()) {
                StringBuilder str = new StringBuilder();
                str.append("Start merging documents: ");
                for (MappingSubject subj : this.getMappingSubjects()) {
                    str.append("'");
                    str.append(SaltUtil.getGlobalId((Identifier)subj.getIdentifier()));
                    str.append("' ");
                }
                logger.debug("[Merger] " + str.toString());
            }
            if ((baseSubject = this.chooseBaseDocument()) == null) {
                throw new PepperModuleInternalException((PepperMapper)this, "No base document could have been computed. ");
            }
            SDocument baseDocument = (SDocument)baseSubject.getIdentifier().getIdentifiableElement();
            this.setBaseDocument(baseDocument);
            for (MappingSubject subj : this.getMappingSubjects()) {
                SDocument sDoc;
                if (!(subj.getIdentifier().getIdentifiableElement() instanceof SDocument) || (sDoc = (SDocument)subj.getIdentifier().getIdentifiableElement()) == this.getBaseDocument()) continue;
                SaltUtil.moveAnnotations((SAnnotationContainer)sDoc, (SAnnotationContainer)baseDocument);
                SaltUtil.moveMetaAnnotations((SAnnotationContainer)sDoc, (SAnnotationContainer)baseDocument);
            }
            this.mergeDocumentStructures(baseSubject);
            MappingSubject baseSubj = null;
            for (MappingSubject subj : this.getMappingSubjects()) {
                SDocument sDoc = (SDocument)subj.getIdentifier().getIdentifiableElement();
                if (sDoc != this.getBaseDocument()) {
                    subj.setMappingResult(DOCUMENT_STATUS.DELETED);
                    continue;
                }
                subj.setMappingResult(DOCUMENT_STATUS.COMPLETED);
                baseSubj = subj;
            }
            this.getMappingSubjects().clear();
            this.getMappingSubjects().add(baseSubj);
        }
        if (this.getMerger() != null) {
            this.getMerger().releaseMergerMapper();
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void mergeDocumentStructures(MappingSubject baseSubject) {
        if (baseSubject != null) {
            if (this.getBaseDocument() == null) {
                this.setBaseDocument((SDocument)baseSubject.getIdentifier().getIdentifiableElement());
            }
            this.getContainer().setBaseDocument(this.getBaseDocument());
        }
        SDocument baseDocument = (SDocument)baseSubject.getIdentifier().getIdentifiableElement();
        if (baseSubject.getDocumentController() != null && this.getPepperMapperController() != null) {
            logger.trace("[Merger] Try to wake up base document {}. ", (Object)baseSubject.getDocumentController().getGlobalId());
            this.getPepperMapperController().getPermissionForProcessDoument(baseSubject.getDocumentController());
            baseSubject.getDocumentController().awake();
            logger.trace("[Merger] Successfully woke up base document {}. ", (Object)baseSubject.getDocumentController().getGlobalId());
        }
        this.normalizePrimaryTexts(baseDocument);
        for (MappingSubject subj : this.getMappingSubjects()) {
            SDocument otherDocument = (SDocument)subj.getIdentifier().getIdentifiableElement();
            if (otherDocument == this.getBaseDocument()) continue;
            if (subj.getDocumentController() != null && this.getPepperMapperController() != null) {
                logger.trace("[Merger] Try to wake up other document {}. ", (Object)subj.getDocumentController().getGlobalId());
                this.getPepperMapperController().getPermissionForProcessDoument(subj.getDocumentController());
                subj.getDocumentController().awake();
                logger.trace("[Merger] Successfully woke up other document {}. ", (Object)subj.getDocumentController().getGlobalId());
            }
            this.normalizePrimaryTexts(otherDocument);
            logger.debug("[Merger] Start merging of base document '{}' with {}. ", (Object)SaltUtil.getGlobalId((Identifier)baseDocument.getIdentifier()), (Object)SaltUtil.getGlobalId((Identifier)subj.getIdentifier()));
            this.mergeDocumentStructures(baseDocument, otherDocument);
            if (!this.isTestMode) {
                this.getContainer().finishDocument(otherDocument);
            }
            if (subj.getDocumentController() == null) continue;
            this.getMerger().done(otherDocument.getIdentifier(), DOCUMENT_STATUS.DELETED);
        }
        if (!this.isTestMode) {
            this.getContainer().finishDocument(baseDocument);
        }
        if (logger.isDebugEnabled()) {
            StringBuilder debug = new StringBuilder();
            if (this.matchingTexts.size() > 0) {
                debug.append("[Merger] mergable texts:\n");
                int i = 1;
                for (Pair pair : this.matchingTexts) {
                    if (i > 1) {
                        debug.append("\n");
                    }
                    ++i;
                    String baseId = (String)((Pair)pair.getLeft()).getLeft();
                    String otherId = (String)((Pair)pair.getRight()).getLeft();
                    String format = "\t%-" + (baseId.length() > otherId.length() ? baseId.length() : otherId.length()) + "s: ";
                    debug.append("<base> \t");
                    debug.append(String.format(format, baseId));
                    debug.append(((String)((Pair)pair.getLeft()).getRight()).substring("<base>".length()));
                    debug.append("\n");
                    debug.append("<other>\t");
                    debug.append(String.format(format, otherId));
                    debug.append((String)((Pair)pair.getRight()).getRight());
                    debug.append("\n");
                }
            }
            if (this.noMatchingTexts.size() > 0) {
                debug.append("[Merger] NOT mergable texts:\n");
                for (Pair<String, String> text : this.noMatchingTexts) {
                    if (((String)text.getRight()).startsWith("<base>")) {
                        debug.append("<base> ");
                        debug.append("\t");
                        debug.append((String)text.getLeft());
                        debug.append("\t");
                        debug.append(((String)text.getRight()).substring("<base>".length()));
                        debug.append("\n");
                        continue;
                    }
                    debug.append("<other>");
                    debug.append("\t");
                    debug.append((String)text.getLeft());
                    debug.append("\t");
                    debug.append((String)text.getRight());
                    debug.append("\n");
                }
            }
            logger.debug(debug.toString());
        }
    }

    private void mergeDocumentStructures(SDocument baseDoc, SDocument otherDoc) {
        if (baseDoc.getDocumentGraph() != null && otherDoc.getDocumentGraph() != null) {
            int initialSize = this.getBaseDocument().getDocumentGraph().getNodes().size();
            if (otherDoc.getDocumentGraph().getNodes().size() > initialSize) {
                initialSize = otherDoc.getDocumentGraph().getNodes().size();
            }
            this.node2NodeMap = new HashMap<SNode, SNode>(initialSize);
            boolean alignedTexts = false;
            if (otherDoc.getDocumentGraph().getTextualDSs() != null) {
                logger.trace("[Merger] Aligning the texts of {} with text in base document. ", (Object)SaltUtil.getGlobalId((Identifier)otherDoc.getIdentifier()));
                HashSet nonEquivalentTokensOfOtherText = new HashSet();
                nonEquivalentTokensOfOtherText.addAll(otherDoc.getDocumentGraph().getTokens());
                alignedTexts = this.alignAllTexts(this.getBaseDocument(), otherDoc);
            } else {
                logger.warn("There is no text in document {} to be merged. Will not copy the tokens!", (Object)SaltUtil.getGlobalId((Identifier)otherDoc.getIdentifier()));
            }
            if (alignedTexts) {
                SDocumentGraph otherGraph = otherDoc.getDocumentGraph();
                SDocumentGraph baseGraph = baseDoc.getDocumentGraph();
                MergeHandler handler = new MergeHandler(this.node2NodeMap, otherGraph, baseGraph, this.getContainer());
                handler.setProperties((MergerProperties)this.getProperties());
                List<SNode> roots = this.getRoots(otherGraph);
                if (roots == null || roots.size() == 0) {
                    logger.warn("Cannot start the traversing for merging document-structure, since no tokens exist for document '" + SaltUtil.getGlobalId((Identifier)otherGraph.getDocument().getIdentifier()) + "'.");
                } else {
                    logger.trace("[Merger] Merging higher document-structure for [{}, {}]", (Object)SaltUtil.getGlobalId((Identifier)baseDoc.getIdentifier()), (Object)SaltUtil.getGlobalId((Identifier)otherDoc.getIdentifier()));
                    otherGraph.traverse(roots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "merger_" + SaltUtil.getGlobalId((Identifier)baseDoc.getIdentifier()), (GraphTraverseHandler)handler, false);
                    handler.mergeSPointingRelations(otherGraph, baseGraph);
                    logger.trace("[Merger] Done with merging higher document-structure for [{}, {}]", (Object)SaltUtil.getGlobalId((Identifier)baseDoc.getIdentifier()), (Object)SaltUtil.getGlobalId((Identifier)otherDoc.getIdentifier()));
                }
            } else {
                logger.warn("Could not align any text for documents {} and {}", (Object)SaltUtil.getGlobalId((Identifier)this.getBaseDocument().getIdentifier()), (Object)SaltUtil.getGlobalId((Identifier)otherDoc.getIdentifier()));
            }
        }
    }

    private List<SNode> getRoots(SDocumentGraph other) {
        LinkedHashSet<Node> retSet = new LinkedHashSet<Node>();
        ArrayList relations = new ArrayList();
        relations.addAll(other.getSpanningRelations());
        relations.addAll(other.getDominanceRelations());
        HashSet<Node> notRootElements = new HashSet<Node>();
        retSet.addAll(other.getTokens());
        for (SRelation relation : relations) {
            if (!notRootElements.contains(relation.getTarget())) {
                notRootElements.add(relation.getTarget());
            }
            if (!notRootElements.contains(relation.getSource()) && !retSet.contains(relation.getSource())) {
                retSet.add(relation.getSource());
            }
            if (!retSet.contains(relation.getTarget())) continue;
            retSet.remove(relation.getTarget());
        }
        ArrayList retVal = null;
        if (!retSet.isEmpty()) {
            retVal = new ArrayList(retSet);
        }
        return retVal;
    }

    public TokenMergeContainer getContainer() {
        return this.container;
    }

    protected MappingSubject chooseBaseDocument() {
        MappingSubject baseSubject = null;
        int maxNumOfElements = 0;
        for (MappingSubject subj : this.getMappingSubjects()) {
            if (subj.getIdentifier() == null) {
                throw new PepperModuleException((PepperMapper)this, "A MappingSubject does not contain a document object. This seems to be a bug. ");
            }
            if (!(subj.getIdentifier().getIdentifiableElement() instanceof SDocument)) continue;
            SDocument document = (SDocument)subj.getIdentifier().getIdentifiableElement();
            if (document == null) {
                throw new PepperModuleException((PepperMapper)this, "A MappingSubject does not contain a document object. This seems to be a bug. ");
            }
            if (this.getBaseCorpusStructure() == null) {
                int currNumOfElements = 0;
                currNumOfElements = document.getDocumentGraph() != null ? document.getDocumentGraph().getNodes().size() + document.getDocumentGraph().getRelations().size() : subj.getDocumentController().getSize_nodes() + subj.getDocumentController().getSize_relations();
                if (maxNumOfElements >= currNumOfElements) continue;
                maxNumOfElements = currNumOfElements;
                baseSubject = subj;
                continue;
            }
            if (!document.getGraph().equals(this.getBaseCorpusStructure())) continue;
            baseSubject = subj;
            break;
        }
        return baseSubject;
    }

    protected void normalizePrimaryTexts(SDocument sDocument) {
        if (sDocument == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot normalize Text of the document since the SDocument reference is NULL");
        }
        if (sDocument.getDocumentGraph() != null) {
            List sTextualDSs = sDocument.getDocumentGraph().getTextualDSs();
            for (STextualDS sTextualDS : sTextualDSs) {
                ArrayList<Integer> originalToNormalizedMapping = new ArrayList<Integer>();
                String normalizedText = this.createOriginalToNormalizedMapping(sTextualDS, originalToNormalizedMapping);
                for (STextualRelation textRel : sDocument.getDocumentGraph().getTextualRelations()) {
                    if (!((STextualDS)textRel.getTarget()).equals(sTextualDS)) continue;
                    SToken sToken = (SToken)textRel.getSource();
                    if ((Integer)textRel.getStart() >= originalToNormalizedMapping.size()) {
                        throw new PepperModuleInternalException((PepperMapper)this, "Cannot find token " + SaltUtil.getGlobalId((Identifier)((SToken)textRel.getSource()).getIdentifier()) + " in  'originalToNormalizedMapping' list. ");
                    }
                    int normalizedTokenStart = (Integer)originalToNormalizedMapping.get((Integer)textRel.getStart());
                    int normalizedTokenEnd = 0;
                    if ((Integer)textRel.getEnd() >= originalToNormalizedMapping.size()) {
                        if ((Integer)textRel.getEnd() >= originalToNormalizedMapping.size() + 1) {
                            throw new PepperModuleInternalException((PepperMapper)this, "textRel.getEnd() >= (originalToNormalizedMapping.size()+1). ");
                        }
                        normalizedTokenEnd = (Integer)originalToNormalizedMapping.get(originalToNormalizedMapping.size() - 1) + 1;
                    } else {
                        normalizedTokenEnd = (Integer)originalToNormalizedMapping.get((Integer)textRel.getEnd());
                    }
                    this.getContainer().addAlignedToken(sTextualDS, sToken, normalizedTokenStart, normalizedTokenEnd);
                }
                this.getContainer().addNormalizedText(sDocument, sTextualDS, normalizedText);
            }
        } else {
            throw new PepperModuleInternalException((PepperMapper)this, "Could not compute the normalized text for document '" + SaltUtil.getGlobalId((Identifier)sDocument.getIdentifier()) + "', because the document contains no document graph. May be it has not been woken up. ");
        }
    }

    private String createOriginalToNormalizedMapping(STextualDS sTextualDS, List<Integer> originalToNormalizedMapping) {
        char[] chr;
        StringBuilder normalizedTextBuilder = new StringBuilder();
        int start = 0;
        for (char c : chr = sTextualDS.getText().toCharArray()) {
            String stringToEscape = ((MergerProperties)this.getProperties()).getEscapeMapping().get(String.valueOf(c));
            if (stringToEscape == null) {
                originalToNormalizedMapping.add(start);
                normalizedTextBuilder.append(c);
                ++start;
                continue;
            }
            if (stringToEscape.length() > 0) {
                originalToNormalizedMapping.add(start);
                for (int i = 0; i < stringToEscape.length(); ++i) {
                    ++start;
                }
                normalizedTextBuilder.append(stringToEscape);
                continue;
            }
            originalToNormalizedMapping.add(start);
        }
        originalToNormalizedMapping.add(start++);
        String normalizedText = normalizedTextBuilder.toString();
        return normalizedText;
    }

    protected List<Integer> createBaseTextNormOriginalMapping(STextualDS sTextualDS) {
        char[] chr;
        ArrayList<Integer> normalizedToOriginalMapping = new ArrayList<Integer>();
        int start = 0;
        for (char c : chr = sTextualDS.getText().toCharArray()) {
            String stringToEscape = ((MergerProperties)this.getProperties()).getEscapeMapping().get(String.valueOf(c));
            if (stringToEscape == null) {
                normalizedToOriginalMapping.add(start);
            } else if (stringToEscape.length() > 0) {
                char[] chr2 = stringToEscape.toCharArray();
                for (int i = 0; i < chr2.length; ++i) {
                    normalizedToOriginalMapping.add(start);
                }
            }
            ++start;
        }
        normalizedToOriginalMapping.add(start++);
        return normalizedToOriginalMapping;
    }

    private boolean alignAllTexts(SDocument baseDoc, SDocument otherDoc) {
        if (otherDoc.getDocumentGraph() == null) {
            throw new PepperModuleDataException((PepperMapper)this, "Cannot map document '" + SaltUtil.getGlobalId((Identifier)otherDoc.getIdentifier()) + "', since it does not contain a document-structure.");
        }
        boolean retVal = false;
        if (otherDoc.getDocumentGraph().getTextualDSs() != null && otherDoc.getDocumentGraph().getTextualDSs().size() > 0) {
            HashSet<SToken> nonEquivalentTokenInOtherTexts = new HashSet<SToken>();
            for (STextualDS baseText : this.getBaseDocument().getDocumentGraph().getTextualDSs()) {
                nonEquivalentTokenInOtherTexts = new HashSet();
                if (otherDoc.getDocumentGraph().getTokens() != null) {
                    nonEquivalentTokenInOtherTexts.addAll(otherDoc.getDocumentGraph().getTokens());
                }
                for (STextualDS otherText : otherDoc.getDocumentGraph().getTextualDSs()) {
                    boolean tryMerge = true;
                    if (((MergerProperties)this.getProperties()).isOnlyMergeTextWithSameName().booleanValue()) {
                        tryMerge = Objects.equal((Object)otherText.getName(), (Object)baseText.getName());
                    }
                    if (!tryMerge) continue;
                    boolean isAlignable = this.alignTexts(baseText, otherText, nonEquivalentTokenInOtherTexts, this.node2NodeMap);
                    if (isAlignable) {
                        retVal = true;
                        ImmutablePair base = new ImmutablePair((Object)baseText.getId(), (Object)("<base>" + baseText.getText()));
                        ImmutablePair other = new ImmutablePair((Object)otherText.getId(), (Object)otherText.getText());
                        this.matchingTexts.add((Pair<Pair<String, String>, Pair<String, String>>)new ImmutablePair((Object)base, (Object)other));
                        this.matchingTextsIdx.add(SaltUtil.getGlobalId((Identifier)otherText.getIdentifier()));
                        this.matchingTextsIdx.add(SaltUtil.getGlobalId((Identifier)baseText.getIdentifier()));
                        this.noMatchingTexts.remove(other);
                        this.noMatchingTexts.remove(base);
                        this.node2NodeMap.put((SNode)otherText, (SNode)baseText);
                        this.mergeTokens(baseText, otherText, this.node2NodeMap);
                    }
                    if (this.matchingTextsIdx.contains(SaltUtil.getGlobalId((Identifier)otherText.getIdentifier()))) continue;
                    this.noMatchingTexts.add((Pair<String, String>)new ImmutablePair((Object)otherText.getId(), (Object)otherText.getText()));
                }
                if (this.matchingTextsIdx.contains(SaltUtil.getGlobalId((Identifier)baseText.getIdentifier()))) continue;
                this.noMatchingTexts.add((Pair<String, String>)new ImmutablePair((Object)baseText.getId(), (Object)("<base>" + baseText.getText())));
            }
        }
        return retVal;
    }

    protected boolean alignTexts(STextualDS baseText, STextualDS otherText, Set<SToken> nonEquivalentTokenInOtherTexts, Map<SNode, SNode> equivalenceMap) {
        if (baseText == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot align the Text of the documents since the base SDocument reference is NULL");
        }
        if (otherText == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot align the Text of the documents since the other SDocument reference is NULL");
        }
        boolean returnVal = false;
        String normalizedBaseText = this.getContainer().getNormalizedText(baseText);
        if (normalizedBaseText == null) {
            throw new PepperModuleInternalException((PepperMapper)this, "Could not align text '" + SaltUtil.getGlobalId((Identifier)baseText.getIdentifier()) + "', because a normalized text for base text was not computed. ");
        }
        String normalizedOtherText = this.getContainer().getNormalizedText(otherText);
        if (normalizedOtherText == null) {
            throw new PepperModuleInternalException((PepperMapper)this, "Could not align texts, because a normalized text for other text '" + SaltUtil.getGlobalId((Identifier)otherText.getIdentifier()) + "' was not computed. ");
        }
        if (this.getContainer().getBaseTextPositionByNormalizedTextPosition(baseText, 0) == -1) {
            this.getContainer().setBaseTextPositionByNormalizedTextPosition(baseText, this.createBaseTextNormOriginalMapping(baseText));
        }
        int offset = -1;
        STextualDS biggerText = baseText;
        STextualDS smallerText = otherText;
        if (normalizedBaseText.length() >= normalizedOtherText.length()) {
            offset = this.indexOfOmitChars(normalizedBaseText.toLowerCase(), normalizedOtherText.toLowerCase(), true, ((MergerProperties)this.getProperties()).getPunctuations());
        } else {
            offset = this.indexOfOmitChars(normalizedOtherText.toLowerCase(), normalizedBaseText.toLowerCase(), true, ((MergerProperties)this.getProperties()).getPunctuations());
            biggerText = otherText;
            smallerText = baseText;
        }
        if (offset != -1) {
            returnVal = true;
            ArrayList<Node> textTokens = new ArrayList<Node>();
            for (Relation relation : smallerText.getGraph().getInRelations(smallerText.getId())) {
                if (!(relation instanceof STextualRelation)) continue;
                textTokens.add(((STextualRelation)relation).getSource());
            }
            for (SToken sToken : textTokens) {
                int smallerTextTokenStart = this.getContainer().getAlignedTokenStart(smallerText, sToken);
                int smallerTextTokenLength = this.getContainer().getAlignedTokenLength(smallerText, sToken);
                if (smallerTextTokenStart != -1 && smallerTextTokenLength != -1) {
                    SToken biggerTextToken = this.getContainer().getAlignedTokenByStart(biggerText, smallerTextTokenStart + offset);
                    if (biggerTextToken == null || this.getContainer().getAlignedTokenLength(biggerText, biggerTextToken) != smallerTextTokenLength) continue;
                    if (biggerText.equals(baseText)) {
                        this.getContainer().addTokenMapping(biggerTextToken, sToken, smallerText);
                        equivalenceMap.put((SNode)sToken, (SNode)biggerTextToken);
                        nonEquivalentTokenInOtherTexts.remove(sToken);
                        continue;
                    }
                    this.getContainer().addTokenMapping(sToken, biggerTextToken, biggerText);
                    equivalenceMap.put((SNode)biggerTextToken, (SNode)sToken);
                    nonEquivalentTokenInOtherTexts.remove(biggerTextToken);
                    continue;
                }
                throw new PepperModuleException((PepperMapper)this, "The SToken " + smallerText.getId() + " of the STextualDS " + smallerText.getId() + " has no proper start or length. It was probably not aligned correctly.");
            }
        }
        return returnVal;
    }

    protected int indexOfOmitChars(String stringToSearchIn, String stringToSearchFor, boolean useIndexOf, Set<Character> omitChars) {
        int successfulMatchCount;
        char[] chr;
        StringBuilder builder = new StringBuilder();
        for (char sourceChar : chr = stringToSearchFor.toCharArray()) {
            if (omitChars.contains(Character.valueOf(sourceChar))) continue;
            builder.append(sourceChar);
        }
        String sourceString = builder.toString();
        if (useIndexOf) {
            char[] chr2;
            builder = new StringBuilder();
            ArrayList<Integer> normalizedToOriginalMapping = new ArrayList<Integer>();
            int start = 0;
            for (char targetChar : chr2 = stringToSearchIn.toCharArray()) {
                if (!omitChars.contains(Character.valueOf(targetChar))) {
                    normalizedToOriginalMapping.add(start);
                    builder.append(targetChar);
                }
                ++start;
            }
            String targetString = builder.toString();
            int index = targetString.indexOf(sourceString);
            if (index != -1) {
                return (Integer)normalizedToOriginalMapping.get(index);
            }
            return index;
        }
        char c = sourceString.toCharArray()[0];
        int position = 0;
        int retVal = -1;
        boolean found = false;
        char[] charsToSearchIn = stringToSearchIn.toCharArray();
        block2: do {
            char[] chr2;
            retVal = position = stringToSearchIn.indexOf(c, position);
            if (position == -1) break;
            found = true;
            successfulMatchCount = 0;
            for (char sourceChar : chr2 = sourceString.toCharArray()) {
                boolean foundChar = false;
                for (int i = position; i < stringToSearchIn.length(); ++i) {
                    char targetChar = charsToSearchIn[i];
                    if (omitChars.contains(Character.valueOf(targetChar))) {
                        ++position;
                        continue;
                    }
                    if (targetChar == sourceChar) {
                        ++successfulMatchCount;
                        foundChar = true;
                        ++position;
                        break;
                    }
                    foundChar = false;
                    break;
                }
                if (foundChar) continue;
                retVal = -1;
                continue block2;
            }
        } while (!found || successfulMatchCount != sourceString.length());
        return retVal;
    }

    protected void mergeTokens(STextualDS baseText, STextualDS otherText, Map<SNode, SNode> equivalenceMap) {
        String normalizedBaseText = this.getContainer().getNormalizedText(baseText);
        String normalizedOtherText = this.getContainer().getNormalizedText(otherText);
        if (this.getContainer().getBaseTextPositionByNormalizedTextPosition(baseText, 0) == -1) {
            this.getContainer().setBaseTextPositionByNormalizedTextPosition(baseText, this.createBaseTextNormOriginalMapping(baseText));
        }
        int offset = -1;
        STextualDS biggerText = baseText;
        if (normalizedBaseText.length() >= normalizedOtherText.length()) {
            offset = this.indexOfOmitChars(normalizedBaseText.toLowerCase(), normalizedOtherText.toLowerCase(), true, ((MergerProperties)this.getProperties()).getPunctuations());
        } else {
            offset = this.indexOfOmitChars(normalizedOtherText.toLowerCase(), normalizedBaseText.toLowerCase(), true, ((MergerProperties)this.getProperties()).getPunctuations());
            biggerText = otherText;
        }
        if (offset != -1) {
            ArrayList<Node> textTokens = new ArrayList<Node>();
            for (Relation relation : otherText.getGraph().getInRelations(otherText.getId())) {
                if (!(relation instanceof STextualRelation)) continue;
                textTokens.add(((STextualRelation)relation).getSource());
            }
            for (SToken sToken : textTokens) {
                SToken baseTextToken = (SToken)equivalenceMap.get(sToken);
                if (baseTextToken == null) {
                    int otherTextTokenStart = this.getContainer().getAlignedTokenStart(otherText, sToken);
                    int otherTextTokenLength = this.getContainer().getAlignedTokenLength(otherText, sToken);
                    if (otherTextTokenStart != -1 && otherTextTokenLength != -1) {
                        int newStart = 0;
                        int newEnd = 0;
                        if (biggerText.equals(baseText)) {
                            newStart = offset + otherTextTokenStart;
                            newEnd = newStart + otherTextTokenLength;
                            newStart = this.getContainer().getBaseTextPositionByNormalizedTextPosition(baseText, newStart);
                            newEnd = this.getContainer().getBaseTextPositionByNormalizedTextPosition(baseText, newEnd);
                            if (newStart < 0) {
                                throw new PepperModuleException((PepperMapper)this, "Cannot create a token, since the SStart value is '-1' for merging '" + SaltUtil.getGlobalId((Identifier)sToken.getIdentifier()) + "' into '" + SaltUtil.getGlobalId((Identifier)baseText.getGraph().getIdentifier()) + "'.");
                            }
                            if (newEnd < 0) {
                                throw new PepperModuleException((PepperMapper)this, "Cannot create a token, since the SEnd value is '-1' for merging '" + SaltUtil.getGlobalId((Identifier)sToken.getIdentifier()) + "' ('" + sToken.getGraph().getText((SNode)sToken) + "') into '" + SaltUtil.getGlobalId((Identifier)baseText.getGraph().getIdentifier()) + "'.");
                            }
                            baseTextToken = baseText.getGraph().createToken((SSequentialDS)baseText, Integer.valueOf(newStart), Integer.valueOf(newEnd));
                        } else {
                            newStart = otherTextTokenStart - offset;
                            newEnd = newStart + otherTextTokenLength;
                            if (newStart >= 0 && newEnd <= normalizedBaseText.length()) {
                                newStart = this.getContainer().getBaseTextPositionByNormalizedTextPosition(baseText, newStart);
                                newEnd = this.getContainer().getBaseTextPositionByNormalizedTextPosition(baseText, newEnd);
                                if (newStart < 0) {
                                    throw new PepperModuleException((PepperMapper)this, "Cannot create a token, since the SStart value is '-1' for merging '" + SaltUtil.getGlobalId((Identifier)sToken.getIdentifier()) + "' into '" + SaltUtil.getGlobalId((Identifier)baseText.getGraph().getIdentifier()) + "'.");
                                }
                                if (newEnd < 0) {
                                    throw new PepperModuleException((PepperMapper)this, "Cannot create a token, since the SEnd value is '-1' for merging '" + SaltUtil.getGlobalId((Identifier)sToken.getIdentifier()) + "' ('" + sToken.getGraph().getText((SNode)sToken) + "') into '" + SaltUtil.getGlobalId((Identifier)baseText.getGraph().getIdentifier()) + "'.");
                                }
                                baseTextToken = baseText.getGraph().createToken((SSequentialDS)baseText, Integer.valueOf(newStart), Integer.valueOf(newEnd));
                                equivalenceMap.put((SNode)sToken, (SNode)baseTextToken);
                            }
                        }
                    }
                }
                if (baseTextToken == null) continue;
                SaltUtil.moveAnnotations((SAnnotationContainer)sToken, (SAnnotationContainer)baseTextToken);
                SaltUtil.moveMetaAnnotations((SAnnotationContainer)sToken, (SAnnotationContainer)baseTextToken);
            }
        }
        SaltUtil.moveAnnotations((SAnnotationContainer)otherText, (SAnnotationContainer)baseText);
        SaltUtil.moveMetaAnnotations((SAnnotationContainer)otherText, (SAnnotationContainer)baseText);
    }
}

