/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.mergingModules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.modules.DocumentController;
import org.corpus_tools.pepper.modules.MappingSubject;
import org.corpus_tools.pepper.modules.PepperManipulator;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperMapperController;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.mergingModules.MergerMapper;
import org.corpus_tools.peppermodules.mergingModules.MergerProperties;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="MergerComponent", factory="PepperManipulatorComponentFactory")
public class Merger
extends PepperManipulatorImpl
implements PepperManipulator {
    public static final String MODULE_NAME = "Merger";
    private static final Logger logger = LoggerFactory.getLogger((String)"Merger");
    private Map<SCorpusGraph, List<Identifier>> importOrder = null;
    protected Multimap mappingTable = null;
    private SCorpusGraph baseCorpusStructure = null;
    private Map<String, List<Identifier>> givenSlots = null;
    private volatile Lock mergerMappersLock = new ReentrantLock();
    private volatile Condition mergerMappersCondition = this.mergerMappersLock.newCondition();
    private volatile int numberOfMergerMappers = 0;
    private Set<String> documentsToMerge = new HashSet<String>();

    public Merger() {
        this.setName(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-MergingModule"));
        this.setDesc("The Merger allows to merge an unbound number of corpora to a single corpus. ");
        this.setProperties(new MergerProperties());
    }

    public boolean isReadyToStart() {
        if (this.getModuleController().getJob().getMaxNumberOfDocuments() < 2) {
            throw new PepperModuleException((PepperModule)this, "The merger cannot work with less than 2 documents in main memory in parallel. Please check the property 'pepper.maxAmountOfProcessedSDocuments' in the Pepper configuration. ");
        }
        return true;
    }

    public SCorpusGraph getBaseCorpusStructure() {
        return this.baseCorpusStructure;
    }

    public void setBaseCorpusStructure(SCorpusGraph baseCorpusStructure) {
        this.baseCorpusStructure = baseCorpusStructure;
    }

    protected synchronized void createMapping() {
        if (this.mappingTable == null) {
            this.setBaseCorpusStructure((SCorpusGraph)this.getSaltProject().getCorpusGraphs().get(0));
            this.importOrder = new HashMap<SCorpusGraph, List<Identifier>>();
            for (SCorpusGraph graph : this.getSaltProject().getCorpusGraphs()) {
                this.importOrder.put(graph, new ArrayList());
            }
            this.mappingTable = new Multimap();
            for (SCorpusGraph graph : this.getSaltProject().getCorpusGraphs()) {
                if (graph.getCorpora().isEmpty()) continue;
                for (SCorpus sCorpus : graph.getCorpora()) {
                    this.mappingTable.put(sCorpus.getId(), (SNode)sCorpus);
                }
                for (SDocument sDocument : graph.getDocuments()) {
                    this.mappingTable.put(sDocument.getId(), (SNode)sDocument);
                }
            }
            ArrayList listOfLists = new ArrayList(this.getSaltProject().getCorpusGraphs().size());
            for (int i = 0; i < this.getSaltProject().getCorpusGraphs().size(); ++i) {
                listOfLists.add(new ArrayList());
            }
            for (String key : this.mappingTable.keySet()) {
                List<SNode> nodes = this.mappingTable.get(key);
                ((List)listOfLists.get(nodes.size() - 1)).add(nodes);
            }
            for (int i = this.getSaltProject().getCorpusGraphs().size(); i > 0; --i) {
                List list = (List)listOfLists.get(i - 1);
                for (List nodes : list) {
                    for (SNode node : nodes) {
                        if (!(node instanceof SDocument)) continue;
                        this.importOrder.get(((SDocument)node).getGraph()).add(node.getIdentifier());
                    }
                }
            }
        }
    }

    public List<Identifier> proposeImportOrder(SCorpusGraph sCorpusGraph) {
        List<Identifier> retVal = null;
        if (sCorpusGraph != null && this.getSaltProject().getCorpusGraphs().size() > 1) {
            this.createMapping();
            if (this.importOrder != null) {
                retVal = this.importOrder.get(sCorpusGraph);
            }
        }
        return retVal;
    }

    private void enhanceBaseCorpusStructure() {
        Set<String> keys = this.mappingTable.keySet();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                List<SNode> slot = this.mappingTable.get(key);
                boolean noBase = true;
                boolean isDoc = true;
                for (SNode node : slot) {
                    if (node == null) continue;
                    if (node instanceof SCorpus) {
                        isDoc = false;
                        if (!((SCorpus)node).getGraph().equals(this.getBaseCorpusStructure())) continue;
                        noBase = false;
                        break;
                    }
                    if (!(node instanceof SDocument)) continue;
                    isDoc = true;
                    if (!((SDocument)node).getGraph().equals(this.getBaseCorpusStructure())) continue;
                    noBase = false;
                    break;
                }
                if (!noBase) continue;
                if (isDoc) {
                    this.getBaseCorpusStructure().createCorpus(URI.createURI((String)key).trimSegments(1));
                    SDocument doc = this.getBaseCorpusStructure().createDocument(URI.createURI((String)key));
                    doc.setDocumentGraph(SaltFactory.createSDocumentGraph());
                    continue;
                }
                this.getBaseCorpusStructure().createCorpus(URI.createURI((String)key));
            }
        }
    }

    private void waitForMergerMapper() {
        this.mergerMappersLock.lock();
        try {
            if (this.getModuleController() != null && this.getModuleController().getJob() != null) {
                while (this.numberOfMergerMappers >= Double.valueOf(Math.floor(this.getModuleController().getJob().getMaxNumberOfDocuments() / 2)).intValue()) {
                    this.mergerMappersCondition.await();
                }
            }
            ++this.numberOfMergerMappers;
        }
        catch (InterruptedException e) {
            throw new PepperModuleException((PepperModule)this, "A problem occured in deadlock permission for merger mapper processes. ", (Throwable)e);
        }
        finally {
            this.mergerMappersLock.unlock();
        }
    }

    public void releaseMergerMapper() {
        this.mergerMappersLock.lock();
        try {
            --this.numberOfMergerMappers;
            this.mergerMappersCondition.signal();
        }
        finally {
            this.mergerMappersLock.unlock();
        }
    }

    public void start() throws PepperModuleException {
        if (this.getSaltProject() == null) {
            throw new PepperFWException("No salt project was set in module '" + this.getName() + ", " + this.getVersion() + "'.");
        }
        if (this.mappingTable == null) {
            logger.warn("[Merger] Cannot merge corpora or documents, since only one corpus structure is given. ");
            boolean isStart = true;
            Identifier sElementId = null;
            DocumentController documentController = null;
            while (isStart || sElementId != null) {
                isStart = false;
                documentController = this.getModuleController().next();
                if (documentController == null) break;
                sElementId = documentController.getDocumentId();
                this.getModuleController().complete(documentController);
            }
            this.end();
            return;
        }
        this.enhanceBaseCorpusStructure();
        if (logger.isDebugEnabled() && this.mappingTable != null) {
            StringBuilder mergerMapping = new StringBuilder();
            mergerMapping.append("Computed mapping for merging:\n");
            for (String key : this.mappingTable.keySet()) {
                List<SNode> partners = this.mappingTable.get(key);
                mergerMapping.append("\t");
                boolean isFirst = true;
                mergerMapping.append("(");
                for (SNode partner : partners) {
                    if (!isFirst) {
                        mergerMapping.append(", ");
                    } else {
                        isFirst = false;
                    }
                    mergerMapping.append(SaltUtil.getGlobalId((Identifier)partner.getIdentifier()));
                }
                mergerMapping.append(")");
                mergerMapping.append("\n");
            }
            logger.debug("[Merger] " + mergerMapping.toString());
        }
        this.setMapperThreadGroup(new ThreadGroup(Thread.currentThread().getThreadGroup(), this.getName() + "_mapperGroup"));
        this.givenSlots = new Hashtable<String, List<Identifier>>();
        boolean isStart = true;
        Identifier sElementId = null;
        DocumentController documentController = null;
        while (isStart || sElementId != null) {
            isStart = false;
            documentController = this.getModuleController().next();
            if (documentController == null) break;
            sElementId = documentController.getDocumentId();
            this.getDocumentId2DC().put(SaltUtil.getGlobalId((Identifier)sElementId), documentController);
            List<SNode> mappableSlot = this.mappingTable.get(sElementId.getId());
            List<Identifier> givenSlot = this.givenSlots.get(sElementId.getId());
            if (givenSlot == null) {
                givenSlot = new ArrayList<Identifier>();
                this.givenSlots.put(sElementId.getId(), givenSlot);
            }
            givenSlot.add(sElementId);
            logger.trace("[Merger] New document has arrived {}. ", (Object)SaltUtil.getGlobalId((Identifier)sElementId));
            this.documentsToMerge.add(SaltUtil.getGlobalId((Identifier)sElementId));
            if (logger.isTraceEnabled()) {
                logger.trace("[Merger] Waiting for further documents, {} documents are in queue. ", (Object)this.documentsToMerge.size());
            }
            documentController.sendToSleep_FORCE();
            if (documentController.isAsleep()) {
                this.getModuleController().getJob().releaseDocument(documentController);
                logger.trace("[Merger] Sent document '{}' to sleep. ", (Object)documentController.getGlobalId());
            } else {
                logger.warn("Was not able to send document '{}' to sleep. ", (Object)documentController.getGlobalId());
            }
            if (givenSlot.size() != mappableSlot.size()) continue;
            try {
                for (Identifier sDocumentId : givenSlot) {
                    DocumentController docController = (DocumentController)this.getDocumentId2DC().get(SaltUtil.getGlobalId((Identifier)sDocumentId));
                    if (docController == null) {
                        throw new PepperModuleException((PepperModule)this, "Cannot find a document controller for document '" + SaltUtil.getGlobalId((Identifier)sDocumentId) + "' in list: " + this.getDocumentId2DC() + ". ");
                    }
                    this.documentsToMerge.remove(docController.getGlobalId());
                }
                this.waitForMergerMapper();
                this.start(sElementId);
            }
            catch (Exception e) {
                throw new PepperModuleException("Any exception occured while merging documents corresponding to '" + sElementId + "'. ", (Throwable)e);
            }
        }
        Collection<PepperMapperController> controllers = null;
        HashSet<PepperMapperController> alreadyWaitedFor = new HashSet<PepperMapperController>();
        controllers = Collections.synchronizedCollection(this.getMapperControllers().values());
        for (PepperMapperController controller : controllers) {
            try {
                controller.join();
                alreadyWaitedFor.add(controller);
            }
            catch (InterruptedException e) {
                throw new PepperFWException("Cannot wait for mapper thread '" + controller + "' in " + this.getName() + " to end. ", (Throwable)e);
            }
        }
        Collection<SCorpus> corpora = Collections.synchronizedCollection(this.getBaseCorpusStructure().getCorpora());
        for (SCorpus sCorpus : corpora) {
            this.start(sCorpus.getIdentifier());
        }
        for (PepperMapperController controller : controllers) {
            try {
                controller.join();
                alreadyWaitedFor.add(controller);
            }
            catch (InterruptedException e) {
                throw new PepperFWException("Cannot wait for mapper thread '" + controller + "' in " + this.getName() + " to end. ", (Throwable)e);
            }
        }
        this.end();
    }

    public void end() throws PepperModuleException {
        ArrayList<SCorpusGraph> removeCorpusStructures = new ArrayList<SCorpusGraph>();
        for (SCorpusGraph graph : this.getSaltProject().getCorpusGraphs()) {
            if (graph == this.getBaseCorpusStructure()) continue;
            removeCorpusStructures.add(graph);
        }
        if (removeCorpusStructures.size() > 0) {
            for (SCorpusGraph graph : removeCorpusStructures) {
                this.getSaltProject().removeCorpusGraph(graph);
            }
        }
        if (this.getSaltProject().getCorpusGraphs().size() != 1) {
            logger.warn("Could not remove all corpus-structures from salt project which are not the base corpus-structure. Left structures are: '" + removeCorpusStructures + "'. ");
        }
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        MergerMapper mapper = new MergerMapper();
        if (sElementId.getIdentifiableElement() instanceof SDocument) {
            mapper.setMerger(this);
            if (this.givenSlots == null || this.givenSlots.size() == 0) {
                throw new PepperModuleException((PepperModule)this, "This should not have been happend and seems to be a bug of module. The problem is, that 'givenSlots' is null or empty in method 'createPepperMapper()'");
            }
            List<Identifier> givenSlot = this.givenSlots.get(sElementId.getId());
            if (givenSlot == null) {
                throw new PepperModuleException((PepperModule)this, "This should not have been happend and seems to be a bug of module. The problem is, that a 'givenSlot' in 'givenSlots' is null or empty in method 'createPepperMapper()'. The sElementId '" + sElementId + "' was not contained in list: " + this.givenSlots);
            }
            boolean noBase = true;
            for (Identifier id : givenSlot) {
                MappingSubject mappingSubject = new MappingSubject();
                mappingSubject.setIdentifier(id);
                mappingSubject.setMappingResult(DOCUMENT_STATUS.IN_PROGRESS);
                if (sElementId.getIdentifiableElement() instanceof SDocument) {
                    DocumentController documentController = (DocumentController)this.getDocumentId2DC().get(SaltUtil.getGlobalId((Identifier)id));
                    mappingSubject.setDocumentController(documentController);
                }
                mapper.getMappingSubjects().add(mappingSubject);
                if (this.getBaseCorpusStructure() != ((SDocument)id.getIdentifiableElement()).getGraph()) continue;
                noBase = false;
            }
            if (noBase) {
                MappingSubject mappingSubject = new MappingSubject();
                SNode baseSNode = (SNode)this.getBaseCorpusStructure().getNode(sElementId.getId());
                if (baseSNode == null) {
                    throw new PepperModuleException((PepperModule)this, "Cannot create a mapper for '" + SaltUtil.getGlobalId((Identifier)sElementId) + "', since no base SNode was found. ");
                }
                mappingSubject.setIdentifier(baseSNode.getIdentifier());
                mappingSubject.setMappingResult(DOCUMENT_STATUS.IN_PROGRESS);
                mapper.getMappingSubjects().add(mappingSubject);
            }
        } else if (sElementId.getIdentifiableElement() instanceof SCorpus) {
            List<SNode> givenSlot = this.mappingTable.get(sElementId.getId());
            if (givenSlot == null) {
                throw new PepperModuleException((PepperModule)this, "This should not have been happend and seems to be a bug of module. The problem is, that a 'givenSlot' in 'givenSlots' is null or empty in method 'createPepperMapper()'. The sElementId '" + sElementId + "' was not contained in list: " + this.givenSlots);
            }
            boolean noBase = true;
            for (SNode sCorpus : givenSlot) {
                MappingSubject mappingSubject = new MappingSubject();
                mappingSubject.setIdentifier(sCorpus.getIdentifier());
                mappingSubject.setMappingResult(DOCUMENT_STATUS.IN_PROGRESS);
                mapper.getMappingSubjects().add(mappingSubject);
                if (!this.getBaseCorpusStructure().equals(((SCorpus)sCorpus).getGraph())) continue;
                noBase = false;
            }
            if (noBase) {
                MappingSubject mappingSubject = new MappingSubject();
                mappingSubject.setIdentifier(((SNode)this.getBaseCorpusStructure().getNode(sElementId.getId())).getIdentifier());
                mappingSubject.setMappingResult(DOCUMENT_STATUS.IN_PROGRESS);
                mapper.getMappingSubjects().add(mappingSubject);
            }
        }
        mapper.setBaseCorpusStructure(this.getBaseCorpusStructure());
        return mapper;
    }

    class Multimap {
        private Map<String, List<SNode>> map = new LinkedHashMap<String, List<SNode>>();

        public void put(String sId, SNode sNode) {
            List<SNode> slot = this.map.get(sId);
            if (slot == null) {
                slot = new ArrayList<SNode>();
                this.map.put(sId, slot);
            }
            slot.add(sNode);
        }

        public List<SNode> get(String sId) {
            return this.map.get(sId);
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder();
            for (String key : this.map.keySet()) {
                retVal.append(key);
                retVal.append("=");
                List<SNode> sNodes = this.map.get(key);
                if (sNodes != null) {
                    int i = 0;
                    for (SNode sNode : sNodes) {
                        if (i != 0) {
                            retVal.append(", ");
                        }
                        retVal.append(SaltUtil.getGlobalId((Identifier)sNode.getIdentifier()));
                        ++i;
                    }
                }
                retVal.append("; ");
            }
            return retVal.toString();
        }

        public Set<String> keySet() {
            return this.map.keySet();
        }
    }
}

