/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.mergingModules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.mergingModules.MergerProperties;
import org.corpus_tools.peppermodules.mergingModules.TokenMergeContainer;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.SaltUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeHandler
implements GraphTraverseHandler {
    public static final Logger logger = LoggerFactory.getLogger((String)"Merger");
    private SDocumentGraph otherGraph = null;
    private SDocumentGraph baseGraph = null;
    private MergerProperties properties = null;
    private Map<SNode, SNode> node2NodeMap = null;
    private TokenMergeContainer container = null;
    private Set<SRelation> visitedRelations = new HashSet<SRelation>();

    public SDocumentGraph getOtherGraph() {
        return this.otherGraph;
    }

    public void setOtherGraph(SDocumentGraph otherGraph) {
        this.otherGraph = otherGraph;
    }

    public SDocumentGraph getBaseGraph() {
        return this.baseGraph;
    }

    public void setBaseGraph(SDocumentGraph baseGraph) {
        this.baseGraph = baseGraph;
    }

    public MergerProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MergerProperties properties) {
        this.properties = properties;
    }

    public MergeHandler(Map<SNode, SNode> node2NodeMap, SDocumentGraph otherGraph, SDocumentGraph baseGraph, TokenMergeContainer container) {
        this.node2NodeMap = node2NodeMap;
        this.setOtherGraph(otherGraph);
        this.setBaseGraph(baseGraph);
        this.container = container;
    }

    public void mergeSPointingRelations(SDocumentGraph otherGraph, SDocumentGraph baseGraph) {
        for (SPointingRelation otherRel : otherGraph.getPointingRelations()) {
            SNode baseSourceNode = this.node2NodeMap.get(otherRel.getSource());
            SNode baseTargetNode = this.node2NodeMap.get(otherRel.getTarget());
            if (baseSourceNode == null) {
                logger.warn("[Merger] Cannot merge SPointingRelation '" + otherRel.getId() + "', because no matching node was found in target graph for source node '" + otherRel.getSource() + "'. ");
                continue;
            }
            if (baseTargetNode == null) {
                logger.warn("[Merger] Cannot merge SPointingRelation '" + otherRel.getId() + "', because no matching node was found in source graph for source node '" + otherRel.getTarget() + "'. ");
                continue;
            }
            List rels = baseGraph.getRelations(baseSourceNode.getId(), baseTargetNode.getId());
            boolean skip = false;
            if (rels != null && rels.size() > 0) {
                for (Relation rel : rels) {
                    if (!(rel instanceof SPointingRelation) || !((SPointingRelation)rel).getType().equals(otherRel.getType())) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            SPointingRelation baseRel = SaltFactory.createSPointingRelation();
            baseRel.setSource((Node)((SStructuredNode)baseSourceNode));
            baseRel.setTarget((Node)((SStructuredNode)baseTargetNode));
            baseRel.setType(otherRel.getType());
            SaltUtil.moveAnnotations((SAnnotationContainer)otherRel, (SAnnotationContainer)baseRel);
            SaltUtil.moveMetaAnnotations((SAnnotationContainer)otherRel, (SAnnotationContainer)baseRel);
            baseGraph.addRelation((Relation)baseRel);
            MergeHandler.copySLayers((IdentifiableElement)otherRel, (IdentifiableElement)baseRel);
        }
    }

    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation sRelation, SNode currNode, long order) {
        boolean retVal = true;
        if (sRelation != null) {
            if (sRelation instanceof SPointingRelation) {
                retVal = false;
            } else if (this.visitedRelations.contains(sRelation)) {
                retVal = false;
            } else {
                this.visitedRelations.add(sRelation);
            }
        }
        return retVal;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode otherNode, long order) {
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode otherNode, long order) {
        if (currNode instanceof SToken) {
            this.mergeNode(currNode, null, SALT_TYPE.STOKEN);
        } else if (currNode instanceof SSpan) {
            this.mergeNode(currNode, SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SSPAN);
        } else if (currNode instanceof SStructure) {
            this.mergeNode(currNode, SALT_TYPE.SDOMINANCE_RELATION, SALT_TYPE.SSTRUCTURE);
        } else if (!(currNode instanceof STextualDS)) {
            throw new PepperModuleException("Merging not implemented for this node type: " + currNode);
        }
    }

    private void mergeNode(SNode currNode, SALT_TYPE sTypeRelations, SALT_TYPE sTypeNode) {
        SNode baseNode = null;
        List<SNode> childrens = this.getChildren(currNode, sTypeRelations);
        if (currNode instanceof SToken || !this.getProperties().isCopyNodes().booleanValue()) {
            List<Object> sharedParents = new ArrayList();
            if (childrens.size() > 0) {
                sharedParents = this.getSharedParent(childrens, sTypeNode);
            }
            if (sharedParents.size() > 0) {
                baseNode = (SNode)sharedParents.get(0);
            }
        }
        if (baseNode == null) {
            switch (sTypeNode) {
                case STOKEN: {
                    baseNode = this.node2NodeMap.get(currNode);
                    if (baseNode != null) break;
                    STextualRelation textRel = null;
                    for (SRelation rel : currNode.getOutRelations()) {
                        if (!(rel instanceof STextualRelation)) continue;
                        textRel = (STextualRelation)rel;
                        break;
                    }
                    Integer start = this.container.getAlignedTokenStart((STextualDS)this.node2NodeMap.get(textRel.getTarget()), (SToken)currNode);
                    Integer length = this.container.getAlignedTokenLength((STextualDS)this.node2NodeMap.get(textRel.getTarget()), (SToken)currNode);
                    if (start != -1 && length != -1) {
                        baseNode = this.baseGraph.createToken((SSequentialDS)((STextualDS)this.node2NodeMap.get(textRel.getTarget())), start, Integer.valueOf(start + length));
                        break;
                    }
                    logger.warn("[Merger] Could not create token in target graph matching to node '" + SaltUtil.getGlobalId((Identifier)currNode.getIdentifier()) + "', because start (" + start + ") or length (" + length + ") was empty. ");
                    break;
                }
                case SSPAN: {
                    ArrayList<SToken> toSTokens = new ArrayList<SToken>();
                    for (SNode sNode : childrens) {
                        toSTokens.add((SToken)sNode);
                    }
                    baseNode = this.baseGraph.createSpan(toSTokens);
                    break;
                }
                case SSTRUCTURE: {
                    ArrayList<SStructuredNode> baseStructureNodes = new ArrayList<SStructuredNode>();
                    for (SNode sNode : childrens) {
                        baseStructureNodes.add((SStructuredNode)sNode);
                    }
                    baseNode = this.baseGraph.createStructure(baseStructureNodes);
                    break;
                }
            }
            this.moveAnnosForRelations(currNode, baseNode);
        }
        if (baseNode != null) {
            this.node2NodeMap.put(currNode, baseNode);
            MergeHandler.copySLayers((IdentifiableElement)currNode, (IdentifiableElement)baseNode);
            SaltUtil.moveAnnotations((SAnnotationContainer)currNode, (SAnnotationContainer)baseNode);
            SaltUtil.moveMetaAnnotations((SAnnotationContainer)currNode, (SAnnotationContainer)baseNode);
        }
    }

    private static void copySLayers(IdentifiableElement other, IdentifiableElement base) {
        block9: {
            block8: {
                if (!(other instanceof SRelation) || !(base instanceof SRelation)) break block8;
                SRelation otherRel = (SRelation)other;
                SRelation baseRel = (SRelation)base;
                if (otherRel.getLayers() == null || otherRel.getLayers().size() == 0) break block9;
                SDocumentGraph baseGraph = (SDocumentGraph)baseRel.getGraph();
                for (SLayer otherLayer : otherRel.getLayers()) {
                    List layers = baseGraph.getLayerByName(otherLayer.getName());
                    SLayer baseLayer = null;
                    if (layers != null && !layers.isEmpty()) {
                        baseLayer = (SLayer)layers.get(0);
                    }
                    if (baseLayer == null) {
                        baseLayer = SaltFactory.createSLayer();
                        baseLayer.setName(otherLayer.getName());
                        SaltUtil.moveAnnotations((SAnnotationContainer)otherLayer, (SAnnotationContainer)baseLayer);
                        SaltUtil.moveMetaAnnotations((SAnnotationContainer)otherLayer, (SAnnotationContainer)baseLayer);
                        baseGraph.addLayer((Layer)baseLayer);
                    }
                    baseRel.addLayer((Layer)baseLayer);
                }
                break block9;
            }
            if (other instanceof SNode && base instanceof SNode) {
                SNode otherNode = (SNode)other;
                SNode baseNode = (SNode)base;
                if (otherNode.getLayers() != null && otherNode.getLayers().size() != 0) {
                    SDocumentGraph baseGraph = (SDocumentGraph)baseNode.getGraph();
                    for (SLayer otherLayer : otherNode.getLayers()) {
                        List layers = baseGraph.getLayerByName(otherLayer.getName());
                        SLayer baseLayer = null;
                        if (layers != null && !layers.isEmpty()) {
                            baseLayer = (SLayer)layers.get(0);
                        }
                        if (baseLayer == null) {
                            baseLayer = SaltFactory.createSLayer();
                            baseLayer.setName(otherLayer.getName());
                            SaltUtil.moveAnnotations((SAnnotationContainer)otherLayer, (SAnnotationContainer)baseLayer);
                            SaltUtil.moveMetaAnnotations((SAnnotationContainer)otherLayer, (SAnnotationContainer)baseLayer);
                            baseGraph.addLayer((Layer)baseLayer);
                        }
                        baseNode.addLayer((Layer)baseLayer);
                    }
                }
            }
        }
    }

    private void moveAnnosForRelations(SNode otherNode, SNode baseNode) {
        if (otherNode != null && baseNode != null) {
            block0: for (SRelation otherRel : otherNode.getOutRelations()) {
                SNode baseChildNode = this.node2NodeMap.get(otherRel.getTarget());
                for (SRelation baseRel : baseNode.getOutRelations()) {
                    if (!baseRel.getTarget().equals(baseChildNode) || !Objects.equals(baseRel.getClass(), otherRel.getClass())) continue;
                    SaltUtil.moveAnnotations((SAnnotationContainer)otherRel, (SAnnotationContainer)baseRel);
                    SaltUtil.moveMetaAnnotations((SAnnotationContainer)otherRel, (SAnnotationContainer)baseRel);
                    if (baseRel.getType() == null) {
                        baseRel.setType(otherRel.getType());
                    }
                    MergeHandler.copySLayers((IdentifiableElement)otherRel, (IdentifiableElement)baseRel);
                    continue block0;
                }
            }
        }
    }

    private List<SNode> getChildren(SNode parent, SALT_TYPE sTypeRelation) {
        ArrayList<SNode> children = new ArrayList<SNode>();
        List relations = parent.getOutRelations();
        if (relations != null) {
            for (SRelation relation : relations) {
                if (!SALT_TYPE.class2SaltType((Class[])new Class[]{relation.getClass()}).contains(sTypeRelation)) continue;
                SNode otherNode = (SNode)relation.getTarget();
                if (otherNode == null) {
                    throw new PepperModuleException("Cannot merge data, because otherBase was null for relation '" + relation + "'. ");
                }
                SNode baseNode = this.node2NodeMap.get(otherNode);
                children.add(baseNode);
            }
        }
        return children;
    }

    private List<SNode> getSharedParent(List<SNode> children, SALT_TYPE sTypeNode) {
        List rels;
        ArrayList<SNode> sharedParents = new ArrayList<SNode>();
        if (children.size() > 0 && children.get(0) != null && (rels = children.get(0).getInRelations()) != null && rels.size() > 0) {
            for (SRelation baseRelation : rels) {
                sharedParents.add((SNode)baseRelation.getSource());
            }
            for (SNode baseNode : children) {
                ArrayList<SNode> parents = new ArrayList<SNode>();
                if (baseNode != null && baseNode.getInRelations() != null) {
                    for (SRelation sRelation : baseNode.getInRelations()) {
                        SNode parent = (SNode)sRelation.getSource();
                        if (!SALT_TYPE.class2SaltType((Class[])new Class[]{parent.getClass()}).contains(sTypeNode)) continue;
                        parents.add(parent);
                    }
                }
                sharedParents.retainAll(parents);
            }
        }
        return sharedParents;
    }
}

