/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.toolboxModules;

import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class ToolboxImporterProperties
extends PepperModuleProperties {
    private static final long serialVersionUID = 3403186500470804226L;
    public static final String PROP_TEXT_ELEMENT = "textElement";
    public static final String PROP_SOUND_ELEMENT = "audioRefElement";
    public static final String PROP_CONCATENATE_TEXT = "concatenateText";
    public static final String PROP_TOKENIZE_TEXT = "tokenizeText";
    public static final String PROP_SEGMENTING_ELEMENT = "segmentingElement";
    public static final String PROP_ASSOCIATE_WITH_ALL_TOKEN = "associateWithAllToks";
    public static final String PROP_NEW_SPAN = "newSpan";
    public static final String PROP_ROOT_ELEMENT = "rootElement";

    public ToolboxImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_TEXT_ELEMENT, String.class, "Defines the name of the xml tag that includes the textual data to be used as primary text (key: 'textElement', default value: 'unicode').", (Object)"unicode", false));
        this.addProperty(new PepperModuleProperty(PROP_SOUND_ELEMENT, String.class, "Defines the name of the sound recordings (key: 'audioRefElement', default value: 'sound').", (Object)"sound", false));
        this.addProperty(new PepperModuleProperty(PROP_SEGMENTING_ELEMENT, String.class, "Defines the element for segmenting into textualDS (key: 'segmentingElement', default value: 'refGroup').", (Object)"refGroup", false));
        this.addProperty(new PepperModuleProperty(PROP_CONCATENATE_TEXT, Boolean.class, "Defines, if the textual data shall be concatenated or if a new string object shall be created (key: 'concatenateText', default is 'true').", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_TOKENIZE_TEXT, Boolean.class, "Defines, if the textual data shall be tokenized (key: 'tokenizeText', default value: 'true')", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_ASSOCIATE_WITH_ALL_TOKEN, String.class, "If one segment (refGroup) holds more than one entry of primary text and you wish to associate some annotations not only to the current primary text entry, but to the whole primary text of the current segment (refGroup), you can enumerate those annotation names here as a comma seperated string (key: 'associateWithAllToks', default value: 'null').", null, false));
        this.addProperty(new PepperModuleProperty(PROP_NEW_SPAN, Boolean.class, "Defines, if there shall be created a new span for each annotation (key: 'newSpan', default value: false).", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_ROOT_ELEMENT, String.class, "Defines the name of root xml element (key: 'rootElement', default value: 'database').", (Object)"database", false));
    }

    public String getPrimaryTextElement() {
        return (String)this.getProperty(PROP_TEXT_ELEMENT).getValue();
    }

    public String getAudioRecordElement() {
        return (String)this.getProperty(PROP_SOUND_ELEMENT).getValue();
    }

    public String getRootElement() {
        return (String)this.getProperty(PROP_ROOT_ELEMENT).getValue();
    }

    public String getSegmentingElement() {
        return (String)this.getProperty(PROP_SEGMENTING_ELEMENT).getValue();
    }

    public Boolean concatenateText() {
        return (Boolean)this.getProperty(PROP_CONCATENATE_TEXT).getValue();
    }

    public Boolean tokenizeText() {
        return (Boolean)this.getProperty(PROP_TOKENIZE_TEXT).getValue();
    }

    public String associateWithAllToken() {
        return (String)this.getProperty(PROP_ASSOCIATE_WITH_ALL_TOKEN).getValue();
    }

    public Boolean createNewSpan() {
        return (Boolean)this.getProperty(PROP_NEW_SPAN).getValue();
    }
}

