/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.toolboxModules;

import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.peppermodules.toolboxModules.Toolbox2SaltMapper;
import org.corpus_tools.peppermodules.toolboxModules.ToolboxImporterProperties;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="ToolboxImporterComponent", factory="PepperImporterComponentFactory")
public class ToolboxImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final Logger logger = LoggerFactory.getLogger(ToolboxImporter.class);

    public ToolboxImporter() {
        this.setName("ToolboxImporter");
        this.setVersion("0.0.1");
        this.setDesc("This importer transforms data of toolbox format to salt. The tag that includes the textual data is configurable.");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.addSupportedFormat("toolbox-xml", "1.0", null);
        this.getDocumentEndings().add("xml");
        this.setProperties(new ToolboxImporterProperties());
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        Toolbox2SaltMapper mapper = new Toolbox2SaltMapper();
        if (sElementId.getIdentifiableElement() != null && sElementId.getIdentifiableElement() instanceof SDocument) {
            URI resource = (URI)this.getIdentifier2ResourceTable().get(sElementId);
            mapper.setResourceURI(resource);
        }
        return mapper;
    }

    public Double isImportable(URI corpusPath) {
        return null;
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        return super.isReadyToStart();
    }
}

