/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.toolboxModules;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.peppermodules.toolboxModules.ToolboxImporter;
import org.corpus_tools.peppermodules.toolboxModules.ToolboxImporterProperties;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class Toolbox2SaltMapper
extends PepperMapperImpl {
    private StringBuilder currentText = new StringBuilder();

    public DOCUMENT_STATUS mapSDocument() {
        DocumentStructureReader contentHandler = new DocumentStructureReader();
        this.readXMLResource(contentHandler, this.getResourceURI());
        return DOCUMENT_STATUS.COMPLETED;
    }

    private SMedialDS createAudioData(String uriString) {
        SMedialDS audio = SaltFactory.createSMedialDS();
        File audioFile = new File(uriString);
        if (audioFile.exists()) {
            audio.setMediaReference(URI.createFileURI((String)uriString));
            this.getDocument().getDocumentGraph().addNode((Node)audio);
            return audio;
        }
        String absPath = this.getResourceURI().toFileString().replace(this.getResourceURI().lastSegment(), uriString);
        audioFile = new File(absPath);
        if (audioFile.exists()) {
            audio.setMediaReference(URI.createFileURI((String)absPath));
            this.getDocument().getDocumentGraph().addNode((Node)audio);
            return audio;
        }
        ToolboxImporter.logger.warn("No audio file for path '" + audioFile.getAbsolutePath() + "' found.");
        return null;
    }

    private void createAudioRelForEachTok(List<SToken> tokList, SMedialDS audio) {
        if (!tokList.isEmpty() && audio != null) {
            SMedialRelation audioRel = null;
            for (SToken tok : tokList) {
                audioRel = SaltFactory.createSMedialRelation();
                File file = new File(audio.getMediaReference().toFileString());
                double duration = this.computeDuration(file);
                audioRel.setSource((Node)tok);
                audioRel.setTarget((Node)audio);
                audioRel.setStart((Number)0.0);
                audioRel.setEnd((Number)duration);
                this.getDocument().getDocumentGraph().addRelation((Relation)audioRel);
            }
            File file = new File(audio.getMediaReference().toFileString());
            double duration = this.computeDuration(file);
            ((SMedialRelation)this.getDocument().getDocumentGraph().getMedialRelations().get(0)).setStart((Number)0.0);
            ((SMedialRelation)this.getDocument().getDocumentGraph().getMedialRelations().get(tokList.size() - 1)).setEnd((Number)duration);
        }
    }

    private void checkForAndRenameDoubledAnno(SSpan tokSpan, String name, String value) {
        if (!tokSpan.containsLabel(name)) {
            tokSpan.createAnnotation(null, name, (Object)value);
        } else {
            String annoName = name;
            for (int i = 1; tokSpan.containsLabel(annoName) && i <= tokSpan.getAnnotations().size(); ++i) {
                if (tokSpan.containsLabel(annoName + "_" + i)) continue;
                annoName = annoName + "_" + i;
            }
            ToolboxImporter.logger.warn("The annotation layer '" + name + "' allready exists and was replaced by '" + annoName + "'.");
            tokSpan.createAnnotation(null, annoName, (Object)value);
        }
    }

    private double computeDuration(File file) {
        Logger.getLogger("org.jaudiotagger").setLevel(Level.OFF);
        double duration = 0.0;
        if (Files.getFileExtension((String)file.getAbsolutePath()).equalsIgnoreCase("mp3")) {
            try {
                AudioFile audioFile = AudioFileIO.read((File)new File(file.getAbsolutePath()));
                duration = ((MP3AudioHeader)audioFile.getAudioHeader()).getPreciseTrackLength();
                duration /= 100.0;
            }
            catch (Exception e) {
                ToolboxImporter.logger.warn("The end of the audioFile '" + file + "' could not be computed and will not be set.");
            }
        } else {
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
                AudioFormat format = audioInputStream.getFormat();
                long frames = audioInputStream.getFrameLength();
                duration = ((double)frames + 0.0) / (double)format.getFrameRate();
            }
            catch (UnsupportedAudioFileException e) {
                ToolboxImporter.logger.warn("The end of the audioFile '" + file + "' could not be computed and will not be set.");
            }
            catch (IOException e) {
                ToolboxImporter.logger.warn("The end of the audioFile '" + file + "' could not be computed and will not be set.");
            }
        }
        return duration;
    }

    public class DocumentStructureReader
    extends DefaultHandler2 {
        STextualDS primaryText = null;
        List<SToken> currentTokList = new ArrayList<SToken>();
        List<SToken> segmentTokList = new ArrayList<SToken>();
        SSpan tokSpan = SaltFactory.createSSpan();
        Set<SAnnotation> annoList = new HashSet<SAnnotation>();
        Map<String, String> audioList = new HashMap<String, String>();
        Map<String, String> annoListForSegmentElem = new HashMap<String, String>();
        String annosToAssociateWithWholeSegment = ((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).associateWithAllToken();
        List<String> annosToAssociateWithWholeSegmentList = new ArrayList<String>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Toolbox2SaltMapper.this.currentText = new StringBuilder();
            if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getPrimaryTextElement().equals(qName)) {
                this.currentTokList = new ArrayList<SToken>();
            }
            if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getSegmentingElement().equals(qName)) {
                this.currentTokList = new ArrayList<SToken>();
                this.segmentTokList = new ArrayList<SToken>();
                this.annoList = new HashSet<SAnnotation>();
                this.audioList = new HashMap<String, String>();
                this.annoListForSegmentElem = new HashMap<String, String>();
                this.tokSpan = SaltFactory.createSSpan();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            for (int i = start; i < start + length; ++i) {
                Toolbox2SaltMapper.this.currentText.append(ch[i]);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            SMedialDS audio = null;
            if (this.annosToAssociateWithWholeSegment != null) {
                this.annosToAssociateWithWholeSegmentList = Arrays.asList(this.annosToAssociateWithWholeSegment.split("\\s*,\\s*"));
            }
            if (!((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getRootElement().equals(qName)) {
                if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getPrimaryTextElement().equals(qName)) {
                    this.currentTokList = new ArrayList<SToken>();
                    if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).concatenateText().booleanValue()) {
                        if (this.primaryText == null) {
                            this.primaryText = SaltFactory.createSTextualDS();
                            this.primaryText.setText("");
                            Toolbox2SaltMapper.this.getDocument().getDocumentGraph().addNode((Node)this.primaryText);
                        }
                        String text = Toolbox2SaltMapper.this.currentText.toString();
                        if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).tokenizeText().booleanValue()) {
                            Tokenizer tokenizer = new Tokenizer();
                            List tokenList = tokenizer.tokenizeToString(Toolbox2SaltMapper.this.currentText.toString(), null);
                            int offset = this.primaryText.getText().length();
                            this.primaryText.setText(this.primaryText.getText() + text);
                            for (String tok : tokenList) {
                                int currentPos = text.indexOf(tok);
                                int start = offset + currentPos;
                                int end = start + tok.length();
                                offset += tok.length() + currentPos;
                                text = text.substring(currentPos + tok.length());
                                SToken currTok = Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createToken((SSequentialDS)this.primaryText, Integer.valueOf(start), Integer.valueOf(end));
                                this.currentTokList.add(currTok);
                            }
                        } else {
                            this.primaryText.setText(this.primaryText.getText() + text);
                            SToken sToken = Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createToken((SSequentialDS)this.primaryText, Integer.valueOf(this.primaryText.getText().length() - text.length()), Integer.valueOf(this.primaryText.getText().length()));
                            this.currentTokList.add(sToken);
                        }
                    } else {
                        this.primaryText = Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createTextualDS(Toolbox2SaltMapper.this.currentText.toString());
                        if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).tokenizeText().booleanValue()) {
                            Tokenizer tokenizer = new Tokenizer();
                            this.currentTokList = tokenizer.tokenize(this.primaryText);
                        } else {
                            SToken currentTok = Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createToken((SSequentialDS)this.primaryText, Integer.valueOf(0), Integer.valueOf(this.primaryText.getText().length()));
                            this.currentTokList.add(currentTok);
                        }
                    }
                    for (SToken sToken : this.currentTokList) {
                        this.segmentTokList.add(sToken);
                    }
                    this.tokSpan = Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createSpan(this.currentTokList);
                    if (!this.annoList.isEmpty()) {
                        for (SAnnotation sAnnotation : this.annoList) {
                            this.tokSpan.addAnnotation(sAnnotation);
                        }
                        this.annoList = new HashSet<SAnnotation>();
                    }
                    if (!this.audioList.isEmpty()) {
                        for (Map.Entry<String, String> entry : this.audioList.entrySet()) {
                            audio = Toolbox2SaltMapper.this.createAudioData(entry.getValue());
                            Toolbox2SaltMapper.this.createAudioRelForEachTok(this.currentTokList, audio);
                        }
                        this.audioList = new HashMap<String, String>();
                    }
                }
                if (this.annosToAssociateWithWholeSegmentList == null || !this.annosToAssociateWithWholeSegmentList.contains(qName)) {
                    if (!((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getPrimaryTextElement().equals(qName) && !((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getSegmentingElement().equals(qName)) {
                        if (!((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getAudioRecordElement().equals(qName)) {
                            if (!this.currentTokList.isEmpty()) {
                                if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).createNewSpan().booleanValue()) {
                                    this.tokSpan = Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createSpan(this.currentTokList);
                                }
                                Toolbox2SaltMapper.this.checkForAndRenameDoubledAnno(this.tokSpan, qName, Toolbox2SaltMapper.this.currentText.toString());
                            } else {
                                this.annoList.add(Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createAnnotation(null, qName, (Object)Toolbox2SaltMapper.this.currentText.toString()));
                            }
                        } else if (!this.currentTokList.isEmpty()) {
                            audio = Toolbox2SaltMapper.this.createAudioData(Toolbox2SaltMapper.this.currentText.toString());
                            Toolbox2SaltMapper.this.createAudioRelForEachTok(this.currentTokList, audio);
                        } else {
                            this.audioList.put(qName, Toolbox2SaltMapper.this.currentText.toString());
                        }
                    }
                } else if (this.annosToAssociateWithWholeSegmentList.contains(qName) && !((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getPrimaryTextElement().equals(qName) && !((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getSegmentingElement().equals(qName)) {
                    this.annoListForSegmentElem.put(qName, Toolbox2SaltMapper.this.currentText.toString());
                }
                if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getSegmentingElement().equals(qName)) {
                    if (!this.annoListForSegmentElem.isEmpty()) {
                        this.tokSpan = Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createSpan(this.segmentTokList);
                        for (Map.Entry<String, String> entry : this.annoListForSegmentElem.entrySet()) {
                            if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).getAudioRecordElement().equals(entry.getKey())) {
                                audio = Toolbox2SaltMapper.this.createAudioData(entry.getValue());
                                Toolbox2SaltMapper.this.createAudioRelForEachTok(this.segmentTokList, audio);
                            } else {
                                if (((ToolboxImporterProperties)Toolbox2SaltMapper.this.getProperties()).createNewSpan().booleanValue()) {
                                    this.tokSpan = Toolbox2SaltMapper.this.getDocument().getDocumentGraph().createSpan(this.segmentTokList);
                                }
                                Toolbox2SaltMapper.this.checkForAndRenameDoubledAnno(this.tokSpan, entry.getKey(), entry.getValue());
                            }
                            this.annoListForSegmentElem.remove(entry);
                        }
                    }
                    this.currentTokList = new ArrayList<SToken>();
                    this.segmentTokList = new ArrayList<SToken>();
                    this.annoList = new HashSet<SAnnotation>();
                    this.annoListForSegmentElem = new HashMap<String, String>();
                }
                Toolbox2SaltMapper.this.currentText = new StringBuilder();
            }
        }
    }
}

