/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger.model.serialization.deserializer;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLUtils {
    private static final Character x09 = new Character('\t');
    private static final Character x0A = new Character('\n');
    private static final Character x0D = new Character('\r');
    private static final Character x20 = new Character(' ');
    private static final Character x22 = new Character('\"');
    private static final Character x27 = new Character('\'');
    private static final Character xB7 = new Character('\u00b7');
    private static final Character xC0 = new Character('\u00c0');
    private static final Character xD6 = new Character('\u00d6');
    private static final Character xD8 = new Character('\u00d8');
    private static final Character xF6 = new Character('\u00f6');
    private static final Character xF8 = new Character('\u00f8');
    private static final Character x02FF = new Character('\u02ff');
    private static final Character x0300 = new Character('\u0300');
    private static final Character x036F = new Character('\u036f');
    private static final Character x0370 = new Character('\u0370');
    private static final Character x037D = new Character('\u037d');
    private static final Character x037F = new Character('\u037f');
    private static final Character x1FFF = new Character('\u1fff');
    private static final Character x200C = new Character('\u200c');
    private static final Character x200D = new Character('\u200d');
    private static final Character x203F = new Character('\u203f');
    private static final Character x2040 = new Character('\u2040');
    private static final Character x2070 = new Character('\u2070');
    private static final Character x218F = new Character('\u218f');
    private static final Character x2C00 = new Character('\u2c00');
    private static final Character x2FEF = new Character('\u2fef');
    private static final Character x3001 = new Character('\u3001');
    private static final Character xD7FF = new Character('\ud7ff');
    private static final Character xE000 = new Character('\ue000');
    private static final Character xF900 = new Character('\uf900');
    private static final Character xFDCF = new Character('\ufdcf');
    private static final Character xFDF0 = new Character('\ufdf0');
    private static final Character xFFFD = new Character('\ufffd');
    private static final String s = String.format("([%c%c%c%c]+)", x09, x0A, x0D, x20);
    private static final String eq = "(" + s + "?=" + s + "?)";
    private static final String namestartchars = String.format(":A-Z_a-z%c-%c%c-%c%c-%c%c-%c%c-%c%c-%c%c-%c%c-%c%c-%c%c-%c%c-%c", xC0, xD6, xD8, xF6, xF8, x02FF, x0370, x037D, x037F, x1FFF, x200C, x200D, x2070, x218F, x2C00, x2FEF, x3001, xD7FF, xF900, xFDCF, xFDF0, xFFFD);
    private static final String namechars = namestartchars + String.format("-\\.0-9%c%c-%c%c-%c", xB7, x0300, x036F, x203F, x2040);
    private static final String namestartchar = "([" + namestartchars + "])";
    private static final String namechar = "([" + namechars + "])";
    private static final String name = "(" + namestartchar + namechar + "*)";
    private static final String normalChar = String.format("[%c%c%c%c-%c%c-%c]", x09, x0A, x0D, x20, xD7FF, xE000, xFFFD);
    private static final String entityref = "(&" + name + ";)";
    private static final String charref = "((&#[0-9]+;)|(&#x[0-9a-fA-F]+;))";
    private static final String reference = "(" + entityref + "|" + "((&#[0-9]+;)|(&#x[0-9a-fA-F]+;))" + ")";
    private static final String attvalueSingleQuote = String.format("(%c([^<&%c]|%s)*%c)", x27, x27, reference, x27);
    private static final String attvalueDoubleQuote = String.format("(%c([^<&%c]|%s)*%c)", x22, x22, reference, x22);
    private static final String attvalue = String.format("(%s|%s)", attvalueSingleQuote, attvalueDoubleQuote);
    private static final String attribute = "(" + name + eq + attvalue + ")";
    public static final String startTag = "<" + name + "(" + s + attribute + ")*" + s + "?>\t*";
    public static final String endTag = "</" + name + s + "?>\t*";
    private static final String piTarget = name;
    private static final String processingInstructionTag = "<\\?" + piTarget + "(" + s + normalChar + "*)?\\?>";
    private static final Pattern sPattern = Pattern.compile(s);
    private static final Pattern eqPattern = Pattern.compile(eq);
    private static final Pattern namePattern = Pattern.compile(name);
    private static final Pattern attributePattern = Pattern.compile(attribute);
    private static final Pattern attvaluePattern = Pattern.compile(attvalue);
    private static final Pattern startTagPattern = Pattern.compile(startTag);
    private static final Pattern endTagPattern = Pattern.compile(endTag);
    private static final Pattern processingInstructionTagPattern = Pattern.compile(processingInstructionTag);

    public static final boolean isWhiteSpace(String input) {
        return sPattern.matcher(input).matches();
    }

    public static final boolean isEq(String input) {
        return eqPattern.matcher(input).matches();
    }

    public static final boolean isStartTag(String input) {
        return startTagPattern.matcher(input).matches();
    }

    public static final boolean isEndTag(String input) {
        return endTagPattern.matcher(input).matches();
    }

    public static final boolean isProcessingInstructionTag(String input) {
        return processingInstructionTagPattern.matcher(input).matches();
    }

    public static final String extractTagName(String input) {
        Matcher matcher = namePattern.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static final Map<String, String> extractAttributeValuePairs(String input) {
        HashMap<String, String> list = new HashMap<String, String>();
        Matcher attrMatcher = attributePattern.matcher(input);
        while (attrMatcher.find()) {
            Matcher attrNameMatcher = namePattern.matcher(attrMatcher.group());
            attrNameMatcher.find();
            String name = attrNameMatcher.group();
            Matcher attrValueMatcher = attvaluePattern.matcher(attrMatcher.group());
            attrValueMatcher.find();
            String value = attrValueMatcher.group();
            value = value.substring(1, value.length() - 1);
            list.put(name, value);
        }
        return list;
    }
}

