/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger.model.serialization;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.treetagger.model.Annotation;
import org.corpus_tools.peppermodules.treetagger.model.AnyAnnotation;
import org.corpus_tools.peppermodules.treetagger.model.Document;
import org.corpus_tools.peppermodules.treetagger.model.Span;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabWriter {
    private static final Logger logger = LoggerFactory.getLogger(TabWriter.class);
    private String separator = "\t";
    private String POSName = "pos";
    private String LemmaName = "lemma";
    public static final String propertyInputMetaTag = "treetagger.input.metaTag";
    public static final String propertyInputFileEncoding = "treetagger.input.fileEncoding";
    public static final String propertyOutputMetaTag = "treetagger.output.metaTag";
    public static final String propertyOutputFileEncoding = "treetagger.output.fileEncoding";
    public static final String propertyExportAnyAnnotation = "treetagger.output.exportAnyAnnotation";
    private static final Pattern inputColumnPattern = Pattern.compile("treetagger\\.input\\.column");
    private static final String defaultOutputFileEncoding = "UTF-8";
    private static final String defaultMetaTag = "meta";
    private static final String defaultExportAnyAnnotation = "true";
    String currentFileName = "";
    URI location = null;
    private Properties properties = null;

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void save(Document document, URI location, Map<?, ?> options) throws IOException {
        if (options != null) {
            this.getProperties().putAll(options);
        }
        if (document == null) {
            throw new PepperModuleException("Cannot treetagger document, because the passed document was empty.");
        }
        this.location = location;
        this.currentFileName = location.toFileString();
        String metaTag = this.getProperties().getProperty(propertyOutputMetaTag, defaultMetaTag);
        logger.info(String.format("using meta tag '%s'", metaTag));
        String fileEncoding = this.getProperties().getProperty(propertyOutputFileEncoding, defaultOutputFileEncoding);
        logger.info(String.format("using output file encoding '%s'", fileEncoding));
        boolean exportAnyAnnotation = this.getProperties().getProperty(propertyExportAnyAnnotation, defaultExportAnyAnnotation).equalsIgnoreCase(defaultExportAnyAnnotation);
        logger.info("exporting any annotation = " + exportAnyAnnotation);
        BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFileName), fileEncoding));
        try {
            ArrayList columnNamesList = null;
            HashMap tokenMap = null;
            if (exportAnyAnnotation) {
                HashSet<String> annoNamesSet = new HashSet<String>();
                tokenMap = new HashMap();
                Integer tokenIndex = 0;
                while (tokenIndex < document.getTokens().size()) {
                    Object token = document.getTokens().get(tokenIndex);
                    Object annotationList = token.getAnnotations();
                    if (token.getPosAnnotation() != null && token.getLemmaAnnotation() != null && annotationList.size() > 2) {
                        tokenMap.put(tokenIndex, new HashMap());
                        HashMap annoMap = (HashMap)tokenMap.get(tokenIndex);
                        for (int annotationIndex = 0; annotationIndex < annotationList.size(); ++annotationIndex) {
                            Annotation annotation = (Annotation)annotationList.get(annotationIndex);
                            if (!(annotation instanceof AnyAnnotation)) continue;
                            String annotationName = annotation.getName();
                            annoNamesSet.add(annotationName);
                            annoMap.put(annotationName, (AnyAnnotation)annotation);
                        }
                    }
                    token = tokenIndex;
                    tokenIndex = tokenIndex + 1;
                    annotationList = tokenIndex;
                }
                columnNamesList = new ArrayList(annoNamesSet);
                Collections.sort(columnNamesList);
                logger.info("The following columns appear in the output file additionally to word form, part-of-speech and lemma: " + columnNamesList.toString());
            }
            if (this.documentHasMetaAnnotations(document)) {
                fileWriter.write(String.format("<%s", metaTag));
                for (int i = 0; i < document.getAnnotations().size(); ++i) {
                    Annotation annotation = document.getAnnotations().get(i);
                    fileWriter.write(String.format(" %s=\"%s\"", annotation.getName(), annotation.getValue()));
                }
                fileWriter.write(">\n");
            }
            ArrayList<Span> spanList = new ArrayList<Span>();
            HashMap<String, Integer> spanNamesCounts = new HashMap<String, Integer>();
            Integer tokenIndex = 0;
            while (tokenIndex < document.getTokens().size()) {
                Object token = document.getTokens().get(tokenIndex);
                for (int spanIndex = spanList.size() - 1; spanIndex >= 0; --spanIndex) {
                    Span span = (Span)spanList.get(spanIndex);
                    if (token.getSpans().contains(span)) continue;
                    String spanName = span.getName();
                    fileWriter.write("</" + spanName + ">\n");
                    spanList.remove(span);
                    Integer spanNameCount = (Integer)spanNamesCounts.get(spanName);
                    if (spanNameCount == 1) {
                        spanNamesCounts.remove(spanName);
                        continue;
                    }
                    spanNamesCounts.put(spanName, spanNameCount - 1);
                }
                HashMap size2SpanlistMap = new HashMap();
                ArrayList<Integer> sizeList = new ArrayList<Integer>();
                for (int spanIndex = token.getSpans().size() - 1; spanIndex >= 0; --spanIndex) {
                    Span span = token.getSpans().get(spanIndex);
                    Integer spanSize = span.getTokens().size();
                    if (spanList.contains(span)) continue;
                    if (!size2SpanlistMap.containsKey(spanSize)) {
                        size2SpanlistMap.put(spanSize, new ArrayList());
                        sizeList.add(spanSize);
                    }
                    ((ArrayList)size2SpanlistMap.get(spanSize)).add(span);
                }
                Collections.sort(sizeList);
                Collections.reverse(sizeList);
                for (int sizeIndex = 0; sizeIndex < sizeList.size(); ++sizeIndex) {
                    int size = (Integer)sizeList.get(sizeIndex);
                    ArrayList<String> currentSpannames = new ArrayList<String>();
                    HashMap currentSpanMap = new HashMap();
                    ArrayList currentSpanlist = (ArrayList)size2SpanlistMap.get(size);
                    for (int spanIndex = 0; spanIndex < currentSpanlist.size(); ++spanIndex) {
                        Span span = (Span)currentSpanlist.get(spanIndex);
                        String spanName = span.getName();
                        if (!currentSpanMap.containsKey(spanName)) {
                            currentSpannames.add(spanName);
                            currentSpanMap.put(spanName, new ArrayList());
                        }
                        ((ArrayList)currentSpanMap.get(spanName)).add(span);
                    }
                    Collections.sort(currentSpannames);
                    for (int spanNameIndex = 0; spanNameIndex < currentSpannames.size(); ++spanNameIndex) {
                        String spansName = (String)currentSpannames.get(spanNameIndex);
                        ArrayList currentSpanlist2 = (ArrayList)currentSpanMap.get(spansName);
                        if (!spanNamesCounts.containsKey(spansName)) {
                            spanNamesCounts.put(spansName, currentSpanlist2.size());
                        } else {
                            spanNamesCounts.put(spansName, (Integer)spanNamesCounts.get(spansName) + currentSpanlist2.size());
                        }
                        if ((Integer)spanNamesCounts.get(spansName) > 1) {
                            logger.warn("There are " + spanNamesCounts.get(spansName) + " spans named " + spansName + " open at the same time!");
                        }
                        for (int spanIndex = 0; spanIndex < currentSpanlist2.size(); ++spanIndex) {
                            Span span = (Span)currentSpanlist2.get(spanIndex);
                            spanList.add(span);
                            fileWriter.write("<" + span.getName());
                            for (Annotation anno : span.getAnnotations()) {
                                fileWriter.write(" " + anno.getName() + "=\"" + anno.getValue() + "\"");
                            }
                            fileWriter.write(">\n");
                        }
                    }
                }
                fileWriter.write(token.getText());
                fileWriter.write(this.separator);
                Annotation anno = token.getPosAnnotation();
                if (anno != null) {
                    fileWriter.write(anno.getValue());
                }
                fileWriter.write(this.separator);
                anno = token.getLemmaAnnotation();
                if (anno != null && anno.getValue() != null) {
                    fileWriter.write(anno.getValue());
                }
                if (exportAnyAnnotation) {
                    for (int colIndex = 0; colIndex < columnNamesList.size(); ++colIndex) {
                        fileWriter.write(this.separator);
                        String columnName = (String)columnNamesList.get(colIndex);
                        HashMap annoMap = (HashMap)tokenMap.get(tokenIndex);
                        if (annoMap == null || (anno = (Annotation)annoMap.get(columnName)) == null) continue;
                        fileWriter.write(anno.getValue());
                    }
                }
                fileWriter.write("\n");
                token = tokenIndex;
                Integer n = tokenIndex = Integer.valueOf(tokenIndex + 1);
            }
            for (int spanIndex = spanList.size() - 1; spanIndex >= 0; --spanIndex) {
                Span span = (Span)spanList.get(spanIndex);
                fileWriter.write("</" + span.getName() + ">\n");
                spanList.remove(span);
            }
            if (this.documentHasMetaAnnotations(document)) {
                fileWriter.write(String.format("</%s>\n", metaTag));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            fileWriter.flush();
            fileWriter.close();
            fileWriter = null;
        }
    }

    private boolean documentHasMetaAnnotations(Document document) {
        if (document == null) {
            return false;
        }
        return !document.getAnnotations().isEmpty();
    }

    protected HashMap<Integer, String> getColumns() {
        HashMap<Integer, String> retVal = new HashMap<Integer, String>();
        Object[] keyArray = this.getProperties().keySet().toArray();
        int numOfKeys = this.getProperties().size();
        String errorMessage = null;
        for (int keyIndex = 0; keyIndex < numOfKeys; ++keyIndex) {
            String key = (String)keyArray[keyIndex];
            if (!inputColumnPattern.matcher(key).find()) continue;
            String indexStr = key.substring("treetagger.input.column".length());
            String name = this.getProperties().getProperty(key);
            Integer index = null;
            try {
                index = Integer.valueOf(indexStr);
            }
            catch (NumberFormatException e) {
                errorMessage = "Invalid property name '" + key + "': " + indexStr + " is not a valid number!";
                logger.error(errorMessage);
                throw new PepperModuleException(errorMessage, (Throwable)e);
            }
            if (index <= 0) {
                errorMessage = "Invalid settings in properties file: no column index less than 1 allowed!";
                logger.error(errorMessage);
                throw new PepperModuleException(errorMessage);
            }
            if (retVal.containsKey(index)) {
                errorMessage = "Invalid settings in properties file:  More than one column is defined for index '" + index + "'";
                logger.error(errorMessage);
                throw new PepperModuleException(errorMessage);
            }
            if (retVal.containsValue(name)) {
                errorMessage = "Invalid settings in properties file:  More than one column is defined for name '" + name + "'";
                logger.error(errorMessage);
                throw new PepperModuleException(errorMessage);
            }
            retVal.put(index, name);
        }
        if (retVal.size() == 0) {
            retVal.put(1, this.POSName);
            retVal.put(2, this.LemmaName);
            return retVal;
        }
        for (int index = 1; index <= retVal.size(); ++index) {
            if (retVal.containsKey(index)) continue;
            errorMessage = "Invalid settings in properties file: column indexes are not consecutive, column" + index + " missing!";
            logger.error(errorMessage);
            throw new PepperModuleException(errorMessage);
        }
        return retVal;
    }
}

