/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger.model.impl;

import org.corpus_tools.peppermodules.treetagger.model.Annotation;
import org.corpus_tools.peppermodules.treetagger.model.Document;
import org.corpus_tools.peppermodules.treetagger.model.Token;
import org.corpus_tools.peppermodules.treetagger.model.TreetaggerFactory;
import org.corpus_tools.peppermodules.treetagger.model.serialization.deserializer.Deserializer;

public class Treetagger {
    public static DocumentBuilder buildDocument() {
        return new DocumentBuilder();
    }

    public static TokenBuilder buildToken() {
        return new TokenBuilder();
    }

    public static Deserializer.Builder deserialize() {
        return new Deserializer.Builder();
    }

    public static class TokenBuilder {
        private final Token token = TreetaggerFactory.eINSTANCE.createToken();

        public TokenBuilder withLine(long line) {
            this.token.setLine(line);
            return this;
        }

        public TokenBuilder withText(String text) {
            this.token.setText(text);
            return this;
        }

        public TokenBuilder withAnnotation(Annotation annotation) {
            this.token.getAnnotations().add(annotation);
            return this;
        }

        public TokenBuilder withAnnotation(String name, String value) {
            return this.withAnnotation(TreetaggerFactory.eINSTANCE.createAnnotation(name, value));
        }

        public Token build() {
            return this.token;
        }
    }

    public static class DocumentBuilder {
        private final Document document = TreetaggerFactory.eINSTANCE.createDocument();

        public DocumentBuilder withAnnotation(String name, String value) {
            this.document.getAnnotations().add(TreetaggerFactory.eINSTANCE.createAnnotation(name, value));
            return this;
        }

        public DocumentBuilder withName(String name) {
            this.document.setName(name);
            return this;
        }

        public DocumentBuilder withToken(Token token) {
            this.document.getTokens().add(token);
            return this;
        }

        public Document build() {
            return this.document;
        }
    }
}

