/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger.model.impl;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.corpus_tools.peppermodules.treetagger.model.Annotation;
import org.corpus_tools.peppermodules.treetagger.model.Document;
import org.corpus_tools.peppermodules.treetagger.model.LemmaAnnotation;
import org.corpus_tools.peppermodules.treetagger.model.POSAnnotation;
import org.corpus_tools.peppermodules.treetagger.model.Span;
import org.corpus_tools.peppermodules.treetagger.model.Token;
import org.corpus_tools.peppermodules.treetagger.model.impl.AnnotatableElementImpl;

public class TokenImpl
extends AnnotatableElementImpl
implements Token {
    protected String text = null;
    protected long line = -1L;
    protected List<Span> spans = new ArrayList<Span>();
    protected Document document = null;

    protected TokenImpl() {
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String newText) {
        this.text = newText;
    }

    @Override
    public long getLine() {
        return this.line;
    }

    @Override
    public void setLine(long line) {
        this.line = line;
    }

    @Override
    public POSAnnotation getPosAnnotation() {
        POSAnnotation posAnno = null;
        for (Annotation anno : this.getAnnotations()) {
            if (!(anno instanceof POSAnnotation)) continue;
            posAnno = (POSAnnotation)anno;
        }
        return posAnno;
    }

    @Override
    public void setPosAnnotation(POSAnnotation newPosAnnotation) {
        this.getAnnotations().add(newPosAnnotation);
    }

    @Override
    public LemmaAnnotation getLemmaAnnotation() {
        LemmaAnnotation lemmaAnno = null;
        for (Annotation anno : this.getAnnotations()) {
            if (!(anno instanceof LemmaAnnotation)) continue;
            lemmaAnno = (LemmaAnnotation)anno;
        }
        return lemmaAnno;
    }

    @Override
    public void setLemmaAnnotation(LemmaAnnotation newLemmaAnnotation) {
        this.getAnnotations().add(newLemmaAnnotation);
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document newDocument) {
        this.document = newDocument;
    }

    @Override
    public List<Span> getSpans() {
        return this.spans;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.line, this.text, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TokenImpl other = (TokenImpl)obj;
        return Objects.equal((Object)this.line, (Object)other.line) && Objects.equal((Object)this.text, (Object)other.text);
    }

    @Override
    public String toString() {
        return this.text + "@" + this.line + super.toString();
    }
}

