/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger.mapper;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.peppermodules.treetagger.TreetaggerImporterProperties;
import org.corpus_tools.peppermodules.treetagger.model.Annotation;
import org.corpus_tools.peppermodules.treetagger.model.Document;
import org.corpus_tools.peppermodules.treetagger.model.LemmaAnnotation;
import org.corpus_tools.peppermodules.treetagger.model.POSAnnotation;
import org.corpus_tools.peppermodules.treetagger.model.Span;
import org.corpus_tools.peppermodules.treetagger.model.Token;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.semantics.SPOSAnnotation;

public class Treetagger2SaltMapper
extends PepperMapperImpl
implements PepperMapper {
    private Document ttDocument = null;

    public TreetaggerImporterProperties getProps() {
        return (TreetaggerImporterProperties)this.getProperties();
    }

    public Document getTtDocument() {
        return this.ttDocument;
    }

    public void setTTDocument(Document ttDocument) {
        this.ttDocument = ttDocument;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        this.getDocument().getDocumentGraph().setName(this.getTtDocument().getName() + "_graph");
        this.getDocument().setName(this.getTtDocument().getName());
        this.addMetaAnnotation(this.getTtDocument().getAnnotations());
        this.createSTextualDS(this.getTtDocument().getTokens(), this.getDocument());
        return DOCUMENT_STATUS.COMPLETED;
    }

    protected void addMetaAnnotation(List<Annotation> tAnnotations) {
        for (Annotation tAnno : tAnnotations) {
            this.getDocument().createMetaAnnotation(null, tAnno.getName(), (Object)tAnno.getValue());
        }
    }

    protected STextualDS createSTextualDS(List<Token> tTokens, SDocument sDocument) {
        boolean annotateUnannotatedSpans = this.getProps().getAnnotateUnannotatedSpans();
        boolean makePointingRelations = this.getProps().getMakePointingRelations();
        List<Boolean> invertPointingRelationsList = this.getProps().getInvertPointingRelations();
        boolean suppressPointingRelationID = this.getProps().getSuppressPRID();
        boolean suppressPointingRelationTarget = this.getProps().getSuppressPRTarget();
        boolean suppressPointingRelationLabel = this.getProps().getSuppressPRLabel();
        boolean usePRHash = this.getProps().getPRUseHash();
        List<String> pointingTargetAnnoList = this.getProps().getPointingTargetAnno();
        List<String> pointingIDAnnoList = this.getProps().getPointingIDAnno();
        List<String> pointingEdgeAnnoList = this.getProps().getPointingEdgeAnno();
        List<String> pointingTypeList = this.getProps().getPointingType();
        List<String> pointingNSList = this.getProps().getPointingNS();
        String spanAnnoNS = this.getProps().getSpanAnnotationNamespace();
        boolean annotateAllSpansWithSpanName = this.getProps().getAnnotateAllSpansWithName();
        boolean prefixSpanAnnotation = this.getProps().getPrefixSpanAnnotation();
        String prefixSpanSeparator = this.getProps().getPrefixSpanSeparator();
        Object[] separateSpanAnnoNames = this.getProps().getSeparateSpanAnnos();
        STextualDS sText = SaltFactory.createSTextualDS();
        sDocument.getDocumentGraph().addNode((Node)sText);
        LinkedList<SLayer> prLayers = new LinkedList<SLayer>();
        LinkedList<String> prLayerNames = new LinkedList<String>();
        if (makePointingRelations) {
            for (String lname : pointingNSList) {
                SLayer prLayer = SaltFactory.createSLayer();
                prLayer.setName(lname);
                prLayer.setGraph((Graph)this.getDocument().getDocumentGraph());
                prLayers.add(prLayer);
                prLayerNames.add(lname);
            }
        }
        Hashtable<Span, SSpan> spanTable = new Hashtable<Span, SSpan>();
        LinkedList prTableList = new LinkedList();
        LinkedList id2spanList = new LinkedList();
        for (int i = 0; i < pointingTargetAnnoList.size(); ++i) {
            Hashtable tab = new Hashtable();
            Hashtable spantab = new Hashtable();
            prTableList.add(tab);
            id2spanList.add(spantab);
        }
        String text = null;
        int start = 0;
        int end = 0;
        Map<String, String> replMap = ((TreetaggerImporterProperties)this.getProperties()).getReplacementMapping();
        Hashtable<String, SLayer> layerMap = new Hashtable<String, SLayer>();
        for (int tokenIndex = 0; tokenIndex < tTokens.size(); ++tokenIndex) {
            Token tToken = tTokens.get(tokenIndex);
            if (replMap != null) {
                for (Map.Entry<String, String> entry : replMap.entrySet()) {
                    tToken.setText(tToken.getText().replace(entry.getKey(), entry.getValue()));
                    if (!this.getProps().getReplaceInAnnos().booleanValue()) continue;
                    for (Annotation tAnnotation : tToken.getAnnotations()) {
                        tAnnotation.setValue(tAnnotation.getValue().replace(entry.getKey(), entry.getValue()));
                    }
                }
            }
            if (text == null) {
                start = 0;
                end = tToken.getText().length();
                text = tToken.getText();
            } else {
                start = text.length() + this.getProps().getSeparatorAfterToken().length();
                end = start + tToken.getText().length();
                text = text + this.getProps().getSeparatorAfterToken() + tToken.getText();
            }
            SToken sToken = this.createSToken(tToken);
            sDocument.getDocumentGraph().addNode((Node)sToken);
            for (int i = 0; i < tToken.getSpans().size(); ++i) {
                Span tSpan = tToken.getSpans().get(i);
                SSpan sSpan = null;
                if (!spanTable.containsKey(tSpan)) {
                    sSpan = SaltFactory.createSSpan();
                    if (tSpan.getName().contains(":")) {
                        String ns = tSpan.getName().split(":")[0];
                        SLayer lyr = null;
                        if (layerMap.containsKey(ns)) {
                            lyr = (SLayer)layerMap.get(ns);
                        } else {
                            lyr = SaltFactory.createSLayer();
                            lyr.setName(ns);
                            lyr.setGraph((Graph)this.getDocument().getDocumentGraph());
                            layerMap.put(ns, lyr);
                        }
                        sSpan.addLayer((Layer)lyr);
                    }
                    spanTable.put(tSpan, sSpan);
                    sSpan.setGraph((Graph)sDocument.getDocumentGraph());
                    sSpan.setName(tSpan.getName());
                    List<Annotation> tAnnotations = tSpan.getAnnotations();
                    if (annotateAllSpansWithSpanName || tAnnotations.size() == 0 && annotateUnannotatedSpans) {
                        sSpan.createAnnotation(spanAnnoNS, tSpan.getName().toLowerCase(), (Object)tSpan.getName().toLowerCase());
                    }
                    for (int j = 0; j < tAnnotations.size(); ++j) {
                        SAnnotation anno = this.createAnnotation(tSpan.getAnnotations().get(j));
                        if (prefixSpanAnnotation) {
                            anno.setName(tSpan.getName() + prefixSpanSeparator + anno.getName());
                        }
                        if (spanAnnoNS != null) {
                            anno.setNamespace(spanAnnoNS);
                        }
                        for (int k = 0; k < pointingTargetAnnoList.size(); ++k) {
                            String pointingTargetAnno = pointingTargetAnnoList.get(k);
                            String pointingEdgeAnno = pointingEdgeAnnoList.get(k);
                            String pointingIDAnno = pointingIDAnnoList.get(k);
                            Hashtable prTable = (Hashtable)prTableList.get(k);
                            Hashtable id2span = (Hashtable)id2spanList.get(k);
                            if (!(makePointingRelations && (pointingTargetAnnoList.contains(anno.getName()) && suppressPointingRelationTarget || pointingEdgeAnnoList.contains(anno.getName()) && suppressPointingRelationLabel || pointingIDAnnoList.contains(anno.getName()) && suppressPointingRelationID))) {
                                sSpan.addAnnotation(anno);
                            }
                            if (!makePointingRelations || !anno.getName().equals(pointingTargetAnno) && !anno.getName().equals(pointingEdgeAnno) && !anno.getName().equals(pointingIDAnno)) continue;
                            if (!prTable.containsKey(sSpan)) {
                                String[] initPR = new String[2];
                                prTable.put(sSpan, initPR);
                            }
                            String[] prInfo = (String[])prTable.get(sSpan);
                            if (anno.getName().equals(pointingTargetAnno)) {
                                prInfo[0] = anno.getValue_STEXT();
                                if (prInfo[0].length() > 0 && usePRHash && prInfo[0].startsWith("#")) {
                                    prInfo[0] = prInfo[0].substring(1);
                                }
                                prTable.put(sSpan, prInfo);
                                continue;
                            }
                            if (anno.getName().equals(pointingIDAnno)) {
                                id2span.put(anno.getValue_STEXT(), sSpan);
                                continue;
                            }
                            prInfo[1] = anno.getValue_STEXT();
                            prTable.put(sSpan, prInfo);
                        }
                    }
                } else {
                    sSpan = (SSpan)spanTable.get(tSpan);
                }
                SSpanningRelation sSpanningRelation = SaltFactory.createSSpanningRelation();
                sSpanningRelation.setSource((Node)sSpan);
                sSpanningRelation.setTarget((Node)sToken);
                sSpanningRelation.setGraph((Graph)sDocument.getDocumentGraph());
            }
            STextualRelation sTextRel = this.createSTextualRelation(sToken, sText, start, end);
            sDocument.getDocumentGraph().addRelation((Relation)sTextRel);
        }
        for (int i = 0; i < pointingTargetAnnoList.size(); ++i) {
            String pointingTargetAnno = pointingTargetAnnoList.get(i);
            String pointingEdgeAnno = pointingEdgeAnnoList.get(i);
            String pointingIDAnno = pointingIDAnnoList.get(i);
            Hashtable prTable = (Hashtable)prTableList.get(i);
            Hashtable id2span = (Hashtable)id2spanList.get(i);
            String pointingNS = "";
            SLayer prLayer = null;
            if (prLayerNames.size() > i) {
                pointingNS = (String)prLayerNames.get(i);
                prLayer = (SLayer)prLayers.get(i);
            }
            String pointingType = pointingTypeList.get(i);
            boolean invertPointingRelations = invertPointingRelationsList.get(i);
            for (SSpan src : prTable.keySet()) {
                String[] prInfo = (String[])prTable.get(src);
                String trgID = prInfo[0];
                String edgeAnno = prInfo[1];
                if (trgID == null) continue;
                if (id2span.containsKey(trgID)) {
                    SSpan trg = (SSpan)id2span.get(trgID);
                    SPointingRelation rel = SaltFactory.createSPointingRelation();
                    if (edgeAnno != null && edgeAnno.length() > 0) {
                        SAnnotation anno = SaltFactory.createSAnnotation();
                        anno.setName(pointingEdgeAnno);
                        anno.setValue((Object)edgeAnno);
                        anno.setNamespace(pointingNS);
                        rel.addAnnotation(anno);
                    }
                    if (!invertPointingRelations) {
                        rel.setSource((Node)src);
                        rel.setTarget((Node)trg);
                    } else {
                        rel.setSource((Node)trg);
                        rel.setTarget((Node)src);
                    }
                    rel.setType(pointingType);
                    rel.addLayer((Layer)prLayer);
                    sDocument.getDocumentGraph().addRelation((Relation)rel);
                    continue;
                }
                throw new PepperModuleDataException((PepperMapper)this, "Input error: pointing relation target ID " + pointingTargetAnno + "=" + trgID + " refers to a non-existent span annotation " + pointingIDAnno + "=" + trgID + "\n");
            }
        }
        if (separateSpanAnnoNames != null) {
            for (SSpan span : spanTable.values()) {
                if (span.getAnnotations().size() <= 1) continue;
                int newAnnoNameCounter = 0;
                ArrayList<String[]> toRemove = new ArrayList<String[]>();
                for (SAnnotation anno : span.getAnnotations()) {
                    if (!ArrayUtils.contains((Object[])separateSpanAnnoNames, (Object)anno.getName())) continue;
                    SSpan newSpan = SaltFactory.createSSpan();
                    newSpan.setGraph((Graph)sDocument.getDocumentGraph());
                    newSpan.setName(span.getName() + "_" + Integer.toString(++newAnnoNameCounter));
                    newSpan.createAnnotation(anno.getNamespace(), anno.getName(), anno.getValue());
                    String[] rem = new String[]{anno.getNamespace(), anno.getName()};
                    toRemove.add(rem);
                    List spanToks = span.getGraph().getOverlappedTokens((SNode)span);
                    for (SToken tok : spanToks) {
                        SSpanningRelation sSpanningRelation = SaltFactory.createSSpanningRelation();
                        sSpanningRelation.setSource((Node)newSpan);
                        sSpanningRelation.setTarget((Node)tok);
                        sSpanningRelation.setGraph((Graph)sDocument.getDocumentGraph());
                    }
                }
                for (String[] rem : toRemove) {
                    span.removeLabel(rem[0], rem[1]);
                }
            }
        }
        sText.setText(text);
        return sText;
    }

    protected SToken createSToken(Token tToken) {
        SToken retVal = SaltFactory.createSToken();
        for (Annotation tAnnotation : tToken.getAnnotations()) {
            retVal.addAnnotation(this.createAnnotation(tAnnotation));
        }
        return retVal;
    }

    protected SAnnotation createAnnotation(Annotation tAnnotation) {
        SPOSAnnotation retVal = null;
        if (tAnnotation instanceof POSAnnotation) {
            retVal = SaltFactory.createSPOSAnnotation();
        } else if (tAnnotation instanceof LemmaAnnotation) {
            retVal = SaltFactory.createSLemmaAnnotation();
        } else {
            retVal = SaltFactory.createSAnnotation();
            retVal.setName(tAnnotation.getName());
        }
        retVal.setValue((Object)tAnnotation.getValue());
        return retVal;
    }

    protected STextualRelation createSTextualRelation(SToken sToken, STextualDS sText, int start, int end) {
        STextualRelation retVal = null;
        retVal = SaltFactory.createSTextualRelation();
        retVal.setTarget((Node)sText);
        retVal.setSource((Node)sToken);
        retVal.setStart((Number)start);
        retVal.setEnd((Number)end);
        return retVal;
    }
}

