/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.exceptions.PepperConvertException;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.treetagger.TreetaggerExporterProperties;
import org.corpus_tools.peppermodules.treetagger.model.Annotation;
import org.corpus_tools.peppermodules.treetagger.model.AnyAnnotation;
import org.corpus_tools.peppermodules.treetagger.model.Document;
import org.corpus_tools.peppermodules.treetagger.model.Span;
import org.corpus_tools.peppermodules.treetagger.model.Token;
import org.corpus_tools.peppermodules.treetagger.model.TreetaggerFactory;
import org.corpus_tools.peppermodules.treetagger.model.serialization.TabWriter;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.semantics.SLemmaAnnotation;
import org.corpus_tools.salt.semantics.SPOSAnnotation;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Salt2TreetaggerMapper
extends PepperMapperImpl {
    private static final Logger logger = LoggerFactory.getLogger(Salt2TreetaggerMapper.class);
    private int numOfSTokensWithMultiplePOSAnnos = 0;
    private int numOfSTokensWithMultipleLemmaAnnos = 0;
    private Document ttDocument = null;

    public TreetaggerExporterProperties getProps() {
        return (TreetaggerExporterProperties)this.getProperties();
    }

    public Document getTTDocument() {
        return this.ttDocument;
    }

    public void setTTDocument(Document ttDocument) {
        this.ttDocument = ttDocument;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() != null) {
            if (this.getTTDocument() == null) {
                this.setTTDocument(TreetaggerFactory.eINSTANCE.createDocument());
            }
            this.getTTDocument().setName(this.getDocument().getName());
            this.addDocumentAnnotations(this.getDocument().getMetaAnnotations(), this.getTTDocument());
            this.addTokens(this.getDocument().getDocumentGraph(), this.getTTDocument());
            if (this.numOfSTokensWithMultiplePOSAnnos > 0) {
                logger.warn("There were " + this.numOfSTokensWithMultiplePOSAnnos + " tokens with more than one POS annotation in the document. The first one found for each token was used for it\u00b4s POS annotation; the remainder was used for ordinary annotations.");
            }
            if (this.numOfSTokensWithMultipleLemmaAnnos > 0) {
                logger.warn("There were " + this.numOfSTokensWithMultipleLemmaAnnos + " tokens with more than one lemma annotation in the document. The first one found for each token was used for it\u00b4s lemma annotation; the remainder was used for ordinary annotations.");
            }
            try {
                this.saveToFile(this.getResourceURI(), this.getTTDocument());
            }
            catch (IOException e) {
                throw new PepperConvertException("Cannot write document with id: '" + this.getDocument().getId() + "' to: '" + this.getResourceURI() + "'.", (Throwable)e);
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private void saveToFile(URI uri, Document tDocument) throws IOException {
        if (uri == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot save o given uri, because its null for document '" + tDocument + "'.");
        }
        TabWriter writer = new TabWriter();
        writer.save(tDocument, uri, this.getProperties().getProperties());
    }

    protected void addDocumentAnnotations(Set<SMetaAnnotation> sMetaAnnotations, Document tDocument) {
        for (SMetaAnnotation metaAnno : sMetaAnnotations) {
            AnyAnnotation tAnno = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
            tAnno.setName(metaAnno.getName());
            tAnno.setValue(metaAnno.getValue_STEXT());
            tDocument.getAnnotations().add(tAnno);
        }
    }

    protected void addTokens(SDocumentGraph sDocumentGraph, Document tDocument) {
        Hashtable token2SpansTable = new Hashtable();
        for (int i = 0; i < sDocumentGraph.getSpanningRelations().size(); ++i) {
            SToken sToken = (SToken)((SSpanningRelation)sDocumentGraph.getSpanningRelations().get(i)).getTarget();
            SSpan sSpan = (SSpan)((SSpanningRelation)sDocumentGraph.getSpanningRelations().get(i)).getSource();
            if (!token2SpansTable.containsKey(sToken)) {
                token2SpansTable.put(sToken, new ArrayList());
            }
            ((ArrayList)token2SpansTable.get(sToken)).add(sSpan);
        }
        Hashtable<SSpan, Span> sSpan2SpanTable = new Hashtable<SSpan, Span>();
        long tokenIndex = 0L;
        for (SToken sToken : sDocumentGraph.getSortedTokenByText()) {
            for (SRelation rel : sToken.getOutRelations()) {
                if (!(rel instanceof STextualRelation)) continue;
                STextualRelation sTexRel = (STextualRelation)rel;
                Token token = TreetaggerFactory.eINSTANCE.createToken();
                token.setLine(tokenIndex++);
                token.setText(((STextualDS)sTexRel.getTarget()).getText().substring((Integer)sTexRel.getStart(), (Integer)sTexRel.getEnd()));
                this.addTokenAnnotations(sToken, token);
                tDocument.getTokens().add(token);
                if (!token2SpansTable.containsKey(sToken)) continue;
                for (int j = 0; j < ((ArrayList)token2SpansTable.get(sToken)).size(); ++j) {
                    SSpan sSpan = (SSpan)((ArrayList)token2SpansTable.get(sToken)).get(j);
                    if (!sSpan2SpanTable.containsKey(sSpan)) {
                        sSpan2SpanTable.put(sSpan, this.createSpan(sSpan));
                    }
                    Span tSpan = (Span)sSpan2SpanTable.get(sSpan);
                    token.getSpans().add(tSpan);
                    tSpan.getTokens().add(token);
                }
            }
        }
    }

    protected void addTokenAnnotations(SToken sToken, Token tToken) {
        Annotation tAnno;
        SAnnotation sAnno;
        int i;
        boolean donePOSAnno = false;
        ArrayList<SAnnotation> possiblePOSAnnos = new ArrayList<SAnnotation>();
        boolean doneLemmaAnno = false;
        ArrayList<SAnnotation> possibleLemmaAnnos = new ArrayList<SAnnotation>();
        for (SAnnotation sAnno2 : sToken.getAnnotations()) {
            Annotation tAnno2 = null;
            if (sAnno2 instanceof SPOSAnnotation) {
                if (!donePOSAnno) {
                    tAnno2 = TreetaggerFactory.eINSTANCE.createPOSAnnotation();
                    donePOSAnno = true;
                } else {
                    ++this.numOfSTokensWithMultiplePOSAnnos;
                    tAnno2 = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
                }
            } else if (sAnno2 instanceof SLemmaAnnotation) {
                if (!doneLemmaAnno) {
                    tAnno2 = TreetaggerFactory.eINSTANCE.createLemmaAnnotation();
                    doneLemmaAnno = true;
                } else {
                    ++this.numOfSTokensWithMultipleLemmaAnnos;
                    tAnno2 = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
                }
            } else if ("pos".equalsIgnoreCase(sAnno2.getName())) {
                if (!donePOSAnno) {
                    possiblePOSAnnos.add(sAnno2);
                } else {
                    tAnno2 = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
                }
            } else if ("lemma".equalsIgnoreCase(sAnno2.getName())) {
                if (!doneLemmaAnno) {
                    possibleLemmaAnnos.add(sAnno2);
                } else {
                    tAnno2 = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
                }
            } else {
                tAnno2 = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
            }
            if (tAnno2 == null) continue;
            tAnno2.setName(sAnno2.getName());
            tAnno2.setValue(sAnno2.getValue_STEXT());
            tToken.getAnnotations().add(tAnno2);
        }
        for (i = 0; i < possiblePOSAnnos.size(); ++i) {
            sAnno = (SAnnotation)possiblePOSAnnos.get(i);
            tAnno = null;
            if (!donePOSAnno) {
                tAnno = TreetaggerFactory.eINSTANCE.createPOSAnnotation();
                donePOSAnno = true;
            } else {
                tAnno = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
            }
            tAnno.setName(sAnno.getName());
            tAnno.setValue(sAnno.getValue_STEXT());
            tToken.getAnnotations().add(tAnno);
        }
        for (i = 0; i < possibleLemmaAnnos.size(); ++i) {
            sAnno = (SAnnotation)possibleLemmaAnnos.get(i);
            tAnno = null;
            if (!doneLemmaAnno) {
                tAnno = TreetaggerFactory.eINSTANCE.createLemmaAnnotation();
                doneLemmaAnno = true;
            } else {
                tAnno = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
            }
            tAnno.setName(sAnno.getName());
            tAnno.setValue(sAnno.getValue_STEXT());
            tToken.getAnnotations().add(tAnno);
        }
    }

    protected Span createSpan(SSpan sSpan) {
        Span retVal = TreetaggerFactory.eINSTANCE.createSpan();
        String alternativeSpanName = null;
        for (SAnnotation sAnno : sSpan.getAnnotations()) {
            AnyAnnotation tAnno = TreetaggerFactory.eINSTANCE.createAnyAnnotation();
            if (alternativeSpanName == null) {
                alternativeSpanName = sAnno.getName();
            }
            tAnno.setName(sAnno.getName());
            tAnno.setValue(sAnno.getValue_STEXT());
            retVal.getAnnotations().add(tAnno);
        }
        retVal.setName(sSpan.getName());
        if (sSpan.getName().startsWith("sSpan") && alternativeSpanName != null && this.getProps().isReplaceGenericSpanNamesProperty().booleanValue()) {
            retVal.setName(alternativeSpanName);
        }
        return retVal;
    }
}

