/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class TreetaggerImporterProperties
extends PepperModuleProperties {
    private static final long serialVersionUID = -7528434389946019271L;
    public static final String PREFIX = "treetagger.input.";
    public static final String PROP_ANNOTATE_UNANNOTATED_SPANS = "treetagger.input.annotateUnannotatedSpans";
    public static final String PROP_MAKE_POINTING_RELATIONS = "treetagger.input.makePointingRelations";
    public static final String PROP_POINTING_RELATION_TARGET_ANNOTATION = "treetagger.input.pointingRelationTargetAnnotation";
    public static final String PROP_POINTING_RELATION_ID_ANNOTATION = "treetagger.input.pointingRelationIDAnnotation";
    public static final String PROP_POINTING_RELATION_NS = "treetagger.input.pointingRelationNamespace";
    public static final String PROP_POINTING_RELATION_TYPE = "treetagger.input.pointingRelationType";
    public static final String PROP_INVERT_POINTING_RELATIONS = "treetagger.input.invertPointingRelations";
    public static final String PROP_POINTING_RELATION_EDGE_ANNOTATION = "treetagger.input.pointingRelationEdgeAnnotation";
    public static final String PROP_POINTING_RELATION_SUPPRESS_ID = "treetagger.input.pointingRelationSuppressID";
    public static final String PROP_POINTING_RELATION_SUPPRESS_TARGET = "treetagger.input.pointingRelationSuppressTarget";
    public static final String PROP_POINTING_RELATION_SUPPRESS_LABEL = "treetagger.input.pointingRelationSuppressLabel";
    public static final String PROP_POINTING_RELATION_USE_HASHTAG = "treetagger.input.pointingRelationUseHash";
    public static final String PROP_SPAN_ANNO_NAMESPACE = "treetagger.input.spanAnnotationNamespace";
    public static final String PROP_SEPARATE_SPAN_ANNOS = "treetagger.input.separateSpanAnnotations";
    public static final String PROP_ANNOTATE_ALL_SPANS_WITH_NAME = "treetagger.input.annotateAllSpansWithSpanName";
    public static final String PROP_META_TAG = "treetagger.input.metaTag";
    public static final String PROP_FILE_ENCODING = "treetagger.input.fileEncoding";
    public static final String PROP_COLUMN_NAMES = "columnNames";
    public static final String COLUMN_NAMES_SEPARATOR = ",";
    public static final String COLUMN_NAMES_TOK = "tok";
    public static final String PROP_SEPARATOR_AFTER_TOKEN = "treetagger.input.separatorAfterToken";
    private static final Pattern PATTERN_PROP_INPUT_COLUMNS = Pattern.compile("treetagger\\.input\\.column");
    private static final String DEFAULT_POS_NAME = "pos";
    private static final String DEFAULT_LEMMA_NAME = "lemma";
    public static final String PROP_PREFIX_SPAN_ANNOS_WITH_ELEMENT = "treetagger.input.prefixElementToAttributes";
    public static final String PROP_PREFIX_ELEMENT_SEPARATOR = "treetagger.input.prefixElementSeparator";
    public static final String PROP_TOKEN_REPLACEMENTS = "treetagger.input.replaceTokens";
    public static final String PROP_ANNO_REPLACEMENTS = "treetagger.input.replacementsInAnnos";
    private Map<String, String> replacementMapping = null;

    public TreetaggerImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_ANNOTATE_UNANNOTATED_SPANS, Boolean.class, "If set true, this switch will cause the module to annotate all spans without attributes with their name as attribute and value.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_ANNOTATE_ALL_SPANS_WITH_NAME, Boolean.class, "If set true, this switch will cause the module to annotate all spans with their name as attribute and value.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_META_TAG, String.class, "States the meta tag used to mark the TreeTagger document in the input file(s).", (Object)"meta", false));
        this.addProperty(new PepperModuleProperty(PROP_SPAN_ANNO_NAMESPACE, String.class, "Namespace to give to span annotations.", null, false));
        this.addProperty(new PepperModuleProperty(PROP_SEPARATE_SPAN_ANNOS, String.class, "Comma separated list of span attribute names for which separate nodes should be generated", null, false));
        this.addProperty(new PepperModuleProperty(PROP_SEPARATOR_AFTER_TOKEN, String.class, "Determines the separator which should be artificially added after a token, when mapping treetagger token to STextualDS in Salt. The default separator is a whitespace given by the character sequence \" \". Note, the separator sequence, must be surrunded by double quotes. To shut of the adding of a separator, just this property value to \"\"", (Object)" ", false));
        this.addProperty(new PepperModuleProperty(PROP_FILE_ENCODING, String.class, "Determines the encoding of the input files. ", (Object)"UTF-8", false));
        this.addProperty(new PepperModuleProperty(PROP_PREFIX_SPAN_ANNOS_WITH_ELEMENT, Boolean.class, "Set to true to add the element name as a prefix to all span element attribute annotations.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_PREFIX_ELEMENT_SEPARATOR, String.class, "Separator to use when prefixing span attribute annotations with element name.", (Object)"_", false));
        this.addProperty(new PepperModuleProperty(PROP_TOKEN_REPLACEMENTS, String.class, "Specify values to find and replace in tokens. This value is a comma separated list of mappings: \"REPLACED_STRING\" : \"REPLACEMENT\" (, \"REPLACED_STRING\" : \"REPLACEMENT\")*", (Object)""));
        this.addProperty(new PepperModuleProperty(PROP_ANNO_REPLACEMENTS, Boolean.class, "If true, make token replacement patterns apply to annotations as well.", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_COLUMN_NAMES, String.class, "Property to determine the column names. The value is a comma separated list, starting with the value 'tok'. The default value is 'tok, pos, lemma'.", (Object)"tok, pos, lemma", false));
        this.addProperty(new PepperModuleProperty(PROP_MAKE_POINTING_RELATIONS, Boolean.class, "If set true, the importer attempts to read pointing relations from selected span annotations.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_TARGET_ANNOTATION, String.class, "The name of a span annotation attribute containing an attribute encoding the id of target spans", (Object)"head", false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_ID_ANNOTATION, String.class, "The name of a span annotation attribute containing the id referred to in target annotations", (Object)"id", false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_TYPE, String.class, "The edge type to assign to pointing relations.", (Object)"dep", false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_NS, String.class, "The namespace to assign to pointing relations.", (Object)"dep", false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_EDGE_ANNOTATION, String.class, "The name of a span annotation attribute containing annotation labels to add as edge annotations to pointing relations", (Object)"func", false));
        this.addProperty(new PepperModuleProperty(PROP_INVERT_POINTING_RELATIONS, String.class, "If set to 'true', pointing relations point towards spans with a pointing relation target annotation, instead of from them.", (Object)"true", false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_USE_HASHTAG, Boolean.class, "If set true, pointing relations targets with hashtag are interpreted as href syntax (hashtag is ignored in target).", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_SUPPRESS_ID, Boolean.class, "If set true, ID annotation of pointing relation markers is not imported as span annotation.", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_SUPPRESS_TARGET, Boolean.class, "If set true, target annotation of pointing relation markers is not imported as span annotation.", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_POINTING_RELATION_SUPPRESS_LABEL, Boolean.class, "If set true, label annotation of pointing relation markers is not imported as span annotation.", (Object)true, false));
    }

    public Boolean getAnnotateUnannotatedSpans() {
        return (Boolean)this.getProperty(PROP_ANNOTATE_UNANNOTATED_SPANS).getValue();
    }

    public Boolean getMakePointingRelations() {
        return (Boolean)this.getProperty(PROP_MAKE_POINTING_RELATIONS).getValue();
    }

    public List<Boolean> getInvertPointingRelations() {
        LinkedList<Boolean> bools = new LinkedList<Boolean>();
        String propVal = (String)this.getProperty(PROP_INVERT_POINTING_RELATIONS).getValue();
        List<String> sepProps = this.splitStringByAndTrim(propVal, COLUMN_NAMES_SEPARATOR);
        for (String prop : sepProps) {
            if (prop.toLowerCase().equals("true")) {
                bools.add(Boolean.TRUE);
                continue;
            }
            bools.add(Boolean.FALSE);
        }
        return bools;
    }

    public Boolean getSuppressPRID() {
        return (Boolean)this.getProperty(PROP_POINTING_RELATION_SUPPRESS_ID).getValue();
    }

    public Boolean getPRUseHash() {
        return (Boolean)this.getProperty(PROP_POINTING_RELATION_USE_HASHTAG).getValue();
    }

    public Boolean getSuppressPRTarget() {
        return (Boolean)this.getProperty(PROP_POINTING_RELATION_SUPPRESS_TARGET).getValue();
    }

    public Boolean getSuppressPRLabel() {
        return (Boolean)this.getProperty(PROP_POINTING_RELATION_SUPPRESS_LABEL).getValue();
    }

    public List<String> getPointingTargetAnno() {
        String propVal = (String)this.getProperty(PROP_POINTING_RELATION_TARGET_ANNOTATION).getValue();
        List<String> sepProps = this.splitStringByAndTrim(propVal, COLUMN_NAMES_SEPARATOR);
        return sepProps;
    }

    public String[] getSeparateSpanAnnos() {
        String annoList = (String)this.getProperty(PROP_SEPARATE_SPAN_ANNOS).getValue();
        String[] annos = null;
        if (annoList != null) {
            annos = annoList.split(COLUMN_NAMES_SEPARATOR);
        }
        return annos;
    }

    public List<String> getPointingIDAnno() {
        String propVal = (String)this.getProperty(PROP_POINTING_RELATION_ID_ANNOTATION).getValue();
        List<String> sepProps = this.splitStringByAndTrim(propVal, COLUMN_NAMES_SEPARATOR);
        return sepProps;
    }

    public List<String> getPointingType() {
        String propVal = (String)this.getProperty(PROP_POINTING_RELATION_TYPE).getValue();
        List<String> sepProps = this.splitStringByAndTrim(propVal, COLUMN_NAMES_SEPARATOR);
        return sepProps;
    }

    public String getSpanAnnotationNamespace() {
        return (String)this.getProperty(PROP_SPAN_ANNO_NAMESPACE).getValue();
    }

    public List<String> getPointingNS() {
        String propVal = (String)this.getProperty(PROP_POINTING_RELATION_NS).getValue();
        List<String> sepProps = this.splitStringByAndTrim(propVal, COLUMN_NAMES_SEPARATOR);
        return sepProps;
    }

    public List<String> getPointingEdgeAnno() {
        String propVal = (String)this.getProperty(PROP_POINTING_RELATION_EDGE_ANNOTATION).getValue();
        List<String> sepProps = this.splitStringByAndTrim(propVal, COLUMN_NAMES_SEPARATOR);
        return sepProps;
    }

    public Boolean getAnnotateAllSpansWithName() {
        return (Boolean)this.getProperty(PROP_ANNOTATE_ALL_SPANS_WITH_NAME).getValue();
    }

    public Boolean getPrefixSpanAnnotation() {
        return (Boolean)this.getProperty(PROP_PREFIX_SPAN_ANNOS_WITH_ELEMENT).getValue();
    }

    public String getPrefixSpanSeparator() {
        return (String)this.getProperty(PROP_PREFIX_ELEMENT_SEPARATOR).getValue();
    }

    public String getSeparatorAfterToken() {
        String separator = (String)this.getProperty(PROP_SEPARATOR_AFTER_TOKEN).getValue();
        separator.replace("\"", "");
        return separator;
    }

    public Map<String, String> getReplacementMapping() {
        PepperModuleProperty prop;
        String replacements;
        if (this.replacementMapping == null && (replacements = (String)(prop = this.getProperty(PROP_TOKEN_REPLACEMENTS)).getValue()) != null && !replacements.isEmpty()) {
            this.replacementMapping = new Hashtable<String, String>();
            String[] singleMappings = replacements.split(COLUMN_NAMES_SEPARATOR);
            if (singleMappings.length > 0) {
                for (String singleMapping : singleMappings) {
                    String[] parts = singleMapping.split(":");
                    if (parts.length != 2) continue;
                    this.replacementMapping.put(parts[0].trim().replace("\"", ""), parts[1].trim().replace("\"", ""));
                }
            }
        }
        return this.replacementMapping;
    }

    public Boolean getReplaceInAnnos() {
        return (Boolean)this.getProperty(PROP_ANNO_REPLACEMENTS).getValue();
    }

    public List<String> getColumnNames() {
        String columnNamesAsString = this.getProperty(PROP_COLUMN_NAMES).getValue().toString();
        List<String> columnNames = this.splitStringByAndTrim(columnNamesAsString, COLUMN_NAMES_SEPARATOR);
        columnNames = this.whenColumnNamesDoesNotStartWithTokThenAddTok(columnNames);
        return columnNames;
    }

    private List<String> whenColumnNamesDoesNotStartWithTokThenAddTok(List<String> columnNames) {
        if (!COLUMN_NAMES_TOK.equalsIgnoreCase(columnNames.get(0))) {
            columnNames.add(0, COLUMN_NAMES_TOK);
        }
        return columnNames;
    }

    private List<String> splitStringByAndTrim(String columnNamesAsString, String separator) {
        String[] entriesAsArray;
        ArrayList<String> entries = new ArrayList<String>();
        for (String entry : entriesAsArray = columnNamesAsString.split(separator)) {
            entries.add(entry.trim());
        }
        return entries;
    }
}

