/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger;

import com.google.common.base.Strings;
import java.util.List;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.treetagger.TreetaggerImporterProperties;
import org.corpus_tools.peppermodules.treetagger.mapper.Treetagger2SaltMapper;
import org.corpus_tools.peppermodules.treetagger.model.Document;
import org.corpus_tools.peppermodules.treetagger.model.impl.Treetagger;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="TreetaggerImporterComponent", factory="PepperImporterComponentFactory")
public class TreetaggerImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String[] TREETAGGER_FILE_ENDINGS = new String[]{"treetagger", "tab", "tt", "txt", "xml"};
    private static final Pattern TREETAGGER_MATCH_PATTERN = Pattern.compile("[a-zA-Z0-9]+(\t[a-zA-Z0-9]+)*");

    public TreetaggerImporter() {
        this.setName("TreetaggerImporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-TreetaggerModules"));
        this.setDesc("This importer transforms data in TreeTagger format produced by the TreeTagger tool (see http://www.cis.uni-muenchen.de/~schmid/tools/TreeTagger/) to a Salt model. ");
        this.addSupportedFormat("treetagger", "1.0", null);
        this.setProperties(new TreetaggerImporterProperties());
        for (String ending : TREETAGGER_FILE_ENDINGS) {
            this.getDocumentEndings().add(ending);
        }
    }

    public Double isImportable(URI corpusPath) {
        Double retValue = 0.0;
        for (String content : this.sampleFileContent(corpusPath, TREETAGGER_FILE_ENDINGS)) {
            if (Strings.isNullOrEmpty((String)content) || !TREETAGGER_MATCH_PATTERN.matcher(content).find()) continue;
            retValue = 1.0;
            break;
        }
        return retValue;
    }

    public SelfTestDesc getSelfTestDesc() {
        return new SelfTestDesc(this.getResources().appendSegment("selfTests").appendSegment("treetaggerImporter").appendSegment("in"), this.getResources().appendSegment("selfTests").appendSegment("treetaggerImporter").appendSegment("expected"));
    }

    public PepperMapper createPepperMapper(Identifier identifier) {
        Treetagger2SaltMapper mapper = new Treetagger2SaltMapper();
        if (identifier.getIdentifiableElement() instanceof SDocument) {
            URI uri = (URI)this.getIdentifier2ResourceTable().get(identifier);
            Document tDocument = this.loadFromFile(uri);
            if (tDocument == null) {
                mapper = null;
            } else {
                mapper.setTTDocument(tDocument);
            }
        }
        return mapper;
    }

    private Document loadFromFile(URI uri) {
        if (uri == null) {
            return null;
        }
        List<String> columnNames = ((TreetaggerImporterProperties)this.getProperties()).getColumnNames();
        String metaTag = this.getProperties().getProperty("treetagger.input.metaTag").getValue().toString();
        String fileEncoding = this.getProperties().getProperty("treetagger.input.fileEncoding").getValue().toString();
        List<Document> documents = Treetagger.deserialize().withFileEncoding(fileEncoding).withMetaTagName(metaTag).withColumnNames(columnNames).from(uri);
        if (documents.isEmpty()) {
            return null;
        }
        return documents.get(0);
    }
}

