/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger;

import java.util.List;
import java.util.Vector;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class TreetaggerExporterProperties
extends PepperModuleProperties {
    public static final String PREFIX = "treetagger.input.";
    public static final String PROP_FILE_EXTENSION = "treetagger.fileExtension";
    public static final String PROP_EXPORT_ANNOS = "treetagger.exportAnnotations";
    public static final String PROP_FLATTEN = "treetagger.output.flatten";
    public static final String FILE_ENDING = "tt";
    public static final String PROP_REPLACE_GENERIC_SPAN_NAMES = "treetagger.output.replaceGenericSpanNames";
    public static final String PROP_META_TAG = "treetagger.output.metaTag";
    private List<String> exportAnnos = null;

    public TreetaggerExporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_FILE_EXTENSION, String.class, "This property determines the ending of TreeTagger files, which are exported. The default value is 'tt'.", (Object)FILE_ENDING, false));
        this.addProperty(new PepperModuleProperty(PROP_EXPORT_ANNOS, String.class, "If set true, each AnyAnnotation of tokens will appear in the output file.", false));
        this.addProperty(new PepperModuleProperty(PROP_FLATTEN, Boolean.class, "If set true, the output directory structure is flat: all documents are put in the output root \tdirectory.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_REPLACE_GENERIC_SPAN_NAMES, Boolean.class, "If set true, generic span names like 'sSpan123' will be replaced with the first annotation \tof the span found. If the span has no annotations, the generic name will not be replaced.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_META_TAG, String.class, "Sets the meta tag used to mark the TreeTagger document in the output file(s).", (Object)"meta", false));
    }

    public String getFileEnding() {
        return (String)this.getProperty(PROP_FILE_EXTENSION).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getExportAnnos() {
        if (this.exportAnnos == null) {
            TreetaggerExporterProperties treetaggerExporterProperties = this;
            synchronized (treetaggerExporterProperties) {
                if (this.exportAnnos == null) {
                    String[] exportAnnos;
                    this.exportAnnos = new Vector<String>();
                    for (String exportAnno : exportAnnos = ((String)this.getProperty(PROP_EXPORT_ANNOS).getValue()).split(",")) {
                        this.exportAnnos.add(exportAnno.trim());
                    }
                }
            }
        }
        return this.exportAnnos;
    }

    public Boolean isFlatten() {
        return (Boolean)this.getProperty(PROP_FLATTEN).getValue();
    }

    public Boolean isReplaceGenericSpanNamesProperty() {
        return (Boolean)this.getProperty(PROP_REPLACE_GENERIC_SPAN_NAMES).getValue();
    }
}

