/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.treetagger;

import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperExporterImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.treetagger.TreetaggerExporterProperties;
import org.corpus_tools.peppermodules.treetagger.mapper.Salt2TreetaggerMapper;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="TreetaggerExporterComponent", factory="PepperExporterComponentFactory")
public class TreetaggerExporter
extends PepperExporterImpl
implements PepperExporter {
    public TreetaggerExporter() {
        this.setName("TreetaggerExporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-TreetaggerModules"));
        this.setDesc("This exporter transforms a Salt model into the TreeTagger format produced by the TreeTagger tool (see http://www.cis.uni-muenchen.de/~schmid/tools/TreeTagger/). ");
        this.addSupportedFormat("treetagger", "1.0", null);
        this.setProperties(new TreetaggerExporterProperties());
        this.setExportMode(PepperExporter.EXPORT_MODE.DOCUMENTS_IN_FILES);
        this.setDocumentEnding("tt");
    }

    public SelfTestDesc getSelfTestDesc() {
        return new SelfTestDesc(this.getResources().appendSegment("selfTests").appendSegment("treetaggerExporter").appendSegment("in"), this.getResources().appendSegment("selfTests").appendSegment("treetaggerExporter").appendSegment("expected"));
    }

    public PepperMapper createPepperMapper(Identifier identifier) {
        Salt2TreetaggerMapper mapper = new Salt2TreetaggerMapper();
        if (identifier.getIdentifiableElement() instanceof SDocument) {
            mapper.setResourceURI((URI)this.getIdentifier2ResourceTable().get(identifier));
        }
        return mapper;
    }
}

