/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper_WebannoTSVModule;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper_WebannoTSVModule.WebannoTSVAnnotation;
import org.corpus_tools.pepper_WebannoTSVModule.WebannoTSVEdge;
import org.corpus_tools.pepper_WebannoTSVModule.WebannoTSVImporterProperties;
import org.corpus_tools.pepper_WebannoTSVModule.WebannoTSVMarkable;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleConnectorFactory;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleReader;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebannoTSV2SaltMapper
extends PepperMapperImpl {
    private String namespace;
    private String tokAnnos;
    private boolean lowercaseTypes;
    private SLayer layer;
    private static final Logger logger = LoggerFactory.getLogger(WebannoTSV2SaltMapper.class);

    public WebannoTSV2SaltMapper() {
        this.setProperties(new WebannoTSVImporterProperties());
    }

    public DOCUMENT_STATUS mapSCorpus() {
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        this.namespace = this.getProperties().getProperties().getProperty("WebannoTSV.namespace", "webanno");
        this.tokAnnos = this.getProperties().getProperties().getProperty("WebannoTSV.tokAnnos", "");
        this.lowercaseTypes = Boolean.valueOf(this.getProperties().getProperties().getProperty("WebannoTSV.lowerTypes"));
        String[] tokAnnoList = this.tokAnnos.split(";");
        if (this.namespace != null) {
            this.layer = SaltFactory.createSLayer();
            this.layer.setName(this.namespace);
            this.layer.setGraph((Graph)this.getDocument().getDocumentGraph());
        }
        URI resource = this.getResourceURI();
        logger.debug("Importing the file {}.", (Object)resource.toFileString());
        TupleReader tupleReader = TupleConnectorFactory.fINSTANCE.createTupleReader();
        try {
            tupleReader.setSeperator("\t");
            tupleReader.setFile(new File(this.getResourceURI().toFileString()));
            tupleReader.readFile();
        }
        catch (IOException e) {
            String errorMessage = "Input file could not be read. Aborting conversion of file " + this.getResourceURI() + ".";
            logger.error(errorMessage);
            throw new PepperModuleDataException((PepperMapper)this, errorMessage);
        }
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        sTextualDS.setGraph((Graph)this.getDocument().getDocumentGraph());
        LinkedHashMap<String, WebannoTSVMarkable> spanAnnoMap = new LinkedHashMap<String, WebannoTSVMarkable>();
        LinkedList<WebannoTSVEdge> pointingRelationList = new LinkedList<WebannoTSVEdge>();
        ArrayList fieldValues = new ArrayList();
        Collection tuple = null;
        int numOfTuples = tupleReader.getNumOfTuples();
        boolean fieldNum = true;
        float processedTuples = 0.0f;
        ArrayList<WebannoTSVAnnotation> annotations = new ArrayList<WebannoTSVAnnotation>();
        int stringBuilderCharBufferSize = tupleReader.characterSize(Integer.valueOf(2)) + numOfTuples;
        StringBuilder primaryText = new StringBuilder(stringBuilderCharBufferSize);
        for (int rowIndex = 0; rowIndex < numOfTuples; ++rowIndex) {
            try {
                tuple = tupleReader.getTuple();
            }
            catch (IOException e) {
                String[] errorMessage = String.format("line %d of input file could not be read. Abort conversion of file " + this.getResourceURI() + ".", rowIndex + 1);
                throw new PepperModuleDataException((PepperMapper)this, (String)errorMessage);
            }
            int tupleSize = tuple.size();
            fieldValues.clear();
            if (tupleSize == 1) {
                String fieldValue = (String)tuple.iterator().next();
                if (fieldNum && fieldValue.startsWith("#T_")) {
                    String[] annoSpecs;
                    WebannoTSVAnnotation.WebannoTSVAnnotationType nodeType = fieldValue.startsWith("#T_RL") ? WebannoTSVAnnotation.WebannoTSVAnnotationType.RELATION : WebannoTSVAnnotation.WebannoTSVAnnotationType.SPAN;
                    String[] declParts = fieldValue.split("=");
                    if (declParts.length > 1 && (annoSpecs = declParts[1].split("\\|")).length > 1) {
                        String nodeName = annoSpecs[0];
                        nodeName = nodeName.replace("webanno.custom.", "");
                        nodeName = nodeName.replaceAll("de.tudarmstadt.ukp.dkpro\\..+\\.", "");
                        if (this.lowercaseTypes) {
                            nodeName = nodeName.toLowerCase();
                        }
                        if (nodeType == WebannoTSVAnnotation.WebannoTSVAnnotationType.SPAN) {
                            for (String anno : Arrays.copyOfRange(annoSpecs, 1, annoSpecs.length)) {
                                annotations.add(new WebannoTSVAnnotation(nodeType, nodeName, anno));
                            }
                        } else if (nodeType == WebannoTSVAnnotation.WebannoTSVAnnotationType.RELATION) {
                            for (String anno : Arrays.copyOfRange(annoSpecs, 1, annoSpecs.length - 1)) {
                                annotations.add(new WebannoTSVAnnotation(nodeType, nodeName, anno, annoSpecs.length - 2));
                            }
                        }
                    }
                }
            } else if (tupleSize > 2) {
                Iterator iter = tuple.iterator();
                String tokID = (String)iter.next();
                String textOffset = (String)iter.next();
                String tokText = (String)iter.next();
                SToken sToken = SaltFactory.createSToken();
                sToken.setGraph((Graph)this.getDocument().getDocumentGraph());
                int tokenTextStartOffset = primaryText.length();
                primaryText.append(tokText).append(" ");
                int tokenTextEndOffset = primaryText.length() - 1;
                STextualRelation sTextualRelation = SaltFactory.createSTextualRelation();
                sTextualRelation.setSource((Node)sToken);
                sTextualRelation.setTarget((Node)sTextualDS);
                sTextualRelation.setStart((Number)tokenTextStartOffset);
                sTextualRelation.setEnd((Number)tokenTextEndOffset);
                sTextualRelation.setGraph((Graph)this.getDocument().getDocumentGraph());
                int annoIndex = 0;
                while (iter.hasNext()) {
                    String annoField = (String)iter.next();
                    if (!annoField.equals("_")) {
                        String[] sepAnnos;
                        if (annoIndex >= annotations.size()) continue;
                        WebannoTSVAnnotation currentAnno = (WebannoTSVAnnotation)annotations.get(annoIndex);
                        if (currentAnno.getType() == WebannoTSVAnnotation.WebannoTSVAnnotationType.SPAN) {
                            for (String sepAnno : sepAnnos = annoField.split("\\|")) {
                                WebannoTSVMarkable mark;
                                String markID;
                                String annoVal;
                                if (sepAnno.contains("[")) {
                                    String[] temp = sepAnno.split("\\[");
                                    annoVal = temp[0];
                                    markID = temp[1].substring(0, temp[1].length() - 1);
                                } else {
                                    annoVal = sepAnno;
                                    markID = tokID;
                                }
                                if (spanAnnoMap.containsKey(markID)) {
                                    mark = (WebannoTSVMarkable)spanAnnoMap.get(markID);
                                } else {
                                    mark = new WebannoTSVMarkable();
                                    spanAnnoMap.put(markID, mark);
                                }
                                mark.addToken(sToken);
                                mark.addAnnotation(this.namespace, currentAnno.getAnnoName(), annoVal);
                                if (Arrays.asList(tokAnnoList).contains(currentAnno.getAnnoName())) {
                                    mark.setIsTokAnno(true);
                                }
                                mark.setNodeName(currentAnno.getNodeName());
                            }
                            if (annoIndex >= annotations.size()) continue;
                            ++annoIndex;
                            continue;
                        }
                        if (currentAnno.getType() != WebannoTSVAnnotation.WebannoTSVAnnotationType.RELATION) continue;
                        int numCols = currentAnno.getNumSisters();
                        for (int j = 1; j < numCols; ++j) {
                            annoField = annoField + "\t" + (String)iter.next();
                        }
                        if (!iter.hasNext()) {
                            throw new PepperModuleDataException((PepperMapper)this, "Insufficient columns found. Annotation field is: " + annoField + " and currentAnnos is: " + currentAnno.getAnnoName() + " which has n sisters: " + currentAnno.getNumSisters());
                        }
                        String relField = (String)iter.next();
                        String[] sepRels = relField.split("\\|");
                        String[] sepAnnoField = annoField.split("\t");
                        for (int j = 0; j < numCols; ++j) {
                            String edgeAnnoValues = sepAnnoField[j];
                            if (j != 0) {
                                currentAnno = (WebannoTSVAnnotation)annotations.get(++annoIndex);
                            }
                            sepAnnos = edgeAnnoValues.split("\\|");
                            if (sepAnnos.length < sepRels.length) {
                                logger.warn("Ignored relation because there were more annotations than edges: " + edgeAnnoValues + "<>" + relField + "\n");
                                continue;
                            }
                            for (int i = 0; i < sepAnnos.length; ++i) {
                                String position;
                                if (i >= sepRels.length) {
                                    throw new PepperModuleDataException((PepperMapper)this, "Missing edge information for: " + edgeAnnoValues + ":" + relField + "\n");
                                }
                                String edgeAnnoValue = sepAnnos[i];
                                String edgeSourceTarget = sepRels[i];
                                String source = "0";
                                String target = "0";
                                if (edgeSourceTarget.contains("[") && edgeSourceTarget.contains("_")) {
                                    String[] position_source_target = edgeSourceTarget.split("\\[");
                                    position = position_source_target[0];
                                    String[] source_target = position_source_target[1].split("_");
                                    source = source_target[0];
                                    target = source_target[1].substring(0, source_target[1].length() - 1);
                                } else {
                                    position = edgeSourceTarget;
                                }
                                if (target.equals("0")) {
                                    target = tokID;
                                }
                                if (source.equals("0")) {
                                    source = position;
                                }
                                WebannoTSVEdge rel = new WebannoTSVEdge(source, target, currentAnno.getNodeName(), currentAnno.getAnnoName(), edgeAnnoValue);
                                pointingRelationList.add(rel);
                            }
                        }
                        if (annoIndex >= annotations.size()) continue;
                        ++annoIndex;
                        continue;
                    }
                    if (annoIndex >= annotations.size()) continue;
                    ++annoIndex;
                }
            }
            if (rowIndex / numOfTuples * 100 % 10 != 0) continue;
            this.addProgress(Double.valueOf(rowIndex / numOfTuples));
        }
        primaryText.deleteCharAt(primaryText.length() - 1);
        sTextualDS.setText(primaryText.toString());
        HashMap<String, Object> spanIDMap = new HashMap<String, Object>();
        for (Map.Entry entry : spanAnnoMap.entrySet()) {
            String ID = (String)entry.getKey();
            WebannoTSVMarkable mark = (WebannoTSVMarkable)entry.getValue();
            ArrayList<SToken> toksToCover = mark.getTokens();
            if (mark.isIsTokAnno()) {
                SToken thisTok = toksToCover.get(0);
                for (SAnnotation anno : mark.getAnnotations()) {
                    if (thisTok.getAnnotation(anno.getNamespace(), anno.getName()) != null) continue;
                    thisTok.addAnnotation(anno);
                }
                spanIDMap.put(ID, thisTok);
                continue;
            }
            SSpan sSpan = this.getDocument().getDocumentGraph().createSpan(toksToCover);
            if (this.namespace != null) {
                if (sSpan == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "Null span detected, created from markable object: " + mark.toString());
                }
                sSpan.addLayer((Layer)this.layer);
            }
            if (mark.getNodeName() != null) {
                sSpan.setName(mark.getNodeName());
            }
            spanIDMap.put(ID, sSpan);
            for (SAnnotation anno : mark.getAnnotations()) {
                if (sSpan.getAnnotation(anno.getNamespace(), anno.getName()) != null) continue;
                sSpan.addAnnotation(anno);
            }
        }
        for (WebannoTSVEdge edge : pointingRelationList) {
            if (edge.getSourceID().equals(edge.getTargetID())) continue;
            SPointingRelation sRel = SaltFactory.createSPointingRelation();
            if (!spanIDMap.containsKey(edge.getSourceID())) {
                throw new PepperModuleDataException((PepperMapper)this, "Input error: relation with missing source element: " + edge.getSourceID() + "\n");
            }
            sRel.setSource((Node)spanIDMap.get(edge.getSourceID()));
            if (!spanIDMap.containsKey(edge.getTargetID())) {
                throw new PepperModuleDataException((PepperMapper)this, "Input error: relation with missing target element: " + edge.getTargetID() + "\n");
            }
            sRel.setTarget((Node)spanIDMap.get(edge.getTargetID()));
            sRel.setType(edge.getType());
            SAnnotation relAnno = SaltFactory.createSAnnotation();
            relAnno.setName(edge.getAnnoName());
            relAnno.setValue((Object)edge.getAnnoValue());
            sRel.addAnnotation(relAnno);
            this.getDocument().getDocumentGraph().addRelation((Relation)sRel);
            if (this.namespace == null) continue;
            relAnno.setNamespace(this.namespace);
            sRel.addLayer((Layer)this.layer);
        }
        return DOCUMENT_STATUS.COMPLETED;
    }
}

