/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis.resolver;

import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.corpus_tools.peppermodules.annis.resolver.QName;

public class VirtualTokenStatistics {
    private final ConcurrentMap<String, QName> virtualAnnoNames = new ConcurrentHashMap<String, QName>();
    private final AtomicBoolean hasRealToken = new AtomicBoolean(false);
    private final Pattern patternNoToken = Pattern.compile("[0-9 ]*");

    public void addVirtualAnnoName(String ns, String name) {
        this.virtualAnnoNames.put(name, new QName(ns, name));
    }

    public Set<QName> getVirtualAnnoNames() {
        return new TreeSet<QName>(this.virtualAnnoNames.values());
    }

    public void checkRealToken(String span) {
        if (!this.patternNoToken.matcher(span).matches()) {
            this.hasRealToken.set(true);
        }
    }

    public boolean getHasRealToken() {
        return this.hasRealToken.get();
    }

    public void merge(VirtualTokenStatistics other) {
        this.virtualAnnoNames.putAll(other.virtualAnnoNames);
        this.hasRealToken.set(this.hasRealToken.get() || other.hasRealToken.get());
    }
}

