/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis.resolver;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StatTableCounter<ValueType> {
    private final Table<String, ValueType, AtomicInteger> values = HashBasedTable.create();
    private final Set<String> layers;

    public StatTableCounter(Set<String> layers) {
        this.layers = layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String layer, ValueType col, int delta) {
        Table<String, ValueType, AtomicInteger> table = this.values;
        synchronized (table) {
            if (this.values.get((Object)layer, col) == null) {
                this.values.put((Object)layer, col, (Object)new AtomicInteger(0));
            }
            ((AtomicInteger)this.values.get((Object)layer, col)).addAndGet(delta);
        }
        this.layers.add(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(StatTableCounter<? extends ValueType> other) {
        Table<String, ValueType, AtomicInteger> table = this.values;
        synchronized (table) {
            for (Table.Cell c : other.values.cellSet()) {
                AtomicInteger i = (AtomicInteger)this.values.get(c.getRowKey(), c.getColumnKey());
                if (i == null) {
                    this.values.put(c.getRowKey(), c.getColumnKey(), c.getValue());
                } else {
                    i.addAndGet(((AtomicInteger)c.getValue()).get());
                }
                this.layers.add((String)c.getRowKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Integer, ValueType> getBySize(String layer) {
        TreeMap result = new TreeMap();
        Table<String, ValueType, AtomicInteger> table = this.values;
        synchronized (table) {
            for (Map.Entry e : this.values.row((Object)layer).entrySet()) {
                result.put(((AtomicInteger)e.getValue()).get(), e.getKey());
            }
        }
        return result;
    }
}

