/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.corpus_tools.peppermodules.annis.resolver.QName;
import org.corpus_tools.peppermodules.annis.resolver.StatMultiMap;

public class PointingStatistics {
    private final Set<QName> layers = Collections.synchronizedSet(new HashSet());
    private final StatMultiMap<QName, QName> terminalAnno = new StatMultiMap(this.layers);
    private final ReadWriteLock numberOfNodeLock = new ReentrantReadWriteLock();
    private long numberOfNodes = 0L;
    private long maxNumberOfNodes = 0L;

    public void addLayer(QName layer) {
        this.layers.add(layer);
    }

    public Set<QName> getLayers() {
        return new HashSet<QName>(this.layers);
    }

    public void setNodeCount(long newCount) {
        this.numberOfNodeLock.writeLock().lock();
        try {
            this.numberOfNodes = newCount;
            this.maxNumberOfNodes = Math.max(this.maxNumberOfNodes, this.numberOfNodes);
        }
        finally {
            this.numberOfNodeLock.writeLock().unlock();
        }
    }

    public long getNodeCount() {
        this.numberOfNodeLock.readLock().lock();
        try {
            long l = this.numberOfNodes;
            return l;
        }
        finally {
            this.numberOfNodeLock.readLock().unlock();
        }
    }

    public long getMaxNodeCount() {
        this.numberOfNodeLock.readLock().lock();
        try {
            long l = this.maxNumberOfNodes;
            return l;
        }
        finally {
            this.numberOfNodeLock.readLock().unlock();
        }
    }

    public void merge(PointingStatistics other) {
        this.layers.addAll(other.layers);
        this.terminalAnno.merge(other.terminalAnno);
        this.numberOfNodeLock.writeLock().lock();
        try {
            this.maxNumberOfNodes = Math.max(this.maxNumberOfNodes, other.numberOfNodes);
        }
        finally {
            this.numberOfNodeLock.writeLock().unlock();
        }
    }

    public StatMultiMap<QName, QName> getTerminalAnno() {
        return this.terminalAnno;
    }
}

