/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.peppermodules.annis.resolver.QName;
import org.corpus_tools.peppermodules.annis.resolver.StatMultiMap;
import org.corpus_tools.peppermodules.annis.resolver.StatTableCounter;
import org.corpus_tools.salt.core.SAnnotation;

public class DomStatistics {
    private final Set<String> layers = Collections.synchronizedSet(new HashSet());
    private final StatTableCounter<String> edgeTypeCounter = new StatTableCounter(this.layers);
    private final StatMultiMap<String, QName> terminalAnno = new StatMultiMap(this.layers);
    private final StatMultiMap<String, String> terminalEdgeType = new StatMultiMap(this.layers);
    private final StatMultiMap<String, QName> edgeAnno = new StatMultiMap(this.layers);
    private final StatTableCounter<QName> nodeAnnoCounter = new StatTableCounter(this.layers);

    public void addRelationType(String layer, String type) {
        if (type != null) {
            this.edgeTypeCounter.add(layer, type, 1);
        }
    }

    public void addRelationAnno(String layer, Set<SAnnotation> annos) {
        if (annos != null) {
            for (SAnnotation a : annos) {
                QName qname = new QName(a.getNamespace(), a.getName());
                this.edgeAnno.add(layer, qname);
            }
        }
    }

    public void addNodeAnno(String layer, Set<SAnnotation> annos) {
        if (annos != null) {
            for (SAnnotation a : annos) {
                QName qname = new QName(a.getNamespace(), a.getName());
                this.nodeAnnoCounter.add(layer, qname, 1);
            }
        }
    }

    public void addTerminalEdgeType(String layer, String type) {
        this.terminalEdgeType.add(layer, type);
    }

    public void merge(DomStatistics other) {
        this.edgeAnno.merge(other.edgeAnno);
        this.edgeTypeCounter.merge(other.edgeTypeCounter);
        this.nodeAnnoCounter.merge(other.nodeAnnoCounter);
        this.terminalAnno.merge(other.terminalAnno);
        this.terminalEdgeType.merge(other.terminalEdgeType);
    }

    public Set<String> getLayers() {
        return new HashSet<String>(this.layers);
    }

    public StatMultiMap<String, QName> getTerminalAnno() {
        return this.terminalAnno;
    }

    public StatMultiMap<String, String> getTerminalEdgeType() {
        return this.terminalEdgeType;
    }

    public StatMultiMap<String, QName> getEdgeAnno() {
        return this.edgeAnno;
    }

    public StatTableCounter<String> getEdgeTypeCounter() {
        return this.edgeTypeCounter;
    }

    public StatTableCounter<QName> getNodeAnnoCounter() {
        return this.nodeAnnoCounter;
    }
}

