/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.corpus_tools.peppermodules.annis.TupleWriterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleWriter {
    private static final Logger logger = LoggerFactory.getLogger(TupleWriter.class);
    private final Lock writerLock = new ReentrantLock();
    private String encoding = "UTF-8";
    private String sperator = "\t";
    private boolean escapeCharacters = false;
    private File outFile = null;
    private Collection<String> attNames = null;
    private final AtomicLong TAId = new AtomicLong(0L);
    private final ConcurrentHashMap<Long, TransactionFile> transactionToTmpStream = new ConcurrentHashMap();
    private ConcurrentMap<Character, String> escapeTable;

    public void addTuple(Collection<String> tuple) throws FileNotFoundException {
        Long taId = this.beginTA();
        this.addTuple(taId, tuple);
        this.commitTA(taId);
    }

    private synchronized Long getNewTAId() {
        long currTAId = this.TAId.getAndIncrement();
        return currTAId;
    }

    public long beginTA() {
        if (logger != null) {
            logger.debug("begin ta of TupleWriter '" + this.getFile() + "' with id: " + this.TAId);
        }
        Long taId = this.getNewTAId();
        this.transactionToTmpStream.put(taId, this.createNewTmpStream());
        return taId;
    }

    private TransactionFile createNewTmpStream() {
        try {
            File tmpFile = File.createTempFile("tupelwriter", ".tmp");
            TransactionFile result = new TransactionFile(tmpFile, new PrintStream((OutputStream)new FileOutputStream(tmpFile), false, this.getEncoding()));
            result.getFile().deleteOnExit();
            return result;
        }
        catch (IOException ex) {
            logger.error("Could not create temporary file", (Throwable)ex);
            return null;
        }
    }

    public void addTuple(Long TAId, Collection<String> tuple) throws FileNotFoundException {
        TransactionFile tmpFile = this.transactionToTmpStream.get(TAId);
        if (tmpFile == null) {
            TransactionFile internalTmpFile = this.createNewTmpStream();
            this.printTupelToStream(internalTmpFile.stream, tuple);
            internalTmpFile.stream.close();
        } else {
            this.printTupelToStream(tmpFile.stream, tuple);
        }
    }

    public void commitTA(Long TAId) throws FileNotFoundException {
        if (TAId == null) {
            throw new TupleWriterException("Cannot commit an empty transaction id for TupleWriter controlling file '" + this.getFile() + "'.");
        }
        if (logger != null) {
            logger.debug("commiting ta of TupleWriter '" + this.getFile() + "' with id: " + TAId);
        }
        this.copyToRealFile(TAId);
        TransactionFile tmp = this.transactionToTmpStream.remove(TAId);
        if (tmp != null) {
            tmp.stream.close();
            tmp.file.delete();
        }
    }

    public void abortTA(Long TAId) {
        TransactionFile tmp;
        if (logger != null) {
            logger.debug("aborting ta with id: " + TAId);
        }
        if ((tmp = this.transactionToTmpStream.remove(TAId)) != null) {
            tmp.stream.close();
            tmp.file.delete();
        }
    }

    private void printTupelToStream(PrintStream stream, Collection<String> tuple) {
        StringBuilder tupleAsString = new StringBuilder();
        int i = 0;
        for (String att : tuple) {
            if (this.escapeCharacters && att != null) {
                StringBuilder escaped = new StringBuilder();
                for (char chr : att.toCharArray()) {
                    String escapeString = (String)this.getEscapeTable().get(Character.valueOf(chr));
                    if (escapeString != null) {
                        escaped.append(escapeString);
                        continue;
                    }
                    escaped.append(chr);
                }
                tupleAsString.append(escaped.toString());
            } else {
                tupleAsString.append(att);
            }
            if (++i >= tuple.size()) continue;
            tupleAsString.append(this.getSeperator());
        }
        tupleAsString.append("\n");
        stream.print(tupleAsString.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToRealFile(Long TAId) {
        TransactionFile tmp = this.transactionToTmpStream.get(TAId);
        if (tmp != null) {
            this.writerLock.lock();
            try (OutputStream out = Files.newOutputStream(this.outFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                Files.copy(tmp.getFile().toPath(), out);
            }
            catch (IOException ex) {
                logger.error("Could not copy transaction file to output file", (Throwable)ex);
            }
            finally {
                this.writerLock.unlock();
            }
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setEscaping(boolean escape) {
        this.escapeCharacters = escape;
    }

    public void setEscapeTable(ConcurrentMap<Character, String> escapeTable) {
        if (escapeTable != null) {
            this.escapeTable = escapeTable;
        }
    }

    public ConcurrentMap<Character, String> getEscapeTable() {
        if (this.escapeTable == null) {
            this.escapeTable = new ConcurrentHashMap<Character, String>();
            this.escapeTable.put(Character.valueOf('\t'), "\\t");
            this.escapeTable.put(Character.valueOf('\n'), "\\n");
            this.escapeTable.put(Character.valueOf('\r'), "\\r");
            this.escapeTable.put(Character.valueOf('\\'), "\\\\");
            this.escapeTable.put(Character.valueOf('\''), "\\'");
        }
        return this.escapeTable;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFile(File out) {
        if (out == null) {
            throw new TupleWriterException("Error(TupleWriter): an empty file-object is given.");
        }
        if (out.getParent() == null) {
            throw new TupleWriterException("Cannot set the given file, because it has no parent folder: " + out + ".");
        }
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        if (out.exists()) {
            if (!out.delete()) {
                logger.error("Could not delete existing output file " + out.getAbsolutePath());
            }
            try {
                if (!out.createNewFile()) {
                    logger.error("Could create new empty output file " + out.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                logger.error("Could create new empty output file " + out.getAbsolutePath(), (Throwable)ex);
            }
        }
        this.outFile = out;
    }

    public File getFile() {
        return this.outFile;
    }

    public void setAttNames(Collection<String> attNames) {
        if (attNames == null) {
            throw new TupleWriterException("ERROR(TupleWriter): The given collection with attribute names is empty.");
        }
        this.attNames = attNames;
    }

    public Collection<String> getAttNames() {
        return this.attNames;
    }

    public void setSeperator(String seperator) {
        this.sperator = seperator;
    }

    public String getSeperator() {
        return this.sperator;
    }

    public static class TransactionFile {
        private File file;
        private PrintStream stream;

        public TransactionFile(File file, PrintStream stream) {
            this.file = file;
            this.stream = stream;
        }

        public File getFile() {
            return this.file;
        }

        public PrintStream getStream() {
            return this.stream;
        }
    }
}

