/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.annis.ANNISExporterProperties;
import org.corpus_tools.peppermodules.annis.Audio2ANNISMapper;
import org.corpus_tools.peppermodules.annis.CorpusType;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.SDominanceRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.SOrderRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.SPointingRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.SRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.SSpanningRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.STimelineRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.peppermodules.annis.resolver.DomStatistics;
import org.corpus_tools.peppermodules.annis.resolver.PointingStatistics;
import org.corpus_tools.peppermodules.annis.resolver.SpanStatistics;
import org.corpus_tools.peppermodules.annis.resolver.VirtualTokenStatistics;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Salt2ANNISMapper
extends PepperMapperImpl
implements GraphTraverseHandler {
    private final AtomicInteger numberOfMappedNodes = new AtomicInteger();
    private int numberOfDocumentNodes;
    private File outputDir;
    private final DomStatistics localDomStats = new DomStatistics();
    private final SpanStatistics localSpanStats = new SpanStatistics();
    private final PointingStatistics localPointingStats = new PointingStatistics();
    private final VirtualTokenStatistics localVirtualTokenStats = new VirtualTokenStatistics();
    private DomStatistics globalDomStats;
    private SpanStatistics globalSpanStats;
    private PointingStatistics globalPointingStats;
    private VirtualTokenStatistics globalVirtualTokenStats;
    private static final Logger logger = LoggerFactory.getLogger(Salt2ANNISMapper.class);
    private IdManager idManager = null;
    public TupleWriter tw_text = null;
    public TupleWriter tw_node = null;
    public TupleWriter tw_nodeAnno = null;
    public TupleWriter tw_rank = null;
    public TupleWriter tw_edgeAnno = null;
    public TupleWriter tw_component = null;
    public TupleWriter tw_corpus = null;
    public TupleWriter tw_corpusMeta = null;
    public TupleWriter tw_visualization = null;
    public String individualCorpusName = null;
    private Pair<String, String> individualCorpusNameReplacement = null;
    public boolean isTestMode = false;
    private boolean mergeTextsWithTimeline = true;
    private SCorpusGraph sCorpusGraph = null;
    private TRAVERSION_TYPE currTraversionType = null;
    private Long prePostOrder = null;
    private boolean mapRelationsInParallel = true;
    private ConcurrentMap<SNode, Long> preorderTable;
    private ConcurrentMap<SNode, Long> postorderTable;

    public Salt2ANNISMapper() {
        this.init();
    }

    private void init() {
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setCorpusGraph(SCorpusGraph sCorpusGraph) {
        this.sCorpusGraph = sCorpusGraph;
    }

    public SCorpusGraph getCorpusGraph() {
        return this.sCorpusGraph;
    }

    public DOCUMENT_STATUS mapSCorpus() {
        if (this.getCorpusGraph() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map sCorpusGraph, because sCorpusGraph is null.");
        }
        this.preorderTable = new ConcurrentHashMap<SNode, Long>();
        this.postorderTable = new ConcurrentHashMap<SNode, Long>();
        this.prePostOrder = 0L;
        try {
            List roots = this.getCorpusGraph().getRoots();
            if (roots == null || roots.size() == 0) {
                throw new PepperModuleException((PepperMapper)this, "Cannot traverse through corpus structure, because there is no Corpus-object as root.");
            }
            if (roots.size() > 1) {
                logger.warn("Only one root corpus is allowed for ANNIS export");
            }
            if (this.getCorpus() != null && roots.contains(this.getCorpus())) {
                if (this.individualCorpusName != null) {
                    this.individualCorpusNameReplacement = new ImmutablePair((Object)((SNode)roots.get(0)).getName(), (Object)this.individualCorpusName);
                }
                this.currTraversionType = TRAVERSION_TYPE.CORPUS_STRUCTURE;
                this.sCorpusGraph.traverse(roots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "compute_corpus_structure", (GraphTraverseHandler)this);
            }
        }
        catch (Exception e) {
            throw new PepperModuleException((PepperMapper)this, "Some error occurs while traversing corpus structure graph.", (Throwable)e);
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void mapRelationsInParallel(boolean parallel) {
        this.mapRelationsInParallel = parallel;
    }

    private synchronized Long getNewPPOrder() {
        if (this.prePostOrder == null) {
            this.prePostOrder = 0L;
        }
        Long currPrePost = this.prePostOrder;
        Long l = this.prePostOrder;
        Long l2 = this.prePostOrder = Long.valueOf(this.prePostOrder + 1L);
        return currPrePost;
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.preorderTable = new ConcurrentHashMap<SNode, Long>();
        this.postorderTable = new ConcurrentHashMap<SNode, Long>();
        this.prePostOrder = 0L;
        this.numberOfMappedNodes.set(0);
        if (this.getDocument() == null || this.getDocument().getDocumentGraph() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map sDocumentGraph, because sDocumentGraph is null.");
        }
        try {
            List sRelationRoots;
            if (this.getDocument().getDocumentGraph().getNodes() != null) {
                this.numberOfDocumentNodes = this.getDocument().getDocumentGraph().getNodes().size();
            }
            Map<SToken, Long> token2Index = this.calculateToken2Index(this.getDocument().getDocumentGraph());
            Multimap subComponentRoots = this.getDocument().getDocumentGraph().getRootsByRelationType(SALT_TYPE.SORDER_RELATION);
            if (subComponentRoots != null && subComponentRoots.size() > 0) {
                for (Map.Entry entry : subComponentRoots.entries()) {
                    SOrderRelation2ANNISMapper sOrderRelationMapper = new SOrderRelation2ANNISMapper(this.getIdManager(), this.getDocument().getDocumentGraph(), token2Index, this.tw_node, this.tw_nodeAnno, this.tw_rank, this.tw_edgeAnno, this.tw_component, this);
                    String traversionType = (String)entry.getKey();
                    if ("salt::NULL".equals(traversionType)) {
                        sOrderRelationMapper.setTraversionSType(null);
                    } else {
                        sOrderRelationMapper.setTraversionSType(traversionType);
                    }
                    ((SRelation2ANNISMapper)sOrderRelationMapper).mapSRelations2ANNIS(subComponentRoots.get(entry.getKey()), SALT_TYPE.SORDER_RELATION, null);
                }
            }
            STimelineRelation2ANNISMapper timelineMapper = new STimelineRelation2ANNISMapper(this.getIdManager(), this.getDocument().getDocumentGraph(), token2Index, this.tw_node, this.tw_nodeAnno, this.tw_rank, this.tw_edgeAnno, this.tw_component, this, this.mergeTextsWithTimeline);
            timelineMapper.run();
            if (this.idManager.hasVirtualTokenization()) {
                Long textId = 0L;
                String sDocumentElementId = this.getDocument().getId();
                if (sDocumentElementId == null) {
                    throw new PepperModuleException((PepperMapper)this, "SId Id of the document '" + this.getDocument().getName() + "' is NULL!");
                }
                Long sDocID = this.idManager.getNewCorpusTabId(sDocumentElementId);
                String textName = "sText0";
                String textContent = Strings.repeat((String)" ", (int)this.idManager.getNumberOfVirtualToken());
                ArrayList<String> tuple = new ArrayList<String>();
                tuple.add(sDocID.toString());
                tuple.add(textId.toString());
                tuple.add(textName);
                tuple.add(textContent);
                long transactionId = this.tw_text.beginTA();
                try {
                    this.tw_text.addTuple(transactionId, tuple);
                    this.tw_text.commitTA(transactionId);
                }
                catch (FileNotFoundException e) {
                    this.tw_text.abortTA(transactionId);
                    throw new PepperModuleException((PepperMapper)this, "Could not write to the node.tab, exception was" + e.getMessage());
                }
            } else {
                this.mapSText();
            }
            ExecutorService exec = null;
            if (this.mapRelationsInParallel) {
                exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            }
            if ((subComponentRoots = this.getDocument().getDocumentGraph().getRootsByRelationType(SALT_TYPE.SPOINTING_RELATION)) != null && subComponentRoots.size() > 0) {
                for (String key : subComponentRoots.keySet()) {
                    SPointingRelation2ANNISMapper sPointingSubRelationMapper = new SPointingRelation2ANNISMapper(this.getIdManager(), this.getDocument().getDocumentGraph(), token2Index, this.tw_node, this.tw_nodeAnno, this.tw_rank, this.tw_edgeAnno, this.tw_component, this);
                    ((SRelation2ANNISMapper)sPointingSubRelationMapper).mapSRelations2ANNIS(subComponentRoots.get((Object)key), SALT_TYPE.SPOINTING_RELATION, TRAVERSION_TYPE.DOCUMENT_STRUCTURE_PR);
                    sPointingSubRelationMapper.setTraversionSType(key);
                    if (exec != null) {
                        exec.execute(sPointingSubRelationMapper);
                        continue;
                    }
                    sPointingSubRelationMapper.run();
                }
            }
            if ((sRelationRoots = this.getDocument().getDocumentGraph().getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SDOMINANCE_RELATION})) != null && sRelationRoots.size() > 0) {
                SDominanceRelation2ANNISMapper sDominanceRelationMapper = new SDominanceRelation2ANNISMapper(this.getIdManager(), this.getDocument().getDocumentGraph(), token2Index, this.tw_node, this.tw_nodeAnno, this.tw_rank, this.tw_edgeAnno, this.tw_component, this);
                ((SRelation2ANNISMapper)sDominanceRelationMapper).mapSRelations2ANNIS(sRelationRoots, SALT_TYPE.SDOMINANCE_RELATION, TRAVERSION_TYPE.DOCUMENT_STRUCTURE_DR);
                if (exec != null) {
                    exec.execute(sDominanceRelationMapper);
                } else {
                    sDominanceRelationMapper.run();
                }
            }
            if ((subComponentRoots = this.getDocument().getDocumentGraph().getRootsByRelationType(SALT_TYPE.SDOMINANCE_RELATION)) != null && subComponentRoots.size() > 0) {
                Set domComponentTypeNames = subComponentRoots.keySet();
                if (!((ANNISExporterProperties)this.getProperties()).getExcludeSingleDomType() || domComponentTypeNames.size() >= 2) {
                    for (String key : domComponentTypeNames) {
                        if ("salt::NULL".equals(key)) continue;
                        SDominanceRelation2ANNISMapper sDominanceSubRelationMapper = new SDominanceRelation2ANNISMapper(this.getIdManager(), this.getDocument().getDocumentGraph(), token2Index, this.tw_node, this.tw_nodeAnno, this.tw_rank, this.tw_edgeAnno, this.tw_component, this);
                        sDominanceSubRelationMapper.setTraversionSType(key);
                        ((SRelation2ANNISMapper)sDominanceSubRelationMapper).mapSRelations2ANNIS(subComponentRoots.get((Object)key), SALT_TYPE.SDOMINANCE_RELATION, TRAVERSION_TYPE.DOCUMENT_STRUCTURE_DR);
                        if (exec != null) {
                            exec.execute(sDominanceSubRelationMapper);
                            continue;
                        }
                        sDominanceSubRelationMapper.run();
                    }
                }
            }
            if ((sRelationRoots = this.getDocument().getDocumentGraph().getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION})) != null && sRelationRoots.size() > 0) {
                SSpanningRelation2ANNISMapper spanningRelationMapper = new SSpanningRelation2ANNISMapper(this.getIdManager(), this.getDocument().getDocumentGraph(), token2Index, this.tw_node, this.tw_nodeAnno, this.tw_rank, this.tw_edgeAnno, this.tw_component, this);
                ((SRelation2ANNISMapper)spanningRelationMapper).mapSRelations2ANNIS(sRelationRoots, SALT_TYPE.SSPANNING_RELATION, TRAVERSION_TYPE.DOCUMENT_STRUCTURE_CR);
                if (exec != null) {
                    exec.execute(spanningRelationMapper);
                } else {
                    spanningRelationMapper.run();
                }
            }
            if ((sRelationRoots = this.getDocument().getDocumentGraph().getTokens()) != null && sRelationRoots.size() > 0) {
                Audio2ANNISMapper audioRelationMapper = new Audio2ANNISMapper(this.getIdManager(), this.getDocument().getDocumentGraph(), token2Index, this.tw_node, this.tw_nodeAnno, this.tw_rank, this.tw_edgeAnno, this.tw_component, this);
                ((SRelation2ANNISMapper)audioRelationMapper).mapSRelations2ANNIS(sRelationRoots, SALT_TYPE.STIME_OVERLAPPING_RELATION, TRAVERSION_TYPE.DOCUMENT_STRUCTURE_AUDIO);
                if (exec != null) {
                    exec.execute(audioRelationMapper);
                } else {
                    audioRelationMapper.run();
                }
            }
            if (exec != null) {
                exec.shutdown();
                while (!exec.awaitTermination(60L, TimeUnit.SECONDS)) {
                }
            }
            SSpanningRelation2ANNISMapper mapper = new SSpanningRelation2ANNISMapper(this.getIdManager(), this.getDocument().getDocumentGraph(), token2Index, this.tw_node, this.tw_nodeAnno, this.tw_rank, this.tw_edgeAnno, this.tw_component, this);
            mapper.beginTransaction();
            for (SNode node : this.getDocument().getDocumentGraph().getTokens()) {
                if (this.idManager.getVirtualisedSpanId(node.getId()) != null) continue;
                mapper.mapSNode(node);
            }
            mapper.commitTransaction();
        }
        catch (PepperModuleException e) {
            throw new PepperModuleException((PepperMapper)this, "Some error occurs while traversing document structure graph.", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new PepperModuleException((PepperMapper)this, "Some error occurs while traversing document structure graph.", (Throwable)e);
        }
        this.mergeLocalStatsIntoGlobal();
        this.setProgress(1.0);
        return DOCUMENT_STATUS.COMPLETED;
    }

    private Map<SToken, Long> calculateToken2Index(SDocumentGraph documentGraph) {
        List tokenSortedByLeft = documentGraph.getSortedTokenByText();
        HashMap<SToken, Long> token2Index = new HashMap<SToken, Long>();
        if (tokenSortedByLeft != null) {
            long i = 0L;
            for (SToken tok : tokenSortedByLeft) {
                token2Index.put(tok, i);
                ++i;
            }
        }
        return Collections.unmodifiableMap(token2Index);
    }

    private void mergeLocalStatsIntoGlobal() {
        if (this.globalDomStats != null) {
            this.globalDomStats.merge(this.localDomStats);
        }
        if (this.globalPointingStats != null) {
            this.globalPointingStats.merge(this.localPointingStats);
        }
        if (this.globalSpanStats != null) {
            this.globalSpanStats.merge(this.localSpanStats);
        }
        if (this.globalVirtualTokenStats != null) {
            this.globalVirtualTokenStats.merge(this.localVirtualTokenStats);
        }
    }

    protected void mapSText() {
        SDocumentGraph sDoc = this.getDocument().getDocumentGraph();
        Long textId = 0L;
        for (STextualDS text : sDoc.getTextualDSs()) {
            String sDocumentElementId = this.getDocument().getId();
            if (sDocumentElementId == null) {
                throw new PepperModuleException((PepperMapper)this, "SElement Id of the document '" + sDoc.getName() + "' is NULL!");
            }
            IdManager manager = this.getIdManager();
            if (manager == null) {
                throw new PepperModuleException((PepperMapper)this, "No IdManager was found, this might be a bug.!");
            }
            Long sDocID = manager.getNewCorpusTabId(sDocumentElementId);
            String textName = text.getName();
            String textContent = text.getText();
            ArrayList<String> tuple = new ArrayList<String>();
            tuple.add(sDocID.toString());
            tuple.add(manager.getNewTextId(text.getId()).toString());
            tuple.add(textName);
            tuple.add(textContent);
            long transactionId = this.tw_text.beginTA();
            try {
                this.tw_text.addTuple(transactionId, tuple);
                this.tw_text.commitTA(transactionId);
            }
            catch (FileNotFoundException e) {
                this.tw_text.abortTA(transactionId);
                throw new PepperModuleException((PepperMapper)this, "Could not write to the node.tab, exception was" + e.getMessage());
            }
            Long l = textId;
            Long l2 = textId = Long.valueOf(textId + 1L);
        }
    }

    private void mapToCorpusTab(SNode sNode, Long id, Long preOrder, Long postOrder) {
        SNode metaOwner;
        TupleWriter corpusTabWriter = this.tw_corpus;
        String idString = id.toString();
        CorpusType corpusType = CorpusType.createFromNode(sNode);
        String name = sNode.getName();
        if (name == null) {
            name = "untitled";
        }
        if (corpusType == CorpusType.DOCUMENT) {
            name = this.idManager.getUniqueDocumentName(name);
        } else if (corpusType == CorpusType.TOPLEVEL && this.individualCorpusNameReplacement != null && name.equals(this.individualCorpusNameReplacement.getLeft())) {
            name = (String)this.individualCorpusNameReplacement.getRight();
        }
        String type = corpusType.getCorpusTabType();
        String version = "NULL";
        String pre = preOrder.toString();
        String post = postOrder.toString();
        String toplevel = corpusType == CorpusType.TOPLEVEL ? "TRUE" : "FALSE";
        SMetaAnnotation versionMetaAnno = sNode.getMetaAnnotation("version");
        if (versionMetaAnno != null && versionMetaAnno.getValue_STEXT() != null) {
            version = versionMetaAnno.getValue_STEXT();
        }
        ArrayList<String> tuple = new ArrayList<String>();
        tuple.add(idString);
        tuple.add(name);
        tuple.add(type);
        tuple.add(version);
        tuple.add(pre);
        tuple.add(post);
        tuple.add(toplevel);
        long transactionId = corpusTabWriter.beginTA();
        try {
            corpusTabWriter.addTuple(transactionId, tuple);
            corpusTabWriter.commitTA(transactionId);
        }
        catch (FileNotFoundException e) {
            corpusTabWriter.abortTA(transactionId);
            throw new PepperModuleException((PepperMapper)this, "Could not write to the corpus.annis, exception was" + e.getMessage());
        }
        if (this.tw_corpusMeta != null && (metaOwner = sNode).getMetaAnnotations() != null) {
            transactionId = this.tw_corpusMeta.beginTA();
            try {
                for (SMetaAnnotation meta : metaOwner.getMetaAnnotations()) {
                    String namespace = meta.getNamespace();
                    if (namespace == null) {
                        namespace = "NULL";
                    }
                    this.tw_corpusMeta.addTuple(transactionId, Arrays.asList(idString, this.idManager.getEscapedIdentifier(namespace), this.idManager.getEscapedIdentifier(meta.getName()), meta.getValue() == null ? "NULL" : meta.getValue_STEXT()));
                }
                this.tw_corpusMeta.commitTA(transactionId);
            }
            catch (FileNotFoundException ex) {
                this.tw_corpusMeta.abortTA(transactionId);
                throw new PepperModuleException((PepperMapper)this, "Could not write to the corpus_annotation.annis, exception was" + ex.getMessage());
            }
        }
    }

    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        Boolean returnValue = false;
        if (this.currTraversionType == TRAVERSION_TYPE.CORPUS_STRUCTURE && (currNode instanceof SCorpus || currNode instanceof SDocument)) {
            returnValue = true;
        }
        return returnValue;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        if (this.currTraversionType == TRAVERSION_TYPE.CORPUS_STRUCTURE && (currNode instanceof SCorpus || currNode instanceof SDocument)) {
            this.idManager.getNewCorpusTabId(currNode.getId());
            if (!this.preorderTable.containsKey(currNode)) {
                this.preorderTable.put(currNode, this.getNewPPOrder());
            }
        }
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        if (this.currTraversionType == TRAVERSION_TYPE.CORPUS_STRUCTURE && (currNode instanceof SDocument || currNode instanceof SCorpus) && this.preorderTable.containsKey(currNode) && !this.postorderTable.containsKey(currNode)) {
            this.postorderTable.put(currNode, this.getNewPPOrder());
            Long iD = null;
            if (currNode instanceof SDocument) {
                SDocument sd = (SDocument)currNode;
                iD = this.getIdManager().getNewCorpusTabId(sd.getId());
            }
            if (currNode instanceof SCorpus) {
                SCorpus sc = (SCorpus)currNode;
                iD = this.getIdManager().getNewCorpusTabId(sc.getId());
            }
            this.mapToCorpusTab(currNode, iD, (Long)this.preorderTable.get(currNode), (Long)this.postorderTable.get(currNode));
        }
    }

    public void notifiyNewNodeMapped() {
        int newValue = this.numberOfMappedNodes.incrementAndGet();
        if (newValue % 100 == 0) {
            double percent = (double)newValue / (double)this.numberOfDocumentNodes;
            this.setProgress(percent * 0.9);
        }
    }

    public DomStatistics getLocalDomStats() {
        return this.localDomStats;
    }

    public SpanStatistics getLocalSpanStats() {
        return this.localSpanStats;
    }

    public PointingStatistics getLocalPointingStats() {
        return this.localPointingStats;
    }

    public VirtualTokenStatistics getLocalVirtualTokenStats() {
        return this.localVirtualTokenStats;
    }

    public void setGlobalDomStats(DomStatistics globalDomStats) {
        this.globalDomStats = globalDomStats;
    }

    public void setGlobalSpanStats(SpanStatistics globalSpanStats) {
        this.globalSpanStats = globalSpanStats;
    }

    public void setGlobalPointingStats(PointingStatistics globalPointingStats) {
        this.globalPointingStats = globalPointingStats;
    }

    public VirtualTokenStatistics getGlobalVirtualTokenStats() {
        return this.globalVirtualTokenStats;
    }

    public void setGlobalVirtualTokenStats(VirtualTokenStatistics globalVirtualTokenStats) {
        this.globalVirtualTokenStats = globalVirtualTokenStats;
    }

    public void setMergeTextsWithTimeline(boolean mergeTextsWithTimeline) {
        this.mergeTextsWithTimeline = mergeTextsWithTimeline;
    }

    public static enum TRAVERSION_TYPE {
        CORPUS_STRUCTURE,
        DOCUMENT_STRUCTURE_TOKEN,
        DOCUMENT_STRUCTURE_CR,
        DOCUMENT_STRUCTURE_DR,
        DOCUMENT_STRUCTURE_DR_SUB,
        DOCUMENT_STRUCTURE_PR,
        DOCUMENT_STRUCTURE_PR_SUB,
        DOCUMENT_STRUCTURE_AUDIO;

    }
}

