/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.SRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.Salt2ANNISMapper;
import org.corpus_tools.peppermodules.annis.SegmentationInfo;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.peppermodules.annis.VirtualNodeID;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STimelineRelation2ANNISMapper
extends SRelation2ANNISMapper {
    private static final Logger log = LoggerFactory.getLogger(STimelineRelation2ANNISMapper.class);
    private final boolean mergeTextsWithTimeline;

    public STimelineRelation2ANNISMapper(IdManager idManager, SDocumentGraph documentGraph, Map<SToken, Long> token2Index, TupleWriter nodeTabWriter, TupleWriter nodeAnnoTabWriter, TupleWriter rankTabWriter, TupleWriter edgeAnnoTabWriter, TupleWriter componentTabWriter, Salt2ANNISMapper parentMapper, boolean mergeTextsWithTimeline) {
        super(idManager, documentGraph, token2Index, nodeTabWriter, nodeAnnoTabWriter, rankTabWriter, edgeAnnoTabWriter, componentTabWriter, parentMapper);
        this.mergeTextsWithTimeline = mergeTextsWithTimeline;
    }

    private VirtualNodeID mapPointOfTime(long tokenIndex, boolean isRoot) {
        String virtualTokenName = "virtualToken" + tokenIndex;
        VirtualNodeID virtualTokenId = this.idManager.getVirtualNodeId(virtualTokenName);
        Long corpus_ref = this.idManager.getNewCorpusTabId(this.documentGraph.getDocument().getId());
        long token_left = tokenIndex;
        long token_right = tokenIndex;
        if (virtualTokenId.isFresh()) {
            super.writeNodeTabEntry(virtualTokenId.getNodeID(), 0L, corpus_ref, "default_layer", virtualTokenName, tokenIndex, tokenIndex, tokenIndex, token_left, token_right, null, null, " ", isRoot);
        }
        return virtualTokenId;
    }

    private void mapSTimeline(STimelineRelation timelineRelation) {
        this.currentComponentId = this.idManager.getGlobal().getNewComponentId();
        this.currentComponentType = "c";
        this.currentComponentLayer = "VIRTUAL";
        this.currentComponentName = "timelineRelationMapping";
        this.mapComponent2ANNIS();
        Long corpus_ref = this.idManager.getNewCorpusTabId(this.documentGraph.getDocument().getId());
        SToken tok = (SToken)timelineRelation.getSource();
        if (tok == null) {
            return;
        }
        String virtualSpanSId = tok.getId();
        virtualSpanSId = virtualSpanSId + "_virtualSpan";
        String virtualSpanName = tok.getName() + "_virtualSpan";
        VirtualNodeID virtualSpanId = this.idManager.getVirtualNodeId(virtualSpanSId);
        ArrayList<Long> overlappedVirtualTokenIds = new ArrayList<Long>();
        Long token_left = (long)((Integer)timelineRelation.getStart());
        Long token_right = (long)((Integer)timelineRelation.getEnd()).intValue() - 1L;
        for (long i = token_left.longValue(); i <= token_right; ++i) {
            String virtualTokenName = "virtualToken" + i;
            VirtualNodeID virtualTokenId = this.idManager.getVirtualNodeId(virtualTokenName);
            overlappedVirtualTokenIds.add(virtualTokenId.getNodeID());
        }
        this.idManager.registerTokenVirtMapping(tok.getId(), virtualSpanId.getNodeID(), overlappedVirtualTokenIds);
        if (virtualSpanId.isFresh()) {
            String span;
            Long segId = null;
            Object segName = null;
            String textName = null;
            SegmentationInfo segmentInfo = this.idManager.getSegmentInformation(tok.getId());
            if (segmentInfo == null) {
                span = this.documentGraph.getText((SNode)tok);
                for (Relation e : this.documentGraph.getOutRelations(tok.getId())) {
                    if (!(e instanceof STextualRelation)) continue;
                    STextualDS text = (STextualDS)((STextualRelation)e).getTarget();
                    textName = text.getName();
                }
            } else {
                segId = segmentInfo.getANNISId();
                segName = segmentInfo.getSegmentationName();
                span = segmentInfo.getSpan();
            }
            this.writeNodeTabEntry(virtualSpanId.getNodeID(), 0L, corpus_ref, "default_layer", virtualSpanName, token_left, token_right, null, token_left, token_right, segId, (String)segName, span, this.isRoot((SNode)tok));
            if (segName != null) {
                this.mapSNodeAnnotation(virtualSpanId.getNodeID(), "default_ns", (String)segName, span);
                this.getVirtualTokenStats().addVirtualAnnoName("default_ns", (String)segName);
            } else if (textName != null) {
                this.mapSNodeAnnotation(virtualSpanId.getNodeID(), "default_ns", textName, span);
                this.getVirtualTokenStats().addVirtualAnnoName("default_ns", textName);
            }
            if (tok.getAnnotations() != null) {
                for (SAnnotation anno : tok.getAnnotations()) {
                    this.mapSNodeAnnotation(null, virtualSpanId.getNodeID(), anno);
                }
            }
        }
        this.prePostOrder = 1L;
        Long parentRank = this.idManager.getGlobal().getNewRankId();
        for (Long tokId : overlappedVirtualTokenIds) {
            this.getNewPPOrder();
            this.getNewPPOrder();
        }
        ArrayList<String> rankEntry = new ArrayList<String>();
        rankEntry.add(parentRank.toString());
        rankEntry.add("0");
        rankEntry.add(this.getNewPPOrder().toString());
        rankEntry.add("" + virtualSpanId.getNodeID());
        rankEntry.add(this.currentComponentId.toString());
        rankEntry.add("NULL");
        rankEntry.add("0");
        this.addTuple(SRelation2ANNISMapper.OutputTable.RANK, rankEntry);
    }

    private void createVirtualTokenization() {
        if (this.documentGraph.getTimeline() == null) {
            throw new PepperModuleException("Cannot create virtual tokenization, because no timeline exists in Salt model. ");
        }
        if (this.documentGraph.getTimeline().getEnd() == null) {
            throw new PepperModuleException("Cannot create virtual tokenization, because the timeline's end value is null. ");
        }
        BitSet virtualCovered = new BitSet((Integer)this.documentGraph.getTimeline().getEnd());
        List timelineRelations = this.documentGraph.getTimelineRelations();
        LinkedHashSet<STimelineRelation> timlineRelationsSet = new LinkedHashSet<STimelineRelation>();
        if (timelineRelations != null && !timelineRelations.isEmpty()) {
            for (STimelineRelation timelineRel1 : timelineRelations) {
                if (timelineRel1.getTarget() == null) continue;
                timlineRelationsSet.add(timelineRel1);
                virtualCovered.set((int)((Integer)timelineRel1.getStart()), (Integer)timelineRel1.getEnd());
            }
        }
        ArrayList<Long> virtualTokenNodeIDs = new ArrayList<Long>((Integer)this.documentGraph.getTimeline().getEnd());
        int tokenIndex = 0;
        for (int i = 0; i <= (Integer)this.documentGraph.getTimeline().getEnd(); ++i) {
            boolean isCovered = virtualCovered.get(tokenIndex);
            VirtualNodeID tokID = this.mapPointOfTime(tokenIndex++, !isCovered);
            virtualTokenNodeIDs.add(tokID.getNodeID());
        }
        this.idManager.registerMininmalVirtToken(virtualTokenNodeIDs);
        for (STimelineRelation t : timlineRelationsSet) {
            this.mapSTimeline(t);
        }
    }

    @Override
    public void mapSRelations2ANNIS(Collection<? extends SNode> sRelationRoots, SALT_TYPE edgeTypeName, Salt2ANNISMapper.TRAVERSION_TYPE traversionType) {
    }

    @Override
    public void run() {
        List timelineRelations = this.documentGraph.getTimelineRelations();
        if (timelineRelations != null && !timelineRelations.isEmpty() && this.mergeTextsWithTimeline) {
            this.beginTransaction();
            this.createVirtualTokenization();
            this.commitTransaction();
        }
    }
}

