/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.SRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.Salt2ANNISMapper;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;

public class SSpanningRelation2ANNISMapper
extends SRelation2ANNISMapper {
    private final Map<SSpan, Boolean> spanIsContinous = Collections.synchronizedMap(new HashMap());

    public SSpanningRelation2ANNISMapper(IdManager idManager, SDocumentGraph documentGraph, Map<SToken, Long> token2Index, TupleWriter nodeTabWriter, TupleWriter nodeAnnoTabWriter, TupleWriter rankTabWriter, TupleWriter edgeAnnoTabWriter, TupleWriter componentTabWriter, Salt2ANNISMapper parentMapper) {
        super(idManager, documentGraph, token2Index, nodeTabWriter, nodeAnnoTabWriter, rankTabWriter, edgeAnnoTabWriter, componentTabWriter, parentMapper);
    }

    @Override
    public void run() {
        this.beginTransaction();
        if (this.sRelationRoots != null && this.sRelationRoots.size() != 0) {
            for (SNode node : this.sRelationRoots) {
                String componentLayerName = "default_ns";
                SLayer componentLayer = this.getFirstComponentLayer(node);
                if (componentLayer != null) {
                    componentLayerName = componentLayer.getName();
                }
                if (this.currentTraversionSType == null) {
                    super.initialiseTraversion("c", componentLayerName, "NULL");
                } else {
                    super.initialiseTraversion("c", componentLayerName, this.currentTraversionSType);
                }
                ArrayList<SNode> singleRootList = new ArrayList<SNode>();
                singleRootList.add(node);
                this.documentGraph.traverse(singleRootList, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traversionType.toString(), (GraphTraverseHandler)this);
                this.mapComponent2ANNIS();
                this.getSpanStats().addLayer(componentLayerName);
            }
        }
        this.commitTransaction();
    }

    @Override
    public void mapSRelations2ANNIS(Collection<? extends SNode> sRelationRoots, SALT_TYPE edgeTypeName, Salt2ANNISMapper.TRAVERSION_TYPE traversionType) {
        this.traversionType = traversionType;
        this.edgeTypeName = edgeTypeName;
        this.sRelationRoots = sRelationRoots;
    }

    @Override
    protected void mapRank2ANNIS(SRelation sRelation, Long targetNodeID, Long rankId, Long preOrder, Long postOrder, Long parentRank, Long level) {
        boolean doMapping = true;
        if (sRelation instanceof SSpanningRelation) {
            if (sRelation.getAnnotations() != null && !sRelation.getAnnotations().isEmpty()) {
                doMapping = true;
            } else {
                SSpan span = (SSpan)sRelation.getSource();
                boolean bl = doMapping = !this.isContinuous(span);
            }
        }
        if (doMapping) {
            super.mapRank2ANNIS(sRelation, targetNodeID, rankId, preOrder, postOrder, parentRank, level);
        }
    }

    private boolean isContinuous(SSpan span) {
        boolean continuous = false;
        Boolean cachedValue = this.spanIsContinous.get(span);
        if (cachedValue != null) {
            continuous = cachedValue;
        } else {
            List overlappedToken = this.documentGraph.getOverlappedTokens((SNode)span, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION});
            if (overlappedToken != null && !overlappedToken.isEmpty()) {
                long minIndex = Integer.MAX_VALUE;
                long maxIndex = Integer.MIN_VALUE;
                for (SToken tok : overlappedToken) {
                    Long idx = (Long)this.token2Index.get(tok);
                    if (idx == null) continue;
                    minIndex = Math.min(minIndex, idx);
                    maxIndex = Math.max(maxIndex, idx);
                }
                long rangeSize = maxIndex - minIndex + 1L;
                continuous = rangeSize == (long)overlappedToken.size();
                this.spanIsContinous.put(span, continuous);
            }
        }
        return continuous;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode fromNode, long order) {
        super.nodeReached(traversalType, traversalId, currNode, (SRelation<SNode, SNode>)sRelation, fromNode, order);
    }

    @Override
    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        super.nodeLeft(traversalType, traversalId, currNode, relation, fromNode, order);
        this.getSpanStats().addNodeAnno(this.currentComponentLayer, currNode.getAnnotations());
    }

    @Override
    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        boolean returnVal = false;
        if (currNode instanceof SSpan && relation == null) {
            returnVal = true;
        }
        if (currNode instanceof SToken && relation instanceof SSpanningRelation) {
            returnVal = true;
        }
        return returnVal;
    }
}

