/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.Salt2ANNISMapper;
import org.corpus_tools.peppermodules.annis.SegmentationInfo;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.peppermodules.annis.resolver.DomStatistics;
import org.corpus_tools.peppermodules.annis.resolver.PointingStatistics;
import org.corpus_tools.peppermodules.annis.resolver.SpanStatistics;
import org.corpus_tools.peppermodules.annis.resolver.VirtualTokenStatistics;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SDATATYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SRelation2ANNISMapper
implements Runnable,
GraphTraverseHandler {
    private static final Logger log = LoggerFactory.getLogger(SRelation2ANNISMapper.class);
    protected IdManager idManager;
    private final Salt2ANNISMapper parentMapper;
    protected SDocumentGraph documentGraph;
    protected static final String DEFAULT_NS = "default_ns";
    protected static final String DEFAULT_LAYER = "default_layer";
    Collection<? extends SNode> sRelationRoots = null;
    SALT_TYPE edgeTypeName = null;
    protected final Map<OutputTable, TupleWriter> writers = new EnumMap<OutputTable, TupleWriter>(OutputTable.class);
    private final Map<OutputTable, Long> transactionIds = new EnumMap<OutputTable, Long>(OutputTable.class);
    protected Salt2ANNISMapper.TRAVERSION_TYPE traversionType;
    protected Long currentComponentId = null;
    protected String currentComponentType = null;
    protected String currentComponentLayer = null;
    protected String currentComponentName = null;
    protected Long rankLevel;
    protected String currentTraversionSType = null;
    protected Long prePostOrder = null;
    private ConcurrentMap<Long, Long> preorderTable;
    protected ConcurrentMap<Long, Long> rankTable;
    HashSet<SNode> virtualNodes;
    protected final Map<SToken, Long> token2Index;

    public SRelation2ANNISMapper(IdManager idManager, SDocumentGraph documentGraph, Map<SToken, Long> token2Index, TupleWriter nodeTabWriter, TupleWriter nodeAnnoTabWriter, TupleWriter rankTabWriter, TupleWriter edgeAnnoTabWriter, TupleWriter componentTabWriter, Salt2ANNISMapper parentMapper) {
        this.idManager = idManager;
        this.parentMapper = parentMapper;
        this.documentGraph = documentGraph;
        this.token2Index = token2Index;
        this.writers.clear();
        this.writers.put(OutputTable.NODE, nodeTabWriter);
        this.writers.put(OutputTable.NODE_ANNOTATION, nodeAnnoTabWriter);
        this.writers.put(OutputTable.RANK, rankTabWriter);
        this.writers.put(OutputTable.EDGE_ANNO, edgeAnnoTabWriter);
        this.writers.put(OutputTable.COMPONENT, componentTabWriter);
    }

    protected void setTraversionSType(String traversionSType) {
        this.currentTraversionSType = traversionSType;
    }

    protected void beginTransaction() {
        this.transactionIds.clear();
        for (Map.Entry<OutputTable, TupleWriter> e : this.writers.entrySet()) {
            this.transactionIds.put(e.getKey(), e.getValue().beginTA());
        }
    }

    protected void initialiseTraversion(String componentType, String componentLayer, String componentName) {
        this.currentComponentId = this.idManager.getGlobal().getNewComponentId();
        this.currentComponentType = componentType;
        this.currentComponentLayer = componentLayer;
        this.currentComponentName = componentName;
        this.rankLevel = 0L;
        this.preorderTable = new ConcurrentHashMap<Long, Long>();
        this.prePostOrder = 0L;
        this.virtualNodes = new HashSet();
        this.rankTable = new ConcurrentHashMap<Long, Long>();
    }

    protected void commitTransaction() {
        try {
            for (Map.Entry<OutputTable, TupleWriter> e : this.writers.entrySet()) {
                Long txId = this.transactionIds.get((Object)e.getKey());
                if (txId == null) continue;
                e.getValue().commitTA(txId);
            }
        }
        catch (FileNotFoundException ex) {
            log.error("Could not write output file", (Throwable)ex);
            this.abortTransaction();
        }
        this.transactionIds.clear();
    }

    protected void abortTransaction() {
        for (Map.Entry<OutputTable, TupleWriter> e : this.writers.entrySet()) {
            Long txId = this.transactionIds.get((Object)e.getKey());
            if (txId == null) continue;
            e.getValue().abortTA(txId);
        }
        this.transactionIds.clear();
    }

    protected synchronized Long getNewPPOrder() {
        if (this.prePostOrder == null) {
            this.prePostOrder = 0L;
        }
        Long currPrePost = this.prePostOrder;
        Long l = this.prePostOrder;
        Long l2 = this.prePostOrder = Long.valueOf(this.prePostOrder + 1L);
        return currPrePost;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> sRelation, SNode fromNode, long order) {
        List<Long> virtualTokenIds = this.idManager.getVirtualisedTokenId(currNode.getId());
        if (virtualTokenIds != null) {
            this.virtualNodes.add(currNode);
        }
        if (virtualTokenIds != null && this.traversionType.equals((Object)Salt2ANNISMapper.TRAVERSION_TYPE.DOCUMENT_STRUCTURE_CR)) {
            for (Long virtualTokenId : virtualTokenIds) {
                Long rankId = this.idManager.getGlobal().getNewRankId();
                Long parentRank = null;
                if (fromNode != null) {
                    parentRank = (Long)this.rankTable.get(this.idManager.getNodeId(fromNode));
                }
                Long pre = this.getNewPPOrder();
                Long post = this.getNewPPOrder();
                ArrayList<String> rankEntry = new ArrayList<String>();
                rankEntry.add(rankId.toString());
                rankEntry.add(pre.toString());
                rankEntry.add(post.toString());
                rankEntry.add(virtualTokenId.toString());
                rankEntry.add(this.currentComponentId.toString());
                if (parentRank == null) {
                    rankEntry.add("NULL");
                } else {
                    rankEntry.add(parentRank.toString());
                }
                rankEntry.add(this.rankLevel.toString());
                boolean hasAnnotations = false;
                if (sRelation != null && sRelation.getAnnotations() != null) {
                    for (SAnnotation sAnnotation : sRelation.getAnnotations()) {
                        this.mapSAnnotation2ANNIS(rankId, sAnnotation);
                        hasAnnotations = true;
                    }
                }
                if (!hasAnnotations && fromNode != null) continue;
                this.addTuple(OutputTable.RANK, rankEntry);
            }
        } else {
            Long currentNodeID = virtualTokenIds != null ? this.idManager.getVirtualisedSpanId(currNode.getId()) : this.mapSNode(currNode);
            if (currentNodeID != null) {
                Long rankId = this.idManager.getGlobal().getNewRankId();
                this.preorderTable.put(currentNodeID, this.getNewPPOrder());
                this.rankTable.put(currentNodeID, rankId);
                if (sRelation != null && sRelation.getAnnotations() != null) {
                    for (SAnnotation sAnnotation : sRelation.getAnnotations()) {
                        this.mapSAnnotation2ANNIS(rankId, sAnnotation);
                    }
                }
            }
        }
        SRelation2ANNISMapper sRelation2ANNISMapper = this;
        sRelation2ANNISMapper.rankLevel = sRelation2ANNISMapper.rankLevel + 1L;
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        Long currNodeID = this.virtualNodes.contains(currNode) ? this.idManager.getVirtualisedSpanId(currNode.getId()) : this.idManager.getNodeId(currNode);
        Long parentRank = null;
        if (fromNode != null) {
            Long fromNodeID = this.virtualNodes.contains(fromNode) ? this.idManager.getVirtualisedSpanId(fromNode.getId()) : this.idManager.getNodeId(fromNode);
            parentRank = (Long)this.rankTable.get(fromNodeID);
        }
        Long rankId = (Long)this.rankTable.get(currNodeID);
        Long pre = (Long)this.preorderTable.get(currNodeID);
        if (rankId != null && pre != null) {
            Long post = this.getNewPPOrder();
            SRelation2ANNISMapper sRelation2ANNISMapper = this;
            sRelation2ANNISMapper.rankLevel = sRelation2ANNISMapper.rankLevel - 1L;
            this.mapRank2ANNIS(relation, currNodeID, rankId, pre, post, parentRank, this.rankLevel);
        } else {
            SRelation2ANNISMapper sRelation2ANNISMapper = this;
            sRelation2ANNISMapper.rankLevel = sRelation2ANNISMapper.rankLevel - 1L;
        }
    }

    protected void addTuple(OutputTable table, Collection<String> tuple) {
        try {
            TupleWriter w = this.writers.get((Object)table);
            if (w != null) {
                Long txId = this.transactionIds.get((Object)table);
                if (txId == null) {
                    w.addTuple(tuple);
                } else {
                    w.addTuple(txId, tuple);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new PepperModuleException("Could not write to the " + table.name() + " tab TupleWriter. Exception is: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        boolean returnVal = false;
        return returnVal;
    }

    public abstract void mapSRelations2ANNIS(Collection<? extends SNode> var1, SALT_TYPE var2, Salt2ANNISMapper.TRAVERSION_TYPE var3);

    protected void mapComponent2ANNIS() {
        ArrayList<String> componentEntry = new ArrayList<String>();
        componentEntry.add(this.currentComponentId.toString());
        componentEntry.add(this.currentComponentType);
        componentEntry.add(this.idManager.getEscapedIdentifier(this.currentComponentLayer));
        componentEntry.add(this.idManager.getEscapedIdentifier(this.currentComponentName));
        this.addTuple(OutputTable.COMPONENT, componentEntry);
    }

    protected void mapRank2ANNIS(SRelation sRelation, Long targetNodeID, Long rankId, Long preOrder, Long postOrder, Long parentRank, Long level) {
        if (targetNodeID == null) {
            throw new PepperModuleException("The given target node for the rank is null");
        }
        if (rankId == null) {
            throw new PepperModuleException("The given rank id for the rank is null");
        }
        if (preOrder == null) {
            throw new PepperModuleException("The given pre order for the rank is null");
        }
        if (postOrder == null) {
            throw new PepperModuleException("The given post order for the rank is null");
        }
        if (level == null) {
            throw new PepperModuleException("The given level for the rank is null");
        }
        ArrayList<String> rankEntry = new ArrayList<String>();
        rankEntry.add(rankId.toString());
        rankEntry.add(((Long)this.preorderTable.get(targetNodeID)).toString());
        rankEntry.add(postOrder.toString());
        rankEntry.add(Long.toString(targetNodeID));
        rankEntry.add(this.currentComponentId.toString());
        if (parentRank == null) {
            rankEntry.add("NULL");
        } else {
            rankEntry.add(parentRank.toString());
        }
        rankEntry.add(level.toString());
        this.addTuple(OutputTable.RANK, rankEntry);
    }

    protected void mapSAnnotation2ANNIS(Long rankId, SAnnotation sAnnotation) {
        if (rankId == null) {
            throw new PepperModuleException("The given rank id for the mapping of the SAnnotation is null");
        }
        if (sAnnotation == null) {
            throw new PepperModuleException("The given SAnnotation is null");
        }
        ArrayList<String> edgeAnnotationEntry = new ArrayList<String>();
        edgeAnnotationEntry.add(rankId.toString());
        String ns = sAnnotation.getNamespace() != null ? sAnnotation.getNamespace() : DEFAULT_NS;
        edgeAnnotationEntry.add(this.idManager.getEscapedIdentifier(ns));
        edgeAnnotationEntry.add(this.idManager.getEscapedIdentifier(sAnnotation.getName()));
        edgeAnnotationEntry.add(sAnnotation.getValue_STEXT());
        this.addTuple(OutputTable.EDGE_ANNO, edgeAnnotationEntry);
    }

    public Long mapSNode(SNode sNode) {
        SegmentationInfo segInfo = this.idManager.getSegmentInformation(sNode.getId());
        if (segInfo != null) {
            return this.mapSNode(sNode, segInfo.getANNISId(), segInfo.getSegmentationName(), segInfo.getSpan());
        }
        return this.mapSNode(sNode, null, null, null);
    }

    private Long mapSNode(SNode node, Long seg_index, String seg_name, String span) {
        String nodeIdentifier = node.getId();
        Pair<Long, Boolean> idPair = this.idManager.getNewNodeId(nodeIdentifier);
        if (!((Boolean)idPair.getRight()).booleanValue()) {
            return (Long)idPair.getLeft();
        }
        Long virtualSpanID = this.idManager.getVirtualisedSpanId(nodeIdentifier);
        if (virtualSpanID != null) {
            return virtualSpanID;
        }
        Long id = (Long)idPair.getLeft();
        Long text_ref = null;
        Long corpus_ref = this.idManager.getNewCorpusTabId(this.documentGraph.getDocument().getId());
        String layer = DEFAULT_NS;
        String name = this.getUniqueNodeName(node);
        Object left = null;
        Object right = null;
        Long token_index = null;
        Object left_token = null;
        Object right_token = null;
        if (node.getLayers() != null && !node.getLayers().isEmpty()) {
            layer = ((SLayer)node.getLayers().iterator().next()).getName();
        }
        if (node instanceof SToken) {
            token_index = this.token2Index.get((SToken)node);
            left_token = token_index;
            right_token = token_index;
            List outRelations = this.documentGraph.getOutRelations(node.getId());
            if (outRelations == null) {
                throw new PepperModuleException("The token " + node.getId() + " has no outgoing relations!");
            }
            for (Relation relation : outRelations) {
                if (!(relation instanceof STextualRelation)) continue;
                STextualRelation sTextualRelation = (STextualRelation)relation;
                left = new Long(((Integer)sTextualRelation.getStart()).intValue());
                right = new Long(((Integer)sTextualRelation.getEnd()).intValue());
                text_ref = this.idManager.getNewTextId(((STextualDS)sTextualRelation.getTarget()).getId());
                span = ((STextualDS)sTextualRelation.getTarget()).getText().substring(((Long)left).intValue(), (Integer)sTextualRelation.getEnd());
                this.getVirtualTokenStats().checkRealToken(span);
                break;
            }
        } else if (node instanceof SSpan || node instanceof SStructure) {
            List overlappedToken = node instanceof SStructure ? this.documentGraph.getOverlappedTokens(node, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SDOMINANCE_RELATION}) : this.documentGraph.getOverlappedTokens(node, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION});
            if (overlappedToken.isEmpty()) {
                log.warn("Node {} is not connected to any token. This is invalid for ANNIS and the node will be excluded.", (Object)node.getId());
                return null;
            }
            if (this.idManager.hasVirtualTokenization()) {
                LinkedList<Long> overlappedVirtualTokenIDs = new LinkedList<Long>();
                for (SToken tok : overlappedToken) {
                    List<Long> tmp = this.idManager.getVirtualisedTokenId(tok.getId());
                    if (tmp == null) continue;
                    overlappedVirtualTokenIDs.addAll(tmp);
                }
                if (overlappedVirtualTokenIDs.isEmpty()) {
                    log.warn("Node {} is not connected to any virtual token. This is invalid for ANNIS and the node will be excluded.", (Object)node.getId());
                    return null;
                }
                Object[] overlappedTokenIndexes = this.idManager.getMinimalVirtTokenIndex(overlappedVirtualTokenIDs.toArray(new Long[overlappedVirtualTokenIDs.size()]));
                Arrays.sort(overlappedTokenIndexes);
                left_token = overlappedTokenIndexes[0];
                right_token = overlappedTokenIndexes[overlappedTokenIndexes.length - 1];
                left = left_token;
                right = right_token;
                span = null;
                text_ref = 0L;
            } else {
                List lastTokenOutRelations;
                STextualDS textualDataSource = null;
                for (SToken t : overlappedToken) {
                    for (SRelation rel : t.getOutRelations()) {
                        if (!(rel instanceof STextualRelation)) continue;
                        STextualRelation textRel = (STextualRelation)rel;
                        if (textualDataSource == null) {
                            textualDataSource = (STextualDS)textRel.getTarget();
                            continue;
                        }
                        if (textualDataSource == textRel.getTarget()) continue;
                        log.warn("Node {} is connected to more than one textual data source. This is invalid for ANNIS and the node will be excluded.", (Object)node.getId());
                        return null;
                    }
                }
                if (textualDataSource == null) {
                    log.warn("Node {} is connected to no textual data source. This is invalid for ANNIS and the node will be excluded.", (Object)node.getId());
                    return null;
                }
                text_ref = this.idManager.getNewTextId(textualDataSource.getId());
                List sortedOverlappedToken = this.documentGraph.getSortedTokenByText(overlappedToken);
                SToken firstOverlappedToken = (SToken)sortedOverlappedToken.get(0);
                SToken lastOverlappedToken = (SToken)sortedOverlappedToken.get(sortedOverlappedToken.size() - 1);
                left_token = (long)this.token2Index.get(firstOverlappedToken);
                right_token = (long)this.token2Index.get(lastOverlappedToken);
                List firstTokenOutRelations = this.documentGraph.getOutRelations(firstOverlappedToken.getId());
                if (firstTokenOutRelations == null) {
                    log.warn("The token {} has no outgoing relations. Node {} will be excluded.!", (Object)firstOverlappedToken.getId(), (Object)node.getId());
                    return null;
                }
                for (Relation relation : firstTokenOutRelations) {
                    if (!(relation instanceof STextualRelation)) continue;
                    STextualRelation sTextualRelation = (STextualRelation)relation;
                    left = new Long(((Integer)sTextualRelation.getStart()).intValue());
                    break;
                }
                if ((lastTokenOutRelations = this.documentGraph.getOutRelations(lastOverlappedToken.getId())) == null) {
                    throw new PepperModuleException("The token " + lastOverlappedToken.getId() + " has no outgoing relations!");
                }
                for (Relation relation : lastTokenOutRelations) {
                    if (!(relation instanceof STextualRelation)) continue;
                    STextualRelation sTextualRelation = (STextualRelation)relation;
                    right = new Long(((Integer)sTextualRelation.getEnd()).intValue());
                    break;
                }
            }
        }
        this.writeNodeTabEntry(id, text_ref, corpus_ref, layer, name, (Long)left, (Long)right, token_index, (Long)left_token, (Long)right_token, seg_index, seg_name, span, this.isRoot(node));
        if (node.getAnnotations() != null) {
            this.mapSNodeAnnotations(node, id, node.getAnnotations());
        }
        this.parentMapper.notifiyNewNodeMapped();
        return id;
    }

    private String getUniqueNodeName(SNode node) {
        URI nodeID = node.getPath();
        return nodeID.fragment();
    }

    protected void writeNodeTabEntry(Long id, Long text_ref, Long corpus_ref, String layer, String name, Long left, Long right, Long token_index, Long left_token, Long right_token, Long seg_index, String seg_name, String span, boolean isRoot) {
        Preconditions.checkArgument((left_token <= right_token ? 1 : 0) != 0, (Object)("Left-most covered token index (" + left_token + ") must be less or equal to the right-most covered token index (" + right_token + "), node " + name + " corpus " + corpus_ref));
        Preconditions.checkArgument((left <= right ? 1 : 0) != 0, (Object)("Left-most covered character index (" + left + ") must be less or equal to the right-most covered character index (" + right + "), node " + name + " corpus " + corpus_ref));
        ArrayList<String> tableEntry = new ArrayList<String>();
        tableEntry.add(id.toString());
        tableEntry.add(text_ref.toString());
        tableEntry.add(corpus_ref.toString());
        tableEntry.add(layer);
        tableEntry.add(name);
        tableEntry.add(left.toString());
        tableEntry.add(right.toString());
        if (token_index == null) {
            tableEntry.add("NULL");
        } else {
            tableEntry.add(token_index.toString());
        }
        tableEntry.add(left_token.toString());
        tableEntry.add(right_token.toString());
        if (seg_index == null) {
            tableEntry.add("NULL");
        } else {
            tableEntry.add(seg_index.toString());
        }
        if (seg_name == null) {
            tableEntry.add("NULL");
        } else {
            tableEntry.add(this.idManager.getEscapedIdentifier(seg_name));
        }
        if (span == null) {
            tableEntry.add("NULL");
        } else {
            tableEntry.add(span);
        }
        tableEntry.add(isRoot ? "TRUE" : "FALSE");
        this.addTuple(OutputTable.NODE, tableEntry);
    }

    protected void mapSNodeAnnotations(SNode node, Long node_ref, Set<SAnnotation> annotations) {
        for (SAnnotation annotation : annotations) {
            this.mapSNodeAnnotation(node, node_ref, annotation);
        }
    }

    protected void mapSNodeAnnotation(Long node_ref, String namespace, String name, String value) {
        ArrayList<String> tableEntry = new ArrayList<String>();
        tableEntry.add(node_ref.toString());
        tableEntry.add(this.idManager.getEscapedIdentifier(namespace));
        tableEntry.add(this.idManager.getEscapedIdentifier(name));
        tableEntry.add(value);
        this.addTuple(OutputTable.NODE_ANNOTATION, tableEntry);
    }

    protected void mapSNodeAnnotation(SNode node, Long node_ref, SAnnotation annotation) {
        String namespace = annotation.getNamespace();
        if (namespace != null) {
            if (namespace.equals("null")) {
                namespace = DEFAULT_NS;
            }
        } else {
            namespace = DEFAULT_NS;
        }
        if (annotation.getValueType() == SDATATYPE.SURI) {
            this.copyLinkedFile(annotation.getValue_SURI());
        }
        String name = annotation.getName();
        String value = annotation.getValue_STEXT();
        this.mapSNodeAnnotation(node_ref, namespace, name, value);
    }

    protected boolean isRoot(SNode n) {
        if (n == null) {
            return false;
        }
        List inRelations = this.documentGraph.getInRelations(n.getId());
        if (inRelations != null) {
            for (Relation e : inRelations) {
                if (!(e instanceof SDominanceRelation) && !(e instanceof SPointingRelation) && !(e instanceof SSpanningRelation)) continue;
                return false;
            }
        }
        return true;
    }

    protected void copyLinkedFile(URI uri) {
        if (uri != null && this.parentMapper != null && this.parentMapper.getOutputDir() != null) {
            File outputDir = this.parentMapper.getOutputDir();
            File sourceFile = uri.toFileString() != null ? new File(uri.toFileString()) : new File(uri.toString());
            if (sourceFile.isFile()) {
                try {
                    String mimeType = Files.probeContentType(sourceFile.toPath());
                    if (mimeType != null) {
                        if (mimeType.startsWith("video/")) {
                            this.idManager.getGlobal().setVideoFound();
                        } else if (mimeType.startsWith("audio/")) {
                            this.idManager.getGlobal().setAudioFound();
                        } else if (mimeType.startsWith("application/pdf")) {
                            this.idManager.getGlobal().setPDFFound();
                        }
                    }
                }
                catch (IOException ex) {
                    log.error("Could not get mime type for file " + sourceFile.getAbsolutePath(), (Throwable)ex);
                }
                File extData = new File(outputDir, "ExtData");
                File docDir = new File(extData, this.documentGraph.getDocument().getName());
                if (!docDir.isDirectory() && !docDir.mkdirs()) {
                    log.error("Could not create directory " + docDir.getAbsolutePath());
                }
                File targetFile = new File(docDir, sourceFile.getName());
                try {
                    com.google.common.io.Files.copy((File)sourceFile, (File)targetFile);
                }
                catch (IOException ex) {
                    log.error("Could not copy file " + sourceFile.getAbsolutePath(), (Throwable)ex);
                }
            }
        }
    }

    protected SLayer getFirstComponentLayer(SNode node) {
        SLayer componentLayer = null;
        Set nodeLayer = node.getLayers();
        if (nodeLayer != null) {
            TreeMap<String, SLayer> layers = new TreeMap<String, SLayer>();
            for (SLayer l : nodeLayer) {
                layers.put(l.getName(), l);
            }
            if (!layers.isEmpty()) {
                componentLayer = (SLayer)layers.firstEntry().getValue();
            }
        }
        return componentLayer;
    }

    public DomStatistics getDomStats() {
        return this.parentMapper.getLocalDomStats();
    }

    public SpanStatistics getSpanStats() {
        return this.parentMapper.getLocalSpanStats();
    }

    public PointingStatistics getPointingStats() {
        return this.parentMapper.getLocalPointingStats();
    }

    public VirtualTokenStatistics getVirtualTokenStats() {
        return this.parentMapper.getLocalVirtualTokenStats();
    }

    public static enum OutputTable {
        RANK,
        EDGE_ANNO,
        COMPONENT,
        NODE,
        NODE_ANNOTATION;

    }
}

