/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.peppermodules.annis.ANNISExporterProperties;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.SRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.Salt2ANNISMapper;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.peppermodules.annis.resolver.QName;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;

public class SPointingRelation2ANNISMapper
extends SRelation2ANNISMapper {
    private SNode lastEnteredNode;
    private final Salt2ANNISMapper parentMapper;

    public SPointingRelation2ANNISMapper(IdManager idManager, SDocumentGraph documentGraph, Map<SToken, Long> token2Index, TupleWriter nodeTabWriter, TupleWriter nodeAnnoTabWriter, TupleWriter rankTabWriter, TupleWriter edgeAnnoTabWriter, TupleWriter componentTabWriter, Salt2ANNISMapper parentMapper) {
        super(idManager, documentGraph, token2Index, nodeTabWriter, nodeAnnoTabWriter, rankTabWriter, edgeAnnoTabWriter, componentTabWriter, parentMapper);
        this.parentMapper = parentMapper;
    }

    @Override
    public void run() {
        this.beginTransaction();
        if (this.sRelationRoots != null && this.sRelationRoots.size() != 0) {
            for (SNode node : this.sRelationRoots) {
                String componentLayer = "default_ns";
                if (this.currentTraversionSType == null) {
                    super.initialiseTraversion("p", componentLayer, "NULL");
                } else {
                    super.initialiseTraversion("p", componentLayer, this.currentTraversionSType);
                }
                ArrayList<SNode> singleRootList = new ArrayList<SNode>();
                singleRootList.add(node);
                this.documentGraph.traverse(singleRootList, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traversionType.toString(), (GraphTraverseHandler)this);
                this.mapComponent2ANNIS();
            }
        }
        this.commitTransaction();
        this.getPointingStats().setNodeCount(this.documentGraph.getNodes().size());
    }

    @Override
    public void mapSRelations2ANNIS(Collection<? extends SNode> sRelationRoots, SALT_TYPE edgeTypeName, Salt2ANNISMapper.TRAVERSION_TYPE traversionType) {
        this.traversionType = traversionType;
        this.edgeTypeName = edgeTypeName;
        this.sRelationRoots = sRelationRoots;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        super.nodeReached(traversalType, traversalId, currNode, (SRelation<SNode, SNode>)relation, fromNode, order);
        this.lastEnteredNode = currNode;
        boolean escapeCharacters = ((ANNISExporterProperties)this.parentMapper.getProperties()).getEscapeCharacters();
        if (relation != null && relation instanceof SPointingRelation) {
            this.currentComponentName = relation.getType() != null && !relation.getType().isEmpty() ? relation.getType() : "salt::NULL";
            if (!relation.getLayers().isEmpty()) {
                String layerName;
                this.currentComponentLayer = layerName = ((SLayer)relation.getLayers().iterator().next()).getName();
            }
        }
    }

    @Override
    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        super.nodeLeft(traversalType, traversalId, currNode, relation, fromNode, order);
        if (this.lastEnteredNode == currNode) {
            Set annos;
            QName layer = new QName(this.currentComponentLayer, this.currentTraversionSType);
            this.getPointingStats().addLayer(layer);
            if (!(currNode instanceof SToken) && (annos = currNode.getAnnotations()) != null) {
                for (SAnnotation anno : annos) {
                    this.getPointingStats().getTerminalAnno().add(layer, new QName(anno.getNamespace(), anno.getName()));
                }
            }
        }
    }

    @Override
    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        boolean returnVal = false;
        if (relation == null) {
            returnVal = true;
        } else if (relation instanceof SPointingRelation) {
            if (this.currentTraversionSType == null) {
                returnVal = true;
            } else if (relation.getType() != null && !relation.getType().isEmpty()) {
                if (relation.getType().equals(this.currentTraversionSType)) {
                    returnVal = true;
                }
            } else if (this.currentTraversionSType.equals("salt::NULL")) {
                returnVal = true;
            }
        }
        return returnVal;
    }
}

